/*  
 * AUTHOR
 *      M. ROSA (STECF)  VERSION 1.0     29-OCT-1985
 *
 * MODIFICATIONS
 *      M. ROSA (STECF)  VERSION 2.0     29-MAR-1986
 *         Add JD and Sid. Time part, correct bug in airmass part
 *         Input is in DEGREES for RA, DEC, Long., Lat.
 *         Add more output
 *      M. ROSA (STECF)  VERSION 3.0     30-MAY-1986
 *         Verify for inclusion in MIDAS release
 *      D. Baade (ST-ECF) VERSION 4.0    07-FEB-1987
 *         a) chop off calculation of ST and JD
 *         b) improved formula for calculation of airmass as a function of
 *            zenith distance
 *         Use more accurate weights for calculation of mean airmass
 *         in the case of long exposures (formula given by P. Stetson,
 *         1988 September, Dominion Astrophysical Observatory Preprint)
 *      K. Banse       890213
 *         move to new ST interfaces and FORTRAN 77
 *      C. Guirao      990213
 *         Translated from Fortran to C by f2c (version 19970805).
 *         Comments and modifications
 *
 * PURPOSE  a) Calculate airmass through sec z
 *
 *             Correct expansion
 *
 *             Airm = sec(z) - 0.0018167(sec(z)-1)
 *                           - 0.002875 (sec(z)-1)**2
 *                           - 0.0008083(sec(z)-1)**3
 *
 * INPUT: array of 8 float values
 *      hour angle (double degrees)      iha
 *      declination (double degree)      idec
 *      latitude (double degree)         ilat
 *      exposure time (float sec)        exposure
 *
 * RETURN:
 *      float airmass
 */

#define dabs(x) (double)abs(x)

/* Table of constant values */

static long int c__1 = 1;
static long int c__2 = 2;
static long int c__8 = 8;

void nairmass(double iha, double idec, double ilat, float exposure, float *airm)
{
    /* Initialized data */

    static double pi = 3.1415926535;
    static float weight[3] = { (float)1.,(float)4.,(float)1. };

    /* Builtin functions */
    double sin(), cos();

    /* Local variables */
    static long int i__;
    static double dd, ha;
    static double rdd, rha;
    static float air;
    static double lat;
    static float delt;
    static double rlat, secz;
    static double facto;
    static long int iactv;

    facto = pi / 180.;
    ha = iha;

/*
    printf("iha=%lf\n",iha);
    printf("idec=%lf\n",idec);
    printf("ilat=%lf\n",ilat);
    printf("exposure=%f\n",ilat);
*/

    /*
     * hour angle in degrees
     */
    while (ha < -180.) {
	ha += (float)360.;
    }

    while (ha > 180.) {
	ha += (float)-360.;
    }

    /*
     * declination in float degrees
    dd = dabs(rb[1]) + (dabs(rb[2]) + dabs(rb[3]) / (float)60.) / (float)60.;
    if (*(unsigned char *)&signs[1] == '-') {
	dd = -dd;
    }
    */
    dd=idec;

    /*
     * latitude in float degrees
    lat = dabs(rb[5]) + (dabs(rb[6]) + dabs(rb[7]) / (float)60.) / (float)60.;
    if (*(unsigned char *)signs == '-') {
	lat = -lat;
    }
    */
    rlat = ilat * facto;
    rdd = dd * facto;

    /* 
     * first case: exposure time infinitly short
     */
    if (exposure <= (float)0.) {
	rha = ha * facto;
	secz = sin(rlat) * sin(rdd) + cos(rlat) * cos(rdd) * cos(rha);
	secz = 1. / secz;
    /*
     * calulate airmass
     * (formula by Young and Irvine, Astron. J. 72, 945 (1967) used below
     * includes refraction correction but is in principle valid only
     * for observations made at sea level)
     */
	air = (float) (secz * ((float)1. - (secz * secz - (float)1.) * (float)
		.0012));
    /*
     * Second case: exposure time > 0.0. Then, the  airmass calculated is the
     * weighted average of airmasses at t0, 0.5(t1-t0) and t1 with weighting
     * factors w0 = 1/6, w1/2 = 4/6, and w1 = 1/6:
     *
     * W A R N I N G:  What follows is a linear interpolation of a
     * hyperexponentially varying function !
     *
     */
    } else {
	delt = exposure / 480.;		/* 0.5 * (sec)*15/3600 */
	ha -= delt;
	air = (float)0.;

	for (i__ = 1; i__ <= 3; ++i__) {
	    ha += delt;
	    rha = ha * facto;
	    secz = sin(rlat) * sin(rdd) + cos(rlat) * cos(rdd) * cos(rha);
	    secz = 1. / secz;		/* zenith distance */
            /*
             * calulate airmass
             * (below formula by Young and Irvine, Astron. J. 72, 945 (1967)
             * includes refraction correction but is in principle valid only
             * for observations made at sea level)
             */
	    air += weight[i__ - 1] * (float) (secz * ((float)1. - (secz * secz 
		    - (float)1.) * (float).0012));
	}
	air /= (float)6.;
    }
    /*
     * return airmass 
     */
    *airm = air;
} 
