/*
 * LX200 Telescope Control library
 * Author:  Ken Shouse (ken@kshouse.engine.swri.edu).
 * Modified by: Carlos Guirao (cguirao@eso.org)
 */

void MySleep(float numSecs);
int ConnectLX200();
void InitiatePortLX200(char *port);
void DisconnectLX200(void);
void SetRate(int newRate);
void StartSlew(int direction);
void StopSlew(int direction);
float GetRA(void);
float GetDec(void);
int SlewToCoords(float newRA, float newDec);
void GetRAlx200(char *returnStr);
void GetDeclx200(char *returnStr);
int Slew2Coords(char *newRA, char *newDec);
void SyncObjectCoords();
int CheckCoords(float desRA, float desDec);
int CheckConnectLX200(void);
void SetFormat(int format);
void SetPrecision(char *precision);

#define	SLEW		1
#define	FIND		2
#define	CENTER		3
#define	GUIDE		4
#define	NORTH		1
#define	EAST		2
#define	SOUTH		3
#define	WEST		4
