/*  
 * Handles the history and log file of lx200 telescope control 
 * Author: Carlos Guirao (cguirao@eso.org)
 */

/* history record */
typedef struct {
    char  lx_name[MAXNM]; 	/* name, including \0 */
    char  lx_utc_date[12]; 	/* UTC Date */
    char  lx_utc_time[10]; 	/* UTC time */
    char  lx_class;		/* current object type */
    short lx_mag;      		/* visual magnitude * MAGSCALE */
    char  lx_spect[2];		/* spectral codes, if appropriate */
    float lx_epoch;    		/* epoch of f_RA/dec */
    float lx_RA;
    float lx_dec;
    float lx_offRA;
    float lx_offdec;
    float lx_exposure;		/* exposure time base in ETC */
    float lx_airmass;		/* airmass at current location */
} Lx200History;


/* telescope.c */
extern void lxh_add_cb P_((Widget w, XtPointer client, XtPointer call));
extern void lxh_goto P_((Lx200History *hp));
extern void lxh_get P_((Lx200History *hp));
extern float lxh_get_exp P_(());
extern float lxh_get_airmass P_(());


/* lx200hist.c */
extern void lxh_create P_((Widget mb));
