# configuration for CRIRES QC plot on DETLIN/DETMON frames
# version for qc_detlin.py V1.1.1 and later

import os

#########################################################################
# 1. data type, format
#########################################################################

# PRO.CATG of master frame
catg_master = 'LINGAIN_LIN'

# PRO.CATG of linearity info table
catg_lin_info = 'LINGAIN_LIN'

# PRO.CATG of gain info table
catg_gain_info = 'LINGAIN_GAIN'

# PRO.CATG of non-linearity coefficients cube
catg_coeff_map = 'LINGAIN_COEFFS'

# column name for exposure time in the above tables
exp_tab_col = 'DIT'

# header key and its value for identifying lamp-on frames
lamp_on_key = 'HIERARCH ESO DPR TYPE'
lamp_on_keyval = 'FLAT,LAMP,DETCHECK'

# header key containing exposure time of lamp-on frames
exp_key = 'HIERARCH ESO DET DIT'

# header key for fitted gain
qc_gain_key = 'HIERARCH ESO QC GAIN'

# header key for nominal gain
nom_gain_key = 'HIERARCH ESO DET OUT1 CONAD'

# allowed extension numbers
allow_ext = ( 1, 2, 3, 4 )

# center rows/columns (first row/column is 0)
centrow, centcol = 255, 509

# center range for expansion plots
xcentrange = (461, 561)
ycentrange = (205, 305)

# area definition for histogram statistics
stat_xrange = (0,1024)
stat_yrange = (100,400)

#########################################################################
# 2. information to be printed in figure head
#########################################################################

# plot type
plot_type = 'DETLIN'

# list of parameters to be written in second line of plot header
# (keyname, header_key)
parameters = []	# empty list
#parameters = [('CLOCK', 'HIERARCH ESO DET READ CLOCK'),
#              ('QUAD', 'HIERARCH ESO OCS CON QUAD') ]

#########################################################################
# 3. manipulate raw/master frames before plotting
#########################################################################

# pre and over scan
prescan = 0
overscan = 0

# user-defined function to normalise master and reference frames
def norm_mst(fitsHDU, ext=0):
	return fitsHDU[ext].data

# user-defined function to normalise raw frames
def norm_raw(fitsHDU, ext=0):
	return fitsHDU[ext].data

#########################################################################
# 4. reference frames
#########################################################################

# NOT USED

# directory for reference frames
#cal_dir = os.environ.get('DFO_CAL_DIR')
#ref_dir = cal_dir + '/REF_FRAMES'

# method for comparison of master with reference
# can be 'div' or 'sub'
# div: divide current master by reference
# sub: subtract reference from current master
#comp_method = 'sub'

# start of file names of reference frames
#ref_root_name = 'CR_PDRK'

# match keys for finding match between recent product and reference
#ref_match_keys = ('HIERARCH ESO DET DIT', )

#########################################################################
# 5. miscellaneous
#########################################################################

# calculate averaged QC1 parameters [option -i]? Using 'writeQC -m AVERAGE'
avg_qc1 = True

#########################################################################
# 6. define what is plotted by qc_mstplt
#########################################################################

# Plot 1: cuts of lamp-on frame
# To overwrite default scaling of y axis use e.g. plot1_yrange = (100,200)
plot1_yrange = ()

# Plot 2: histogram of lamp-on frame
# logarithmic y axis: True|False
histo_log = True
# x axis scaling is defined via multiple of the stddev of the input image; define multiple here
#histo_range = 6.0
# it is also possible to explicitely define the x range
histo_range = (-1000.0,15000.0)
# step size of binning; to overwrite default insert a value > 0 here
histo_step = 0

