#******************************************************************************
# E.S.O. - VLT project
#
# "@(#) $Id: System.cshrc.source,v 1.160 1999/04/14 09:29:32 vltsccm Exp $" 
#
# who        when      what
# --------  --------  --------------------------------------------------
# wpirani   24/02/98  New structure for machine specific configuration
# gfilippi  31/03/98  support INTROOT
# gfilippi  29/04/98  WIND_LMHOST customizable
# gfilippi  29/04/98  fixed $RTAPROOT/shared/man in MANPATH
# wpirani   26/06/98  Many fixes and enhancements
# wpirani   16/07/98  Fixed Tornado's MANPATH
# gfilippi  25/09/98  added vcsolac support
# gfilippi  08/10/98  fixed error in vcsolac support, DHS_DATA user defined
#

#-----------------------------------------------------------------------
#  >>>>>>>> DO NOT EDIT THIS FILE!!! See System.cshrc.source for more.
#

set os = `uname`
set release = `uname -r`
switch ($os)
    case SunOS:
        set path = ( /usr/5bin /usr/ucb /usr/bin )
        switch ($release)
        case 5*:
            set path = ( /usr/ccs/bin  $path )
            breaksw
        default:
            ;
        endsw
	breaksw
    case HP-UX:
        switch ($release)
        case B.10.10:
        case B.10.20:
            if ( -r /etc/PATH ) then
                setenv PATH `cat /etc/PATH`
            else
                set path = ( /usr/bin \
                             /opt/ansic/bin \
                             /usr/ccs/bin \
                             /usr/contrib/bin \
                             /opt/nettladm/bin \
                             /opt/langtools/bin \
                             /opt/lrom/bin \
                          )
            endif
            breaksw
        default:
            set path = ( /bin /usr/bin )
            breaksw
        endsw
	breaksw
    default:
        set path = ( /bin /usr/bin )
endsw
set myname = `whoami`
if ( ! $?HOST ) setenv HOST `hostname`
if ( ! $?LOGNAME ) setenv LOGNAME `whoami`
if ( $myname == "root" ) then
    set path = ( $path /etc /usr/etc )
else
    set path = ( /usr/local/bin $path ) 
endif


setenv TAPE /dev/rmt/0m

switch ($os)
    case SunOS:
        setenv MANPATH /usr/local/man:/usr/man:/usr/server/man:/usr/server/man/local
        switch ($release)
	case 5*:
            setenv MANPATH /usr/lang/man:${MANPATH}
            breaksw
        default:
            ;
            breaksw
        endsw
	breaksw
    case HP-UX:
        switch ($release)
        case B.10.10:
        case B.10.20:
            if ( -r /etc/MANPATH ) then
                setenv MANPATH `cat /etc/MANPATH`
            else
                setenv MANPATH /usr/share/man:/usr/contrib/man:/usr/local/man
            endif
            # add /usr/server/man/ as well
	    setenv MANPATH ${MANPATH}:/usr/server/man/
            breaksw
        default:
            setenv MANPATH /usr/man:/usr/local/man
            breaksw
        endsw
       	breaksw
    default:
        echo ""
endsw

setenv CC gcc

set X11_ONLY_EXISTS = FALSE
set MOTIF_EXISTS = FALSE

set LATEX_EXISTS = FALSE

setenv GNU_ROOT  /vlt/gnu
setenv TCLTK_ROOT  /vlt/tcltk
setenv DFLOW_ROOT /vlt/dflow

setenv VLT_VCCBOOTTIME	300

#!!! because the majority of the machines are in Graching, the default is TRUE
set VLTSCCM_EXISTS = TRUE

set NEEDS_DIR_USR_ETC = FALSE

set SOFTBENCH_EXISTS = FALSE

set RTAP_EXISTS = FALSE

set STARCAT_EXISTS = FALSE



setenv CMM_HOST te13.hq.eso.org
setenv CMM_PORT 3000

setenv SNIFF_DIR /software/sniff

#----------------------------------------------------------------------
# For every machine there must be a file /vlt/System/config/$HOST.cshrc
# defining the specific setup of that machine 
#
source /vlt/System/config/$HOST.cshrc

if ( -r ~/config/$HOST.cshrc.local ) source ~/config/$HOST.cshrc.local

#-------------------------------------------------------
switch ($os)
    case SunOS:
        setenv LPATH
	if ( $?LD_LIBRARY_PATH == 0 ) then
       	    setenv LD_LIBRARY_PATH /opt/SUNWmotif/lib:/usr/openwin/lib
	else
	    setenv LD_LIBRARY_PATH ${LD_LIBRARY_PATH}:/opt/SUNWmotif/lib:/usr/openwin/lib
	endif 
        ;        # use the default built-in list: /lib /usr/lib /usr/local/lib.
                 # Not true for te1 (see above if (te1) ...)
	breaksw
    case HP-UX:
        switch ($release)
        case B.10.10:
        case B.10.20:
            setenv LPATH      /usr/local/lib:/usr/lib:/usr/ccs/lib
            setenv SHLIB_PATH /usr/local/lib:/usr/lib:/usr/ccs/lib
            breaksw
        default:
            setenv LPATH /lib:/usr/lib:/usr/local/lib
            breaksw
        endsw
	breaksw
    default:
        ;
	breaksw
endsw
switch ($os)
    case HP-UX:
	setenv	EDITOR vuepad 		
	breaksw
    case SunOS:
	setenv	EDITOR  xedit		
	breaksw
    default
	setenv	EDITOR  vi	
endsw
if ( $?PRINTER == 0 ) then
    setenv PRINTER ppbla12
endif
if ( $myname != "root" ) then
    umask 022           
else
    umask 002           
endif
if ($X11_ONLY_EXISTS == "TRUE") then
    switch ($os)
        case SunOS:
            switch ($release)
            case 5*:
                set path    = ( $path  /usr/bin/X11 /usr/openwin/bin )   
                setenv MANPATH ${MANPATH}
                ;
                breaksw
            default:
                ;
                breaksw
            endsw
	    breaksw
        case HP-UX:
            switch ($release)
            case B.10.10:
            case B.10.20:
                set path    = ( $path  /usr/bin/X11 /usr/contrib/bin/X11 )   
                ;
                breaksw
            default:
                set path    = ( $path  /usr/bin/X11 /usr/local/bin/X11 )   
                breaksw
            endsw
            breaksw
        default:
    endsw
endif
if ($MOTIF_EXISTS == "TRUE") then
    switch ($os)
        case SunOS:
            switch ($release)
            case 5*:
                set path    = ( $path  /usr/bin/X11 /usr/openwin/bin )   
                setenv MANPATH ${MANPATH}:/usr/openwin/man:/usr/openwin/share/man
                ;
                breaksw
            default:
                ;
                breaksw
            endsw
	    breaksw
        case HP-UX:
            switch ($release)
            case B.10.10:
            case B.10.20:
                set path    = ( $path  /usr/bin/X11 /usr/contrib/bin/X11 )   
                ;
                breaksw
            default:
                set path    = ( $path  /usr/bin/X11 /usr/local/bin/X11 )   
                breaksw
            endsw
            breaksw
        default:
    endsw
endif
setenv XAPPLRESDIR /vlt/System/X11/app-defaults/


# to enable .Xdefaults processing within VUE OR Motif
if ( $?DISPLAY && -r $HOME/.Xdefaults) then
   xrdb -merge $HOME/.Xdefaults
endif
setenv XENVIRONMENT ${HOME}/.Xdefaults


if ( $?GNU_ROOT ) then 
    switch ($os)
        case SunOS:
            switch ($release)
            case 5*:
                setenv PATH        ${GNU_ROOT}/bin:${PATH}   
                setenv MANPATH     ${GNU_ROOT}/man:${MANPATH}
                setenv LD_LIBRARY_PATH  ${GNU_ROOT}/lib:${LD_LIBRARY_PATH}
                ;
                breaksw
            default:
                ;
                breaksw
            endsw
	    breaksw
        case HP-UX:
            switch ($release)
            case B.10.10:
            case B.10.20:
                setenv PATH        ${GNU_ROOT}/bin:${PATH}   
                setenv MANPATH     ${GNU_ROOT}/man:${MANPATH}
                setenv LPATH       ${GNU_ROOT}/lib:${LPATH}
                setenv SHLIB_PATH  ${GNU_ROOT}/lib:${SHLIB_PATH}
                ;
                breaksw
            default:
                breaksw
            endsw
            breaksw
        default:
    endsw
endif

if ( $?TCLTK_ROOT ) then 
    switch ($os)
        case SunOS:
            switch ($release)
            case 5*:
                setenv PATH        ${TCLTK_ROOT}/bin:${PATH}   
                setenv MANPATH     ${TCLTK_ROOT}/man:${MANPATH}
                setenv LD_LIBRARY_PATH  ${TCLTK_ROOT}/lib:${LD_LIBRARY_PATH}
                ;
                breaksw
            default:
                ;
                breaksw
            endsw
	    breaksw
        case HP-UX:
            switch ($release)
            case B.10.10:
            case B.10.20:
                setenv PATH        ${TCLTK_ROOT}/bin:${PATH}   
                setenv MANPATH     ${TCLTK_ROOT}/man:${MANPATH}
                setenv LPATH       ${TCLTK_ROOT}/lib:${LPATH}
                setenv SHLIB_PATH  ${TCLTK_ROOT}/lib:${SHLIB_PATH}
                ;
                breaksw
            default:
                breaksw
            endsw
            breaksw
        default:
    endsw
endif

if ( $?DFLOW_ROOT ) then 
    switch ($os)
        case SunOS:
            switch ($release)
            case 5*:
                setenv PATH        ${DFLOW_ROOT}/bin:${PATH}   
                setenv MANPATH     ${DFLOW_ROOT}/man:${MANPATH}
                setenv LD_LIBRARY_PATH  ${DFLOW_ROOT}/lib:${LD_LIBRARY_PATH}
                ;
                breaksw
            default:
                ;
                breaksw
            endsw
	    breaksw
        case HP-UX:
            switch ($release)
            case B.10.10:
            case B.10.20:
                setenv PATH        ${DFLOW_ROOT}/bin:${PATH}   
                setenv MANPATH     ${DFLOW_ROOT}/man:${MANPATH}
                setenv LPATH       ${DFLOW_ROOT}/lib:${LPATH}
                setenv SHLIB_PATH  ${DFLOW_ROOT}/lib:${SHLIB_PATH}
                ;
                breaksw
            default:
                breaksw
            endsw
            breaksw
        default:
    endsw
endif


if ($os == "HP-UX")  then
   set path = ( /usr/vue/bin $path )
endif

if ($NEEDS_DIR_USR_ETC == "TRUE") then 
    set path = ( $path /usr/etc )
endif

if ($NEEDS_DIR_USR_ETC == "TRUE") then 
    set path = ( $path /usr/etc )
endif

if ( $?WIND_BASE ) then 
    if ( $?CPU == 0 ) then
        setenv CPU MC68040
    endif

    switch ($CPU)
    case MC68040:
        setenv VX_CPU_FAMILY 68k
        breaksw
    case PPC604:
        setenv VX_CPU_FAMILY ppc
        breaksw
    default:
        setenv VX_CPU_FAMILY unknown_CPU_type_$CPU
        breaksw
	endsw

    if ( $?WIND_HOST_TYPE == 0 ) then
       if ($os == "HP-UX" ) then
          setenv WIND_HOST_TYPE parisc-hpux10
	  setenv VX_HOST_TYPE hp9700
       else
          setenv WIND_HOST_TYPE sun4-solaris2
	  setenv VX_HOST_TYPE solaris
       endif
    endif

    if ( $?WIND_LMHOST == 0 ) then
         setenv WIND_LMHOST te16,te67
    endif
    setenv WIND_REGISTRY `hostname`
    setenv PATH ${PATH}:${WIND_BASE}/host/${WIND_HOST_TYPE}/bin
    setenv GCC_EXEC_PREFIX  ${WIND_BASE}/host/${WIND_HOST_TYPE}/lib/gcc-lib/
    # ONLY FOR SOLARIS2:
    if ($os == "SunOS") then
       setenv LD_LIBRARY_PATH ${LD_LIBRARY_PATH}:/usr/dt/lib:/usr/openwin/lib
    endif

    setenv MANPATH ${MANPATH}:${WIND_BASE}/host/man:${WIND_BASE}/target/man
    setenv MANPATH ${MANPATH}:${WIND_BASE}/host/${WIND_HOST_TYPE}/man

    setenv VXROOT     ${WIND_BASE}/target
    setenv VX_VW_BASE ${WIND_BASE}/target  
    setenv VX_HSP_BASE  $VXROOT
    setenv VX_BSP_BASE  $VXROOT
    setenv VX_VW_BASE   $VXROOT
endif


if ($RTAP_EXISTS == "TRUE") then
    switch ($os)
        case SunOS:
            switch ($release)
            case 5*:
                setenv RTAPROOT /usr/rtap
                set path = ( $path $RTAPROOT/bin $RTAPROOT/script $RTAPROOT/contrib/bin) 
                # for NetLS 2.X 
                set path = ( $path /usr/lib/netls/bin )
                setenv MANPATH ${MANPATH}:${RTAPROOT}/man 
                setenv LD_LIBRARY_PATH ${RTAPROOT}/lib:${LD_LIBRARY_PATH}:/usr/opt/lib
                ;
                breaksw
            default:
                ;
                breaksw
            endsw
	    breaksw
        case HP-UX:
            switch ($release)
            case B.10.10:
            case B.10.20:
                setenv RTAPROOT /opt/rtap/A.06.70
                set path=($path $RTAPROOT/bin)
                setenv MANPATH ${MANPATH}:$RTAPROOT/share/man
                setenv LPATH ${RTAPROOT}/lib:${LPATH} 

                setenv CRTOOLS_ROOT /opt/crTools/C.01.60
                setenv LPATH ${CRTOOLS_ROOT}/shlib:${LPATH}
                setenv SHLIB_PATH ${SHLIB_PATH}:/opt/crTools/C.01.60/shlib:/opt/rtap/A.06.70/shlib

                breaksw
            default:
                setenv RTAPROOT /usr/rtap
                set path = ( $path $RTAPROOT/bin $RTAPROOT/script $RTAPROOT/contrib/bin) 
                # for NetLS 2.X 
                set path = ( $path /usr/lib/netls/bin )
                setenv MANPATH ${MANPATH}:${RTAPROOT}/man 
                setenv LPATH ${RTAPROOT}/lib:${LPATH}
                breaksw
            endsw
            breaksw
        default:
    endsw
    if ( $?RTAPENV == 0 ) then
        setenv RTAPENV w${HOST}
    endif
    if ($os == "HP-UX" && ($release == "A.09.03" || $release == "A.09.05" || $release == "A.09.07")) then
	    setenv RtapUnlockExe_NODE te13    
    endif
endif

if ( $?VLTROOT ) then 
    setenv VLT_CDT_ROOT     $VLTROOT/CDT
    setenv VLT_ERROR_ROOT   $VLTROOT/ERRORS
    setenv VLT_ALARM_ROOT   $VLTROOT/ALARMS
    if ( ! $?VLT_LOG_FILES ) setenv VLT_LOG_FILES	${VLTDATA}/tmp
    if ( ! $?VLT_LOG_ROOT )  setenv VLT_LOG_ROOT	${VLTDATA}/config
    set path = ( $VLTROOT/bin $path )
    setenv MANPATH ${VLTROOT}/man:${VLTROOT}/vw/man:${MANPATH}
    if ( $?INTROOT ) then 
        set path = ( $INTROOT/bin $path )  
        setenv MANPATH ${INTROOT}/man:${INTROOT}/vw/man:${MANPATH}
    endif
    switch ($os)
        case SunOS:
            switch ($release)
            case 5*:
	        setenv LD_LIBRARY_PATH      ${VLTROOT}/lib:${LD_LIBRARY_PATH}
                if ( $?INTROOT ) then 
	            setenv LD_LIBRARY_PATH      ${INTROOT}/lib:${LD_LIBRARY_PATH}
                endif
                breaksw
            default:
                ;
                breaksw
            endsw
	    breaksw
        case HP-UX:
            switch ($release)
            case B.10.10:
            case B.10.20:
	        setenv LPATH      ${VLTROOT}/lib:${LPATH}
                setenv SHLIB_PATH ${VLTROOT}/lib:${SHLIB_PATH}
                if ( $?INTROOT ) then 
	            setenv LPATH      ${INTROOT}/lib:${LPATH}
                    setenv SHLIB_PATH ${INTROOT}/lib:${SHLIB_PATH}
                endif
                breaksw
            default:
                ;
                breaksw
            endsw
            breaksw
        default:
            ;
    endsw
endif

if ( $?DFS_ROOT ) then 
    setenv DFS_RUNTIME_ROOT  ${DFS_ROOT}/dfs
    setenv DFS_HOME          ${DFS_RUNTIME_ROOT}
    setenv DFS_HELP          ${DFS_HOME}/help
    setenv PATH {$PATH}:{$DFS_RUNTIME_ROOT}/bin
    setenv MANPATH {$MANPATH}:{$DFS_RUNTIME_ROOT}/man
    if ( $?DHS_DATA == 0 ) then
        if ( $?INS_ROOT == 0 ) then
            set INS_ROOT = ___ERROR___DHS_requires_INS_ROOT_to_be_defined
        endif
        if ( $?INS_USER == 0 ) then
            set INS_USER = ___ERROR___DHS_requires_INS_USER_to_be_defined
        endif
        setenv DHS_DATA    ${INS_ROOT}/${INS_USER}/ARCDATA
    endif
    if ( $?BAD_DIR == 0 ) then
        if ( $?INS_ROOT == 0 ) then
            set INS_ROOT = ___ERROR___DHS_requires_INS_ROOT_to_be_defined
        endif
        if ( $?INS_USER == 0 ) then
            set INS_USER = ___ERROR___DHS_requires_INS_USER_to_be_defined
        endif
        setenv BAD_DIR     ${INS_ROOT}/${INS_USER}/BADDATA
    endif
    setenv DHS_LOG     ${DHS_DATA}
    if ( $?DHS_HOST == 0 ) then
        set DHS_HOST = ___ERROR___DHS_requires_DHS_HOST_to_be_defined
    endif
    setenv DHS_CONFIG  archeso@${DHS_HOST}:/data/msg
    if ( $?OLAS_ID == 0 ) then
        set OLAS_ID = ___ERROR___DHS_requires_OLAS_ID_to_be_defined
    endif
endif

if ($VLTSCCM_EXISTS == "TRUE") then
    setenv VLTSCCM /vltsccm/vlt/SCCM
    setenv VLT_DOCARCHIVE_HOST te13
    setenv VLT_DOCARCHIVE_ROOT /vltsccm/vlt/doc    
    setenv PLAN_ROOT $VLTSCCM/wpDatabase
    if ( ! $?LCUROOT ) then
	setenv LCUROOT 		/vltsccm/LCUS
    endif
    # RHOST is defined host by host.
endif

if ($STARCAT_EXISTS == "TRUE") then
    setenv SKYCATDIR /vlt/dflow
endif

if ( $?MIDASHOME ) then 
    setenv MANPATH ${MANPATH}:$MIDASHOME/$MIDVERS/system/unix
    setenv PATH ${PATH}:$MIDASHOME/$MIDVERS/system/unix
    if ( "$os" == "SunOS" ) then
	setenv LD_LIBRARY_PATH ${LD_LIBRARY_PATH}:$MIDASHOME/$MIDVERS/lib
    else
	setenv SHLIB_PATH ${SHLIB_PATH}:$MIDASHOME/$MIDVERS/lib
    endif
endif

if ( $?SNIFF_DIR ) then
    switch ($os)
        case HP-UX:
             setenv PATH        ${PATH}:${SNIFF_DIR}/bin
             breaksw
        default:
             breaksw
    endsw
endif

if ($SOFTBENCH_EXISTS == "TRUE") then
    set path = ( /usr/softbench/bin $path )  
    setenv MANPATH /usr/softbench/man:${MANPATH}
endif

if ($LATEX_EXISTS == "TRUE") then
    setenv PATH ${PATH}:/usr/server/tetex/bin
    setenv MANPATH ${MANPATH}:/usr/server/tetex/man
    unsetenv BIBINPUTS BSTINPUTS GFFONTS MFBASES MFINPUTS MFPOOLi
    unsetenv PKFONTS TEXFONTS TEXFORMATS TEXPOOL VFFONTS
    setenv TEXINPUTS :/usr/server/tetex/journal-styles      # for teTeX
    setenv INFOPATH /usr/server/tetex/info
endif


if ( $?FMHOME ) then 
   setenv PATH ${PATH}:$FMHOME/bin
   if ( $?FM_FLS_HOST == 0 ) then 
      # default to server for garching machines
      setenv FM_FLS_HOST te16.hq.eso.org
   endif
endif

if ($?TSEE_STARTUP) then 
     source $TSEE_STARTUP
     setenv MANPATH ${MANPATH}:$TSEE_MANPATH
endif

switch ($os)
    case SunOS:
	switch ($release)
	    case 5*:
		if ($?CMD_SHMADDR == 0) then
	    	    setenv CMD_SHMADDR 0x60000000
		endif
		breaksw
            default:
		;
		breaksw
        endsw
    default:
	;
	breaksw
endsw

#-------------------------------------------------------------------------------
#
# SET-UP THE TIMEZONE
#
#-------------------------------------------------------------------------------
#
if ( -r /etc/TIMEZONE ) then
    setenv TZ `/usr/bin/sh -c '. /etc/TIMEZONE ; echo $TZ' `
else
    setenv TZ MET-1METDST
endif

if ( $myname != "root" ) set path = ( . $path)
unset	myname
unset	os

alias	pwd	'echo $cwd'
# ___oOo___
