#*******************************************************************************
# E.S.O. - VLT project
#
# "@(#) $Id: System.login.source,v 1.160 1999/04/14 09:29:32 vltsccm Exp $" 
#
# System.login(.source)
#
# who         when      what
# --------  --------  ---------------------------------------------------
# wpirani   24/02/98  New structure for machine specific configuration
#

#  >>>>>>>> DO NOT EDIT THIS FILE!!! See System.login.source for more.
#


set os = `uname`
set myname = `whoami`
switch ($os)
    case SunOS:
        breaksw

    case HP-UX:
        breaksw

    default:
        echo "System.login: WARNING - unknown operating system $os"
        echo ""
        echo "    System.login has been designed to work on SunOS or HP-UX"
        echo "    and it might not work here. Please ask your System Manager"
        echo ""
        echo "Login proceedes . . ."
        echo ""
endsw

setenv  MORE    -scdf    

setenv PAGER more

set     autologout = 0          
set     ignoreeof               
set     cdpath = (~ ~/.. ..)    
set     noclobber               
unset   notify                  

set MYSHELL = `basename $SHELL`
if ($MYSHELL == "tcsh") then
	set prompt="%m %n:%~ %h > "
endif

set history  = 40                    
set savehist = 40                    
set     filec                   
set     fignore = ( .o )        
set     time = 10               
set     system = `hostname`     
unset   noglob
alias   a       'alias'
alias   u       'unalias'
alias   .       'echo $cwd'
alias   subdir  'ls -dl * | egrep "^total.*|^d.*|^l.*/"'
alias   ls      'ls -FCa'
alias   ll      'ls -al'
alias   du      'echo "512-byte blocks allocated under $PWD . . . "; ""du -s'
switch ($os)
    case SunOS:
        alias   df    'echo "disk occupation (in Kbyte) . . ."; /usr/5bin/df -k'
        breaksw

    case HP-UX:
        alias   df    'echo "disk occupation (in 512-byte units) . . ."; /bin/df -t'
        breaksw
endsw

alias   h       history
alias   lo      logout
alias   m       '$PAGER'
alias   apropos 'man -k'
if ($?DISPLAY) then
    if ($?EDITOR) alias   edit    '$EDITOR \!* &' 
    alias   xterm   'xterm  -ls -sb -T xterm@`hostname`  \!* &'
    alias   qxrdb   'xrdb -q | grep \!* '
    switch ($os)
        case SunOS:
            alias   xfig    'xfig \!* &'
            alias   xtex    'xtex \!* &'
            breaksw
        case HP-UX:
            alias   xtex    'xdvi \!* &'
            alias   hpterm  'hpterm -ls -sb -sl 6s -T HPterm@`hostname` \!* &'
            alias   tkman   'tkman \!* &'
            alias   xr      'set noglob; eval `/usr/bin/X11/resize`'
            alias   res     xr
            breaksw
    endsw
else  
    alias   edit    'vi \!*' 
    echo ""
    echo "System.login: WARNING - variable DISPLAY not defined "
    echo "              set DISPLAY before using any Xwindow application or"
    echo "              give -display option in the command line invoking"
    echo "              the Xwindow application."
    echo "              Alternatively, open an xterm instead of this type of"
    echo "              login."
    echo ""
endif
if ( $?VLTSCCM ) then 
    alias laptop cat $VLTSCCM/laptop/booking
endif

alias   psg     'ps -aef | grep \!* | grep -v grep'

if ( $?TERM ) then
    if ($TERM != "unknown" && $TERM != "network" && $TERM != "su") then 
        stty start ^Q stop ^S intr ^C kill ^U erase ^H       
        stty echoe
        if ( $?DISPLAY && $os == "HP-UX" ) then
            eval `/usr/bin/X11/resize`  >& /dev/null
            eval `/usr/bin/X11/resize`
        endif
    else
        echo "System.login: WARNING - TERM type >$TERM< unknown "
        echo "              Use stty to define terminal setting."
        echo ""
    endif
else
    echo "System.login: WARNING - \$TERM not defined "
    echo "              Set \$TERM and use stty to define terminal setting."
    echo ""
endif
if ( $?VLTROOT ) then
   alias setmod "source $VLTROOT/bin/vltSetmod.csh"
endif 
if ( $?VXROOT ) then
    alias vxman     'setenv OLD_MANPATH $MANPATH; setenv MANPATH $VXROOT/man\:$VXROOT/GNU/$VX_HOST_TYPE.$VX_CPU_FAMILY/man; man \!*; setenv MANPATH $OLD_MANPATH; unsetenv OLD_MANPATH'
endif
if ( $?FMHOME )  then
    alias frame $FMHOME/bin/imaker
endif
if ( $?MIDASHOME ) then 
    alias inmidas   $MIDASHOME/$MIDVERS/system/unix/inmidas
    alias gomidas   $MIDASHOME/$MIDVERS/system/unix/gomidas
    alias helpmidas $MIDASHOME/$MIDVERS/system/unix/helpmidas
endif

# if ( $os == "HP-UX" ) then
    if ( -f /etc/motd ) then
        cat /etc/motd
        echo ""
    endif
# endif
if ( -f /usr/bin/mail ) then                   
    mail -e
    if ( $status == 0 ) then
	echo  "You have mail on $HOST."
    endif
endif

if ( -f /usr/bin/news ) then
    news -n                       
endif


unset  myname
unset  os

# ___oOo___
