#******************************************************************************
# E.S.O. - VLT project
#
# "@(#) $Id: wdft1.cshrc,v 1.4 1998/05/11 08:45:54 vltsccm Exp $" 
#
# who        when      what
# --------  --------  ----------------------------------------------
# gfilippi  08/01/98  created for NTT installation in La Silla
# wpirani   06/07/98  customized for te1 in ESO Garching
#

#
# include definition common to all VCM machines
#
source /vlt/System/config/DEV.cshrc

setenv VLTROOT /vlt/MAY97
unsetenv WIND_BASE
unsetenv WIND_HOST_TYPE
set RTAP_EXISTS = FALSE
unsetenv RTAPENV
setenv NOCCS defined
unsetenv MIDASHOME
unsetenv MIDVERS
unsetenv FMHOME
set set LATEX_EXISTS = TRUE

set path = (/usr/server/mail+news/bin $path)
set path = ($path /usr/server/bin)
set path = ($path /usr/server/gnu/bin)
set path = ($path /usr/server/tk/4.1/bin)
setenv MANPATH ${MANPATH}:/usr/server/gnu/man:/usr/server/man/local
# for X11 R5
set path = ($path /usr/server/X11/bin)
setenv LD_LIBRARY_PATH /usr/server/X11/lib
setenv MANPATH ${MANPATH}:/usr/server/X11/man
set X11_ONLY_EXISTS = TRUE
set X11_ONLY_EXISTS = FALSE
set MOTIF_EXISTS = TRUE
set NEEDS_DIR_USR_ETC = TRUE
setenv MOTIFHOME /opt/SUNWmotif
setenv OPENWINHOME /usr/openwin
setenv LD_LIBRARY_PATH ${LD_LIBRARY_PATH}:$MOTIFHOME/lib:$OPENWINHOME/lib:/usr/lib/X11:/usr/local/lib:/usr/ucblib:/usr/ccs/lib
setenv PATH ${PATH}:$MOTIFHOME/bin:$MOTIFHOME/demo

############################
#                          #
# TRANSPUTER STUFF FOLLOWS #
#                          #
############################

# Transputer Root directory
setenv TRANSPUTER_ROOT /usr/local
# official Inmos occam2 tool root directory for SUN machines:
setenv OCCAM_ROOT $TRANSPUTER_ROOT/D4305
# C language transputer configurator:
setenv IC_ROOT $TRANSPUTER_ROOT/TrUtils/ic/
# S507 Network root directory:
setenv INMOSNET $TRANSPUTER_ROOT/S507
# DSP root directory:
setenv DSP_ROOT $TRANSPUTER_ROOT/DSP
# INQUEST root directory:
setenv INQUEST_ROOT $TRANSPUTER_ROOT/INQUEST
# occam2 package licence server
setenv LM_LICENSE_FILE $OCCAM_ROOT/license/solaris/inmos_ld.dat

# Variables used in the INMOS occam2 package
#
# ISEARCH is the "file system search path" used by compiler, linker,
# configurer, ...
# NOTE: it needs the closing slash '/' at the end of the directory name
# a - official packages directories:
setenv ISEARCH "$OCCAM_ROOT/libs/;$DSP_ROOT/dtm/h/;$DSP_ROOT/dtm/lib/"
# b - local <module>/ace/ directories:
setenv ISEARCH "$ISEARCH;../include/;../lib/;../object/"

# TRANSPUTER specifies the default capability name to use
setenv TRANSPUTER T805

# IDEBUGSIZE is the amount of the root transputer memory:
# it is used by idebug
setenv IDEBUGSIZE '#400000'

# IBOARDSIZE is the board memory size
setenv IBOARDSIZE '#400000'

# ITERM: terminal definition file
# it is used by idebug and isim
setenv ITERM $OCCAM_ROOT/iterms/sun.itm

# ICONDB specifies the whereabouts of the connection database file
# it is used by iserver
setenv ICONDB $OCCAM_ROOT/connect/EsoConn.dat
#
# set the transputer path TRANPATH
#
# a - put INMOSNET before to use its iserver for the IMS B300
set TRANPATH = ( $INMOSNET/bin/sun4 )
# b - put occam2 directories
set TRANPATH = ( $TRANPATH $OCCAM_ROOT/libs $OCCAM_ROOT/tools )
# c - put dsp directories
set TRANPATH = ( $TRANPATH $DSP_ROOT/dtm/h $DSP_ROOT/dtm/lib )
# d - put C configurer directory
set TRANPATH = ( $TRANPATH $IC_ROOT )
# set path (path is also used by imake to create makefile)
set path = ( $path $TRANPATH)

#
#___oOo___
