
# @(#) $Revision: 1.160 $      

# Default (example of) system-wide profile file (/usr/bin/csh initialization).
# This should be kept to the bare minimum every user needs.

	# default path for all users.
	set path=(/usr/bin /usr/ccs/bin /usr/contrib/bin)

	if ( -r /etc/PATH ) then

		# Insure that $PATH includes /usr/bin .  If /usr/bin is
		# present in /etc/PATH then $PATH is set to the contents
		# of /etc/PATH.  Otherwise, add the contents of /etc/PATH
		# to the end of the default $PATH definition above.

		grep -q -e '^/usr/bin$' -e '^/usr/bin:' -e ':/usr/bin:'\
                        -e ':/usr/bin$' /etc/PATH

                if ( $status ) then
			set path=($path `tr ":" " " </etc/PATH `)
		else
			set path=(`tr ":" " " </etc/PATH `)
		endif
	endif

	set prompt="[\!] % "

	# default MANPATH
	setenv MANPATH /usr/share/man:/usr/contrib/man:/usr/local/man

	if ( -r /etc/MANPATH ) then
		setenv MANPATH `cat /etc/MANPATH`
	endif

	if ( -r /etc/TIMEZONE ) then
		setenv TZ `/usr/bin/sh -c '. /etc/TIMEZONE ; echo $TZ' ` # set the TZ variable
	else
		setenv TZ MST7MDT      # change this for local time.
	endif

 	if ( ! $?TERM ) then			# if TERM is not set,
 		setenv TERM hp			#   use the default
 	endif

# GIF 04/12/98  skip the rest ....
exit 

# This is to meet legal requirements...

	cat /etc/copyright			# copyright message.

# Miscellaneous shell-only actions:

	if ( -f /etc/motd ) then
		cat /etc/motd			# message of the day.
	endif

	if ( -f /usr/bin/mail ) then
		mail -e 	 		# notify if mail.

		if ( $status == 0 ) echo  "You have mail."
	endif

	if ( -f /usr/bin/news ) then
		news -n				# notify if new news.
	endif

	if ( -r /tmp/changetape ) then		# might wish to delete this:
		echo
		echo "You are the first to log in since backup:"
		echo "Please change the backup tape.\n"

		rm -f /tmp/changetape
	endif

