#*******************************************************************************
# E.S.O. - VLT project
#
# "@(#) $Id: accData.sql,v 1.25 1999/05/09 22:46:25 vltsccm Exp $"
#
# who       when      what
# --------  --------  ----------------------------------------------
# mkiekebu  01/03/99  la1agb, la1agc and lt1adc changed to PPC
# mkiekebu  25/02/99  IP number of ISSAC updated.
# ssandroc  14/12/98  corrected UT2: subnet assignment, wt2tcs final address
# mkiekebu  14/09/98  FORS environments added
# tphan     11/09/98  updated for UT2
# bgustafs  03/07/98  corrected environments lt1m2 and lr1m2
# bgustafs  09/05/98  corrected configuration of lr1m2, lr1aga, lr1agb,
#                     lr1agc and lr1agco
# gfilippi  23/12/97  configured for VLT UT1
#

#************************************************************************
#   NAME
#       accData.sql - ASCII copy of the ACC database
#
#   SYNOPSIS
#       $VLTDATA/msql/accData.sql
#
#   DESCRIPTION
#       database definition for some machines currently part 
#       of the VLT development pool
# 
#       To load this file:
#                           $VLTDATA/msql/accLoadData
#
#
#  CAUTION
#
#------------------------------------------------------------------------

# **************
# *  Subnets   *
# **************
#
# enable_status  -> accENABLED | accDISABLED
# telescope_unit -> UT1 | UT2 | UT3 | UT4 | VLTI | (null)
#
#        subnet_name     Subnet name
#        description     Short description
#        ip_address      IP address (x.y.z.0)
#        router_name     DNS router name (gateway)
#        router_ip_addr  router (gateway) IP address
#        enable_status   '' (not used)
#        instrument      '' (not used)
#        telescope_unit  '' (not used)
#

INSERT INTO subnet VALUES ('a1','UT1 acquisition       LAN','134.171.208.0','esohq-r1-atm0-12','134.171.208.254','','','')\g
INSERT INTO subnet VALUES ('a2','UT2 acquisition       LAN','134.171.209.0','esohq-r1-atm0-12','134.171.209.254','','','')\g
INSERT INTO subnet VALUES ('a3','UT3 acquisition       LAN','134.171.210.0','esohq-r1-atm0-12','134.171.210.254','','','')\g
INSERT INTO subnet VALUES ('a4','UT4 acquisition       LAN','134.171.211.0','esohq-r1-atm0-12','134.171.211.254','','','')\g

INSERT INTO subnet VALUES ('r1','UT1 Rapid Guiding     LAN','134.171.212.0','esohq-r1-atm0-12','134.171.212.254','','','')\g
INSERT INTO subnet VALUES ('r2','UT2 Rapid Guiding     LAN','134.171.213.0','esohq-r1-atm0-12','134.171.213.254','','','')\g
INSERT INTO subnet VALUES ('r3','UT3 Rapid Guiding     LAN','134.171.214.0','esohq-r1-atm0-12','134.171.214.254','','','')\g
INSERT INTO subnet VALUES ('r4','UT4 Rapid Guiding     LAN','134.171.215.0','esohq-r1-atm0-12','134.171.215.254','','','')\g

INSERT INTO subnet VALUES ('t1','UT1 Telescope Control LAN','134.171.216.0','esohq-r1-atm0-12','134.171.216.254','','','')\g
INSERT INTO subnet VALUES ('t2','UT2 Telescope Control LAN','134.171.217.0','esohq-r1-atm0-12','134.171.217.254','','','')\g
INSERT INTO subnet VALUES ('t3','UT3 Telescope Control LAN','134.171.218.0','esohq-r1-atm0-12','134.171.218.254','','','')\g
INSERT INTO subnet VALUES ('t4','UT4 Telescope Control LAN','134.171.219.0','esohq-r1-atm0-12','134.171.219.254','','','')\g

INSERT INTO subnet VALUES ('ta','UT1 Test Camera LAN','134.171.202.0','esohq-r1-atm0-12','134.171.202.254','','','')\g

INSERT INTO subnet VALUES ('f1','UT1 FORS Instr. LAN','134.171.196.0','esohq-r1-atm0-12','134.171.196.254','','','')\g

INSERT INTO subnet VALUES ('is','UT1 ISAAC Instr. LAN','134.171.199.0','esohq-r1-atm0-12','134.171.199.254','','','')\g

INSERT INTO subnet VALUES ('gs','General Services LAN','134.171.224.0','esohq-r1-atm0-12','134.171.224.254','','','')\g

# **************
# *  stations  *
# **************

#
# define  stations (hosts)
#    station_name   host name (e.g.: te49) 
#    station_type   '' 
#    subnet_name    ''  
#    ip_address     IP address of the host (x.y.z.w)
#    active_status  ''
#    location       ''
#    responsible    ''
#    telephone      ''
#    email          ''
#    station_arch   hp9700 | solaris | 68k 
#    station_cpu    hppa   | sparc   | MC68040 
#    station_bsp    mv167  (for LCU host type only)
#    attic          1 (do not show it in host list) | 0 (visible)
#

#
# UT1 Guide/acquisition LAN
#
INSERT INTO station VALUES ('wa1tcs' ,'','a1','134.171.208.1'  ,'','UT1-HP-C110 guide/acquisition WS ','VCM','','','hp9700' ,'hppa'  ,''  ,0)\g
INSERT INTO station VALUES ('la1aga' ,'','a1','134.171.208.20' ,'','UT1-autoguiding camera Nasmyth A ','VCM','','','68k','MC68040','mv167',0)\g
INSERT INTO station VALUES ('la1agb' ,'','a1','134.171.208.21' ,'','UT1-autoguiding camera Nasmyth B ','VCM','','','ppc','PPC604','mv2604',0)\g
INSERT INTO station VALUES ('la1agc' ,'','a1','134.171.208.22' ,'','UT1-autoguiding camera Cassegrain','VCM','','','ppc','PPC604','mv2604',0)\g
INSERT INTO station VALUES ('la1agco','','a1','134.171.208.23' ,'','UT1-autoguiding camera Coude     ','VCM','','','68k','MC68040','mv167',0)\g
INSERT INTO station VALUES ('la1iaa' ,'','a1','134.171.208.25' ,'','UT1-image analysis Nasmyth A     ','VCM','','','68k','MC68040','mv167',0)\g
INSERT INTO station VALUES ('la1iab' ,'','a1','134.171.208.26' ,'','UT1-image analysis Nasmyth B     ','VCM','','','68k','MC68040','mv167',0)\g
INSERT INTO station VALUES ('la1iac' ,'','a1','134.171.208.27' ,'','UT1-image analysis Cassegrain    ','VCM','','','68k','MC68040','mv167',0)\g
INSERT INTO station VALUES ('la1iaco','','a1','134.171.208.28' ,'','UT1-image analysis Coude         ','VCM','','','68k','MC68040','mv167',0)\g
INSERT INTO station VALUES ('sa01'   ,'','a1','134.171.208.200','','UT1-guide acquisition HUB1       ','VCM','','',''   ,''       ,''     ,0)\g
INSERT INTO station VALUES ('ra11'   ,'','a1','134.171.208.254','','UT1-autoguiding Gateway          ','VCM','','',''   ,''       ,''     ,0)\g

#
# UT1 Rapid Guiding LAN
#
INSERT INTO station VALUES ('lr1m2'  ,'','r1','134.171.212.30' ,'','UT1-M2                           ','VCM','','','68k','MC68040','',0)\g
INSERT INTO station VALUES ('lr1aga' ,'','r1','134.171.212.20' ,'','UT1-autoguiding camera Nasmyth A ','VCM','','','68k','MC68040','mv167',0)\g
INSERT INTO station VALUES ('lr1agb' ,'','r1','134.171.212.21' ,'','UT1-autoguiding camera Nasmyth B ','VCM','','','68k','MC68040','mv167',0)\g
INSERT INTO station VALUES ('lr1agc' ,'','r1','134.171.212.22' ,'','UT1-autoguiding camera Cassegrain','VCM','','','68k','MC68040','mv167',0)\g
INSERT INTO station VALUES ('lr1agco','','r1','134.171.212.23' ,'','UT1-autoguiding camera Coude     ','VCM','','','68k','MC68040','mv167',0)\g
INSERT INTO station VALUES ('sr01'   ,'','r1','134.171.212.200','','UT1-rapid guiding HUB1           ','VCM','','',''   ,''       ,''     ,0)\g

#
# UT1 Telescope Control LAN
#
# IMPORTANT NOTE:
INSERT INTO station VALUES ('wt1tcs' ,'','t1','134.171.216.1'  ,'','UT1-HP-C110 Telescope Control WS ','VCM','','','hp9700' ,'hppa'  ,''  ,0)\g
INSERT INTO station VALUES ('wt1d95' ,'','t1','134.171.216.10' ,'','UT1-HP-715 DEC95 WS for m1m3/m2  ','VCM','','','hp9700' ,'hppa'  ,''  ,0)\g
INSERT INTO station VALUES ('lt1aga' ,'','t1','134.171.216.20' ,'','UT1-autoguiding camera Nasmyth A ','VCM','','','68k','MC68040','mv167',0)\g
INSERT INTO station VALUES ('lt1agb' ,'','t1','134.171.216.21' ,'','UT1-autoguiding camera Nasmyth B ','VCM','','','68k','MC68040','mv167',0)\g
INSERT INTO station VALUES ('lt1agc' ,'','t1','134.171.216.22' ,'','UT1-autoguiding camera Cassegrain','VCM','','','68k','MC68040','mv167',0)\g
INSERT INTO station VALUES ('lt1agco','','t1','134.171.216.23' ,'','UT1-autoguiding camera Coude     ','VCM','','','68k','MC68040','mv167',0)\g
INSERT INTO station VALUES ('lt1iaa' ,'','t1','134.171.216.25' ,'','UT1-image analysis Nasmyth A     ','VCM','','','68k','MC68040','mv167',0)\g
INSERT INTO station VALUES ('lt1iab' ,'','t1','134.171.216.26' ,'','UT1-image analysis Nasmyth B     ','VCM','','','68k','MC68040','mv167',0)\g
INSERT INTO station VALUES ('lt1iac' ,'','t1','134.171.216.27' ,'','UT1-image analysis Cassegrain    ','VCM','','','68k','MC68040','mv167',0)\g
INSERT INTO station VALUES ('lt1iaco','','t1','134.171.216.28' ,'','UT1-image analysis Coude         ','VCM','','','68k','MC68040','mv167',0)\g
INSERT INTO station VALUES ('lt1m2'  ,'','t1','134.171.216.30' ,'','UT1-M2                           ','VCM','','','68k','MC68040','mv167_m2-p0-s16',0)\g
INSERT INTO station VALUES ('lt1m2a' ,'','t1','134.171.216.31' ,'','UT1-M2 proxy                     ','VCM','','','68k','MC68040','',0)\g
INSERT INTO station VALUES ('lt1m2b' ,'','t1','134.171.216.32' ,'','UT1-M2 proxy                     ','VCM','','','68k','MC68040','mv167_m2-p1-s16',0)\g
INSERT INTO station VALUES ('lt1ada' ,'','t1','134.171.216.35' ,'','UT1-adapter-rotator Nasmyth A    ','VCM','','','68k','MC68040','mv167',0)\g
INSERT INTO station VALUES ('lt1adb' ,'','t1','134.171.216.36' ,'','UT1-adapter-rotator Nasmyth B    ','VCM','','','68k','MC68040','mv167',0)\g
INSERT INTO station VALUES ('lt1adc' ,'','t1','134.171.216.37' ,'','UT1-adapter-rotator Cassegrain   ','VCM','','','ppc','PPC604','mv2604',0)\g
INSERT INTO station VALUES ('lt1enc' ,'','t1','134.171.216.40' ,'','UT1-Enclosure                    ','VCM','','','68k','MC68040','mv167',0)\g
INSERT INTO station VALUES ('lt1hb'  ,'','t1','134.171.216.41' ,'','UT1-Hydrostatic bearings         ','VCM','','','68k','MC68040','mv167',0)\g
INSERT INTO station VALUES ('lt1alt' ,'','t1','134.171.216.42' ,'','UT1-Altitude                     ','VCM','','','68k','MC68040','mv167',0)\g
INSERT INTO station VALUES ('lt1az'  ,'','t1','134.171.216.43' ,'','UT1-Azimuth                      ','VCM','','','68k','MC68040','mv167',0)\g
INSERT INTO station VALUES ('lt1co'  ,'','t1','134.171.216.44' ,'','UT1-Coude                        ','VCM','','','68k','MC68040','mv167',0)\g
INSERT INTO station VALUES ('lt1m1m3','','t1','134.171.216.48' ,'','UT1-M1M3                         ','VCM','','','68k','MC68040','mv167',0)\g
INSERT INTO station VALUES ('lt1m1bp','','t1','134.171.216.49' ,'','UT1-M1M3 backplane               ','VCM','','','68k','MC68040','mv167',0)\g
INSERT INTO station VALUES ('lt1m1a' ,'','t1','134.171.216.50' ,'','UT1-M1M3 VIUC #0 proxy           ','VCM','','','68k','MC68040','mv167',0)\g
INSERT INTO station VALUES ('lt1m1b' ,'','t1','134.171.216.51' ,'','UT1-M1M3 VIUC #1 proxy           ','VCM','','','68k','MC68040','mv167',0)\g
INSERT INTO station VALUES ('lt1m1c' ,'','t1','134.171.216.52' ,'','UT1-M1M3 VIUC #2 proxy           ','VCM','','','68k','MC68040','mv167',0)\g
INSERT INTO station VALUES ('lt1m1d' ,'','t1','134.171.216.53' ,'','UT1-M1M3 VIUC #3 proxy           ','VCM','','','68k','MC68040','mv167',0)\g
INSERT INTO station VALUES ('lt1m1e' ,'','t1','134.171.216.54' ,'','UT1-M1M3 VIUC #4 proxy           ','VCM','','','68k','MC68040','mv167',0)\g
INSERT INTO station VALUES ('lt1m1f' ,'','t1','134.171.216.55' ,'','UT1-M1M3 VIUC #5 proxy           ','VCM','','','68k','MC68040','mv167',0)\g
INSERT INTO station VALUES ('st11'   ,'','t1','134.171.216.200','','UT1-Telescope Control HUB1       ','VCM','','',''   ,''       ,''     ,0)\g
INSERT INTO station VALUES ('st12'   ,'','t1','134.171.216.201','','UT1-Telescope Control HUB2       ','VCM','','',''   ,''       ,''     ,0)\g
INSERT INTO station VALUES ('rt11'   ,'','t1','134.171.216.254','','UT1-Telescope Control Gateway    ','VCM','','',''   ,''       ,''     ,0)\g


#
# UT1 Guide/acquisition LAN
#
INSERT INTO station VALUES ('wgsops' ,'','gs','134.171.224.2'  ,'','Operation Support WS','VLT','','','hp9700' ,'hppa'  ,''  ,0)\g

#
# UT1 Instrument: Test Camera
#
INSERT INTO station VALUES ('wtatcam','','ta','134.171.202.1'  ,'','UT1-HP-C110 Test Camera WS       ','VCM','','','hp9700' ,'hppa'  ,''  ,0)\g
INSERT INTO station VALUES ('ltatcam','','ta','134.171.202.16' ,'','UT1-TC Instrument Control        ','VCM','','','68k','MC68040','mv167',0)\g
INSERT INTO station VALUES ('ltatcpi','','ta','134.171.202.17' ,'','UT1-TC Pupil image TCCD          ','VCM','','','68k','MC68040','mv167',0)\g
INSERT INTO station VALUES ('ltatcwf','','ta','134.171.202.18' ,'','UT1-TC Wavefront TCCD            ','VCM','','','68k','MC68040','mv167',0)\g
INSERT INTO station VALUES ('wtaccd' ,'','ta','134.171.202.19' ,'','UT1-TC FIERA CCD                 ','VCM','','','solaris','sparc' ,''  ,0)\g

#
# UT1 Instrument: FORS        
#
INSERT INTO station VALUES ('wf1ors' ,'','f1','134.171.196.1'  ,'','UT1-HP-C110 FORS Instrument WS   ','VCM','','','hp9700' ,'hppa'  ,''  ,0)\g
INSERT INTO station VALUES ('lf1ics1','','f1','134.171.196.16' ,'','LCU FORS 1                       ','VCM','','','68k','MC68040','mv167',0)\g
INSERT INTO station VALUES ('lf1ics2','','f1','134.171.196.17' ,'','LCU FORS 1                       ','VCM','','','68k','MC68040','mv167',0)\g
INSERT INTO station VALUES ('lf1ics3','','f1','134.171.196.18' ,'','LCU FORS 1                       ','VCM','','','68k','MC68040','mv167',0)\g
INSERT INTO station VALUES ('wf1ccd' ,'','f1','134.171.196.19' ,'','FORS 1 FIERA CCD                 ','VCM','','','solaris','sparc' ,''  ,0)\g

#
# UT1 Instrument: ISAAC        
#
INSERT INTO station VALUES ('wisaac', '','is','134.171.199.1'  ,'','UT1-HP-C110 ISAAC Instrument WS  ','VCM','','','hp9700' ,'hppa'  ,''  ,0)\g
INSERT INTO station VALUES ('lisic',  '','is','134.171.199.16' ,'','LCU ISAAC INS                    ','VCM','','','68k','MC68040','mv167',0)\g
INSERT INTO station VALUES ('listccd','','is','134.171.199.17' ,'','LCU ISAAC TCCD                   ','VCM','','','68k','MC68040','mv167',0)\g
INSERT INTO station VALUES ('wisdc',  '','is','134.171.199.18' ,'','ISAAC FIERA CCD                  ','VCM','','','solaris','sparc' ,''  ,0)\g

# ******************
# *  environments  *
# ******************

# define environments (RTAP, CCS-lite, LCU)
#
#    progenv_name   environment name
#    description    ''
#    env_type       RTAP | LCU | QSEMU
#    tcp_port       TCP port number (as in /etc/services)
#    station_name   host where the environment is running
#    attic          1 (do not show it in environment list) | 0 (visible)
 
INSERT INTO prog_environment VALUES ('wt1tcs'  ,'','RTAP',2301,'wt1tcs' ,'','','',0 ) \g
INSERT INTO prog_environment VALUES ('wt1d95'  ,'','RTAP',2301,'wt1d95' ,'','','',0 ) \g

INSERT INTO prog_environment VALUES ('wt1tcs0' ,'','RTAP',2220,'wt1tcs' ,'','','',1 ) \g
INSERT INTO prog_environment VALUES ('wt1tcs1' ,'','RTAP',2221,'wt1tcs' ,'','','',1 ) \g
INSERT INTO prog_environment VALUES ('wt1tcs2' ,'','RTAP',2222,'wt1tcs' ,'','','',1 ) \g
INSERT INTO prog_environment VALUES ('wt1tcs3' ,'','RTAP',2223,'wt1tcs' ,'','','',1 ) \g
INSERT INTO prog_environment VALUES ('wt1tcs4' ,'','RTAP',2224,'wt1tcs' ,'','','',1 ) \g
INSERT INTO prog_environment VALUES ('wt1tcs5' ,'','RTAP',2225,'wt1tcs' ,'','','',1 ) \g
INSERT INTO prog_environment VALUES ('wt1tcs6' ,'','RTAP',2226,'wt1tcs' ,'','','',1 ) \g
INSERT INTO prog_environment VALUES ('wt1tcs7' ,'','RTAP',2227,'wt1tcs' ,'','','',1 ) \g
INSERT INTO prog_environment VALUES ('wt1tcs8' ,'','RTAP',2228,'wt1tcs' ,'','','',1 ) \g
INSERT INTO prog_environment VALUES ('wt1tcs9' ,'','RTAP',2229,'wt1tcs' ,'','','',1 ) \g

INSERT INTO prog_environment VALUES ('lt1ada'  ,'','LCU' ,2160,'lt1ada' ,'','','',0 ) \g
INSERT INTO prog_environment VALUES ('lt1adb'  ,'','LCU' ,2160,'lt1adb' ,'','','',0 ) \g
INSERT INTO prog_environment VALUES ('lt1adc'  ,'','LCU' ,2160,'lt1adc' ,'','','',0 ) \g
INSERT INTO prog_environment VALUES ('lt1enc'  ,'','LCU' ,2160,'lt1enc' ,'','','',0 ) \g
INSERT INTO prog_environment VALUES ('lt1hb'   ,'','LCU' ,2160,'lt1hb'  ,'','','',0 ) \g
INSERT INTO prog_environment VALUES ('lt1alt'  ,'','LCU' ,2160,'lt1alt' ,'','','',0 ) \g
INSERT INTO prog_environment VALUES ('lt1az'   ,'','LCU' ,2160,'lt1az'  ,'','','',0 ) \g
INSERT INTO prog_environment VALUES ('lt1co'   ,'','LCU' ,2160,'lt1co'  ,'','','',0 ) \g
INSERT INTO prog_environment VALUES ('lt1m1m3' ,'','LCU' ,2160,'lt1m1m3','','','',0 ) \g
INSERT INTO prog_environment VALUES ('lt1m2'   ,'','LCU' ,2160,'lt1m2'  ,'','','',0 ) \g
INSERT INTO prog_environment VALUES ('lr1m2'   ,'','LCU' ,2160,'lt1m2b' ,'lr1m2','','',0 ) \g

INSERT INTO prog_environment VALUES ('wa1tcs'  ,'','RTAP',2301,'wa1tcs' ,'','','',0 ) \g

INSERT INTO prog_environment VALUES ('wa1tcs0' ,'','RTAP',2220,'wa1tcs' ,'','','',1 ) \g
INSERT INTO prog_environment VALUES ('wa1tcs1' ,'','RTAP',2221,'wa1tcs' ,'','','',1 ) \g
INSERT INTO prog_environment VALUES ('wa1tcs2' ,'','RTAP',2222,'wa1tcs' ,'','','',1 ) \g
INSERT INTO prog_environment VALUES ('wa1tcs3' ,'','RTAP',2223,'wa1tcs' ,'','','',1 ) \g
INSERT INTO prog_environment VALUES ('wa1tcs4' ,'','RTAP',2224,'wa1tcs' ,'','','',1 ) \g
INSERT INTO prog_environment VALUES ('wa1tcs5' ,'','RTAP',2225,'wa1tcs' ,'','','',1 ) \g
INSERT INTO prog_environment VALUES ('wa1tcs6' ,'','RTAP',2226,'wa1tcs' ,'','','',1 ) \g
INSERT INTO prog_environment VALUES ('wa1tcs7' ,'','RTAP',2227,'wa1tcs' ,'','','',1 ) \g
INSERT INTO prog_environment VALUES ('wa1tcs8' ,'','RTAP',2228,'wa1tcs' ,'','','',1 ) \g
INSERT INTO prog_environment VALUES ('wa1tcs9' ,'','RTAP',2229,'wa1tcs' ,'','','',1 ) \g

INSERT INTO prog_environment VALUES ('la1aga'  ,'','LCU' ,2160,'la1aga' ,'','' ,'lr1aga',0 ) \g
INSERT INTO prog_environment VALUES ('la1agb'  ,'','LCU' ,2160,'la1agb' ,'','' ,'lr1agb',0 ) \g
INSERT INTO prog_environment VALUES ('la1agc'  ,'','LCU' ,2160,'la1agc' ,'','' ,'lr1agc',0 ) \g
INSERT INTO prog_environment VALUES ('la1agco' ,'','LCU' ,2160,'la1agco','','','lr1agco',0 ) \g
INSERT INTO prog_environment VALUES ('la1iaa'  ,'','LCU' ,2160,'la1iaa' ,'','','',0 ) \g
INSERT INTO prog_environment VALUES ('la1iab'  ,'','LCU' ,2160,'la1iab' ,'','','',0 ) \g
INSERT INTO prog_environment VALUES ('la1iac'  ,'','LCU' ,2160,'la1iac' ,'','','',0 ) \g
INSERT INTO prog_environment VALUES ('la1iaco' ,'','LCU' ,2160,'la1iaco','','','',0 ) \g
INSERT INTO prog_environment VALUES ('wgsops'  ,'','RTAP',2301,'wgsops' ,'','','',0 ) \g

INSERT INTO prog_environment VALUES ('wtatcam' ,'','RTAP',2310,'wtatcam','','','',0 )\g
INSERT INTO prog_environment VALUES ('ltatcam' ,'','LCU', 2160,'ltatcam','','','',0 )\g
INSERT INTO prog_environment VALUES ('ltatcpi' ,'','LCU', 2160,'ltatcpi','','','',0 )\g
INSERT INTO prog_environment VALUES ('ltatcwf' ,'','LCU', 2160,'ltatcwf','','','',0 )\g
INSERT INTO prog_environment VALUES ('wtaccd'  ,'','RTAP',2303,'wtaccd','','','',0 )\g

# *********************
# * FORS Environments 
# *********************
INSERT INTO prog_environment VALUES ('wf1ors'  ,'','RTAP',2301,'wf1ors','','','',0 )\g
INSERT INTO prog_environment VALUES ('lf1ics1' ,'','LCU', 2160,'lf1ics1','','','',0 )\g
INSERT INTO prog_environment VALUES ('lf1ics2' ,'','LCU', 2160,'lf1ics2','','','',0 )\g
INSERT INTO prog_environment VALUES ('lf1ics3' ,'','LCU', 2160,'lf1ics3','','','',0 )\g
INSERT INTO prog_environment VALUES ('wf1ccd'  ,'','RTAP',2225,'wf1ccd','','','',0 )\g


# *********************
# * ISAAC Environments 
# *********************
INSERT INTO prog_environment VALUES ('wisaac', '','RTAP',2301,'wisaac','','','',0 )\g
INSERT INTO prog_environment VALUES ('lisic',  '','LCU', 2160,'lisic','','','',0 )\g
INSERT INTO prog_environment VALUES ('listccd','','LCU', 2160,'listccd','','','',0 )\g
INSERT INTO prog_environment VALUES ('wisdc'  ,'','RTAP',2303,'wisdc','','','',0 )\g


# ******************
# *  progenv_name  *
# ******************

#
# Default RTAP(or ','QSEMU) environment from which an LCU environment boots
# (also log reporting node)
#
#    progenv_name   "client" LCU environment name
#    bootenv_name   "host" RTAP (or ','QSEMU) environment name

INSERT INTO lcu_progenv VALUES ('lt1ada'   ,'wt1tcs'  ) \g
INSERT INTO lcu_progenv VALUES ('lt1adb'   ,'wt1tcs'  ) \g
INSERT INTO lcu_progenv VALUES ('lt1adc'   ,'wt1tcs'  ) \g
INSERT INTO lcu_progenv VALUES ('lt1enc'   ,'wt1tcs'  ) \g
INSERT INTO lcu_progenv VALUES ('lt1hb'    ,'wt1tcs'  ) \g
INSERT INTO lcu_progenv VALUES ('lt1alt'   ,'wt1tcs'  ) \g
INSERT INTO lcu_progenv VALUES ('lt1az'    ,'wt1tcs'  ) \g
INSERT INTO lcu_progenv VALUES ('lt1co'    ,'wt1tcs'  ) \g
INSERT INTO lcu_progenv VALUES ('lt1m1m3'  ,'wt1tcs'  ) \g
INSERT INTO lcu_progenv VALUES ('lt1m2'    ,'wt1tcs'  ) \g
INSERT INTO lcu_progenv VALUES ('lr1m2'    ,'wt1tcs'  ) \g

INSERT INTO lcu_progenv VALUES ('la1aga'   ,'wa1tcs'  ) \g
INSERT INTO lcu_progenv VALUES ('la1agb'   ,'wa1tcs'  ) \g
INSERT INTO lcu_progenv VALUES ('la1agc'   ,'wa1tcs'  ) \g
INSERT INTO lcu_progenv VALUES ('la1agco'  ,'wa1tcs'  ) \g
INSERT INTO lcu_progenv VALUES ('la1iaa'   ,'wa1tcs'  ) \g
INSERT INTO lcu_progenv VALUES ('la1iab'   ,'wa1tcs'  ) \g
INSERT INTO lcu_progenv VALUES ('la1iac'   ,'wa1tcs'  ) \g
INSERT INTO lcu_progenv VALUES ('la1iaco'  ,'wa1tcs'  ) \g

INSERT INTO lcu_progenv VALUES ('ltatcam'  ,'wtatcam' ) \g
INSERT INTO lcu_progenv VALUES ('ltatcpi'  ,'wtatcam' ) \g
INSERT INTO lcu_progenv VALUES ('ltatcwf'  ,'wtatcam' ) \g

# ******************************
# * FORS LCU_PROG Environments 
# ******************************
INSERT INTO lcu_progenv VALUES ('lf1ics1'  ,'wf1ors' ) \g
INSERT INTO lcu_progenv VALUES ('lf1ics2'  ,'wf1ors' ) \g
INSERT INTO lcu_progenv VALUES ('lf1ics3'  ,'wf1ors' ) \g

# ******************************
# * ISAAC LCU_PROG Environments 
# ******************************
INSERT INTO lcu_progenv VALUES ('lisic'    ,'wisaac' ) \g
INSERT INTO lcu_progenv VALUES ('listccd'  ,'wisaac' ) \g



# *************************
# *  UT2 (tphan 11 sep 98)*
# *************************
#

#
# UT2 Guide/acquisition LAN
#
INSERT INTO station VALUES ('wa2tcs' ,'','a2','134.171.209.1'  ,'','UT2-HP-C110 guide/acquisition WS ','VCM','','','hp9700' ,'hppa'  ,''  ,0)\g
INSERT INTO station VALUES ('la2aga' ,'','a2','134.171.209.20' ,'','UT2-autoguiding camera Nasmyth A ','VCM','','','68k','MC68040','mv167',0)\g
INSERT INTO station VALUES ('la2agb' ,'','a2','134.171.209.21' ,'','UT2-autoguiding camera Nasmyth B ','VCM','','','68k','MC68040','mv167',0)\g
INSERT INTO station VALUES ('la2agc' ,'','a2','134.171.209.22' ,'','UT2-autoguiding camera Cassegrain','VCM','','','68k','MC68040','mv167',0)\g
INSERT INTO station VALUES ('la2agco','','a2','134.171.209.23' ,'','UT2-autoguiding camera Coude     ','VCM','','','68k','MC68040','mv167',0)\g
INSERT INTO station VALUES ('la2iaa' ,'','a2','134.171.209.25' ,'','UT2-image analysis Nasmyth A     ','VCM','','','68k','MC68040','mv167',0)\g
INSERT INTO station VALUES ('la2iab' ,'','a2','134.171.209.26' ,'','UT2-image analysis Nasmyth B     ','VCM','','','68k','MC68040','mv167',0)\g
INSERT INTO station VALUES ('la2iac' ,'','a2','134.171.209.27' ,'','UT2-image analysis Cassegrain    ','VCM','','','68k','MC68040','mv167',0)\g
INSERT INTO station VALUES ('la2iaco','','a2','134.171.209.28' ,'','UT2-image analysis Coude         ','VCM','','','68k','MC68040','mv167',0)\g

INSERT INTO station VALUES ('sa21'   ,'','a2','134.171.209.200','','UT2-guide acquisition HUB1       ','VCM','','',''   ,''       ,''     ,0)\g
INSERT INTO station VALUES ('ra21'   ,'','a2','134.171.209.254','','UT2-autoguiding Gateway          ','VCM','','',''   ,''       ,''     ,0)\g

#
# UT2 Rapid Guiding LAN
#
INSERT INTO station VALUES ('lr2m2'  ,'','r2','134.171.213.30' ,'','UT2-M2                           ','VCM','','','68k','MC68040','',0)\g
INSERT INTO station VALUES ('lr2aga' ,'','r2','134.171.213.20' ,'','UT2-autoguiding camera Nasmyth A ','VCM','','','68k','MC68040','mv167',0)\g
INSERT INTO station VALUES ('lr2agb' ,'','r2','134.171.213.21' ,'','UT2-autoguiding camera Nasmyth B ','VCM','','','68k','MC68040','mv167',0)\g
INSERT INTO station VALUES ('lr2agc' ,'','r2','134.171.213.22' ,'','UT2-autoguiding camera Cassegrain','VCM','','','68k','MC68040','mv167',0)\g
INSERT INTO station VALUES ('lr2agco','','r2','134.171.213.23' ,'','UT2-autoguiding camera Coude     ','VCM','','','68k','MC68040','mv167',0)\g

INSERT INTO station VALUES ('sr21'   ,'','r2','134.171.213.200','','UT2-rapid guiding HUB1           ','VCM','','',''   ,''       ,''     ,0)\g

#
# UT2 Telescope Control LAN
#
INSERT INTO station VALUES ('wt2tcs' ,'','t2','134.171.217.1'  ,'','UT2-HP-C110 Telescope Control WS ','VCM','','','hp9700' ,'hppa'  ,''  ,0)\g
INSERT INTO station VALUES ('wt2d95' ,'','t2','134.171.217.10' ,'','UT2-HP-715 DEC95 WS for m1m3/m2  ','VCM','','','hp9700' ,'hppa'  ,''  ,0)\g
INSERT INTO station VALUES ('lt2aga' ,'','t2','134.171.217.20' ,'','UT2-autoguiding camera Nasmyth A ','VCM','','','68k','MC68040','mv167',0)\g
INSERT INTO station VALUES ('lt2agb' ,'','t2','134.171.217.21' ,'','UT2-autoguiding camera Nasmyth B ','VCM','','','68k','MC68040','mv167',0)\g
INSERT INTO station VALUES ('lt2agc' ,'','t2','134.171.217.22' ,'','UT2-autoguiding camera Cassegrain','VCM','','','68k','MC68040','mv167',0)\g
INSERT INTO station VALUES ('lt2agco','','t2','134.171.217.23' ,'','UT2-autoguiding camera Coude     ','VCM','','','68k','MC68040','mv167',0)\g
INSERT INTO station VALUES ('lt2iaa' ,'','t2','134.171.217.25' ,'','UT2-image analysis Nasmyth A     ','VCM','','','68k','MC68040','mv167',0)\g
INSERT INTO station VALUES ('lt2iab' ,'','t2','134.171.217.26' ,'','UT2-image analysis Nasmyth B     ','VCM','','','68k','MC68040','mv167',0)\g
INSERT INTO station VALUES ('lt2iac' ,'','t2','134.171.217.27' ,'','UT2-image analysis Cassegrain    ','VCM','','','68k','MC68040','mv167',0)\g
INSERT INTO station VALUES ('lt2iaco','','t2','134.171.217.28' ,'','UT2-image analysis Coude         ','VCM','','','68k','MC68040','mv167',0)\g
INSERT INTO station VALUES ('lt2m2'  ,'','t2','134.171.217.30' ,'','UT2-M2                           ','VCM','','','68k','MC68040','mv167_m2-p0-s16',0)\g
INSERT INTO station VALUES ('lt2m2a' ,'','t2','134.171.217.31' ,'','UT2-M2 proxy                     ','VCM','','','68k','MC68040','',0)\g
INSERT INTO station VALUES ('lt2m2b' ,'','t2','134.171.217.32' ,'','UT2-M2 proxy                     ','VCM','','','68k','MC68040','mv167_m2-p1-s16',0)\g
INSERT INTO station VALUES ('lt2ada' ,'','t2','134.171.217.35' ,'','UT2-adapter-rotbtor Nasmyth A    ','VCM','','','68k','MC68040','mv167',0)\g
INSERT INTO station VALUES ('lt2adb' ,'','t2','134.171.217.36' ,'','UT2-adapter-rotbtor Nasmyth B    ','VCM','','','68k','MC68040','mv167',0)\g
INSERT INTO station VALUES ('lt2adc' ,'','t2','134.171.217.37' ,'','UT2-adapter-rotbtor Cassegrain   ','VCM','','','68k','MC68040','mv167',0)\g
INSERT INTO station VALUES ('lt2enc' ,'','t2','134.171.217.40' ,'','UT2-Enclosure                    ','VCM','','','68k','MC68040','mv167',0)\g
INSERT INTO station VALUES ('lt2hb'  ,'','t2','134.171.217.41' ,'','UT2-Hydrostbtic bearings         ','VCM','','','68k','MC68040','mv167',0)\g
INSERT INTO station VALUES ('lt2alt' ,'','t2','134.171.217.42' ,'','UT2-Altitude                     ','VCM','','','68k','MC68040','mv167',0)\g
INSERT INTO station VALUES ('lt2az'  ,'','t2','134.171.217.43' ,'','UT2-Azimuth                      ','VCM','','','68k','MC68040','mv167',0)\g
INSERT INTO station VALUES ('lt2co'  ,'','t2','134.171.217.44' ,'','UT2-Coude                        ','VCM','','','68k','MC68040','mv167',0)\g
INSERT INTO station VALUES ('lt2m1m3','','t2','134.171.217.48' ,'','UT2-M1M3                         ','VCM','','','68k','MC68040','mv167',0)\g
INSERT INTO station VALUES ('lt2m1bp','','t2','134.171.217.49' ,'','UT2-M1M3 backplane               ','VCM','','','68k','MC68040','mv167',0)\g
INSERT INTO station VALUES ('lt2m1a' ,'','t2','134.171.217.50' ,'','UT2-M1M3 VIUC #0 proxy           ','VCM','','','68k','MC68040','mv167',0)\g
INSERT INTO station VALUES ('lt2m1b' ,'','t2','134.171.217.51' ,'','UT2-M1M3 VIUC #1 proxy           ','VCM','','','68k','MC68040','mv167',0)\g
INSERT INTO station VALUES ('lt2m1c' ,'','t2','134.171.217.52' ,'','UT2-M1M3 VIUC #2 proxy           ','VCM','','','68k','MC68040','mv167',0)\g
INSERT INTO station VALUES ('lt2m1d' ,'','t2','134.171.217.53' ,'','UT2-M1M3 VIUC #3 proxy           ','VCM','','','68k','MC68040','mv167',0)\g
INSERT INTO station VALUES ('lt2m1e' ,'','t2','134.171.217.54' ,'','UT2-M1M3 VIUC #4 proxy           ','VCM','','','68k','MC68040','mv167',0)\g
INSERT INTO station VALUES ('lt2m1f' ,'','t2','134.171.217.55' ,'','UT2-M1M3 VIUC #5 proxy           ','VCM','','','68k','MC68040','mv167',0)\g

INSERT INTO station VALUES ('st21'   ,'','t2','134.171.217.200','','UT2-Telescope Control HUB1       ','VCM','','',''   ,''       ,''     ,0)\g
INSERT INTO station VALUES ('st22'   ,'','t2','134.171.217.201','','UT2-Telescope Control HUB2       ','VCM','','',''   ,''       ,''     ,0)\g
INSERT INTO station VALUES ('rt21'   ,'','t2','134.171.217.254','','UT2-Telescope Control Gateway    ','VCM','','',''   ,''       ,''     ,0)\g


#
# UT2 Instrument: Test Camera
#
INSERT INTO station VALUES ('wtbtcam','','tb','134.171.203.1'  ,'','UT2-HP-C110 Test Camera WS       ','VCM','','','hp9700' ,'hppa'  ,''  ,0)\g
INSERT INTO station VALUES ('ltbtcam','','tb','134.171.203.16' ,'','UT2-TC Instrument Control        ','VCM','','','68k','MC68040','mv167',0)\g
INSERT INTO station VALUES ('ltbtcpi','','tb','134.171.203.17' ,'','UT2-TC Pupil image TCCD          ','VCM','','','68k','MC68040','mv167',0)\g
INSERT INTO station VALUES ('ltbtcwf','','tb','134.171.203.18' ,'','UT2-TC Wavefront TCCD            ','VCM','','','68k','MC68040','mv167',0)\g
INSERT INTO station VALUES ('wtbccd' ,'','tb','134.171.203.19' ,'','UT2-TC FIERA CCD                 ','VCM','','','solaris','sparc' ,''  ,0)\g


# ******************
# *  environments  *
# ******************

# define environments (RTAP, CCS-lite, LCU)
#
#    progenv_name   environment name
#    description    ''
#    env_type       RTAP | LCU | QSEMU
#    tcp_port       TCP port number (as in /etc/services)
#    station_name   host where the environment is running
#    attic          1 (do not show it in environment list) | 0 (visible)
 
INSERT INTO prog_environment VALUES ('wt2tcs'  ,'','RTAP',2301,'wt2tcs' ,'','','',0 ) \g

INSERT INTO prog_environment VALUES ('wt2tcs0' ,'','RTAP',2220,'wt2tcs' ,'','','',1 ) \g
INSERT INTO prog_environment VALUES ('wt2tcs1' ,'','RTAP',2221,'wt2tcs' ,'','','',1 ) \g
INSERT INTO prog_environment VALUES ('wt2tcs2' ,'','RTAP',2222,'wt2tcs' ,'','','',1 ) \g
INSERT INTO prog_environment VALUES ('wt2tcs3' ,'','RTAP',2223,'wt2tcs' ,'','','',1 ) \g
INSERT INTO prog_environment VALUES ('wt2tcs4' ,'','RTAP',2224,'wt2tcs' ,'','','',1 ) \g
INSERT INTO prog_environment VALUES ('wt2tcs5' ,'','RTAP',2225,'wt2tcs' ,'','','',1 ) \g
INSERT INTO prog_environment VALUES ('wt2tcs6' ,'','RTAP',2226,'wt2tcs' ,'','','',1 ) \g
INSERT INTO prog_environment VALUES ('wt2tcs7' ,'','RTAP',2227,'wt2tcs' ,'','','',1 ) \g
INSERT INTO prog_environment VALUES ('wt2tcs8' ,'','RTAP',2228,'wt2tcs' ,'','','',1 ) \g
INSERT INTO prog_environment VALUES ('wt2tcs9' ,'','RTAP',2229,'wt2tcs' ,'','','',1 ) \g

INSERT INTO prog_environment VALUES ('lt2ada'  ,'','LCU' ,2160,'lt2ada' ,'','','',0 ) \g
INSERT INTO prog_environment VALUES ('lt2adb'  ,'','LCU' ,2160,'lt2adb' ,'','','',0 ) \g
INSERT INTO prog_environment VALUES ('lt2adc'  ,'','LCU' ,2160,'lt2adc' ,'','','',0 ) \g
INSERT INTO prog_environment VALUES ('lt2enc'  ,'','LCU' ,2160,'lt2enc' ,'','','',0 ) \g
INSERT INTO prog_environment VALUES ('lt2hb'   ,'','LCU' ,2160,'lt2hb'  ,'','','',0 ) \g
INSERT INTO prog_environment VALUES ('lt2alt'  ,'','LCU' ,2160,'lt2alt' ,'','','',0 ) \g
INSERT INTO prog_environment VALUES ('lt2az'   ,'','LCU' ,2160,'lt2az'  ,'','','',0 ) \g
INSERT INTO prog_environment VALUES ('lt2co'   ,'','LCU' ,2160,'lt2co'  ,'','','',0 ) \g
INSERT INTO prog_environment VALUES ('lt2m1m3' ,'','LCU' ,2160,'lt2m1m3','','','',0 ) \g
INSERT INTO prog_environment VALUES ('lt2m2'   ,'','LCU' ,2160,'lt2m2'  ,'','','',0 ) \g
INSERT INTO prog_environment VALUES ('lr2m2'   ,'','LCU' ,2160,'lt2m2b' ,'lr2m2','','',0 ) \g

INSERT INTO prog_environment VALUES ('wa2tcs'  ,'','RTAP',2301,'wa2tcs' ,'','','',0 ) \g

INSERT INTO prog_environment VALUES ('wa2tcs0' ,'','RTAP',2220,'wa2tcs' ,'','','',1 ) \g
INSERT INTO prog_environment VALUES ('wa2tcs1' ,'','RTAP',2221,'wa2tcs' ,'','','',1 ) \g
INSERT INTO prog_environment VALUES ('wa2tcs2' ,'','RTAP',2222,'wa2tcs' ,'','','',1 ) \g
INSERT INTO prog_environment VALUES ('wa2tcs3' ,'','RTAP',2223,'wa2tcs' ,'','','',1 ) \g
INSERT INTO prog_environment VALUES ('wa2tcs4' ,'','RTAP',2224,'wa2tcs' ,'','','',1 ) \g
INSERT INTO prog_environment VALUES ('wa2tcs5' ,'','RTAP',2225,'wa2tcs' ,'','','',1 ) \g
INSERT INTO prog_environment VALUES ('wa2tcs6' ,'','RTAP',2226,'wa2tcs' ,'','','',1 ) \g
INSERT INTO prog_environment VALUES ('wa2tcs7' ,'','RTAP',2227,'wa2tcs' ,'','','',1 ) \g
INSERT INTO prog_environment VALUES ('wa2tcs8' ,'','RTAP',2228,'wa2tcs' ,'','','',1 ) \g
INSERT INTO prog_environment VALUES ('wa2tcs9' ,'','RTAP',2229,'wa2tcs' ,'','','',1 ) \g

INSERT INTO prog_environment VALUES ('la2aga'  ,'','LCU' ,2160,'la2aga' ,'','' ,'lr2aga',0 ) \g
INSERT INTO prog_environment VALUES ('la2agb'  ,'','LCU' ,2160,'la2agb' ,'','' ,'lr2agb',0 ) \g
INSERT INTO prog_environment VALUES ('la2agc'  ,'','LCU' ,2160,'la2agc' ,'','' ,'lr2agc',0 ) \g
INSERT INTO prog_environment VALUES ('la2agco' ,'','LCU' ,2160,'la2agco','','','lr2agco',0 ) \g
INSERT INTO prog_environment VALUES ('la2iaa'  ,'','LCU' ,2160,'la2iaa' ,'','','',0 ) \g
INSERT INTO prog_environment VALUES ('la2iab'  ,'','LCU' ,2160,'la2iab' ,'','','',0 ) \g
INSERT INTO prog_environment VALUES ('la2iac'  ,'','LCU' ,2160,'la2iac' ,'','','',0 ) \g
INSERT INTO prog_environment VALUES ('la2iaco' ,'','LCU' ,2160,'la2iaco','','','',0 ) \g

INSERT INTO prog_environment VALUES ('wtbtcam' ,'','RTAP',2310,'wtbtcam','','','',0 )\g
INSERT INTO prog_environment VALUES ('ltbtcam' ,'','LCU', 2160,'ltbtcam','','','',0 )\g
INSERT INTO prog_environment VALUES ('ltbtcpi' ,'','LCU', 2160,'ltbtcpi','','','',0 )\g
INSERT INTO prog_environment VALUES ('ltbtcwf' ,'','LCU', 2160,'ltbtcwf','','','',0 )\g
INSERT INTO prog_environment VALUES ('wtbccd'  ,'','RTAP',2303,'wtbccd','','','',0 )\g

# ******************
# *  progenv_name  *
# ******************

#
# Default RTAP(or ','QSEMU) environment from which an LCU environment boots
# (also log reporting node)
#
#    progenv_name   "client" LCU environment name
#    bootenv_name   "host" RTAP (or ','QSEMU) environment name

INSERT INTO lcu_progenv VALUES ('lt2ada'   ,'wt2tcs'  ) \g
INSERT INTO lcu_progenv VALUES ('lt2adb'   ,'wt2tcs'  ) \g
INSERT INTO lcu_progenv VALUES ('lt2adc'   ,'wt2tcs'  ) \g
INSERT INTO lcu_progenv VALUES ('lt2enc'   ,'wt2tcs'  ) \g
INSERT INTO lcu_progenv VALUES ('lt2hb'    ,'wt2tcs'  ) \g
INSERT INTO lcu_progenv VALUES ('lt2alt'   ,'wt2tcs'  ) \g
INSERT INTO lcu_progenv VALUES ('lt2az'    ,'wt2tcs'  ) \g
INSERT INTO lcu_progenv VALUES ('lt2co'    ,'wt2tcs'  ) \g
INSERT INTO lcu_progenv VALUES ('lt2m1m3'  ,'wt2tcs'  ) \g
INSERT INTO lcu_progenv VALUES ('lt2m2'    ,'wt2tcs'  ) \g
INSERT INTO lcu_progenv VALUES ('lr2m2'    ,'wt2tcs'  ) \g

INSERT INTO lcu_progenv VALUES ('la2aga'   ,'wa2tcs'  ) \g
INSERT INTO lcu_progenv VALUES ('la2agb'   ,'wa2tcs'  ) \g
INSERT INTO lcu_progenv VALUES ('la2agc'   ,'wa2tcs'  ) \g
INSERT INTO lcu_progenv VALUES ('la2agco'  ,'wa2tcs'  ) \g
INSERT INTO lcu_progenv VALUES ('la2iaa'   ,'wa2tcs'  ) \g
INSERT INTO lcu_progenv VALUES ('la2iab'   ,'wa2tcs'  ) \g
INSERT INTO lcu_progenv VALUES ('la2iac'   ,'wa2tcs'  ) \g
INSERT INTO lcu_progenv VALUES ('la2iaco'  ,'wa2tcs'  ) \g

INSERT INTO lcu_progenv VALUES ('ltbtcam'  ,'wtbtcam' ) \g
INSERT INTO lcu_progenv VALUES ('ltbtcpi'  ,'wtbtcam' ) \g
INSERT INTO lcu_progenv VALUES ('ltbtcwf'  ,'wtbtcam' ) \g

#
#___oOo___
