# e-MERLIN imaging script for J1252+5634 (4 spws x 64 channels) in CASA 4.4.0

#Calibration steps
thesteps = [0]
step_title = {0: 'Flag bad data (flagdata)',
              1: 'Make dirty image (clean)',
              2: 'Make clean image (clean)',
              3: 'Make natural weighting clean image (clean)',
              4: 'Make uniform weighting clean image (clean)',
              5: 'Insert intial model (ft)',
              6: 'Phase-only self-calibration loop (gaincal, applycal, clean)',
              7: 'Amplitude-only self-calibration loop (gaincal, applycal, clean)'}

try:
  print 'List of steps to be executed ...', mysteps
  thesteps = mysteps
except:
  print 'global variable mysteps not set.'
if (thesteps==[]):
  thesteps = range(0,len(step_title))
  print 'Executing all steps: ', thesteps


# The Python variable 'mysteps' will control which steps
# are executed when you start the script using
#   execfile('scriptForCalibration.py')
# e.g. setting
#   mysteps = [2,3,4]# before starting the script will make the script execute
# only steps 2, 3, and 4
# Setting mysteps = [] will make it execute all steps.

print 'Write the value for variables -> run the script from the beginning'

#definitions that are placed outside of the steps, therefore will always be applied, no matter what step you decide to run. Putting these at the top makes it easier to change them.

msfile = '1252+5634.ms' #ms multisource file
myspw = '0~3' #spw of interest, use myspw = '3' if your computer is slow
mymask = '1252+5634.mask' #the mask that you would like to use during cleaning, feel free to use you own mask
mymodel = '1252+5634.model' #the model that you will use during calibration, feel free to use you own model
doInteractive = F
mysolintphase = '30s' #the solution interval used in step 6
mysolintamp = 'inf' #the solution interval used in step 7


# This step flags the data that we found after running calibration steps, i.e. post-calibration flagging. This is data that cannot be corrected from calibration. We put this step at the begining of the script because it should be removed before further self-calibration steps
mystep = 0
if(mystep in thesteps):
  casalog.post('Step '+str(mystep)+' '+step_title[mystep],'INFO')
  print 'Step ', mystep, step_title[mystep]

  flagdata(vis="1252+5634.ms",mode="manual",autocorr=False,inpfile="",reason="any",tbuff=0.0,spw="",field="",antenna="",uvrange="",timerange="21:30:00~21:32:00",correlation="",scan="",intent="",array="",observation="",feed="",clipminmax=[],datacolumn="DATA",clipoutside=True,channelavg=False,clipzeros=False,quackinterval=1.0,quackmode="beg",quackincrement=False,tolerance=0.0,addantenna="",lowerlimit=0.0,upperlimit=90.0,ntime="scan",combinescans=False,timecutoff=4.0,freqcutoff=3.0,timefit="line",freqfit="poly",maxnpieces=7,flagdimension="freqtime",usewindowstats="none",halfwin=1,extendflags=True,winsize=3,timedev="",freqdev="",timedevscale=5.0,freqdevscale=5.0,spectralmax=1000000.0,spectralmin=0.0,extendpols=True,growtime=50.0,growfreq=50.0,growaround=False,flagneartime=False,flagnearfreq=False,minrel=0.0,maxrel=1.0,minabs=0,maxabs=-1,spwchan=False,spwcorr=False,basecnt=False,name="Summary",action="apply",display="",flagbackup=True,savepars=False,cmdreason="",outfile="")

  flagdata(vis="1252+5634.ms",mode="manual",autocorr=False,inpfile="",reason="any",tbuff=0.0,spw="",field="",antenna="",uvrange="",timerange="30:20:00~32:00:00",correlation="",scan="",intent="",array="",observation="",feed="",clipminmax=[],datacolumn="DATA",clipoutside=True,channelavg=False,clipzeros=False,quackinterval=1.0,quackmode="beg",quackincrement=False,tolerance=0.0,addantenna="",lowerlimit=0.0,upperlimit=90.0,ntime="scan",combinescans=False,timecutoff=4.0,freqcutoff=3.0,timefit="line",freqfit="poly",maxnpieces=7,flagdimension="freqtime",usewindowstats="none",halfwin=1,extendflags=True,winsize=3,timedev="",freqdev="",timedevscale=5.0,freqdevscale=5.0,spectralmax=1000000.0,spectralmin=0.0,extendpols=True,growtime=50.0,growfreq=50.0,growaround=False,flagneartime=False,flagnearfreq=False,minrel=0.0,maxrel=1.0,minabs=0,maxabs=-1,spwchan=False,spwcorr=False,basecnt=False,name="Summary",action="apply",display="",flagbackup=True,savepars=False,cmdreason="",outfile="")

# This step generates dirty images and psf images of our target. This useful to do to make sure that we have correct seetings in clean, but also its useful to look at the psf as as it can help us identify real structure from side-lobes when we run clean.
mystep = 1
if(mystep in thesteps):
  casalog.post('Step '+str(mystep)+' '+step_title[mystep],'INFO')
  print 'Step ', mystep, step_title[mystep]

  clean(vis="1252+5634.ms",imagename="dirty.b0",outlierfile="",field="",spw="0~3",selectdata=True,timerange="",uvrange="",antenna="",scan="",observation="",intent="",mode="mfs",resmooth=False,gridmode="",wprojplanes=-1,facets=1,cfcache="cfcache.dir",rotpainc=5.0,painc=360.0,aterm=True,psterm=False,mterm=True,wbawp=False,conjbeams=True,epjtable="",interpolation="linear",niter=0,gain=0.1,threshold="0.0mJy",psfmode="clark",imagermode="csclean",ftmachine="mosaic",mosweight=False,scaletype="SAULT",multiscale=[],negcomponent=-1,smallscalebias=0.6,interactive=doInteractive,mask=[],nchan=-1,start=0,width=1,outframe="",veltype="radio",imsize=512,cell="0.0107arcsec",phasecenter="",restfreq="",stokes="I",weighting="briggs",robust=0,uvtaper=False,outertaper=[''],innertaper=['1.0'],modelimage="",restoringbeam=[''],pbcor=False,minpb=0.2,usescratch=False,noise="1.0Jy",npixels=0,npercycle=100,cyclefactor=1.5,cyclespeedup=-1,nterms=1,reffreq="",chaniter=False,flatnoise=True,allowchunk=False)

  clean(vis="1252+5634.ms",imagename="dirty.b2",outlierfile="",field="",spw="0~3",selectdata=True,timerange="",uvrange="",antenna="",scan="",observation="",intent="",mode="mfs",resmooth=False,gridmode="",wprojplanes=-1,facets=1,cfcache="cfcache.dir",rotpainc=5.0,painc=360.0,aterm=True,psterm=False,mterm=True,wbawp=False,conjbeams=True,epjtable="",interpolation="linear",niter=0,gain=0.1,threshold="0.0mJy",psfmode="clark",imagermode="csclean",ftmachine="mosaic",mosweight=False,scaletype="SAULT",multiscale=[],negcomponent=-1,smallscalebias=0.6,interactive=doInteractive,mask=[],nchan=-1,start=0,width=1,outframe="",veltype="radio",imsize=512,cell="0.0107arcsec",phasecenter="",restfreq="",stokes="I",weighting="briggs",robust=2,uvtaper=False,outertaper=[''],innertaper=['1.0'],modelimage="",restoringbeam=[''],pbcor=False,minpb=0.2,usescratch=False,noise="1.0Jy",npixels=0,npercycle=100,cyclefactor=1.5,cyclespeedup=-1,nterms=1,reffreq="",chaniter=False,flatnoise=True,allowchunk=False)

  clean(vis="1252+5634.ms",imagename="dirty.b-2",outlierfile="",field="",spw="0~3",selectdata=True,timerange="",uvrange="",antenna="",scan="",observation="",intent="",mode="mfs",resmooth=False,gridmode="",wprojplanes=-1,facets=1,cfcache="cfcache.dir",rotpainc=5.0,painc=360.0,aterm=True,psterm=False,mterm=True,wbawp=False,conjbeams=True,epjtable="",interpolation="linear",niter=0,gain=0.1,threshold="0.0mJy",psfmode="clark",imagermode="csclean",ftmachine="mosaic",mosweight=False,scaletype="SAULT",multiscale=[],negcomponent=-1,smallscalebias=0.6,interactive=doInteractive,mask=[],nchan=-1,start=0,width=1,outframe="",veltype="radio",imsize=512,cell="0.0107arcsec",phasecenter="",restfreq="",stokes="I",weighting="briggs",robust=-2,uvtaper=False,outertaper=[''],innertaper=['1.0'],modelimage="",restoringbeam=[''],pbcor=False,minpb=0.2,usescratch=False,noise="1.0Jy",npixels=0,npercycle=100,cyclefactor=1.5,cyclespeedup=-1,nterms=1,reffreq="",chaniter=False,flatnoise=True,allowchunk=False)


# This step makes the first clean image using Briggs, robust = 0 weighting.
mystep = 2
if(mystep in thesteps):
  casalog.post('Step '+str(mystep)+' '+step_title[mystep],'INFO')
  print 'Step ', mystep, step_title[mystep]

  os.system('rm -rf clean.b0.auto.*') #This will remove old images

  clean(vis="1252+5634.ms",imagename="clean.b0.auto",outlierfile="",field="",spw="0~3",selectdata=True,timerange="",uvrange="",antenna="",scan="",observation="",intent="",mode="mfs",resmooth=False,gridmode="",wprojplanes=-1,facets=1,cfcache="cfcache.dir",rotpainc=5.0,painc=360.0,aterm=True,psterm=False,mterm=True,wbawp=False,conjbeams=True,epjtable="",interpolation="linear",niter=3000,gain=0.05,threshold="0.7mJy",psfmode="clark",imagermode="csclean",ftmachine="mosaic",mosweight=False,scaletype="SAULT",multiscale=[],negcomponent=-1,smallscalebias=0.6,interactive=doInteractive,mask=mymask,nchan=-1,start=0,width=1,outframe="",veltype="radio",imsize=512,cell="0.0107arcsec",phasecenter="",restfreq="",stokes="I",weighting="briggs",robust=0,uvtaper=False,outertaper=[''],innertaper=['1.0'],modelimage="",restoringbeam=[''],pbcor=False,minpb=0.2,usescratch=False,noise="1.0Jy",npixels=0,npercycle=100,cyclefactor=1.5,cyclespeedup=-1,nterms=1,reffreq="",chaniter=False,flatnoise=True,allowchunk=False)


# This step makes the first clean image using Briggs, robust = 2 weighting.
mystep = 3
if(mystep in thesteps):
  casalog.post('Step '+str(mystep)+' '+step_title[mystep],'INFO')
  print 'Step ', mystep, step_title[mystep]

  os.system('rm -rf clean.b2.auto.*') #This will remove old images
  clean(vis="1252+5634.ms",imagename="clean.b2.auto",outlierfile="",field="",spw="0~3",selectdata=True,timerange="",uvrange="",antenna="",scan="",observation="",intent="",mode="mfs",resmooth=False,gridmode="",wprojplanes=-1,facets=1,cfcache="cfcache.dir",rotpainc=5.0,painc=360.0,aterm=True,psterm=False,mterm=True,wbawp=False,conjbeams=True,epjtable="",interpolation="linear",niter=3000,gain=0.05,threshold="0.7mJy",psfmode="clark",imagermode="csclean",ftmachine="mosaic",mosweight=False,scaletype="SAULT",multiscale=[],negcomponent=-1,smallscalebias=0.6,interactive=doInteractive,mask=mymask,nchan=-1,start=0,width=1,outframe="",veltype="radio",imsize=512,cell="0.0107arcsec",phasecenter="",restfreq="",stokes="I",weighting="briggs",robust=2,uvtaper=False,outertaper=[''],innertaper=['1.0'],modelimage="",restoringbeam=[''],pbcor=False,minpb=0.2,usescratch=False,noise="1.0Jy",npixels=0,npercycle=100,cyclefactor=1.5,cyclespeedup=-1,nterms=1,reffreq="",chaniter=False,flatnoise=True,allowchunk=False)


# This step makes the first clean image using Briggs, robust = -2 weighting.
mystep = 4
if(mystep in thesteps):
  casalog.post('Step '+str(mystep)+' '+step_title[mystep],'INFO')
  print 'Step ', mystep, step_title[mystep]

  os.system('rm -rf clean.b-2.auto.*') #This will remove old images

  clean(vis="1252+5634.ms",imagename="clean.b-2.auto",outlierfile="",field="",spw="0~3",selectdata=True,timerange="",uvrange="",antenna="",scan="",observation="",intent="",mode="mfs",resmooth=False,gridmode="",wprojplanes=-1,facets=1,cfcache="cfcache.dir",rotpainc=5.0,painc=360.0,aterm=True,psterm=False,mterm=True,wbawp=False,conjbeams=True,epjtable="",interpolation="linear",niter=3000,gain=0.05,threshold="0.5mJy",psfmode="clark",imagermode="csclean",ftmachine="mosaic",mosweight=False,scaletype="SAULT",multiscale=[],negcomponent=-1,smallscalebias=0.6,interactive=doInteractive,mask=mymask,nchan=-1,start=0,width=1,outframe="",veltype="radio",imsize=512,cell="0.0107arcsec",phasecenter="",restfreq="",stokes="I",weighting="briggs",robust=-2,uvtaper=False,outertaper=[''],innertaper=['1.0'],modelimage="",restoringbeam=[''],pbcor=False,minpb=0.2,usescratch=False,noise="1.0Jy",npixels=0,npercycle=100,cyclefactor=1.5,cyclespeedup=-1,nterms=1,reffreq="",chaniter=False,flatnoise=True,allowchunk=False)


# This step adds a model for our target to our measurement set (note that further runs of clean will do this automatically for you).
mystep = 5
if(mystep in thesteps):
  casalog.post('Step '+str(mystep)+' '+step_title[mystep],'INFO')
  print 'Step ', mystep, step_title[mystep]

  ft(vis="1252+5634.ms",field="",spw="",model=mymodel,nterms=1,reffreq="",complist="",incremental=False,usescratch=True)


# This is a phase-only self-calibration loop that involves calibration, applying the calibration, and then making a new image and model, based on the sepf-calibration process. The step can be run multiple times i.e. mysteps = [6].
mystep = 6
if(mystep in thesteps):
  casalog.post('Step '+str(mystep)+' '+step_title[mystep],'INFO')
  print 'Step ', mystep, step_title[mystep]

  os.system('rm -rf clean.b0.self.*') #This will remove old images

  gaincal(vis="1252+5634.ms",caltable="1.phasecal",field="",spw="",intent="",selectdata=True,timerange="",uvrange="",antenna="",scan="",observation="",msselect="",solint=mysolintphase,combine="",preavg=-1.0,refant="Mk2",minblperant=4,minsnr=3.0,solnorm=False,gaintype="G",smodel=[],calmode="p",append=False,splinetime=3600.0,npointaver=3,phasewrap=180.0,docallib=False,callib="",gaintable=[],gainfield=[],interp=[],spwmap=[],parang=False)

  applycal(vis="1252+5634.ms",field="",spw="",intent="",selectdata=True,timerange="",uvrange="",antenna="",scan="",observation="",msselect="",docallib=False,callib="",gaintable=['1.phasecal'],gainfield=[],interp=[],spwmap=[],calwt=False,parang=False,applymode="",flagbackup=True)

  clean(vis="1252+5634.ms",imagename="clean.b0.self",outlierfile="",field="",spw="0~3",selectdata=True,timerange="",uvrange="",antenna="",scan="",observation="",intent="",mode="mfs",resmooth=False,gridmode="",wprojplanes=-1,facets=1,cfcache="cfcache.dir",rotpainc=5.0,painc=360.0,aterm=True,psterm=False,mterm=True,wbawp=False,conjbeams=True,epjtable="",interpolation="linear",niter=3000,gain=0.05,threshold="0.5mJy",psfmode="clark",imagermode="csclean",ftmachine="mosaic",mosweight=False,scaletype="SAULT",multiscale=[],negcomponent=-1,smallscalebias=0.6,interactive=doInteractive,mask=mymask,nchan=-1,start=0,width=1,outframe="",veltype="radio",imsize=512,cell="0.0107arcsec",phasecenter="",restfreq="",stokes="I",weighting="briggs",robust=0,uvtaper=False,outertaper=[''],innertaper=['1.0'],modelimage="",restoringbeam=[''],pbcor=False,minpb=0.2,usescratch=True,noise="1.0Jy",npixels=0,npercycle=100,cyclefactor=1.5,cyclespeedup=-1,nterms=1,reffreq="",chaniter=False,flatnoise=True,allowchunk=False)


# This is an amplitude-only self-calibration loop that involves calibration, applying the calibration, and then making a new image and model, based on the self-calibration process. The step can be run multiple times i.e. mysteps = [7], but once is likely enough. It will also produce your final image. Congrats!
mystep = 7
if(mystep in thesteps):
  casalog.post('Step '+str(mystep)+' '+step_title[mystep],'INFO')
  print 'Step ', mystep, step_title[mystep]
            
  os.system('rm -rf clean.b0.self2.*') #This will remove old images

  gaincal(vis="1252+5634.ms",caltable="1.ampcal",field="",spw="",intent="",selectdata=True,timerange="",uvrange="",antenna="",scan="",observation="",msselect="",solint=mysolintamp,combine="scan",preavg=-1.0,refant="Mk2",minblperant=4,minsnr=3.0,solnorm=False,gaintype="G",smodel=[],calmode="a",append=False,splinetime=3600.0,npointaver=3,phasewrap=180.0,docallib=False,callib="",gaintable=[],gainfield=[],interp=[],spwmap=[],parang=False)
                        
  applycal(vis="1252+5634.ms",field="",spw="",intent="",selectdata=True,timerange="",uvrange="",antenna="",scan="",observation="",msselect="",docallib=False,callib="",gaintable=['1.phasecal', '1.ampcal'],gainfield=[],interp=[],spwmap=[],calwt=False,parang=False,applymode="",flagbackup=True)
    
  clean(vis="1252+5634.ms",imagename="clean.b0.self2",outlierfile="",field="",spw="0~3",selectdata=True,timerange="",uvrange="",antenna="",scan="",observation="",intent="",mode="mfs",resmooth=False,gridmode="",wprojplanes=-1,facets=1,cfcache="cfcache.dir",rotpainc=5.0,painc=360.0,aterm=True,psterm=False,mterm=True,wbawp=False,conjbeams=True,epjtable="",interpolation="linear",niter=3000,gain=0.05,threshold="0.5mJy",psfmode="clark",imagermode="csclean",ftmachine="mosaic",mosweight=False,scaletype="SAULT",multiscale=[],negcomponent=-1,smallscalebias=0.6,interactive=doInteractive,mask=mymask,nchan=-1,start=0,width=1,outframe="",veltype="radio",imsize=512,cell="0.0107arcsec",phasecenter="",restfreq="",stokes="I",weighting="briggs",robust=0,uvtaper=False,outertaper=[''],innertaper=['1.0'],modelimage="",restoringbeam=[''],pbcor=False,minpb=0.2,usescratch=True,noise="1.0Jy",npixels=0,npercycle=100,cyclefactor=1.5,cyclespeedup=-1,nterms=1,reffreq="",chaniter=False,flatnoise=True,allowchunk=False)

