/*
 * Decompiled with CFR 0.152.
 */
package com.nomagic.magicdraw.examples.imagegenerator;

import com.nomagic.magicdraw.core.Application;
import com.nomagic.magicdraw.core.project.ProjectDescriptorsFactory;
import com.nomagic.magicdraw.export.image.ImageExporter;
import com.nomagic.magicdraw.uml.symbols.DiagramPresentationElement;
import com.nomagic.runtime.ApplicationExitedException;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;

public class ExportDiagramImages {
    private static final String PROJECT = "project_file";
    private static final String DESTINATION = "destination_dir";

    public static void main(String[] stringArray) {
        String string;
        ArrayList<String> arrayList = new ArrayList<String>(Arrays.asList(stringArray));
        Object object = arrayList.iterator();
        while (object.hasNext()) {
            string = object.next();
            if (!ExportDiagramImages.checkArgument(string, PROJECT) && !ExportDiagramImages.checkArgument(string, DESTINATION)) continue;
            object.remove();
        }
        object = System.getProperty(PROJECT, "");
        if (((String)object).length() == 0) {
            System.out.println("Project file not defined!");
            return;
        }
        string = System.getProperty(DESTINATION, "");
        if (string.length() == 0) {
            System.out.println("Destination directory not defined!");
            return;
        }
        File file = new File(string);
        if (!file.exists() && !file.mkdirs()) {
            System.out.println("Cannot create destination directory!");
            return;
        }
        stringArray = new String[arrayList.size()];
        stringArray = arrayList.toArray(stringArray);
        System.out.println("Exporting images...");
        Application application = Application.getInstance();
        try {
            application.start(false, true, false, stringArray, null);
            application.getProjectsManager().loadProject(ProjectDescriptorsFactory.createProjectDescriptor((URI)new File((String)object).toURI()), true);
            for (DiagramPresentationElement diagramPresentationElement : application.getProject().getDiagrams()) {
                String string2 = diagramPresentationElement.getDiagram().getQualifiedName();
                string2 = string2.replace(File.separator, "-");
                string2 = string2.replace(' ', '_');
                string2 = string2.replace(':', '_');
                string2 = string2.replace('{', '_');
                string2 = string2.replace('}', '_');
                string2 = string2.replace('(', '_');
                string2 = string2.replace(')', '_');
                File file2 = new File(file, string2 + ".png");
                System.out.println(">> " + string2 + " ");
                ImageExporter.export((DiagramPresentationElement)diagramPresentationElement, (int)1, (File)file2);
            }
            application.shutdown();
        }
        catch (ApplicationExitedException applicationExitedException) {
            applicationExitedException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    private static boolean checkArgument(String string, String string2) {
        String string3 = string2 + "=";
        if (string.startsWith(string3)) {
            String string4 = string.substring(string3.length());
            System.setProperty(string2, string4);
            return true;
        }
        return false;
    }
}

