/*
 * Decompiled with CFR 0.152.
 */
import java.applet.Applet;
import java.applet.AppletContext;
import java.awt.Canvas;
import java.awt.Cursor;
import java.awt.Event;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Polygon;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Vector;

class DiagramCanvas
extends Canvas {
    Vector nodes = new Vector();
    Applet myApplet;
    Image myImage;
    int myImageWidth;
    int myImageHeight;

    void setApplet(Applet a) {
        this.myApplet = a;
    }

    void setImage(Image i, int w, int h) {
        this.myImage = i;
        this.myImageWidth = w;
        this.myImageHeight = h;
    }

    void addNode(Polygon r, String file) {
        Node n = new Node(r, file);
        this.nodes.addElement(n);
    }

    public void paint(Graphics g) {
        if (this.myImage == null) {
            return;
        }
        g.drawImage(this.myImage, 0, 0, this.myImageWidth, this.myImageHeight, this);
    }

    public void traverseLink(Node n) {
        URL newURL;
        AppletContext context = this.myApplet.getAppletContext();
        URL oldURL = this.myApplet.getDocumentBase();
        String theProtocol = oldURL.getProtocol();
        String theHost = oldURL.getHost();
        String theFileAsString = oldURL.getFile();
        int lind = theFileAsString.lastIndexOf("/");
        String newFileAsString = theFileAsString.substring(0, lind + 1).concat(n.file());
        try {
            newURL = new URL(theProtocol, theHost, newFileAsString);
        }
        catch (MalformedURLException malformedURLException) {
            return;
        }
        context.showDocument(newURL, "_self");
    }

    public synchronized boolean mouseDown(Event evt, int x, int y) {
        int i = 0;
        while (i < this.nodes.size()) {
            Node n = (Node)this.nodes.elementAt(i);
            if (n.containsPoint(x, y)) {
                this.traverseLink(n);
                break;
            }
            ++i;
        }
        return true;
    }

    public synchronized boolean mouseMove(Event evt, int x, int y) {
        boolean found = false;
        int i = 0;
        while (i < this.nodes.size()) {
            Node n = (Node)this.nodes.elementAt(i);
            if (n.containsPoint(x, y)) {
                this.setCursor(new Cursor(12));
                found = true;
                break;
            }
            ++i;
        }
        if (!found) {
            this.setCursor(new Cursor(0));
        }
        return true;
    }

    public synchronized boolean mouseExit(Event evt, int x, int y) {
        this.setCursor(new Cursor(0));
        return true;
    }
}

