/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Event;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.LayoutManager;
import java.awt.Panel;
import java.awt.Scrollbar;

public class WrappingTextPanel
extends Panel {
    private String text;
    Scrollbar sbV;
    int sbVPosition = 0;
    int sbVWidth = 16;
    private FontMetrics fm;
    protected Image im1;
    protected Graphics g1 = null;
    private Font font;
    private int rowSize;
    private int textBaseLine;
    private int viewWidth;
    private int viewHeight;
    private boolean bDirty;
    private TextScanner scanner;

    public WrappingTextPanel() {
        super.setLayout(new BorderLayout());
        this.sbV = new Scrollbar(1);
        this.add("East", this.sbV);
        this.font = new Font("Dialog", 0, 12);
        this.fm = this.getToolkit().getFontMetrics(this.font);
        this.rowSize = this.fm.getHeight();
        this.textBaseLine = this.fm.getDescent() + this.fm.getLeading() / 2;
        this.viewWidth = 0;
        this.viewHeight = 0;
    }

    public void setBackground(Color color) {
        super.setBackground(color);
        this.invalidate();
    }

    public void setForeground(Color color) {
        super.setForeground(color);
        this.invalidate();
    }

    public void setText(String string) {
        this.scanner = new TextScanner(string, this.viewWidth - this.sbVWidth, this.fm);
        this.sbVPosition = 0;
        this.redraw();
    }

    public boolean handleEvent(Event event) {
        if (event.target == this.sbV) {
            if (event.arg == null) {
                return false;
            }
            if (this.sbVPosition != (Integer)event.arg) {
                this.sbVPosition = (Integer)event.arg;
                this.redraw();
            }
        }
        return super.handleEvent(event);
    }

    public boolean keyDown(Event event, int n) {
        switch (n) {
            case 1003: {
                this.sbVPosition = this.sbVPosition + this.sbV.getPageIncrement() <= this.sbV.getMaximum() ? (this.sbVPosition += this.sbV.getPageIncrement()) : this.sbV.getMaximum();
                this.redraw();
                break;
            }
            case 1002: {
                this.sbVPosition = this.sbVPosition - this.sbV.getPageIncrement() >= this.sbV.getMinimum() ? (this.sbVPosition -= this.sbV.getPageIncrement()) : this.sbV.getMinimum();
                this.redraw();
                break;
            }
            case 1004: {
                this.sbVPosition = this.sbVPosition - this.sbV.getLineIncrement() >= this.sbV.getMinimum() ? (this.sbVPosition -= this.sbV.getLineIncrement()) : this.sbV.getMinimum();
                this.redraw();
                break;
            }
            case 1005: {
                this.sbVPosition = this.sbVPosition + this.sbV.getLineIncrement() <= this.sbV.getMaximum() ? (this.sbVPosition += this.sbV.getLineIncrement()) : this.sbV.getMaximum();
                this.redraw();
            }
        }
        return false;
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    public void paint(Graphics graphics) {
        Dimension dimension = this.size();
        if (dimension.width != this.viewWidth || dimension.height != this.viewHeight) {
            this.redraw();
        }
        graphics.drawImage(this.im1, 0, 0, this);
    }

    public void redraw() {
        if (this.isShowing()) {
            this.drawText();
            this.repaint();
        } else {
            this.bDirty = true;
        }
    }

    public void repaint() {
        if (this.bDirty) {
            this.drawText();
        }
        this.bDirty = false;
        super.repaint();
    }

    public void drawText() {
        int n;
        int n2;
        int n3;
        Dimension dimension = this.size();
        if (dimension.width != this.viewWidth || dimension.height != this.viewHeight || this.g1 == null) {
            this.im1 = this.createImage(dimension.width - this.sbVWidth, dimension.height);
            if (this.g1 != null) {
                this.g1.dispose();
            }
            this.g1 = this.im1.getGraphics();
            this.viewWidth = dimension.width;
            this.viewHeight = dimension.height;
            if (this.scanner != null) {
                this.scanner.setLineWidth(this.viewWidth - this.sbVWidth);
            }
        }
        if (this.scanner != null) {
            if (this.scanner.getNumberOfLines() > this.viewHeight / this.rowSize) {
                n3 = this.viewHeight / this.rowSize;
                n2 = this.scanner.getNumberOfLines();
                n = n2 - n3 + 2;
                if (n > n2 - 1) {
                    n = n2 - 1;
                }
                this.sbV.show();
                if (this.sbVPosition > n) {
                    this.sbVPosition = n;
                }
                this.sbV.setValues(this.sbVPosition, n3, 0, this.scanner.getNumberOfLines());
            } else {
                this.sbVPosition = 0;
                this.sbV.hide();
            }
        } else {
            this.sbVPosition = 0;
            this.sbV.hide();
        }
        this.g1.setFont(this.font);
        this.setFont(this.font);
        this.g1.setColor(this.getBackground());
        this.g1.fillRect(0, 0, this.viewWidth - this.sbVWidth, this.viewHeight);
        if (this.scanner != null) {
            n3 = this.sbVPosition + this.viewHeight / this.rowSize;
            n2 = this.scanner.getNumberOfLines();
            if (n3 > n2) {
                n3 = n2;
            }
            this.g1.setColor(this.getForeground());
            n = this.sbVPosition;
            while (n < n3) {
                String string = this.scanner.getLineAt(n);
                int n4 = 0;
                int n5 = (n - this.sbVPosition) * this.rowSize;
                this.g1.drawString(string, n4, n5 + this.rowSize - this.textBaseLine);
                ++n;
            }
        }
    }

    public void setLayout(LayoutManager layoutManager) {
    }
}

