#!/bin/bash

start_dir=`pwd`
dir=`dirname $0`
cd $dir; export mydir=`pwd`
cd $start_dir

yum -y install openssh-server openssh-clients
systemctl enable sshd
systemctl start sshd

yum -y install curl policycoreutils ed wget

systemctl enable postfix
systemctl start postfix

firewall-cmd --permanent --add-service=http
firewall-cmd --permanent --add-service=https
firewall-cmd --permanent --add-service=ssh
systemctl reload firewalld
sleep 10

curl https://packages.gitlab.com/install/repositories/gitlab/gitlab-ee/script.rpm.sh | sudo bash

#EXTERNAL_URL="http://eltgitlab2.hq.eso.org" yum install -y gitlab-ee
EXTERNAL_URL="http://gitlab.eso.org" yum install -y gitlab-ee

#mkdir /git-data

mv /etc/gitlab/gitlab.rb  /etc/gitlab/gitlab.rb.ori
cp $mydir/gitlab.rb  /etc/gitlab
cp $mydir/ESO_CA.crt  /etc/pki/ca-trust/extracted/pem

# Enable now Https and reconfigure again
# Setup SSL Certificate
mkdir /etc/gitlab/ssl
chmod 700 /etc/gitlab/ssl
cd /etc/gitlab/ssl
cp $mydir/gitlab.eso.org.crt /etc/gitlab/ssl
cp $mydir/gitlab.eso.org.key /etc/gitlab/ssl
chmod 600 /etc/gitlab/ssl/*

gitlab-ctl reconfigure
gitlab-ctl restart


# Allow in /etc/sudoers some gitlab maintenance commands to account 'git'
grep -q GITSOFTWARE /etc/sudoers
if [ $? != 0 ]; then
  cat << EOF   >> /etc/sudoers
# Allow git to run updates
Cmnd_Alias GITSOFTWARE = /bin/rpm, /usr/bin/yum, /usr/bin/gitlab-ctl, /usr/bin/gitlab-rake, /bin/touch /etc/gitlab/skip-auto-reconfigure, sudoedit /etc/gitlab/gitlab.rb
git     ALL=(root)  NOPASSWD:  GITSOFTWARE
EOF
else
  echo "/etc/sudoers already edited"
fi
