/*******************************************************************************
amdlib.c

Source:
-------
Dr. Christian A. Hummel

Description:
------------

Modification history:
---------------------
18-Sep-2006  C.A.Hummel, file created
*******************************************************************************/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>

#include "export.h"
#include "amdlib.h"

#define PI 3.141592653589793
#define RAD(x) ((x)/360.*2.*PI)
#define NEG(x) ((x) > 0 ? -(x) : (x))
#define MIN(x,y) ((x) > (y) ? (y) : (x))
#define MAX(x,y) ((x) > (y) ? (x) : (y))

/* Global variables */

IDL_STRING *azCatalogPath,*azLibraryPath;
char azHIC[250],azHIP[250],azSAO[250],azFKV[250],azBSC[250];
char azBAT[250],azSKY[250],azFLN[250],azSPL[250],azJPL[250];

/* Function prototypes */

int tpstar(int argc, char *argp[]);

/*----------------------------------------------------------------------------*/
int amdlibcomputep2vm(int argc, char *argp[]){
	/* 
	Call amdlibComputeP2VM in amdlib C-library of AMBER DRS.
	*/

	IDL_STRING *p2vmdata,*badpixels,*p2vm;
	long *p2vmtype,;
	int errmsg;

        if (argc != 14) {
      		fprintf(stderr,"\nWrong # of parameters(%d)",argc);
      		return(1);
      		}

	p2vmdata= ((IDL_STRING**)argp)[4];
	badpixels= ((IDL_STRING**)argp)[4];
	p2vmtype=    ((long**)argp)[0];
	p2vm= ((IDL_STRING**)argp)[4];
	
	status=amdlibComputeP2VM(p2vmdata[0].s,badpixels[0].s,p2vmtype,p2vm[0].s,
			&errmsg);
	return((int)status);
	}
/*----------------------------------------------------------------------------*/
