;-------------------------------------------------------------------------------
pro dark,id1
;
if n_elements(id1) eq 0 then id1=1
id=id1-1
;
files=file_search('*.txt')
n=n_elements(files)
;
jds=fltarr(n)
modes=strarr(n)
dits=fltarr(n)
;
mv=fltarr(5,n)
me=fltarr(5,n)
vmax=fltarr(5,n)
vmed=fltarr(5,n)
mpsd=fltarr(5,n)
;
for i=0,n-1 do begin
	words=nameparse(files(i),'+')
	parsedate,words(0),y,m,d
	jds(i)=julian(y,m,d)
	modes(i)=words(1)
	p2vmid=words(2)
	dits(i)=float(words(3))
	status=dc_read_free(files(i),v1,v2,v3,v4,v5,/col)
	mv(*,i)=v1
	me(*,i)=v2
	vmax(*,i)=v3
	vmed(*,i)=v4
	mpsd(*,i)=v5
endfor
jds=jds-julian(2009,1,1)+1
;
; First, plot median dark level as a function of DIT
;
!p.multi=[0,3,3]
umodes=unique(modes)
n=n_elements(umodes)
;
; Loop over all instrument modes
for i=0,n-1 do begin
;
!p.charsize=2.0
!p.title=umodes(i)
!x.title='DIT [s]'
!y.title='Window '+string(id1,format='(i1)')
;
index=where(modes eq umodes(i))
cfiles=files(index)
cdits=dits(index)
cjds=jds(index)
ucdits=unique(cdits)
m=n_elements(ucdits)
;
xmin=0
if strpos(umodes(i),'Low') ge 0 then xmax=0.2
if strpos(umodes(i),'Med') ge 0 then xmax=2.0
if strpos(umodes(i),'High') ge 0 then xmax=14.0
jndex=where(cdits lt xmax)
ymin=min(mv(id,index(jndex)))-1
ymax=max(mv(id,index(jndex)))+1
plot,cdits,mv(0,index),/nodata,xrange=[xmin,xmax],yrange=[ymin,ymax]
;
; Loop over DITs
for j=0,m-1 do begin
	jndex=where(cdits eq ucdits(j))
;	Get data for this mode and DIT
        y=reform(mv(id,index(jndex)))
        e=reform(me(id,index(jndex)))
        x=fltarr(n_elements(y))+ucdits(j)
	oplot,x,y,psym=1
	oploterr,x,y,e,3
endfor
;
endfor
;
!x.range=0
!y.range=0
;
; Second, plot variance of successive darks within a night vs date
;
umodes=unique(modes)
n=n_elements(umodes)
;
; Loop over all instrument modes
for i=0,n-1 do begin
;
!p.multi=[0,2,4]
!p.charsize=2.0
!x.title='Day of 2009'
!y.title='Med. var., window '+string(id1,format='(i1)')
;
index=where(modes eq umodes(i))
cfiles=files(index)
cdits=dits(index)
cjds=jds(index)
ucdits=unique(cdits)
m=n_elements(ucdits)
;
; Loop over DITs
for j=0,m-1 do begin
	!p.title=umodes(i)+string(ucdits(j),format='(f7.3)')
        jndex=where(cdits eq ucdits(j))
;       Get data for this mode and DIT
	y=reform(vmed(id,index(jndex)))
	x=jds(index(jndex))
	!x.range=[min(x)-1,max(x)+1]
	ymin=0
	ymax=max(y)
	!y.range=1.1*[ymin,ymax]
	if total(y) gt 0 then plot,x,y,psym=1
endfor
;
endfor
;
; Finally, plot magnitude of hightest Fourier comp. vs median error
;
!p.charsize=1.5
!p.multi=0
!x.range=0
!y.range=0
!p.title=''
!x.title='Error of median of dark frame pixel values'
!y.title='Height of maximum Fourier component'
plot,me,mpsd,psym=1,xtype=1,ytype=1
;
end
