;
; Copyright 2005, 2006 University of Leiden.
;
; This file is part of MIA+EWS.
;
; MIA+EWS is free software; you can redistribute it and/or modify
; it under the terms of the GNU General Public License as published by
; the Free Software Foundation; either version 2 of the License, or
; (at your option) any later version.
;
; MIA+EWS is distributed in the hope that it will be useful,
; but WITHOUT ANY WARRANTY; without even the implied warranty of
; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
; GNU General Public License for more details.
;
; You should have received a copy of the GNU General Public License
; along with MIA; if not, write to the Free Software
; Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
;
;********************************************************
;#class#
;midiDumEl
;#description#
;very low level routine to create the IDL equivalent of
;one element in a Fits Table
;#end_class#
;*******************************************************

FUNCTION midiDumEl, idlType, nDim, iErr=iErr
;+
; Project : MIDI
;
;   Create a template IDL-variable representing one element 
;   of a binary table
;
; INPUTS:
;   idlType   int      IDL specification of input type, e.g. 1 = byte
;   nDIM      intarr   array specifying size of variable in each dimension
;
; OUTPUTS:    iErr
; RETURNS     ?arr     an empty IDL array of specified type and dimensions
;  Check the number of parameters.
;
;establish error handler
   cErr = 0
   catch, cErr
   if (cErr NE 0) then begin
;supress further handling at this level 
      catch, /cancel 
      midiCatchError
      iErr = 1
RETURN,0
   endif         ; handle actual error
   if N_PARAMS() NE 2 then begin
      midiSetError, 'Syntax:  midiDumEl(IDLTYPE, nDim) '
;  Create a SIZE like array from nDim and idlType
   i0 = MIN(WHERE(nDim EQ 0))
   if (i0 EQ 1) then midiSetError, 'Empty Array'
;scalar
   if (i0 EQ 0 AND (idlType NE 7)) then begin
      CASE idlType OF
         1: structEl = 0B
	 2: structEL = 0
	 3: structEl = 0L
	 4: structEl = 0.0
	 5: structEl = double(0.0)
	 6: structEl = complex(0.0, 0.0)
      ENDCASE
      endif else begin
      if (i0 EQ -1) then I0 = nDim ELSE  I0 = nDim(0:I0 - 1)
;Fix for character strings.  Then the first dimension is actually
;the number of characters per string, which is irrelvant at this point
      if (idlType EQ 7) then begin
         nChar = i0[1]
         if (i0[0] EQ 1) then i0 = [1,1] else   $
         i0 = [i0[0]-1>1,i0[2:n_elements(i0)-1]]
      endif
      nl = 1L
      for i = 1, N_ELEMENTS(I0) - 1 do nl = nl * i0(i)
      i0 = [i0, idlType, nl]
;
      structEl = MAKE_ARRAY(SIZE = i0)
   endelse
   if (idlType EQ 7) then structEl[*] = STRING(REPLICATE(32b,nChar))
   iErr = 0
   RETURN, structEl
END
