FUNCTION midiTotalFrames, files
   RETURN,FIX(TOTAL(midigetkeyword('DET NDIT', $
      midiextractfiles(files))))
END
FUNCTION spHdTrim, hdname
   name = STRUPCASE(STRTRIM(hdname,2))
   if (STRMID(name,0,2) NE 'HD') then RETURN,name
   num = STRTRIM(INDGEN(10),2)
   outname='HD'
   for i=2,STRLEN(name)-1 do begin
      ch = STRMID(hdName,i,1)
      if (TOTAL(ch EQ num) GT 0) then outname=outname+ch
   endfor
RETURN, outname
END

PRO spFluxDiam, targ, flux, diam
   CLOSE,1
   OPENR,1,'$test/calibrators.txt'
   ll=''
   readf,1,ll
   ntarg=0
   readf,1,ntarg
   tdata = STRARR(7,ntarg)
   for i=0,ntarg-1 do begin readf,1,ll&tdata[*,i]=STRSPLIT(ll,' ',/ex)&endfor
   close,1
   targname = STRTRIM(targ,2)
   mtarg = N_ELEMENTS(targname)
   for i=0,mtarg-1 do targname[i]=sphdtrim(targname[i])
   flux = FLTARR(mtarg)
   diam = flux
   for i=0,mtarg-1 do begin
      flux[i] = 0.
      diam[i] = 0.
      j = MIN(WHERE(targname[i] EQ tdata[0,*]))
      if (j LT 0) then j=MIN(WHERE(STRPOS(REFORM(tdata[6,*]),targname[i]) GE 0))
      if (j LT 0) then RETURN
      flux[i] = FLOAT(tdata[2,j])
      diam[i] = FLOAT(tdata[4,j])
   endfor
RETURN
END

FUNCTION spDiam, file, flux, targ
    targ= MIDIGETKEYWORD('TARG NAME',file+'.fringes.fits')
    targ= STRTRIM(targ,2)
    spFluxDiam, targ, flux, diam
RETURN, diam
END

FUNCTION diskVis, prefix, flux, target, diam, base
   fringefile = prefix+'.fringes.fits'
   wave = oirgetwavelength(fringefile)
   diam = spDiam(prefix, flux, target) ; milliarcsec
   base = 0.5*(midigetkeyword('PBL12 END',fringefile)+$
      midigetkeyword('PBL12 START', fringefile))
   beselarg = !pi*base*diam/(!radeg*3.6e6)
   wavem = float(1.e-6*wave)
   beselarg = float(beselarg[0])
   beselarg = beselarg/wavem
   RETURN, midiairy(beselarg)
END

FUNCTION undat, s
   ns = N_ELEMENTS(s)
   sz=SIZE(s.data1,/dim)
   if (N_ELEMENTS(sz) EQ 1) then sz = [sz,1]
   out = FLTARR(sz[0],sz[1],4, ns)
   for i=0, ns-1 do begin
      out[*,*,0,i]=s[i].data1
      out[*,*,1,i]=s[i].data2
      out[*,*,2,i]=s[i].data3
      out[*,*,3,i]=s[i].data4
   endfor
RETURN,REFORM(out)
END

FUNCTION undata,f,m 
   if (N_PARAMS() EQ 1) then RETURN,undat(oirgetdata(f))
   RETURN,undat(oirgetdata(f,m))
END

FUNCTION undata4,f,m
   data = undata(f,m)
   sz = SIZE(data,/dim)
   if N_ELEMENTS(sz) EQ 3 then RETURN,REFORM(data,sz[0],160)
   if N_ELEMENTS(sz) EQ 4 then RETURN,REFORM(data,sz[0],160,sz[3])
END

FUNCTION sidelobes,x
   sz = SIZE(x,/dim)
   out = x
   for i=0,sz[0]-1 do begin
      y = REFORM(x[i,*])
      p = max(y, z)
      zap = 1.
      for j=z,sz[1]-1 do begin
         if(y[j] le 0.) then zap = 0.
         y[j] =y[j]*zap
      endfor
      zap = 1.
      for j=z,0,-1 do begin
         if(y[j] le 0.) then zap = 0.
         y[j] =y[j]*zap
      endfor
      out[i,*] = y
   endfor
RETURN, out
END

FUNCTION doYear, x
   nx = N_ELEMENTS(x)
   year = fltarr(nx)
   day = fltarr(nx)
   for i=0,nx-1 do begin
      d= STRSPLIT(x[i],'T',/ex)
      d1=FIX(STRSPLIT(d[0],'-',/ex))
      year[i] = d1[0]-2000+(d1[1]/12.)+d1[2]/365.
      d2=FLOAT(STRSPLIT(d[1],':',/ex))
      day[i] = (d2[0]*3600+d2[1]*60+d2[2])/86400.
   endfor
RETURN, year+day
END

FUNCTION mjd2000,x
   RETURN,2000.d0+(x-51544.)/365.25
END

FUNCTION spDeFft,x
   sz=SIZE(x,/dim)
   nd = N_ELEMENTS(sz)
   if (nd LT 2) then sz=[sz,1]
   if (nd LT 3) then sz=[sz,1]
   if (nd LT 4) then sz=[sz,1]
   dft = FLTARR(sz[0],sz[1],sz[2],sz[3])
   for iw=0,sz[3]-1 do for iz=0,sz[2]-1 do for ix=0,sz[0]-1 do $
      dft[ix,*,iz,iw] = FLOAT(FFT(x[ix,*,iz,iw],-1))
RETURN, dft
END

FUNCTION spSkyPix, prefix=prefix, ab=ab
;
;      compute pixels that are actually exposed to sky or tunnel
;      (as opposed to cold stops)
;
;      algorithm:
;        per column in the sky photometry frames
;        only take pixels GT mean of 2nd/3rd/38/39th brightest pixels
;
   if (KEYWORD_SET(prefix)) then $
      asky = undata(prefix+'.Achop.fits',7) $
   else asky = undata(ab+'.ABchop.fits',7)
   sz = SIZE(asky,/dim)
   skymask = FLTARR(sz[0], sz[1], 4, 2)
   skymask(*,*,*,0) = asky
   if (KEYWORD_SET(prefix)) then $
      skymask(*,*,*,1) = undata(prefix+'.Bchop.fits',7) $
   else skymask[*,*,*,1] = skymask[*,*,*,0]
   outmask = BYTE(0*skymask)
   for j=0,1 do for i=0,3 do for k=0,sz[0]-1 do begin
      s = REFORM(skymask[k,1+SORT(skymask[k,1:*,i,j]),i,j])
      sm = mean(s[[1,2,sz[1]-3,sz[1]-2]])
      outmask[k,*,i,j] = SMOOTH(skymask[k,*,i,j] gt sm, 4)
   endfor
   if (KEYWORD_SET(prefix)) then begin 
      outmask[*,*,0,0] = 0.
      outmask[*,*,3,1] = 0.
   endif
RETURN, outmask
END

PRO spSkyRMS, datafile, msChop, mtChop, rsChop, rtChop
  ;
  chopdata = midichopimagearray(datafile)
  s = WHERE(chopdata.tartyp2 eq 'S ')
  t = WHERE(chopdata.tartyp2 eq 'T ')
  nS = N_ELEMENTS(s)
  nT = N_ELEMENTS(t)
  sChop = undat(chopdata[s])
  tChop = undat(chopdata[t])
  sZ = SIZE(sChop,/dim)
  msChop = TOTAL(sChop,4)/nS
  mtChop = TOTAL(tChop,4)/nT
  for i=0,nS-1 do sChop[*,*,*,i] = sChop[*,*,*,i] - msChop
  for i=0,nT-1 do tChop[*,*,*,i] = tChop[*,*,*,i] - mtChop
  rsChop  = TOTAL(sChop^2,4)/nS
  rtChop  = TOTAL(tChop^2,4)/nT
RETURN
END

;FUNCTION spSkyMask, files, sm=sm
;
;  if (NOT KEYWORD_SET(sm)) then sm = 20
;  print,' getting fluctuation data'
;  rmsData = undat(midiChopMeanRms(files, sm=sm))
;  print,' got it '
;  rmsData = rmsData[*,*,*,3]
;  sz = SIZE(rmsData,/dim)
;  coolMask = rmsData
;  for j=0,3 do begin
;    tmp = rmsData[*,*,j]
;    for k=0,sz[0] - 1 do begin
;       h   = tmp(k,sort(tmp[k,*]))
;       tmp[k,*]  = tmp[k,*]-h[0.2*sz[1]]
;       h    = h  -h[0.1*sz[1]]
;       tmp[k,*]  = tmp[k,*]/h[0.9*sz[1]]
;       coolmask[k,*,j] = tmp[k,*] 
;    endfor
;    print,j
;  endfor
;RETURN, coolmask
;END

FUNCTION spRegress, model, data, weight, fit, nozero=nozero
   sz = SIZE(model,/dim)
   if (NOT KEYWORD_SET(nozero)) then begin
      if (N_ELEMENTS(sz) EQ 1) then $
         RETURN, REGRESS(REFORM(model,1,sz), REFORM(data), REFORM(weight), fit)
      fit = model
      rg = FLTARR(sz[0])
      for k=0, sz[0]-1 do begin
         rg[k] = REGRESS(model[k,*], REFORM(data[k,*]), REFORM(weight[k,*]), y)
         fit[k,*] = y
      endfor
   endif else begin
      if (N_ELEMENTS(sz) EQ 1) then begin
         rg = TOTAL(model*data*weight)/total(weight*model^2)
         fit = rg*model
      endif else begin
         fit = model
         rg = FLTARR(sz[0])
         for k=0, sz[0]-1 do begin
            rg[k] = TOTAL(model[k,*]*data[k,*]*weight[k,*])/$
                    TOTAL(model[k,*]*model[k,*]*weight[k,*])
            fit[k,*] = rg[k]*model[k,*]
         endfor
      endelse
   endelse
RETURN, rg
END

FUNCTION spDeBase, data, masks
   debase = data
   sz = SIZE(data,/dim)
   if (N_ELEMENTS(sz) GE 3) then nz = sz[2] else nz = 1
   ny = sz[1]
   yy = findgen(ny)
   for z=0,nz-1 do begin
      for k=0,sz[0]-1 do begin
         wy = reform(masks[k,*,z])
         if (TOTAL(wy) GT 2.) then begin
            q = polyfitw(yy, reform(data[k,*,z]), wy, 1, yd)
            debase[k,*,z] = data[k,*,z] - yd
         endif
      endfor
   endfor
RETURN, debase
END

PRO spFileInfo, ppIn, unit=unit
;
   if (NOT KEYWORD_SET(unit)) then u=-1 else u=unit
   pp = STRSPLIT(ppIn,'.',/ex)
   if (N_ELEMENTS(pp) GT 1) then preAfile = ppIn $
   else preAfile = pp+'.ABchop.fits'
   dit   = midigetkeyword('DET DIT', preAfile)
   targ  = midigetkeyword('TARG NAME',preAfile)
   targ  = STRTRIM(targ,2)
   airm  = 0.5*(midigetkeyword('AIRM END',preAfile)+midigetkeyword('AIRM START',preAfile))
   tau   = 0.5*(midigetkeyword('TAU0 END',preAfile)+midigetkeyword('TAU0 START',preAfile))
   see   = 0.5*(midigetkeyword('FWHM END',preAfile)+midigetkeyword('FWHM START',preAfile))
   chop  = midigetkeyword('CHOP FREQ',preAfile)
   t1    = midigetkeyword('CONF STATION1',preAfile)
   t2    = midigetkeyword('CONF STATION2',preAfile)
   mjd   = mjd2000(midigetkeyword('MJD-OBS',preAfile))
   spFluxDiam, targ, flux, diam
   printf,u,'      MIDI SCI-PHOT Kappa Solver   '
   printf,u,'  target    ',targ
   printf,u,' telescopes ',t1,' ',t2
   printf,u,' obsdate    ',mjd,format='(a12,f9.4)'
   printf,u,' chop freq  ',chop,' sec',format='(a12,f7.5,a)'
   printf,u,' airmass    ', airm,format='(a12,f4.2)'
   printf,u,' seeing     ', see,format='(a12,f4.2)'
   printf,u,' tau_0      ', 1000*tau,' msec ',format='(a12,f4.2,a)'
   printf,u,' tau_0(10)  ', 36411.*tau,' msec ',format='(a11,f5.0,a)'
   printf,u,' DIT        ', 1000*dit,' msec ',format='(a12,f4.1,a)'
   printf,u,' flux       ', flux, ' Jy ',format='(a11,f4.0,a)'
   printf,u,' diam       ', diam, ' mas',format='(a11,f4.0,a)'
RETURN
END

PRO spKeywords, pre, dit, targ, airm, tau, see, flux, diam, date
   if (N_PARAMS() EQ 0) then begin
      print,' spkeywords, pre, dit, targ, airm, tau, see, flux, diam '
      RETURN
   endif
   files = pre+'.fringes.fits'
   keys=['DET DIT','TARG NAME','AIRM END','TAU0 END','FWHM END','OPT1 NAME','MJD-OBS']
   output = midigetkeywordlist(keys, files)
   dit  = REFORM(float(output[0,*]))
   targ = REFORM(strtrim(output[1,*],2))
   airm = REFORM(float(output(2,*)))
   tau  = REFORM(float(output(3,*)))
   see  = REFORM(float(output(4,*)))
   gris = REFORM(strtrim(output[5,*],2))
   date = REFORM(mjd2000(DOUBLE(output[6,*])))
   spFluxDiam, targ, flux, diam
RETURN
END

FUNCTION spPSFphot, image, psf, mask
;      column by column flux estimator including linear background
;      INPUTS:
;         image: real data
;         psf: same format as image.  Each column (psf[i,*]) contains
;              FFT of normalized (TOTAL(psf[i,*]) = 1) idealized
;              version of what image[i,*] should look like without
;              noise or backgrounds
;         mask: same format as image.  Each column mask[i,*] gives
;               pixel weights to use during fit
;
;       RETURNS: flux per column that best fits psf to image
;
   newPsf = image  ; just allocating space
   sz = SIZE(image,/dim)
   nDim = N_ELEMENTS(sz)
   if (nDim EQ 3) then nz = sz[2] else nz=1
;      select an x-range  of pixels near center of spectrum
   dx   = 5
   xx   = sz[0]/2 + indgen(2*dx)-dx
   yy = SHIFT(FINDGEN(sz[1])-sz[1]/2,-sz[1]/2); dummy variable y-direction
;      fitting function for REGRESS.  1st column is linear function.
   yfit     = FLTARR(2, sz[1])
   yfit[0,*] = FINDGEN(sz[1]) - .5*sz[1] ; linear background fit
   spectrum = FLTARR(sz[0],nz)
;
;      extract profile at center of image and find convolution
;      necessary to make psf look like image.  This includes
;      both position shift and blurring
;
;      select central pixels; extract and average in x-direction
;      first for psf
   for iz=0, nz-1 do begin
;      if multi-dimensional, select one subimage
      psfz   = psf[*,*,iz]
      imagez = image[*,*,iz]
      maskz  = mask[*,*,iz]
;         extract psf and average.  Note psf is already FFTd
      pcent  = TOTAL(psfz[xx,*],1)/N_ELEMENTS(xx)
;      sum image on same pixels, then FFT
      cc = TOTAL(imagez[xx,*],1)
      cc = FFT(cc>0,1)
;         divide fft of image by psf to find convolving function
;         exclude values > 1?
      psent = cc/cc[0]/pcent
      pmax  = where(ABS(psent) GT 1.)
      if (max(pmax) GE 0) then psent(pmax) = psent(pmax)/ABS(psent(pmax))
      pph   = midiphase(psent)
      wyy = abs(yy) LE 5 ; fit phase gradient in center of UV plane
      q = POLYFITW(yy, pph, wyy, 1, yph)
      psent = ABS(psent) * exp(complex(0.,1.)*yph)
      for k=0,sz[0]-1 do newPsf[k,*,iz] = FLOAT(FFT(psfz[k,*] * psent,-1))
;
;      fit psf
      for k=0,sz[0]-1 do begin
         yfit[1,*] = newPsf[k,*]
         q = REGRESS(yfit, REFORM(imagez[k,*]), REFORM(maskz[k,*]),y)
         if (finite(q[0,1])) then spectrum[k,iz] = q[0,1] else spectrum[k,iz]=0.
      endfor
   endfor ; z loop
RETURN, REFORM(spectrum)
END

FUNCTION spChopPhot, pre, cal
   spFileIn, cal , masks, kappa, psfs, pcent, psfab
   sz = SIZE(masks,/dim)
   spectrum = FLTARR(sz[0],4,2)
   images = 0*masks
   images[*,*,*,0] = undata(pre+'.Achop.fits',1)
   images[*,*,*,1] = undata(pre+'.Bchop.fits',1)
   for i=0,1 do for j=0,1 do spectrum(*,i+1,j) = $
      spPSFphot(images[*,*,i+1,j], psfs[*,*,i,j], masks[*,*,i+1,j])
   spectrum(*,0,1) = $
      spPSFphot(images[*,*,0,1], psfab[*,*,1], masks[*,*,0,1])
   spectrum(*,3,0) = $
      spPSFphot(images[*,*,3,0], psfab[*,*,0], masks[*,*,3,0])
RETURN,spectrum
END

FUNCTION midiMakeMask, image, fudge=fudge, waveref=waveref
;    construct gaussian masks based on a clean image
;
;    default fudge is 2.
   if (NOT KEYWORD_SET(fudge)) then fudge = 2.
   myImage = image ; for internal use
   sImage = SIZE(image, /dim)
   nx = sImage[0]
   ny = sImage[1]
;  mask = FLTARR(nx, 2)
   xx = FINDGEN(nx)
   yy = FINDGEN(ny)
   wt = FLTARR(nx)
   if (NOT KEYWORD_SET(waveref)) then $
      if (sImage[0] GT 180) then waveref = getenv('grismscurve') $
      else waveref = getenv('prismscurve')
   wave = oirgetwavelength(waveref)
   if (sImage[0]) GT 180 then begin
      wmin = MIN(where(wave GT 7.5))
      wmax = MAX(where(wave LT 13.0))
   endif else begin
      wmin = MIN(where(wave LT 13.0))
      wmax = MAX(where(wave GT 7.5))
   endelse
   for i=0, ny-1 do myImage(*,i) = median(myImage(*,i),5)
;  if (KEYWORD_SET(hotwave)) then begin
;     wave=hotwave
;     dwave = abs(wave-shift(wave,1))
;     dwave[0]=dwave[1]
;     dwave[nx-1]=dwave[nx-1]
;     wfit = TRANSPOSE(wave^(-6))
;     wwave = wave gt 8 and (wave lt 13) and (wave lt 9 or (wave gt 10))
;     for i=0,ny-1 do begin
;        f = regress(wfit,myImage[*,i],wwave,const=c)
;        myImage[*,i] = myImage[*,i]-c
;     endfor
;  endif
;
;      gaussian fits to image.  Start in middle where beam should be clean
;      then step your way towards both ends
   gPar = FLTARR(nx, 2)
   dx = 6
   i = nx/2
   px = pk(yy, myImage[i,*])
   xr = ROUND(px)-dx+indgen(2*dx)
   x=yy[xr]			; CAH
   y=reform(myImage[i,xr])	; CAH
   a0=fltarr(3)			; CAH
   a0[0]=max(y,j)		; CAH
   a0[1]=x[j]			; CAH
   a0[2]=2.5			; CAH
   q = GAUSSFIT(yy[xr], myImage[i,xr], a, estimates=a0, nTerm=3,sigma=s,chisq=c)
   a0 = a
   for i=nx/2, nx-21 do begin
      if max(myImage[i,xr])/a0[0] gt 0.05 then begin	; CAH
      px = pk(yy, myImage[i,*])
      if abs(px-a0(1)) gt 2 then px=a0(1)	; CAH
      xr = ROUND(px)-dx+indgen(2*dx)
      a=a0	; CAH
      a(0)=max(myImage[i,xr])	; CAH
      q = GAUSSFIT(yy[xr], myImage[i,xr], a, estimate=a, nTerm=3,sigma=s)
      if finite(a[2]) eq 0 then a[2]=0 ; CAH
      gPar[i,*] = a[1:2]
      wt[i] = s[2] LT 0.5 AND (FINITE(s[2])) AND (a[0] GT 0.) and (a[2] GT 0.)
      endif else wt[i]=0
   endfor
   for i=nx/2, 20, -1 do begin
      if max(myImage[i,xr])/a0[0] gt 0.05 then begin	; CAH
      px = pk(yy, myImage[i,*])
      if abs(px-a0(1)) gt 2 then px=a0(1)	; CAH
      xr = ROUND(px)-dx+indgen(2*dx)
      a=a0	; CAH
      a(0)=max(myImage[i,xr])	; CAH
      q = GAUSSFIT(yy[xr], myImage[i,xr], a, estimate=a, nTerm=3,sigma=s)
      if finite(a[2]) eq 0 then a[2]=0 ; CAH
      gPar[i,*] = a[1:2]
      wt[i] = s[2] LT 0.5 AND (FINITE(s[2])) AND (a[0] GT 0.) and (a[2] GT 0.)
      endif else wt[i]=0
   endfor
;         now do 3rd order polynomial fits to center/halfwidth parameters
;  gPar[1,*] = gPar[1,*] > 1	; CAH
   for i=0, 1 do begin
      q = POLYFITW(xx, gPar(*,i), wt, 3, gg)
      gPar(*,i) = gg
   endfor
;         insert polynomial fits of gaussians into mask
;  cFudge = 0.5/fudge^2
;  for i=0, nx-1 do begin
;     argh = cFudge * ((yy-gPar[i,0])/gPar[i,1])^2 <10
;     mask[i,*] = exp(-argh) 
;  endfor
      mask = gPar
;         replace fits for wave > 13 or wave < 8
   if (wmin GT 0) then for i=0,wmin-1 do mask[i,*] = mask[wmin,*]
   if (wmax LT (nx-2)) then for i=wmax+1,nx-1 do mask[i,*] = mask[wmax,*]
RETURN, mask
END

FUNCTION spGMask, mask, fudge=fudge, type=type
;    reconstruct gaussian mask from fit parameters
   if (NOT KEYWORD_SET(fudge)) then fudge = 1.
   if (NOT KEYWORD_SET(type)) then type = 'gauss' $
      else type = STRTRIM(type,2)
   sz = SIZE(mask,/dim)
   outMask = FLTARR(sz[0], 40)
   yy = FINDGEN(40)
  
   if (type eq 'gauss') then begin
      for i=0,sz[0]-1 do begin
         if ((mask[i,0] LE 0) OR (mask[i,1] LE 0)) then outMask[i,*] = 0. else $ ; CAH
         outMask[i,*] = exp(-0.5 * ((yy-mask[i,0])/(fudge*mask[i,1]))^2 >(-20))
      endfor
   endif else if (type eq 'flat') then begin
      for i=0,sz[0]-1 do begin
         if ((mask[i,0] LE 0) OR (mask[i,1] LE 0)) then outMask[i,*] = 0. else $ ; CAH
         outMask[i,*] = ABS(yy-mask[i,0]) LT (fudge*mask[i,1])
      endfor
   endif else begin
      print,'unspecified mask type ',type
      RETURN,0
   endelse
RETURN, outMask
END

FUNCTION spSigmaClipMask, gMask, sigma, neg=neg
;    given a gaussian mask, return a binary mask with points >< sigma clipped
     sLevel = exp(-0.5*sigma^2)
     if (NOT KEYWORD_SET(neg)) then RETURN,( gmask GT sLevel)
     RETURN, (gmask GT 0.) AND (gmask LT sLevel)
END

PRO spFileOut, outPre, masks, kappa, psfs, pcent, psfab, refFile=refFile
;
;   default refFeil
   if (NOT KEYWORD_SET(refFile)) then refFile=outPre+'.Achop.fits'
;    write masks
;  get a detector object from ref file
   sz = SIZE(psfs,/dim)
   nx = sz[0]
   ny = sz[1]
   adet = OBJ_NEW('imageDetector', refFile)
   adet->close
;    change image size to contain gaussian fits
   detTable = adet->table()
   (*detTable).naxis[1,*] = 2
   mtemp = REPLICATE(adet->datatemplate(),2)
   mdco = WHERE(STRPOS(TAG_NAMES(mtemp),'DATA') GE 0)
   for i=0,3 do mtemp.(mdco[i]) = REFORM(masks[*,*,i,*])
;
   outName = outPre+'.mask.fits'
   adet->newFile,outName
   imobj = OBJ_NEW('imagedata', adet)
   imobj->appendtofile,adet
   imobj->writerows,mtemp
   imobj->close
   OBJ_DESTROY,imobj
   OBJ_DESTROY,adet
;
;   convert to pseudocomplex and write psfs
;
   adet = OBJ_NEW('imageDetector', refFile)
   adet->close
;    change image size
   detTable = adet->table()
   (*detTable).naxis[0,*] = 2*(*detTable).naxis[0,*]
   mtemp = REPLICATE(adet->datatemplate(),2)
   mdco = WHERE(STRPOS(TAG_NAMES(mtemp),'DATA') GE 0)
   for j=0,1 do for k=0,1 do for iy=0,ny-1 do for ix=0,nx-1 do $
      mtemp[j].(mdco[k+1])[2*ix:2*ix+1,iy] = $
         [FLOAT(psfs[ix,iy,k,j]),IMAGINARY(psfs[ix,iy,k,j])]
   outName = outPre+'.psfs2.fits'
   adet->newFile,outName
   imobj = OBJ_NEW('imagedata', adet)
   imobj->appendtofile,adet
   imobj->writerows,mtemp
   imobj->close
   OBJ_DESTROY,imobj
   OBJ_DESTROY,adet
;
;   kappa matrices
;
   adet = OBJ_NEW('imageDetector', refFile)
   adet->close
;    change image size
   detTable = adet->table()
   (*detTable).naxis[1,*] = 1
   mtemp = adet->datatemplate()
   mdco = WHERE(STRPOS(TAG_NAMES(mtemp),'DATA') GE 0)
   for j=0,1 do for k=0,1  do $
      mtemp.(mdco[k+2*j])=  kappa(*,k,j)
   outName = outPre+'.kappa.fits'
   adet->newFile,outName
   imobj = OBJ_NEW('imagedata', adet)
   imobj->appendtofile,adet
   imobj->writerows,mtemp
   imobj->close
   OBJ_DESTROY,imobj
   OBJ_DESTROY,adet
;
;     pcent, y-profiles at center
;
   adet = OBJ_NEW('imageDetector', refFile)
   adet->close
;    change image size; ny * 2
   detTable = adet->table()
   (*detTable).naxis[0,*] = 2 * ny
   (*detTable).naxis[1,*] = 1
   mtemp = REPLICATE(adet->datatemplate(),3)
   for i=0,2 do begin
   for ix=0, ny-1 do begin
      mtemp[i].data1[2*ix:2*ix+1,0] = $
         [FLOAT(pcent[ix,1,i]),IMAGINARY(pcent[ix,1,i])]
      mtemp[i].data4[2*ix:2*ix+1,0] = $
         [FLOAT(pcent[ix,0,i]),IMAGINARY(pcent[ix,0,i])]
   endfor
   endfor
   outName = outPre+'.psfy.fits'
   adet->newFile,outName
   imobj = OBJ_NEW('imagedata', adet)
   imobj->appendtofile,adet
   imobj->writerows,mtemp
   imobj->close
   OBJ_DESTROY,imobj
   OBJ_DESTROY,adet
;
;    psfab
;
   adet = OBJ_NEW('imageDetector', refFile)
   adet->close
;    change image size
   detTable = adet->table()
   (*detTable).naxis[0,*] = 2*(*detTable).naxis[0,*]
   mtemp = adet->datatemplate()
   mdco = WHERE(STRPOS(TAG_NAMES(mtemp),'DATA') GE 0)
   for iy=0,ny-1 do for ix=0,nx-1 do begin
      mtemp.data4[2*ix:2*ix+1,iy] = $
         [FLOAT(psfab[ix,iy,0]),IMAGINARY(psfab[ix,iy,0])]
      mtemp.data1[2*ix:2*ix+1,iy] = $
         [FLOAT(psfab[ix,iy,1]),IMAGINARY(psfab[ix,iy,1])]
   endfor
   outName = outPre+'.psfab.fits'
   adet->newFile,outName
   imobj = OBJ_NEW('imagedata', adet)
   imobj->appendtofile,adet
   imobj->writerows,mtemp
   imobj->close
   OBJ_DESTROY,imobj
   OBJ_DESTROY,adet
RETURN
END

FUNCTION spFftPsf, image
   m   = sidelobes(image)
   sz  = SIZE(m,/dim)
   psf = complex(m)
   for k=0, sz[0]-1 do begin
      psf[k,*] = FFT(m[k,*],1)
      if (abs(psf[k,0]) GT 0.) then psf[k,*] = psf[k,*]/psf[k,0] $
         else psf[k,*] = 0.
   endfor
;
RETURN, psf
END

FUNCTION spSkyBackMasks, calmask, achop, bchop, skymasks, fudge=fudge, $
   type=type
;
   if (NOT KEYWORD_SET(fudge)) then fudge = 6
   if (NOT KEYWORD_SET(type)) then type = 'back'
   type = STRTRIM(type,2)
   sz      = SIZE(achop,/dim)
   newMask = FLTARR(sz[0], sz[1], 4, 2)
   yy      = -4 + findgen(9) ; trial y-shift amounts
   zz      = fltarr(9)       ; store correlation after shift
;
;           cross correlate a.data4 and mask.data4; i.e. PA data

   cmask = calMask ; local version
   a = achop[*,*,3]
   m = spGMask(calMask[*,*,3,0], fudge=1)
;           shift, multiply, total; then find peak
   for i=0,8 do zz[i] = total(a * shift(m,0,yy[i]))
   ym = pk(yy,zz)
   print,'ashift = ',ym
;            shift mask origin
   cmask[*,0,*,0] = cmask[*,0,*,0] + ym
   if (type EQ 'back') then $
       for j=0,3 do newMask[*,*,j,0] = $
          skyMasks[*,*,j,0]* $
          spGMask(cmask[*,*,j,0],fudge=fudge,type='flat') * $
          (1-spGMask(cmask[*,*,j,0],fudge=2,type='flat')) $
   else if (type EQ 'center') then $
      for j=0,3 do newMask[*,*,j,0] = $
         skyMasks[*,*,j,0] * $
          spGMask(cmask[*,*,j,0],fudge=5,type='flat')  $
   else begin
      print,' mask type '+type+' not known '
      RETURN,0
   endelse
;           same for PB data
    a = bchop[*,*,0]
    m = spGMask(cmask[*,*,0,1], fudge=1)
    for i=0,8 do zz[i] = total(a * shift(m,0,yy[i]))
    ym = pk(yy,zz)
    print,'bshift = ',ym
    cmask[*,0,*,1] = cmask[*,0,*,1] + ym
   if (type EQ 'back') then $
       for j=0,3 do newMask[*,*,j,1] = $
          skyMasks[*,*,j,1]* $
          spGMask(cmask[*,*,j,1],fudge=fudge,type='flat') * $
          (1-spGMask(cmask[*,*,j,1],fudge=2,type='flat') ) $
   else if (type EQ 'center') then $
      for j=0,3 do newMask[*,*,j,1] = $
         skyMasks[*,*,j,1] * $
          spGMask(cmask[*,*,j,1],fudge=5,type='flat') 
RETURN, newMask
END

PRO spCross, calpre, masks, kappa, psfs, pcent, psfab, $
   waveref=waveref, fudge=fudge, out=out, smx=smx
;    compute photometric masks and kappa coefficients
;    from calibrator A/Bphotometry images
;
;     inputs:  calpre identifies calibrator Achop and Bchop 
;                     photometry mode files
;     outputs: masks: oirData[2] format structures containing
;                     4-channel (actually 3-channel) flux masks
;                     from input files
;              kappa: fltarr(nx,2,2) ratios of masked fluxes
;                     as I[1,2] / P[A,B].  stored as
;                     kappa[*,1/2, A/B]
;              psfs : complex(nx,ny,1:2,A:B) normalized fourier transforms of
;                     calibrator profiles in I1/2 channels of A/Bchop
;                     observations.  Normalized  means that sum under
;                     each profile in y-direction is 1.0
;              pcent: complex(ny, A:B) normalized fourier transforms of
;                     calibrator profiles of PA/B near x-center position
;              psfab: complex(nx,ny,A:B) normalized fourier transforms of
;                     calibrator profiles in PA/PB channels of A/Bchop
;                     observations.  Normalized  means that sum under
;                     each profile in y-direction is 1.0
;
;  
   if (N_PARAMS() LT 1) then begin
      print,' spCross calpre, mask, kappa, psfs, pcent, psfab '+$
         'waveref=waveref, fudge=fudge, out=out, smx=smx '
      RETURN
   endif
   if (NOT KEYWORD_SET(fudge)) then fudge = 2.
   if (fudge LT 2.) then print,' Using FUDGE < 2 is DANGEROUS '
;      which disperser?  get wavelength reference file
   preAfile = calpre+'.Achop.fits'
   gris = STRTRIM(midigetkeyword('GRIS NAME', preAfile),2)
   if (NOT KEYWORD_SET(waveref)) then $
      if (gris EQ 'GRISM') then waveref = getenv('grismscurve') $
         else waveref=getenv('prismscurve')
;     retrieve Achop and Bchop photometry images
;  spFileInfo, preAfile ; print some reference data
   achop    = oirgetdata(preAfile,1)
   achop    = REPLICATE(achop[0],2)
   achop[1] = oirgetdata(calpre+'.Bchop.fits',1)
   achop    = undat(achop) ; convert structures to simple idl arrays
   sz       = SIZE(achop,/dim)
;     get wavelength information
   wave = FLTARR(sz[0], 4)
   for i=0,3 do wave[*,i] = oirgetwavelength(waveref, i+1)
;      compute masks
   print,' computing calibration masks '
;  masks = achop ; just to get array sizes right
   masks = FLTARR(sz[0], 2, 4, 2)
   skymasks = spSkyPix(prefix=calpre)  ; where detector sees sky/tunnel
;       presmooth in x-direction
   if (KEYWORD_SET(smx)) then for j=0,3 do for i=0,1 do for k=0,sz[1]-1 do $
      achop[*,k,j,i] = SMOOTH(achop[*,k,j,i],smx)
;       compute A- and B-masks by gaussian fitting
   for i= 1,3 do $
      masks[*,*,i,0] = midiMakeMask(achop[*,*,i,0],fudge=fudge)
   masks[*,*,0,0] = 0.
   for i= 0,2 do $
      masks[*,*,i,1] = midiMakeMask(achop[*,*,i,1],fudge=fudge)
   masks[*,*,3,1] = 0.
;      get wavelength info
;      compute kappa ratios
   kappa = FLTARR(sz[0],2,2)
;              use masks to specify background fitting region
   print,'subtracting backgrounds '
   xx = findgen(sz[1])
   for i=0,1 do begin
      for j=0,3 do begin 
      achop[*,*,j,i] = spDeBase( achop[*,*,j,i], $
;        skymasks[*,*,j,i] and (masks[*,*,j,i] lt .02))
         skymasks[*,*,j,i] * (1-spgmask(masks[*,*,j,i],fudge=3,type='flat')) )
      endfor
   endfor
;       determine fluxes for a- and b- photometry
   aphot = FLTARR(sz[0],4, 2)
   for j=0,3 do for i=0,1 do aphot[*,j,i] = $
;     TOTAL(achop[*,*,j,i]* (masks[*,*,j,i] gt .05),2)
      TOTAL(achop[*,*,j,i]* spgmask(masks[*,*,j,i],fudge=2.4,type='flat'),2)

;       interpolate photometry channels in wavelength to I1/2 channels
;       and divide to get kappa coefficients
   print,'finding kappa '
   for i=0,1 do begin 
      ap = INTERPOL(aphot[*,3,0], wave[*,3], wave[*,i+1], /spline)
      kappa(*,i,0) = aphot[*,i+1,0]/(ap > (.01*max(ap))) > .1
   endfor
   for i=0,1 do begin
      ap = INTERPOL(aphot[*,0,1], wave[*,0], wave[*,i+1], /spline)
      kappa(*,i,1) = aphot[*,i+1,1]/(ap > (.01*max(ap))) > .1
   endfor
;       compute y-direction point spread functions of I and P channels
   psfs  = complexarr(sz[0], sz[1], 2, 2)
   psfab = complexarr(sz[0], sz[1], 2)
   rflux = fltarr(sz[0],2,2)
   for i=0,1 do for j=0,1 do begin
;     m = achop[*,*,j+1,i]  * (masks[*,*,j+1,i] gt .01) > 0
      m = achop[*,*,j+1,i]  * spgmask(masks[*,*,j+1,i],fudge=3,type='flat') > 0
      m = sidelobes(m)
      fm = complex(m)
      for k=0, sz[0]-1 do begin
         fm[k,*] = FFT(m[k,*],1)
         if (abs(fm[k,0]) GT 0.) then fm[k,*] = fm[k,*]/fm[k,0] $
            else fm[k,*] = 0.
      endfor
      psfs[*, *, j, i] = fm
   endfor
;
   m = sidelobes(achop[*,*,3,0] > 0)
   for k=0, sz[0]-1 do begin
      fm[k,*] = FFT(m[k,*],1)
      fm[k,*] = fm[k,*]/fm[k,0]
   endfor
   psfab[*,*,0] = fm
   m = sidelobes(achop[*,*,0,1]> 0)
   for k=0, sz[0]-1 do begin
      fm[k,*] = FFT(m[k,*],1)
      fm[k,*] = fm[k,*]/fm[k,0]
   endfor
   psfab[*,*,1] = fm
;         compute FFTS of central profiles of PA and PB channels
   pcent = complexarr(sz[1], 2,3)
   if (gris EQ 'PRISM') then dx = 5 else dx = 8
   xx = sz[0]/2 + indgen(2*dx)-dx
   for i=0,2 do begin 
      cc = TOTAL(achop[xx+(i-1)*4*dx,*,3,0],1)
      cc = FFT(cc>0,1)
      pcent[*,0,i] = cc/cc[0]
      cc = TOTAL(achop[xx+(i-1)*4*dx,*,0,1],1)
      cc = FFT(cc>0,1)
      pcent[*,1,i] = cc/cc[0]
   endfor
;         if requested, write to disk
   if (KEYWORD_SET(out)) then $
      spFileOut, out, masks, kappa, psfs, pcent, psfab,$
         refFile=calpre+'.Achop.fits'
RETURN
END

PRO spFileIn, pre , masks, kappa, psfs, pcent, psfab
;           read in stored calibrator versions of reference files
   if (N_PARAMS() LT 1) then begin
      print,'spFileIn pre, masks, kappa, psfs, pcent, psfab '
      RETURN
   endif
   masks = undat(oirGetData(pre+'.mask.fits'))
   kk    = oirGetData(pre+'.kappa.fits')
   dk    = WHERE(STRPOS(TAG_NAMES(kk),'DATA') GE 0)
   sz    = SIZE(kk[0].data2, /dim)
   kappa = REFORM(undat(kk), sz[0], 2, 2)
;  for j=0,1 do for i=0,1 do kappa(*,j,i) = kk.(dk[j+2*i])
   p2    = oirGetData(pre+'.psfs2.fits')
   pab   = oirGetData(pre+'.psfab.fits')
   sz    = SIZE(p2[0].data2, /dim)
   psfs  = COMPLEXARR(sz[0]/2,sz[1], 2, 2)
   psfab = COMPLEXARR(sz[0]/2, sz[1], 2)
   for i=0,1 do begin
      psfs(*,*,0,i) = TRANSPOSE(pseudocomplex(p2[i].data2))
      psfs(*,*,1,i) = TRANSPOSE(pseudocomplex(p2[i].data3))
   endfor
   psfab[*,*,0] = pseudocomplex(pab.data4,/notranspose)
   psfab[*,*,1] = pseudocomplex(pab.data1,/notranspose)
   py    = oirGetData(pre+'.psfy.fits')
   pcent = COMPLEXARR(sz[1],2,3)
   for i=0,2 do begin 
      pcent[*,0,i] = REFORM(pseudocomplex(py[i].data4))
      pcent[*,1,i] = REFORM(pseudocomplex(py[i].data1))
   endfor
RETURN
END

FUNCTION spPhot, image, psf, pcent, weight, imfit
;
   sz = SIZE(image,/dim)
   newPsf = image
   org    = image
;      adjust profile at center of image from calibrator->source
   dx = 5
   xx = sz[0]/2 + indgen(2*dx)-dx
   yy = SHIFT(FINDGEN(sz[1])-sz[1]/2,-sz[1]/2)
   wyy = abs(yy) LE 5
   cc = TOTAL(image[xx,*],1)
   cc = FFT(cc>0,1)
   psent = cc/cc[0]/pcent
   pmax  = where(ABS(psent) GT 1.)
   if (max(pmax) GE 0) then psent(pmax) = psent(pmax)/ABS(psent(pmax))
   pph   = midiphase(psent)
   q = POLYFITW(yy, pph, wyy, 1, yph)
   psent = ABS(psent) * exp(complex(0.,1.)*yph)
   for k=0,sz[0]-1 do newPsf[k,*] = FLOAT(FFT(psf[k,*] * psent,-1))
;
   spectrum = FLTARR(sz[0])
   yfit     = FLTARR(2, sz[1])
   yfit[0,*] = FINDGEN(sz[1]) - .5*sz[1] ; linear background fit
   wfit      = REPLICATE(1., sz[1]) ; weighting function
;  wfit[0:2] = 0.
;  wfit[sz[1]-3:sz[1]-1] = 0.
;      fit psf
   imfit = image
   for k=0,sz[0]-1 do begin
      wfit = REFORM(weight[k,*])
      yfit[1,*] = newPsf[k,*]
      if(total(wfit*(REFORM(image[k,*]) gt 0)) GT 4) then begin	; CAH
         q = REGRESS(yfit, REFORM(image[k,*]), wfit,y,status=status)
if status ne 0 then stop
         if (finite(q[0,1]) and status eq 0) then begin ; CAH
		spectrum[k] = q[0,1] 
                imfit[k,*] = y	; CAH
         endif else begin ; CAH
		spectrum[k]=0.
         	imfit[k,*]  = 0
	 endelse
      endif else begin
         spectrum[k] = 0
         imfit[k,*]  = 0
      endelse
   endfor
RETURN, spectrum
END

FUNCTION spInt, masks, kappa, psfs, pcent,  psfab, $
   prefix=prefix, abPre=abPre, waveref=waveref
;
;    compute I1/I2 images from A/B images for target 
;        based on transformation information stored
;        in kappa, psfs, pcent etc.
;
;    get photometry images for target
;
   if (N_PARAMS() LT 1) then begin
      print,'spint(masks,kappa,psfs,pcent,psfab,prefix=p,abpre=a,wave=w)'
      RETURN,0
   endif
   if (KEYWORD_SET(prefix)) then begin 
      achop = undata(prefix+'.Achop.fits')
      bchop = undata(prefix+'.Bchop.fits')
      gris  = STRTRIM(midigetkeyword('GRIS NAME', prefix+'.Achop.fits'),2)
      skymasks = spSkyPix(prefix=prefix)  ; where detector sees sky/tunnel
   endif else begin
      abfile = abpre+'.ABchop.fits'
      achop = undata(abfile)
      bchop = achop
      gris = STRTRIM(midigetkeyword('GRIS NAME', abfile),2)
      skymasks = spSkyPix(ab=abpre)  ; where detector sees sky/tunnel
   endelse
   if (NOT KEYWORD_SET(waveref)) then if (gris EQ 'grism') then $
      waveref=getenv('grismscurve') else waveref=getenv('prismscurve')

   sImage      = SIZE(achop,/dim)
   imageDim    = N_ELEMENTS(sImage)
   if (imageDim LT 4) then begin
      outData = FLTARR(sImage[0], sImage[1], sImage[2], 2) 
      nImage  = 1
   endif else begin
      outData = FLTARR(sImage[0], sImage[1], sImage[2], 2, sImage[3])
      nImage = sImage[3]
   endelse
   wave    = FLTARR(sImage[0], 4)
   for i=0,3 do wave[*,i] = oirgetwavelength(waveref, i+1)
   psent = pcent

   photFluxAB    = FLTARR(sImage[0], 2 )
   photFlux12    = FLTARR(sImage[0], 2,2)
   m = COMPLEXARR(sImage[0], sImage[1])
   if (gris EQ 'PRISM') then dx = 5 else dx = 8
   xx = sImage[0]/2 + indgen(2*dx)-dx
   yy = SHIFT(FINDGEN(sImage[1])-sImage[1]/2,-sImage[1]/2)
   wyy = abs(yy) LE 3
   x2 = sImage[0]/2 + 4 * dx * [-1,0,1]
   ii = COMPLEX(0.,1.)
   backMasks = spSkyBackMasks(masks, achop[*,*,*,0], bchop[*,*,*,0], skymasks)
   photMasks = spSkyBackMasks(masks, achop[*,*,*,0], bchop[*,*,*,0], $
      skymasks,type='center')
;             construct sky background masks
   for im = 0, nImage-1 do begin
;             photometric fluxes from A/B channels based
;             on input psfs 
      achop[*,*,3,im] = spDeBase(achop[*,*,3,im], backMasks[*,*,3,0])
      bchop[*,*,0,im] = spDeBase(bchop[*,*,0,im], backMasks[*,*,0,1])
      achop[*,*,3,im] = sidelobes(achop[*,*,3,im])
      bchop[*,*,0,im] = sidelobes(achop[*,*,0,im])
      photFluxAB[*,0] = spPhot(achop[*,*,3,im], psfab[*,*,0], pcent[*,0,1],$
         photMasks[*,*,3,0], y)
      photFluxAB[*,1] = spPhot(bchop[*,*,0,im], psfab[*,*,1], pcent[*,1,1],$
         photMasks[*,*,0,1], y)
;     for i=0,1 do photFlux12[*,i,0] = spPhot(achop[*,*,i+1,im], psfab[*
;
;             determine y-profiles at center of photometric
;             channels (where we hope optics are good)
;             This exactly duplicates determination of pcent in spCross
      for i=0,2 do begin 
            cc = TOTAL(achop[xx+(i-1)*dx*4,*,3,im],1)
            cc = FFT(cc>0,1)
            psent[*,0,i] = cc/cc[0]
            cc = TOTAL(bchop[xx+(i-1)*dx*4,*,0,im],1)
            cc = FFT(cc>0,1)
            psent[*,1,i] = cc/cc[0]
      endfor

      for i=0,1 do for j=0,1 do begin
;            i gives which output channel to compute (I1 or I2)
;            j gives which input channel to use (PA or PB)
;            convolve (via fourier transform) psfs at all
;            wavelengths according to what they look like in center channels
         pratio = psent(*,j,*)/pcent(*,j,*)
         pratio = reform(pratio)
         pabs   = abs(pratio[*,1]) < 1.
         pabs=fsmooth1(pabs,2.)
         pph   = midiphase(pratio)
         q = fltarr(2,3)
         for k=0,2 do q[*,k] = POLYFITW(yy, pph[*,k], wyy, 1, yph)
         q2 = poly_fit(x2,q[1,*],1)
         qall = pex(q2, findgen(sImage[0]))
;
         for k=0,sImage[0]-1 do m[k,*] = psfs[k,*,i,j] * pabs * exp(ii * yy *qall[k])
;            scale psfs by measured photometric fluxes and kappa matrices
;            include interpolation for wavelength shifts
         for k=0,sImage[1]-1 do m[*,k] = m[*,k] * kappa[*,i,j] * $
            INTERPOL(photFluxAB[*,j], wave[*,3-3*j], wave[*,i+1], /spline)
;            FFT back to image space
     for k=0,sImage[0]-1 do outData[k,*,i+1, j,im] = FLOAT(FFT(m[k,*],-1))
      endfor
   endfor ; loop over images
RETURN, outData
END

FUNCTION spABphotometry, pre
   infiles=pre+['.ABchop.fits','.ABphotometry.fits','.geo2.fits']
   chop = undata(infiles[0],1)
   phot = undata(infiles[1],1)
   sz   = SIZE(phot,/dim)
   skymasks = spSkyPix(ab = pre)
   abmask   = undata(pre+'.ABmask.fits')
   abmask   = skymasks
   abPhot   = FLTARR(sz[0],2)
   yfit     = FLTARR(2, sz[1])
   yfit[1,*]= FINDGEN(sz[1])-.5*sz[1]
   for j=0,1 do for k=0,sz[0]-1 do begin
      psf = phot[k,*,j+1]
      if TOTAL(psf) eq 0 then abPhot[k,j]=0 else begin ; CAH
      yfit[0,*] = psf/TOTAL(psf)
      mask = REFORM(abmask[k,*,j+1]*skymasks[k,*,j+1,0])
      q=0				; CAH
      if total(mask) ge 10 then $	; CAH
      q = REGRESS(yfit, REFORM(chop[k,*,j+1]), mask)
      if (0 EQ FINITE(q[0])) then abPhot[k,j] = 0 else abPhot[k,j] = q[0]
      endelse
   endfor
RETURN, abPhot
END

PRO sci2Hi, kappaPre, abPre, outPre, waveref=waveref
;
;             create outpre.Aphotometry.fits/.Bphotometry.fits
;             that simulate what would appear in I1/I2 channels
;             given what we measure in PA/PB channels
   if (N_PARAMS() LE 0) then begin
      print,'sci2Hi kappapre, abfile, outpre, waveref=waveref'
      RETURN
   endif
;             get psfs etc that belong to kappa calibrator
   spFileIn, kappaPre, masks, kappa, psfs, pcent, psfab
   abFile  = abPre+'.ABchop.fits'
;             get waveref if not specified
   if (NOT KEYWORD_SET(waveref)) then begin
      gris = STRTRIM(midigetkeyword('GRIS NAME',abFile),2)
      if (gris EQ 'GRISM') then waveref = getenv('grismscurve') $
      else waveref = getenv('prismscurve')
   endif
;              actual photometry and interpolation etc done in spInt
   abData  = spInt( masks, kappa, psfs, pcent, psfab, abpre=abpre, $
      waveref=waveref)
;     prepare two output files containing A and B data
   dataSize = SIZE(abData,/dim)
   dataDim  = N_ELEMENTS(dataSize)
   if (dataDim gt 4) then nImage = dataSize[4] else nImage = 1
   outn=outpre+['.Aphotometry.fits', '.Bphotometry.fits','.geo.fits',$
      '.ABphotometry.fits','.geo2.fits']
   for i=0,1 do begin
      det = OBJ_NEW('imagedetector', abfile)
      detHead = det->priHead()
      temp = det->datatemplate()
      outTags = WHERE(STRPOS(TAG_NAMES(temp),'DATA') GE 0)
      image  = OBJ_NEW('imagedata', det)
      det->close
      det->newFile,outn[i],priHead=detHead, ierr=ierr
      image->appendtofile, det,ierr=ierr
      for im=0, nImage-1 do begin
         for tag = 0,3 do temp.(outTags[tag]) = abData[*,*,tag,i,im]
         image->writerows,temp, ierr=ierr
      endfor
      image->close
      OBJ_DESTROY,image
      OBJ_DESTROY,det
      OBJ_DESTROY,detHead
   endfor
;             output geometric mean of A and B
   det = OBJ_NEW('imagedetector', abfile)
   detHead = det->priHead()
   image  = OBJ_NEW('imagedata', det)
   det->close
   det->newFile,outn[2],priHead=detHead, ierr=ierr
   image->appendtofile, det,ierr=ierr
   for im=0, nImage-1 do begin
      for tag = 0,3 do temp.(outTags[tag]) = $
         SQRT(abData[*,*,tag,0,im] * abData[*,*,tag,1,im]>0)
      image->writerows,temp, ierr=ierr
   endfor
   image->close
   OBJ_DESTROY,image
   OBJ_DESTROY,det
   OBJ_DESTROY,detHead
;                output sum of A+B for photometry purposes
   det = OBJ_NEW('imagedetector', abfile)
   detHead = det->priHead()
   image  = OBJ_NEW('imagedata', det)
   det->close
   det->newFile,outn[3],priHead=detHead, ierr=ierr
   image->appendtofile, det,ierr=ierr
   for im=0, nImage-1 do begin
      for tag = 0,3 do temp.(outTags[tag]) = $
         abData[*,*,tag,0,im] + abData[*,*,tag,1,im]
      image->writerows,temp, ierr=ierr
   endfor
   image->close
   OBJ_DESTROY,image
   OBJ_DESTROY,det
   OBJ_DESTROY,detHead
;             adjust geo to make computed A+B look like measured A+B
   geo  = undata(outn[2],1)
   sum  = undata(outn[3],1)
   chop = undata(abPre+'.ABchop.fits',1)
   skymasks = spSkyPix(ab = abPre)
   backmask =spSkyBackMasks( masks, chop, chop, skymasks, fudge=4, $
      type='center')
   abFix = FLTARR(dataSize[0],2)
   wave = oirgetwavelength(waveref,2)
   for i=0,1 do begin
      wavewt = wave gt 8 and (wave lt 13)
      for k=0, dataSize[0]-1 do begin
      abFix[k,i]=1	; CAH
      if total(REFORM(backmask[k,*,i+1,i])) ge 10 and total(abs(sum[k,*,i+1])) ne 0 then $	; CAH
         abFix[k,i] = REGRESS(sum[k,*,i+1],REFORM(chop[k,*,i+1]),$
            REFORM(backmask[k,*,i+1,i])) else wavewt[k]=0 ; CAH
         if (0 EQ FINITE(abFix[k,i])) then begin
            abFix[k,i]=1
            wavewt[k] = 0
         endif
      endfor
      q = POLYFITW(wave, abFix(*,i), wavewt,2, qy)
      abFix[*,i] = abFix[*,i]/qy
      for k=0, dataSize[0]-1 do geo[k,*,i+1] = geo[k,*,i+1]*abfix[k,i]
   endfor
   temp.data2 = geo[*,*,1]
   temp.data3 = geo[*,*,2]
   oirNewData,outn[2], outn[4], temp
RETURN
END

PRO sPhotometry, pre
;
;    output rows--

   grism = STRTRIM(midigetkeyword('GRIS NAME',pre+'.ABchop.fits'),2)
   if (grism EQ 'GRISM') then waveref = getenv('grismscurve') $
      else waveref = getenv('prismscurve')
   oldDetector = OBJ_NEW('imageDetector',pre+'.ABchop.fits')
   odt = oldDetector->table()
   newDetector = OBJ_NEW('imageDetector',1,maxcoeff=oldDetector->maxcoeff())
   ndt = newDetector->table()
   (*ndt).region = 1
   (*ndt).ports  = 1
   (*ndt).correlation  = 1
   (*ndt).naxis = (*odt)[1].naxis
   (*ndt).naxis[1,0] = 1
   (*ndt).corner = (*odt)[1].corner
   (*ndt).crVal  = (*odt)[1].crVal
   (*ndt).crPix  = (*odt)[1].crPix
   (*ndt).cType  = (*odt)[1].cType
   (*ndt).cD     = (*odt)[1].cD
   (*ndt).dmp     = (*odt)[1].dmp
   (*ndt).dmc     = (*odt)[1].dmc
   oldDetector->close
   OBJ_DESTROY,oldDetector
   temp = newDetector->dataTemplate()

   newDetector->newFile, pre+'.rawphot.fits'
   image = OBJ_NEW('imageData', newDetector)
   image->appendToFile, newDetector
   abPhot = spABPhotometry(pre)
   wave = FLTARR((*ndt).naxis[0,0],2)
   for i=0,1 do wave(*,i) = oirgetwavelength(waveref,i+2)
   abPhot[*,1] = INTERPOL(abPhot[*,1],wave[*,0],wave[*,1],/spline)
   temp.data1 = .5*TOTAL(abPhot,2)
   image->writerows,temp
   image->close
   OBJ_DESTROY, image
   OBJ_DESTROY, newDetector
RETURN
END

FUNCTION spMasks, calMasks, abPrefix, fudge=fudge
;
;    compute photometric/interferometric masks
;    for use with ABchop files
;
;    The algorithm is:
;       extract PA- and PB- images from ABchop data
;       cross correlate these with the PA/PB calibrator
;       masks specified by calMasks, to determine best shifts.
;       Then shift both these and the I1/I2 calMasks
;        by the specified amounts.
;
;     Currently we also multiply the final masks by skymasks
;     (zero on parts of the detector covered by slits)


   if (NOT KEYWORD_SET(fudge)) then fudge = 2.5
   abphot  = oirgetdata(abprefix+'.ABchop.fits',1)
   sz      = SIZE(abphot.data2,/dim)
   dTag    = WHERE(STRPOS(TAG_NAMES(abphot),'DATA') GE 0)
   outMask = REPLICATE(abphot,2)

   yy = -4 + findgen(9) ; trial y-shift amounts
   zz = fltarr(9)       ; store correlation after shift
;
;           cross correlate a.data4 and mask.data4; i.e. PA data

      cmask = calMasks ; local version
      a = abphot.data4
      m = spGMask(cmask[*,*,3,0], fudge=1)
;           shift, multiply, total; then find peak
      for i=0,8 do zz[i] = total(a * shift(m,0,yy[i]))
      ym = pk(yy,zz)
      print,'ashift = ',ym
;            shift mask origin
      cmask[*,0,*,0] = cmask[*,0,*,0] + ym
;     for j=1,2 do for k=0,sz[0]-1 do outMask[0].(dTag[j])[k,*] = $
;        ps1(REFORM(calMasks[k,*,j,0]), ym)
       for j=0,3 do outMask[0].(dTag[j]) = spGMask(cmask[*,*,j,0],fudge=fudge)
;           same for PB data
      a = abphot.data1
      m = spGMask(cmask[*,*,0,1], fudge=1)
      for i=0,8 do zz[i] = total(a * shift(m,0,yy[i]))
      ym = pk(yy,zz)
      print,'bshift = ',ym
      cmask[*,0,*,1] = cmask[*,0,*,1] + ym
;     for j=1,2 do for k=0,sz[0]-1 do outMask[1].(dTag[j])[k,*] = $
;        ps1(REFORM(calMasks[k,*,j,1]), ym)
      for j=0,3 do outMask[1].(dTag[j]) = spGMask(cmask[*,*,j,1],fudge=fudge)
;           guess where pixels do not see sky
      skyMask = spSkyPix( ab=abprefix)
      for i=0,1 do for j=1,2 do outMask[i].(dTag[j]) = outmask[i].(dTag[j]) $
         * skyMask[*,*,j,i]
RETURN, outMask
END

PRO spMakeTrackMask, cal, abPrefix, trackMaskFile, fudge=fudge
;
;     compute masks for dealing with ABchop data
;     shift calibrator masks according to PA/PB data (in spMasks)
;     Then take where appropriate geometric mean of PA and PB masks
;     and output the result into a file
;
    if(NOT KEYWORD_SET(fudge)) then fudge = 2.5
;     read in calibrator masks
   spFileIn, cal , calMasks
;     convert from centroid/sigma description to actual gaussian
;     find best shift and return
   newMask = spMasks(calMasks, abPrefix, fudge = fudge)
   outMask = newMask[0]
   outMask.data1 = newMask[1].data1
   outMask.data2 = SQRT(newMask[0].data2 * newMask[1].data2> 0)
   outMask.data3 = SQRT(newMask[0].data3 * newMask[1].data3> 0)
;      write output to file
   oirNewData, abprefix+'.ABchop.fits', trackMaskFile, outMask
RETURN
END

FUNCTION spGetGeo,prefix, smx
   smp = [smx,1,1]
   geo = SMOOTH(undata(prefix+'.geo.fits',1),smp)
   geo = geo[*,*,1:2]
RETURN,geo
END

FUNCTION spGetABsum,prefix,smx
   smp = [smx,1,1]
   absum = SMOOTH(undata(prefix+'.ABphotometry.fits',1),smp)
   absum = absum[*,*,1:2]
RETURN,absum
END

;FUNCTION spGetGeo2,prefix, mask,smx
;   smp = [smx,1,1]
;   a = SMOOTH(undata(prefix+'.Aphotometry.fits',1),smp)
;   a = a[*,*,1:2]
;   b = SMOOTH(undata(prefix+'.Bphotometry.fits',1),smp)
;   b = b[*,*,1:2]
;   ab = SMOOTH(undata(prefix+'.ABchop.fits',1),smp)
;   ab = ab[*,*,1:2]
;   abPlus  = a+b
;   abMinus = a-b
;   sz = SIZE(a,/dim)
;   geo = ab
;   ymodel = FLTARR(2,sz[1])
;   for j=0,1 do for k=0,sz[0]-1 do begin
;      if (rms(a[k,*,j]) GT 1) and (rms(b[k,*,j]) GT 1) then begin
;;     if (TOTAL(a[k,*,j]) GT 0) and (TOTAL(b[k,*,j]) GT 0) then begin
;         ymodel[0,*]=abPlus[k,*,j]
;         ymodel[1,*]=abMinus[k,*,j]
;         qfit = REGRESS(ymodel, REFORM(ab[k,*,j]), REFORM(mask[k,*,j+1]))
;         geo[k,*,j] = qfit[0]*abPlus[k,*,j]^2 - qfit[1]*abMinus[k,*,j]^2
;      endif else geo[k,*,j] = 0.
;   endfor
;   geo = 0.5 * SQRT(geo>0)
;RETURN, geo
;END

FUNCTION spVis, prefix,smx=smx,geo1=geo1,mask=mask
;
   if (NOT KEYWORD_SET(smx)) then smx = 1
   smp = [smx,1,1]
   gris = STRTRIM(midigetkeyword('GRIS NAME',prefix+'.ABchop.fits'),2)
   if (gris eq 'GRISM') then waveref = getenv('grismscurve') $
      else waveref=getenv('prismscurve')
   wave = oirgetwavelength(waveref,2)
   if (KEYWORD_SET(mask)) then fitmask = undata(prefix+'.ABmask.fits',1) GT .06
   if (KEYWORD_SET(geo1)) then geo = undata(prefix+'.geo.fits',1) $
      else geo   = undata(prefix+'.geo2.fits',1)
   geo  = geo[*,*,1:2]
   rc   = COMPLEX(geo) ; get size
   corr = geo ; get size
   rr   = oirgetdata(prefix+'.RMS1.fits',1) ; get correlated flux map
   rc[*,*,0] = pseudocomplex(rr.data1,/no)  ; convert to complex
   rr = oirgetdata(prefix+'.RMS2.fits',1)   ; same for 2nd window
   rc[*,*,1] = pseudocomplex(rr.data1,/no)
   corr  = ABS(rc)  ; use absolute value of corr. flux
   corr  = SMOOTH(corr,smp) ; smooth
   geo   = SMOOTH(geo,smp)  ; same for geometric mean photometry
   phase = !radeg*midiPhase(TOTAL(TOTAL(rc,2),2)) ; average phase in each channel
   sz = SIZE(corr,/dim)
   vis = FLTARR(sz[0],2)
   geo_t=total(geo,2)
   for j=0, 1 do for i=0, sz[0]-1 do begin
      if (KEYWORD_SET(mask)) then wy = reform(fitmask[i,*,j+1]) $
         else wy = replicate(1.,40)
      if (TOTAL(geo[i,*,j]) GT 0.01*max(geo_t(*,j))) then begin ; CAH
        vis[i,j] = REGRESS(geo[i,*,j], REFORM(corr[i,*,j]),wy,y,status=status)
        if status ne 0 then vis[i,j]=0 ; CAH
	if abs(vis[i,j]) gt 1 then vis[i,j]=0 ; CAH
      endif
   endfor
   vis = .5*TOTAL(vis,2)
   for i=0,sz[0]-1 do if (vis[i] LT 0) then begin
      vis[i] = ABS(vis[i])
      phase[i] = 360-phase(i)
   endif
   midiPutVis,prefix+'.insvis.fits',wave,vis,phase
RETURN, vis
END

PRO spPipe, base, abFiles, cal, curve=curve, smooth=smooth, gsmooth=gsmooth,$
   abmask=abmask,nodelete=nodelete
;        try to compute instrumental visibility for SCI_PHOT ABchopped
;        data
;      check some default parameters
   if (NOT KEYWORD_SET(smooth)) then smooth = 8
   opt1 = STRTRIM(MIDIGETKEYWORD('INS GRIS NAME',abFiles), 2)
   if (NOT KEYWORD_SET(curve)) then begin
      if (opt1 EQ 'GRISM') then curve=getenv('grismscurve') $
         else curve=getenv('prismscurve')
   endif
;          Run chop photometry program on input data;
;          put output in base+'.ABchop.fits'
   abChop = base+'.ABchop.fits'
   print,' using curve reference ',curve
   print,' Extracting photometric images from ',abFiles
   print,' Total input frames is ',fix(TOTAL(midigetkeyword('DET NDIT',$
      midiextractfiles(abFiles))))
   cbin = getenv('vltiCbin')+'/'
   command=cbin+'oirChopPhotoImages -in "'+abFiles+'" -out '+$
;     abChop+' -ref '+curve
;     abChop
      abChop+' -dSky 99'	; CAH
   spawn,command
;
   erase
   chopData = undata(abChop,1)
   for i=0,3 do tvsclm,chopData[*,*,i],3,0,120*i
   print,' constructing new tracking masks based on cal data from ',cal, $
      ' and ',abChop
   trackMask  = base+'.ABmask.fits'
   calMask    = cal+'.mask.fits'
   spMakeTrackMask, cal, base, trackMask
   maskData = undata(trackMask,1)
   for i=0,3 do tvsclm,chopData[*,*,i]*maskData[*,*,i],3,0,120*i
;
   print,' converting sp Photometry images into HS photometry images'
;  sci2Hi, cal, base, base, curve
   sci2Hi, cal, base, base
;
   print,' extracting simple correlated fluxes '
   midiVisPipe, base, abFiles, mask=abMask, smooth=smooth, gsmooth=gsmooth
;
   print,' construct I1 fringe images '
   spawn,cbin+'oirFormFringes "'+abFiles+'" '+base+'.fringes2.fits -noI1 -smooth '+string(smooth, 2)
   print,' construct I2 fringe images '
   spawn,cbin+'oirFormFringes "'+abFiles+'" '+base+'.fringes1.fits -noI2 -smooth '+string(smooth, 2)
   print,' construct I1 coherent images '
   spawn,cbin+'oirRotateGroupDelay '+base+'.fringes1.fits '+base+'.groupdelay.fits '+base+'.fringemap1.fits -phase '+base+'.ungroupdelay.fits'
   print,' construct I2 coherent images '
   spawn,cbin+'oirRotateGroupDelay '+base+'.fringes2.fits '+base+'.groupdelay.fits '+base+'.fringemap2.fits -phase '+base+'.ungroupdelay.fits'
   print,' sum I1 coherent flux '
   spawn,cbin+'oirMeanRMS '+base+'.fringemap1.fits '+base+'.RMS1.fits -float'
   print,' sum I2 coherent flux '
   spawn,cbin+'oirMeanRMS '+base+'.fringemap2.fits '+base+'.RMS2.fits -float'
   if (NOT KEYWORD_SET(nodelete)) then begin
      print,' clean up some big files '
      spawn,'rm '+base+'.fringemap[12].fits '
      spawn,'rm '+base+'.fringes[12].fits '
      spawn,'rm '+base+'.compressed.fits '
      spawn,'rm '+base+'.insopd.fits '
   endif
   wave = oirgetwavelength(curve)
;  diam = spDiam( base, flux, targ)
;  dVis = diskVis( base, flux, target, diam, baseline)
   vis = spVis(base,/mask)
   sPhotometry,base
   targ = midigetkeyword('TARG NAME', abChop)
   PLOT,wave,vis,xr=[8,13],yr=[0,1.5],xTitle='wavelength(mu)',$
      ytitle='Visibility',title='Instrumental Visibility for '+targ
;  OPLOT, wave, vis/dVis, thick=2
RETURN
END

PRO spPlot,base, side, invis=invis, sm=sm, dt=dt
   if (NOT KEYWORD_SET(dt)) then dt = .05
   a=oirgetdata(base+'.Aphotometry.fits',1)
   b=oirgetdata(base+'.Bphotometry.fits',1)
   ab = oirgetdata(base+'.ABchop.fits',1)
   wave = oirgetwavelength(base+'.Aphotometry.fits')
   if (side EQ 1) then begin
      a = a.data2
      b = b.data2
     ab = ab.data2
      c = oirgetdata(base+'.RMS1.fits',1)
   endif else begin
      a = a.data3
      b = b.data3
     ab = ab.data3
      c = oirgetdata(base+'.RMS2.fits',1)
   endelse
   c = pseudocomplex(c.data1,/no)
   ca = abs(c)
   cf = float(c)
   ci = imaginary(c)
   sz = SIZE(a,/dim)
   if (NOT KEYWORD_SET(invis)) then invis = 1.
   if (N_ELEMENTS(invis) eq 1) then inv = REPLICATE(invis, sz[0]) $
      else inv = invis
   if (KEYWORD_SET(sm)) then begin
      for i=0,sz[1]-1 do a[*,i] = smooth(a[*,i], sm)
      for i=0,sz[1]-1 do b[*,i] = smooth(b[*,i], sm)
      for i=0,sz[1]-1 do ca[*,i] = smooth(ca[*,i], sm)
      for i=0,sz[1]-1 do cf[*,i] = smooth(cf[*,i], sm)
      for i=0,sz[1]-1 do ci[*,i] = smooth(ci[*,i], sm)
   endif
   geo = sidelobes(SQRT(a*b>0))
   yr = max(ca)* [-.1,1.5]*mean(invis)
   for i=0, sz[0]-1 do begin
      plot, geo[i,*], yr=yr, thick=2
      oplot,inv[i]*cf[i,*],thick=2, color=255
      oplot,inv[i]*ci[i,*],thick=2, color=255*256l
      xyouts,5,.8*yr[1],string(wave[i],format='(f4.1)'),charsize=2
      wait,dt
   endfor
RETURN
END

FUNCTION uncpsf, p
;
   sz = SIZE(p,/ dim)
   nDim = N_ELEMENTS(sz)
   rpsf = FLOAT(p)
   if (nDim EQ 1) then rpsf = FLOAT(FFT(p,-1)) else $
   if (nDim EQ 2) then for i=0, sz[0]-1 do rpsf[i,*] = FLOAT(FFT(p[i,*],-1)) $
   else if (nDim EQ 3) then $
      for j=0,sz[2]-1 do for i=0, sz[0]-1 do $
         rpsf[i,*,j] = FLOAT(FFT(p[i,*,j],-1)) $
   else if (nDim EQ 4) then $
      for k=0,sz[3]-1 do $
      for j=0,sz[2]-1 do for i=0, sz[0]-1 do $
         rpsf[i,*,j,k] = FLOAT(FFT(p[i,*,j,k],-1))
RETURN, rpsf
END

PRO psfcrossCheck, calpre, kappapre, dt=dt
;
   IF (NOT KEYWORD_SET(dt)) then dt = .05
   ll = ''
   achop = oirgetdata(calpre+'.Achop.fits',1)
   achop    = REPLICATE(achop[0],2)
   achop[1] = oirgetdata(calpre+'.Bchop.fits',1)
   wave = oirgetwavelength(calpre+'.Achop.fits',2)
   sz = SIZE(achop[0].data1,/dim)
   spFileIn, kappapre, masks, kappa, psfs, pcent, psfab
;           check psfs
   realPsf = uncpsf(psfs)
   realab  = uncpsf(psfab)
   print,'    CHECK PSF of A-PHOTO CHANNEL (DATA4) '
   yr = [-.05,1.2]
   for i=0, sz[0]-1 do begin
      PLOT,realab[i,*,0]/MAX(realab[i,*,0]),yr=yr,thick=2
      OPLOT,achop[0].data4[i,*]/MAX(achop[0].data4[i,*])
      xyouts,10,.5,STRING(wave[i],format='(f4.1)')
      xyouts,10,.6,'PA'
      wait,dt
   endfor
   print,'    CHECK PSF of B-PHOTO CHANNEL (DATA4) '
   wait,2.
   for i=0, sz[0]-1 do begin
      PLOT,realab[i,*,1]/MAX(realab[i,*,1]),yr=yr,thick=2
      OPLOT,achop[1].data1[i,*]/MAX(achop[1].data1[i,*])
      xyouts,10,.5,STRING(wave[i],format='(f4.1)')
      xyouts,10,.6,'PB'
      wait,dt
   endfor
   print,'    CHECK PSF of I1 channel for Achop data '
   wait,2.
   for i=0, sz[0]-1 do begin
      PLOT,realpsf[i,*,0,0]/MAX(realpsf[i,*,0,0]),yr=yr,thick=2
      OPLOT,achop[0].data2[i,*]/MAX(achop[0].data2[i,*])
      xyouts,10,.5,STRING(wave[i],format='(f4.1)')
      xyouts,10,.6,'I1 Achop'
      wait,dt
   endfor
   print,'    CHECK PSF of I2 channel for Achop data '
   wait,2.
   for i=0, sz[0]-1 do begin
      PLOT,realpsf[i,*,1,0]/MAX(realpsf[i,*,1,0]),yr=yr,thick=2
      OPLOT,achop[0].data3[i,*]/MAX(achop[0].data3[i,*])
      xyouts,10,.5,STRING(wave[i],format='(f4.1)')
      xyouts,10,.6,'I2 Achop'
      wait,dt
   endfor
   print,'    CHECK PSF of I1 channel for Bchop data '
   wait,2.
   for i=0, sz[0]-1 do begin
      PLOT,realpsf[i,*,0,1]/MAX(realpsf[i,*,0,1]),yr=yr,thick=2
      OPLOT,achop[1].data2[i,*]/MAX(achop[1].data2[i,*])
      xyouts,10,.5,STRING(wave[i],format='(f4.1)')
      xyouts,10,.6,'I1 Bchop'
      wait,dt
   endfor
   print,'    CHECK PSF of I2 channel for Bchop data '
   wait,2.
   for i=0, sz[0]-1 do begin
      PLOT,realpsf[i,*,1,1]/MAX(realpsf[i,*,1,1]),yr=yr,thick=2
      OPLOT,achop[1].data3[i,*]/MAX(achop[1].data3[i,*])
      xyouts,10,.5,STRING(wave[i],format='(f4.1)')
      xyouts,10,.6,'I2 Bchop'
      wait,dt
   endfor
RETURN
END


FUNCTION kappacheck,kappapre, waveref, prefix=prefix,abpre=abpre,org=org, $
   photImage=photImage,summ=summ
;
   if (N_PARAMS() LT 2) then begin
      print,'kappacheck(kappapre,waveref,prefix=prefix,ab=ab,org=org,summ=summ)'
      RETURN,0
   endif
;
   spFileIn, kappapre, imask, kappa, psfs, pcent, psfab
;
   if (KEYWORD_SET(abpre)) then begin
      abfile     = abpre+'.ABchop.fits'
      abdata     = REPLICATE(oirgetdata(abfile,1),2)
      abmaskfile = abpre+'.ABmask.fits'
      abmask     = REPLICATE(oirgetdata(abmaskfile,1),2)
      imask      = undat(abmask)
   endif else if (KEYWORD_SET(prefix)) then begin
      afile     = prefix+'.Achop.fits'
      abdata    = REPLICATE(oirgetdata(afile,1),2)
      abdata[1] = oirgetdata(prefix+'.Bchop.fits',1)
   endif else begin
      print,' enter either prefix or ab '
      RETURN,0
   endelse

   abimage = undat(abdata) 
   sz      = SIZE(abdata,/dim)
   yy      = findgen(sz[1])
;  image   = FLTARR(sz[0],sz[1],4,2)
   for i=0,1 do abimage[*,*,*,i] = spDeBase(abimage[*,*,*,i], $
      imask[*,*,*,i] lt .02)
;
   imagedata=spInt(imask, kappa, psfs, pcent,  psfab, $
      prefix=prefix, abpre=abpre, waveref=waveref, photImage=photImage)
   image = imagedata[*,*,*,i,0]
   org     = abimage
   abimage = abimage[*,*,1:2,*]
   image   = image[*,*,1:2,*]
   if (KEYWORD_SET(ab)) then begin
      abimage = abimage[*,*,*,0]
      image   = total(image,4)
   endif
   dimage = image - abimage
   qual   = MEAN(abimage*image)/SQRT(MEAN(image^2))/SQRT(MEAN(abimage^2))
   print,'quality ',1-qual
   if (KEYWORD_SET(summ) AND KEYWORD_SET(ab)) then begin
      dimage = image
      for i=0,1 do dimage[*,*,i]  = sidelobes(dimage[*,*,i])
      for i=0,1 do abimage[*,*,i] = sidelobes(abimage[*,*,i])
      dimage = TOTAL(TOTAL(dimage,2),2)
      abimage = TOTAL(TOTAL(abimage,2),2)
      dimage  = dimage/(abimage>1.e2)
   endif
   if (KEYWORD_SET(summ) AND KEYWORD_SET(prefix)) then begin
      dimage=image
      for i=0,1 do for j=0,1 do dimage[*,*,i,j] = sidelobes(dimage[*,*,i,j])
      for i=0,1 do for j=0,1 do abimage[*,*,i,j] = sidelobes(abimage[*,*,i,j])
      dimage = TOTAL(TOTAL(TOTAL(dimage,4),3),2)
      abimage = TOTAL(TOTAL(TOTAL(abimage,4),3),2)
      dimage  = dimage/(abimage>1.e2)
   endif
RETURN, dimage
END

PRO assemble,prefix,a,b,ab,c,p,corr,geo,mask,abase=abase
if (N_PARAMS() EQ 0) then begin
   print,' assemble,pre,a,b,ab,c,p,corr,geo,mask '
   RETURN
   endif
   a = undat(oirgetdata(prefix+'.Aphotometry.fits',1))
   b = undat(oirgetdata(prefix+'.Bphotometry.fits',1))
   ab = undat(oirgetdata(prefix+'.ABchop.fits',1))
   mask=undat(oirgetdata(prefix+'.mask.fits',1))
   sz = SIZE(a,/dim)
   if (not KEYWORD_SET(abase)) then begin
      yy = findgen(40)-20.
      for j=0,3 do begin
         for i=0,sz[0]-1 do begin
            wy =  mask[i,*,j] lt .02
            if (TOTAL(wy) GT 5) then begin
               q = POLYFITW(yy, ab[i,*,j],wy,1,y)
               ab[i,*,j] = ab[i,*,j] - y
            endif
         endfor
      endfor
   endif
   c  = oirgetvis(prefix+'.corr.fits')
   c = c.visamp
   p = oirgetdata(prefix+'.photometry.fits',6)
   p = p.data1
   corr = complex(a[*,*,0:1])
   rr = oirgetdata(prefix+'.RMS1.fits',1)
   corr[*,*,0] = pseudocomplex(rr.data1,/no)
   rr = oirgetdata(prefix+'.RMS2.fits',1)
   corr[*,*,1] = pseudocomplex(rr.data1,/no)
   geo = float(corr)
   geo(*,*,0) = sqrt(a[*,*,1]*b[*,*,1]>0)
   geo(*,*,1) = sqrt(a[*,*,2]*b[*,*,2]>0)
RETURN
END


PRO spPhotPipe,base,files
   gris=STRTRIM(midigetkeyword('INS GRIS',files[0]),2)
   shut=STRTRIM(midigetkeyword('INS SHUT',files),2)
   if (gris EQ 'GRISM') then ref=getenv('grismscurve')
   if (gris EQ 'PRISM') then ref=getenv('prismscurve')
   for i=0,N_ELEMENTS(files)-1 do begin 
      if (shut[i] eq 'AOPEN') then suff='.Achop.fits' 
      if (shut[i] eq 'BOPEN') then suff='.Bchop.fits' 
      if (shut[i] eq 'ABOPEN') then suff='.ABchop.fits' 
      print,'   ',midiTotalFrames(files[i]),' total frames in fileset ',i+1
      spawn,getenv('vltiCbin')+'/oirChopPhotoImages -in "'+files[i]+'" -out '+base+$
;        suff+' -ref '+ref
;        suff+' -dSky 50'
         suff+' -dSky 99'	; CAH
   endfor
RETURN
END

PRO spCrossCal,base,files,smx=smx,fudge=fudge
;
;        front end for spCross
;        take AOPEN and BOPEN files and run oirChopPhotoImages
;        to make base.Achop.fits/Bchop.fits.  Then
;        call spCross to compute psfs, masks etc.
;        Store results on disk.
;
   if (NOT KEYWORD_SET(smx))   then smx = 5
   if (NOT KEYWORD_SET(fudge)) then fudge = 3
;
   shut = STRTRIM(midigetkeyword('INS SHUT',files),2)
   gris = STRTRIM(midigetkeyword('GRIS NAME',files[0]),2)
   if TOTAL(shut EQ 'AOPEN') NE 1 then begin
      print,'I need 1 and only 1 AOPEN file'
      RETURN
   endif
   if TOTAL(shut EQ 'BOPEN') NE 1 then begin
      print,'I need 1 and only 1 AOPEN file'
      RETURN
   endif
;  if (gris EQ 'GRISM') then waveref='$test/grism/grismcurveref.fits'
;  if (gris EQ 'PRISM') then waveref='$test/prism/prismcurveref.fits'
   if (gris EQ 'GRISM') then waveref=getenv('grismscurve')
   if (gris EQ 'PRISM') then waveref=getenv('prismscurve')
   print,'   Processing raw photometric files '
   spPhotPipe,base,files
   spCross, base, masks, kappa, psfs, pcent, psfab, $
      waveref=waveref, fudge=fudge, out=base, smx=smx
RETURN
END


FUNCTION spgen,pre,n
   RETURN,pre+STRTRIM(indgen(n),2)
END

PRO summtest, k, pre
   w = '$test/prism/prismcurveref.fits'
   d = kappacheck(k, w, pre=pre,/summ)
   wave = oirgetwavelength('$test/prism/prismcurveref.fits')
   ww = where(wave gt 8. and (wave lt 12.5))
   plot,wave,alog(smooth(d,5)>.01),xr=[8,13],yr=0.2*[-1,1]
   d1 = mean(alog(d[ww]))
   spFileInfo, pre+'.Achop.fits'
   d = kappacheck(k, w, ab=pre,/summ)
   d2 = mean(alog(d[ww]))
   oplot,wave,alog(smooth(d,5)>.01),thick=2
   spFileInfo, pre+'.ABchop.fits'
   print,d1,' ',d2
RETURN
END

FUNCTION spRescale, highFreq, lowFreq, wavemask, order=order
;  highFreq = spectrum with lots of detail but uncertain normalization
;  i.e. may contain scale and slope errors
;
;  lowFreq  = spectrum of same  source with poor detail but "reliable"
;  scaling and slope
;
;  output = highFreq rescaled so its 0th, 1st.. moments look like lowFreq
;
   if (NOT KEYWORD_SET(order)) then order = 1

   nx = N_ELEMENTS(highFreq)
   fit = FLTARR(order+1, nx)
   xx = (FINDGEN(nx)-.5*nx)/nx
   for i=0,order do fit[i,*] = highFreq * xx^i
   qfit = REGRESS(fit, lowFreq, wavemask, newSpec)
RETURN, newSpec
END

PRO spCalVis, targ, cal, diam=diam, flux10=flux10, calspec=calspec
   if (NOT KEYWORD_SET(flux10)) then flux10 = 1.
   targVis = oirgetvis(targ+'.insvis.fits')
   calfile = cal+'.insvis.fits'
   calVis  = oirgetvis(calfile,wave=wave)
   if (KEYWORD_SET(diam)) then begin
      base = 0.5*(midigetkeyword('PBL12 END',calfile)+ $
         midigetkeyword('PBL12 START', calfile))
      beselarg = !pi*base*diam/(!radeg*3.6e6)
      wavem = float(1.e-6*wave)
      beselarg = float(beselarg[0])
      beselarg = beselarg/wavem
      caldisk = midiairy(beselarg)
   endif else caldisk = 1.
   targAmp = targVis.visamp /(calVis.visamp>.01)/(calDisk>.01)
   targPhi = targVis.visphi - calVis.visphi
   w = where(targPhi GT 360)
   if (max(w) GT (-1)) then targPhi(w) = targPhi(w) - 360.
   w = where(targPhi LT (-360))
   if (max(w) GT (-1)) then targPhi(w) = targPhi(w) + 360.
   midiPutVis,targ+'.calvis.fits',wave,targAmp,TargPhi
   if (KEYWORD_SET(calspec)) then begin
      jy = oirgetdata(calspec)
      jy = jy.data1
   endif else jy = flux10 * (10./wave)^2
   targPhotFile = targ+'.rawphot.fits'
   targFlux = oirgetdata(targPhotFile)
   calflux  = oirgetdata(cal+'.rawphot.fits')
   targFlux.data1 = targFlux.data1 * jy/(calflux.data1 > 1)
   oirNewData, targPhotFile, targ+'.calphot.fits',targFlux
END

PRO spVisPrintRaw, pre, outFile=outFile
;
   abfile = pre+'.ABchop.fits'

   targ = STRTRIM(midigetkeyword('TARG NAME',abfile),2)
   date = STRTRIM(midigetkeyword('DATE-OBS',abfile),2)
   gris = STRTRIM(midigetkeyword('GRIS NAME',abfile),2)
   airm = STRTRIM(.5*(midigetkeyword('AIRM START',abfile)+$
      midigetkeyword('AIRM END',abfile)),2)
   see = STRTRIM(.5*(midigetkeyword('FWHM START',abfile)+$
      midigetkeyword('FWHM END',abfile)),2)
   station1 = STRTRIM(midigetkeyword('CONF STATION1',abfile),2)
   station2 = STRTRIM(midigetkeyword('CONF STATION2',abfile),2)
   vis = oirgetvis(pre+'.insvis.fits',wave=wave)
   phot= oirgetdata(pre+'.rawphot.fits')
   if (KEYWORD_SET(outFile)) then begin
      unit=1
      openw,unit,outFile
   endif else unit=-1
   nWave = N_ELEMENTS(wave)
   printf,unit, 'TARGET:'+targ
   printf,unit, 'OBS-DATE:'+date
   printf,unit,'DISPERSER:'+gris
   printf,unit,'AIRMASS:'+airm
   printf,unit,'SEEING:'+see
   printf,unit,'STATION IDs: ',station1,' ',station2,' Station IDs '
   printf,unit,' wavelength(mu)   vis amp    vis phase(deg)   flux(adu/s)   '
   for i=0,nWave-1 do printf,unit, wave[i], vis.visamp[i]>0, vis.visphi[i], phot.data1[i]
   if (unit NE -1) then close,unit
RETURN
END

PRO spVisPrintCal, pre, outFile=outFile
;
   abfile = pre+'.ABchop.fits'

   targ = STRTRIM(midigetkeyword('TARG NAME',abfile),2)
   date = STRTRIM(midigetkeyword('DATE-OBS',abfile),2)
   gris = STRTRIM(midigetkeyword('GRIS NAME',abfile),2)
   airm = STRTRIM(.5*(midigetkeyword('AIRM START',abfile)+$
      midigetkeyword('AIRM END',abfile)),2)
   see = STRTRIM(.5*(midigetkeyword('FWHM START',abfile)+$
      midigetkeyword('FWHM END',abfile)),2)
   station1 = STRTRIM(midigetkeyword('CONF STATION1',abfile),2)
   station2 = STRTRIM(midigetkeyword('CONF STATION2',abfile),2)
   vis = oirgetvis(pre+'.calvis.fits',wave=wave)
   phot= oirgetdata(pre+'.calphot.fits')
   if (KEYWORD_SET(outFile)) then begin
      unit=1
      openw,unit,outFile
   endif else unit=-1
   nWave = N_ELEMENTS(wave)
   printf,unit, 'TARGET:'+targ
   printf,unit, 'OBS-DATE:'+date
   printf,unit,'DISPERSER:'+gris
   printf,unit,'AIRMASS:'+airm
   printf,unit,'SEEING:'+see
   printf,unit,'STATION IDs: ',station1,' ',station2,' Station IDs '
   printf,unit,' wavelength(mu)   vis amp    vis phase(deg)   flux(Jy)   '
   for i=0,nWave-1 do printf,unit, wave[i], vis.visamp[i]>0, vis.visphi[i], phot.data1[i]
   if (unit NE -1) then close,unit
RETURN
END
