;
; Copyright 2005, 2006 University of Leiden.
;
; This file is part of MIA+EWS.
;
; MIA+EWS is free software; you can redistribute it and/or modify
; it under the terms of the GNU General Public License as published by
; the Free Software Foundation; either version 2 of the License, or
; (at your option) any later version.
;
; MIA+EWS is distributed in the hope that it will be useful,
; but WITHOUT ANY WARRANTY; without even the implied warranty of
; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
; GNU General Public License for more details.
;
; You should have received a copy of the GNU General Public License
; along with MIA; if not, write to the Free Software
; Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
;
; $Id: chop_nod_disp.pro,v 1.11 2006/04/20 10:23:30 koehler Exp $
;
; chop_phot_disp.pro
; Created:     Wed Apr 16 15:18:21 2003 by Koehler@sun47
; Last change: Thu Apr 20 12:19:44 2006
;
;
; Main routine is "chop_nod_disp"
;
; INPUTS:
;	fname	  MIDI data (dispersed)
;	skyname	  MIDI sky data (dispersed) - UNTESTED!!
;	WIDTH=w	  Width of 1D-gaussian relative to width of fit
;	TRACE_ORDER=o	Order of polynomial used to fit position
;	FWHM_ORDER=o	Order of polynomial used to fit FWHM
;	BEFORE=b	Number of frames to skip before chop
;	AFTER=a		Number of frames to skip after chop
;	/SILENT   tells routine to be non interactive
;	/REVERSE  flags for object and sky are reversed (Feb.2003 run)
;	/DEBUG	  remove insects by printing them to death
;
; OUTPUTS:
;	an ascii file
;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; it would be nice to adapt the 320 to the window size,
; but al least it can't get larger than 320, or can it??
;'
PRO midisptrace__Define
foo = { midisptrace, $
         xsize: -1, ysize: -1, $
         trace: fltarr(320), FWHM: fltarr(320), fluxmax: fltarr(320),$
         range: fltarr(320), nRange: 0, $
         trace_coeff: fltarr(3), sigma_coeff: fltarr(2) $
}
end

pro chop_nod_disp_one_window_obsolete, win, width, t_order, w_order, $
                              mtrace, Flux,Flux_c, weighting_win, $
                              XMIN=xmin,XMAX=xmax, BGNOISE=bgnoise,$
                              DEBUG=debug, SILENT=silent

common MidiOptions,midi_options,maskfile_mymidi,kappafile,la_bins ; CAH

  sz = size(win)
  x_size= sz[1]
  y_size= sz[2]
  print,"window is ",x_size," x ",y_size
  win=win-median(total(win,1)/x_size)   ; added by CAH: baseline correction
  if not keyword_set(bgnoise) then begin
  testbg=mean(win(*,sz[2]*0.8:sz[2]-1))
  if (testbg ge 0.0) then bgnoise=testbg else bgnoise=0.
  endif

  mtrace = {midisptrace}
  mtrace.xsize= x_size
  mtrace.ysize= y_size
  sigma  = fltarr(x_size)
  Flux   = fltarr(x_size)
  Flux_c = fltarr(x_size)
  backgr = fltarr(x_size)

  win_c = win
  weighting_win = fltarr(x_size,y_size)
  column = dindgen(y_size)

  if not keyword_set(xmin) then xmin= 0
  if not keyword_set(xmax) then xmax= x_size-1
  ;
  ; first find pos and width for each column with sufficient signal
  ;
  if max(win) lt 5*stddev(win(*,sz[2]*0.8:sz[2]-1)) then begin
  print,'WARNING: NOT ENOUGH FLUX WITHIN THE WINDOW!!!!!!!!!!!!!'
  return
  endif
  if midi_options.m then begin  ; CAH
	fitmask,win,mtrace
	sigma=mtrace.FWHM(0:x_size-1)/sqrt(2.*alog(2))
  endif else begin
  FOR i= xmin, xmax DO BEGIN
      IF (total(win(i,*)) gt bgnoise * y_size) THEN BEGIN
          ; do a little median smoothing on the column to remove badpix
          fit1D= gaussfit(column, median(reform(win[i,*]),3), b, NTERMS=3)

          if (b[1] gt 0 and b[1] lt y_size) then begin
              mtrace.trace[i]  = b[1]
              mtrace.FWHM[i]   = b[2] * sqrt(2.*alog(2))
              mtrace.fluxmax[i]= b[0]
              sigma[i] = b[2]
          endif

          if keyword_set(debug) then $
            print, "  x=",i, ", y=",mtrace.trace[i],", fwhm=",mtrace.FWHM[i]
      endif
  endfor
  endelse	; CAH

  ; forget points that are too weird
  ; use only points with flux to compute the median
  range = where(mtrace.fluxmax gt 0)
  if mean(range) eq -1 then begin
  print,'NOT ABLE TO GET A GOOD TRACE!!!!!!!!!!!!!'
  return
  endif
  bad_trace= where( abs(mtrace.trace-median(mtrace.trace[range])) ge 4.2, bad_count)
  if  bad_count gt 0  then begin
      mtrace.fluxmax[bad_trace] = 0.
      range = where( mtrace.fluxmax gt 0)
  endif
  if keyword_set(debug) then begin
      window,3
      !P.multi= 0
      plot, mtrace.trace, yrange = [0,y_size]
      oplot, range, mtrace.trace[range],psym=1
      oplot, mtrace.trace + mtrace.FWHM, linestyle=2
      oplot, mtrace.trace - mtrace.FWHM, linestyle=2
      junk="" & read,"Hit return",junk
  end
  ;
  ; now fit a polynomial to it
  ;
  mtrace.trace_coeff= poly_fit(range, mtrace.trace[range], t_order,$
                               MEASURE_ERRORS = 1./mtrace.fluxmax[range])
  mtrace.sigma_coeff= poly_fit(range, sigma[range], w_order,$
                               MEASURE_ERRORS = 1./mtrace.fluxmax[range])
  trace_fit  = poly(findgen(x_size),mtrace.trace_coeff)
  sigma_fit  = poly(findgen(x_size),mtrace.sigma_coeff)
  FWHM_fit   = sigma_fit * sqrt(2.*alog(2))

  print,"trace coeff: ",mtrace.trace_coeff
  print,"sigma coeff: ",mtrace.sigma_coeff

  ; measure bg, flux, and create mask for ALL columns, not just xmin..xmax
  j = findgen(y_size)
  medianback=5	;odd number please
  midmedian=(medianback-1)/2.
  FOR i= midmedian, x_size-1-midmedian DO BEGIN
	;background correction (polynomial fit per column)
;OLIVIER: increased coef to 4 for background
          spec_0 = fix( trace_fit[i] - 4.*FWHM_fit[i] + 0.5)
          spec_1 = fix( trace_fit[i] + 4.*FWHM_fit[i] + 0.5)
          if keyword_set(debug) then $
            print, "  x=",i, ", y=",trace_fit[i],", spectrum at",spec_0,"...",spec_1
          if (spec_0 le 0)      then spec_0 = 1
          if (spec_0 ge y_size) then spec_0 = y_size-1
          if (spec_1 ge y_size) then spec_1 = y_size-2
          if (spec_1 lt spec_0) then spec_1 = spec_0

          back = dindgen(spec_0)
          back_1 = dindgen(y_size-spec_1+1)+spec_1
	  back = [back,back_1]
          tmpmed=median(win[i-midmedian:i+midmedian,*],medianback)
         ; tmpmed=smooth(tmpmed,medianback)
          background = [ reform(tmpmed[midmedian,0:spec_0]),reform(tmpmed[midmedian,spec_1:y_size-1])]
          background_coef= POLY_FIT(back, background, 1)
          win_c[i,*]= win[i,*] - POLY(column, background_coef)

          FLUX[i]  = total(win_c[i,spec_0:spec_1])
          backgr[i]= total(win[i,spec_0:spec_1]) - Flux[i]

          weighting_win[i,*]= exp(-(j-trace_fit[i])^2./(2.*(sigma_fit[i]*width)^2.))
          FLUX_c[i]= total(win_c[i,*] * weighting_win[i,*])
  ENDFOR

  range = where(mtrace.fluxmax gt 0)	;plot only points where we did the 1D-gaussfit
  mtrace.range = range
  mtrace.Nrange= N_elements(range)

  if not keyword_set(silent) then begin
      !p.multi=[0, 0,2 , 0, 0]
      !p.charsize = 1.
      window, 1, xsize=600, ysize=600
      plot, trace_fit, $
        yrange=[floor(min(trace_fit-FWHM_fit)), ceil(max(trace_fit+FWHM_fit))],$
        xtitle='Wavelength (in pixels)', ytitle='Y Photocenter in pix'
      oplot,range, mtrace.trace[range], psym=1
      oplot,trace_fit+FWHM_fit, linestyle=1
      oplot,trace_fit-FWHM_fit, linestyle=1

      plot, Flux, linestyle=1, xrange=[0,x_size], $
        xtitle='Wavelength (in pixels)', ytitle='Flux in ADUs'
      oplot,Flux_c
      oplot,backgr,linestyle=2
  endif
end

;-----------------------------------------------------------------------
;---------------	MAIN PROG	--------------------------------
;-----------------------------------------------------------------------

pro chop_nod_disp_obsolete, fname, skyname, WIDTH=width, TRACE_ORDER=t_order, $
                   FWHM_ORDER=w_order, SILENT=silent, REVERSE=reverse,$
                   BEFORE=before, AFTER=after, DEBUG=debug

  ; make once and for all sure that fname is a scalar
  fname = fname[0]
  hdrname= (oirFileList(fname))[0]

  if not file_test("PHOTOMETRY") then spawn,'mkdir "PHOTOMETRY"'

; PROBLEM TO SOLVE: WHERE IS THE GAIN IN THE MIDI HEADER?
; DISCUSSION WITH WALTER
  gain = 145	;ADUs to photons conversion factor

  if not keyword_set(width)   then width = 1.0
  if not keyword_set(t_order) then t_order = 2
  if not keyword_set(w_order) then w_order = 1
  if not keyword_set(before)  then before  = 1
  if not keyword_set(after)   then after   = 1


  if N_Params() gt 1  then begin
      print, 'Reading nodding data...'

      skyname = skyname[0]

      ;im_on= oirgetmeanrms(fname)
      spawn, 'rm PHOTOMETRY/nod_ftemp.fits PHOTOMETRY/nod_skytemp.fits'
      spawn, getenv("drsRoot") + '/c/bin/oirMeanRMS "' + fname + '" PHOTOMETRY/nod_ftemp.fits'
      im_on= oirgetdata('PHOTOMETRY/nod_ftemp.fits')

      ;im_sky = oirgetmeanrms(skyname)
      spawn, getenv("drsRoot") + '/c/bin/oirMeanRMS "' + skyname + '" PHOTOMETRY/nod_skytemp.fits'
      im_sky= oirgetdata('PHOTOMETRY/nod_skytemp.fits')

      win1 = im_on[0].data1-im_sky[0].data1
      win2 = im_on[0].data2-im_sky[0].data2

; CAH: added this because it is needed later
      im = obj_new('imagedata', hdrname)
      he = im->prihead()
      beam = he->getpar('INS OPT1')
      telescope = he->getpar('INS SHUT')
      disp = he->getpar('INS GRIS')
      obj_destroy,im


  endif else begin
  ;-------------- Walter routine to extract chopped images -------------

      print, Format='("Reading chopped data, before = ",I0,", after = ",I0)',before,after
      chop_image= MIDIChopImageC(fname, before=before, after=after)

      im = obj_new('imagedata', hdrname)
      he = im->prihead()
      beam = he->getpar('INS OPT1')
      telescope = he->getpar('INS SHUT')
      disp = he->getpar('INS GRIS')
      obj_destroy,im

      if (beam EQ 'HIGH_SENS') or (beam EQ 'OPEN    ') then begin
          print,"high_sens, using data1 & 2"
          on_source_win1 = chop_image[0].data1
          on_source_win2 = chop_image[0].data2
          off_source_win1= chop_image[1].data1
          off_source_win2= chop_image[1].data2
      endif else if (beam EQ 'SCI_PHOT') then begin
          print,"sci_phot, using data2 & 3"
          on_source_win1 = chop_image[0].data2
          on_source_win2 = chop_image[0].data3
          off_source_win1= chop_image[1].data2
          off_source_win2= chop_image[1].data3
          if (telescope EQ 'AOPEN   ') then begin
          print,'telescope A'
          	on_source_winphot = chop_image[0].data4
          	off_source_winphot = chop_image[1].data4
          endif
          if (telescope EQ 'BOPEN   ') then begin
          print,'telescope  B'
          	on_source_winphot = chop_image[0].data1
          	off_source_winphot = chop_image[1].data1
          endif

      endif else begin
          print,"INS OPT1 is",beam
          print,"Neither HIGH_SENS, OPEN, nor SCI_PHOT, don't know where my data are!"
          return
      endelse
      if keyword_set(reverse) then begin
          win1 = off_source_win1-on_source_win1
          win2 = off_source_win2-on_source_win2
 if (beam EQ 'SCI_PHOT') then winphot = off_source_winphot-on_source_winphot
      endif else begin
          win1 = on_source_win1-off_source_win1
          win2 = on_source_win2-off_source_win2
  if (beam EQ 'SCI_PHOT') then winphot = on_source_winphot-off_source_winphot
      endelse
  endelse
n=size(win1)
x_size=n[1]
y_size=n[2]
NDIT  =n[3]

win1_display = win1
win2_display = win2
if (beam EQ 'SCI_PHOT') then winphot_display = winphot
testwin1=where(win1 lt 0.1)
testwin2=where(win2 lt 0.1)
if mean(testwin1) ne -1 then win1_display(testwin1)=0.1
if mean(testwin2) ne -1 then win2_display(testwin2)=0.1
if (beam EQ 'SCI_PHOT') then begin
testwinphot=where(winphot lt 0.1)
if mean(testwinphot) ne -1 then winphot_display(testwinphot)=0.1
endif

;DISPLAY FOR CHECKING IMAGE QUALITY
if (beam EQ 'HIGH_SENS') then begin
	factor = 3.
	factorx = 2
	if (disp EQ 'PRISM   ') then factorx = 3
	window,0, xsize=n[1]*factorx*2+10, ysize=n[2]*factor*2+10
	tvscl, rebin(sqrt(win1_display),n[1]*factorx, n[2]*factor, /SAMPLE),0
	tvscl, rebin(sqrt(win2_display),n[1]*factorx, n[2]*factor, /SAMPLE),1
endif
if (beam EQ 'SCI_PHOT') then begin
	factor = 2.
	factorx = 1
	if (disp EQ 'PRISM   ') then factorx = 2
	window,0, xsize=n[1]*factorx*3, ysize=n[2]*factor*2
	tvscl, rebin(sqrt(win1_display),n[1]*factorx, n[2]*factor, /SAMPLE),0
	tvscl, rebin(sqrt(win2_display),n[1]*factorx, n[2]*factor, /SAMPLE),1
	tvscl, rebin(sqrt(winphot_display),n[1]*factorx, n[2]*factor, /SAMPLE),2

endif
if (beam EQ 'OPEN    ') then begin
	factor = 3.
	factorx = 2
	if (disp EQ 'PRISM   ') then factorx = 3
	print,'WARNING: PHOTOMETRY WITHOUT BEAM COMBINER!!!'
	window,0, xsize=n[1]*factorx*2+10, ysize=n[2]*factor*2+10
	tvscl, rebin(sqrt(win1_display),n[1]*factorx, n[2]*factor, /SAMPLE),0
	tvscl, rebin(sqrt(win2_display),n[1]*factorx, n[2]*factor, /SAMPLE),1
endif

;FOR i=0, x_size-1 DO BEGIN
;    win1_display[i,*] = median(reform(win1_display[i,*]),3)
;    win2_display[i,*] = median(reform(win2_display[i,*]),3)
;end
;tvscl, rebin(sqrt(win1_display),n[1]*factor, n[2]*factor, /SAMPLE),2
;tvscl, rebin(sqrt(win2_display),n[1]*factor, n[2]*factor, /SAMPLE),3
;    testOK = "string"
;    read, '> Hit someone', testOK

;---------------- PHOTOMETRY ROUTINE --------------


print,'-------------  FIRST FIND THE STAR in I1 ------------'
;print,"height of win1:",N_elements(win1[0,*])

if (beam NE 'OPEN    ') then begin
chop_nod_disp_one_window_obsolete, win1, width, t_order,w_order, $
  traceI1, Flux_I1, Flux_I1c, weighting_win1, DEBUG=debug, SILENT=silent
endif

if (beam EQ 'OPEN    ') then begin
if (telescope EQ 'AOPEN   ') then begin
chop_nod_disp_one_window_obsolete, win1, width, t_order,w_order, $
  traceI1, Flux_I1, Flux_I1c, weighting_win1, DEBUG=debug, SILENT=silent
endif else begin
  sz = size(win1)
  x_size= sz[1]
  Flux_I1=dblarr(x_size)
  Flux_I1c=dblarr(x_size)
  weighting_win1=dblarr(x_size)
  traceI1 = {midisptrace}
endelse
endif


wset,0
tvpos=2
if (beam EQ 'SCI_PHOT') then tvpos=3
tvscl, rebin(sqrt(win1_display*weighting_win1),n[1]*factorx, n[2]*factor, /SAMPLE),tvpos

if not keyword_set(silent) then begin
    testOK = "string"
    read, '> Is the dataset satisfactory for beam I1? (y/n) ? ', testOK
    if (strupcase(testOK) eq "N") then begin
        print, '<!> OK try another file'
        goto, ende
    endif
endif

print,'-------------  SECOND FIND THE STAR in I2 ------------'

if (beam NE 'OPEN    ') then begin
chop_nod_disp_one_window_obsolete, win2, width, t_order,w_order, $
  traceI2, Flux_I2, Flux_I2c, weighting_win2, DEBUG=debug, SILENT=silent
endif

if (beam EQ 'OPEN    ') then begin
if (telescope EQ 'BOPEN   ') then begin
chop_nod_disp_one_window_obsolete, win2, width, t_order,w_order, $
  traceI2, Flux_I2, Flux_I2c, weighting_win2, DEBUG=debug, SILENT=silent
endif else begin
  sz = size(win2)
  x_size= sz[1]
  Flux_I2=dblarr(x_size)
  Flux_I2c=dblarr(x_size)
  weighting_win2=dblarr(x_size)
  traceI2 = {midisptrace}
endelse
endif

wset,0
tvpos=tvpos+1.
tvscl, rebin(sqrt(win2_display*weighting_win2),n[1]*factorx, n[2]*factor, /SAMPLE),tvpos

if not keyword_set(silent) then begin
    testOK = "string"
    read, '> Is the dataset satisfactory for beam I2? (y/n) ? ', testOK
    if (strupcase(testOK) eq "N") then begin
        print, '<!> OK try another file'
        goto, ende
    endif
endif

;;;;;;;;;;;;;;;;;; ONLY SCI_PHOT ;;;;;;;;;;;;;;;;;;;;;

if (beam EQ 'SCI_PHOT') then begin

print,'-------------  THIRD FIND THE STAR in Phot BEAM ------------'

chop_nod_disp_one_window_obsolete, winphot, width, t_order,w_order, $
  tracePhot, Flux_Phot, Flux_Photc, weighting_winPhot, DEBUG=debug, SILENT=silent

wset,0
tvpos=tvpos+1.
tvscl, rebin(sqrt(winphot_display*weighting_winPhot),n[1]*factorx, n[2]*factor, /SAMPLE),tvpos

if not keyword_set(silent) then begin
    testOK = "string"
    read, '> Is the dataset satisfactory for photometric beam? (y/n) ? ', testOK
    if (strupcase(testOK) eq "N") then begin
        print, '<!> OK try another file'
        goto, ende
    endif
endif
endif  ;loop for SCI_PHOT mode

;;;;;;;;;;; write something to disk ;;;;;;;;;;;;;;;;;;;;;;

     im = obj_new('fitsfile',hdrname)
     he = im->prihead()
     ;OBJECT    = STRCOMPRESS(he->getpar('OBJECT'),/remove_all)
     OBJECT        = STRCOMPRESS(he->getpar('OBS TARG NAME'),/remove_all)
     DIT       = he->getpar('DET DIT')
     INS_GRIS_NAME = STRCOMPRESS(he->getpar('INS GRIS NAME'),/remove_all)
     INS_FILT_NAME = STRCOMPRESS(he->getpar('INS FILT NAME'),/remove_all)
     INS_OPT1_NAME = STRCOMPRESS(he->getpar('INS OPT1 NAME'),/remove_all)
     INS_SHUT_NAME = strcompress(he->getpar('INS SHUT NAME'),/remove_all)
     obj_destroy,im

     short_file_name= MIDIname_datime(fname)
     OPENW,lun,'PHOTOMETRY/Phot_'+short_file_name+'.txt',/get_lun

     printf,lun,OBJECT
     printf,lun,short_file_name
     if N_Params() gt 1  then $
       printf,lun, MIDIname_datime(skyname), '	name of sky'
     printf,lun,format='(A10,"		",A)', INS_GRIS_NAME,'grism name'
     printf,lun,format='(A10,"		",A)', INS_FILT_NAME,'filter name'
     printf,lun,format='(A10,"		",A)', INS_OPT1_NAME,'opt1 name'
     printf,lun,format='(A10,"		",A)', INS_SHUT_NAME,'shutter name'

     printf,lun, DIT,'	Time exposure in s'

     if traceI1.Nrange gt 0.0 then range1 = traceI1.range[0:traceI1.Nrange-1] else range1 = 1.
     if traceI2.Nrange gt 0.0 then range2 = traceI2.range[0:traceI2.Nrange-1] else range2 = 1.
     printf,lun, -1,total(traceI2.trace[range2])/traceI2.Nrange, '	Star position in beam A'
     printf,lun, -1,total(traceI1.trace[range1])/traceI1.Nrange, '	Star position in beam B'
     printf,lun, -1,'		Aperture for Beam A in pixels'
     printf,lun, -1,'		Aperture for Beam B in pixels'

     printf,lun,total(Flux_I2c[range2])* gain/DIT,'	Flux A in Photons/s'
     printf,lun, 0. * gain/DIT,'	error Flux A'
     printf,lun, 0. * gain/DIT,'	sky A'
     printf,lun, 0. * gain/DIT,'	error sky A'

     printf,lun,total(Flux_I1c[range1])* gain/DIT,'	Flux B in Photons/s'
     printf,lun, 0. * gain/DIT,'	error Flux B'
     printf,lun, 0. * gain/DIT,'	sky B'
     printf,lun, 0. * gain/DIT,'	error sky B'

     printf,lun, "----- Table of flux per column in Photons/s -----"
     printf,lun, "Beam A"
     printf,lun, "  x     y    flux         flux_corrected"
     ;range = where(Flux_I2 gt 0.)
     for i=0,N_elements(Flux_I2)-1 do begin
         x = i ;range[i]
         printf,lun, Format='(I4,2X,F5.2,X,G12.6,X,G12.6)',$
           x, traceI2.trace[x], (Flux_I2[x]>0.)*gain/DIT, Flux_I2c[x]*gain/DIT
     endfor

     printf,lun, "Beam B"
     ;range = where(Flux_I1 gt 0.)
     for i=0,N_elements(Flux_I1)-1 do begin
         x = i ;range[i]
         printf,lun, Format='(I4,2X,F5.2,X,G12.6,X,G12.6)',$
           x, traceI1.trace[x], (Flux_I1[x]>0.)*gain/DIT, Flux_I1c[x]*gain/DIT
     endfor

     CLOSE,lun & free_lun,lun

  oirNewData, hdrname, make_maskname(fname), $
    { data1: weighting_win1, data2: weighting_win2 }
  ; the data for the mask is a struct with entries data1 and data2
  ; channel B is from win1, which is from data1

ende:

end
