; FUNCTION readphot: reads an ASCII table into float array;
;                   Photometry of MIDI spectra extracted from Chop_nod_disp.pro
; 
; INPUT required: filename - string; file to be processed
;       keywords: /noweighting - extract the total flux without applied weighting function
;
; OUTPUT created: float array
;
; SYNTAX: Readphot, string, array, airmass, range, /noweighting
;
;-
;---------------------------------------------------------
pro readphot, file, outarr, airmass, noweightin=noweighting

;file='PHOTOMETRY/'+make_shortname_DATA(file)
close,1
short_file_name= MIDIname_datime(file)
file='PHOTOMETRY/Phot_'+short_file_name+'.txt'

openr, 1, file
object=''
readf, 1,object

print, file
print,'TARGET : ',object

file=''
tmp=''
disp='' ;DISPERSION UNIT
comb=''	;BEAM COMBINER
shut=''	;SHUTTER
readf, 1,file
readf, 1,disp
disp = STRCOMPRESS(strmid(disp, 0, 10),/remove_all)
print,'DISPERSION : ',disp
readf, 1,tmp
readf, 1,comb
comb = STRCOMPRESS(strmid(comb, 0, 10),/remove_all)
print,'MODE : ', comb
readf, 1,shut
shut = STRCOMPRESS(strmid(shut, 0, 10),/remove_all)
print,'SHUTTER : ',shut

beam_comb=(comb eq 'SCI_PHOT')
beam_comb2=((comb eq 'SCI_PHOT') and (shut eq 'ABOPEN'))
IF beam_comb then begin
	IF beam_comb2 then begin
	nbeam=4
	ENDIF ELSE BEGIN
	nbeam=3
	ENDELSE
ENDIF ELSE BEGIN
	nbeam=2
ENDELSE

readf, 1,airmass
print,'AIRMASS : ',airmass
readf, 1,texpo
readf, 1,posxA
readf, 1,posxB
readf, 1,aperA
readf, 1,aperB
readf, 1,fluxA
readf, 1,errorA
readf, 1,skyA
readf, 1,errorskyA
readf, 1,fluxB
readf, 1,errorB
readf, 1,skyB
readf, 1,errorskyB
readf, 1,tmp
readf,1, range
readf, 1,tmp
readf, 1,tmp

midi_x=fltarr(range)
midi_fA=fltarr(range)
midi_fcA=fltarr(range)
x=0
y=0.0
z=0.0

FOR i=0, range-1 DO BEGIN
	readf, 1,x,w, y,z
	midi_x[i]=x 
	midi_fA[i]=y 
	midi_fcA[i]=z
ENDFOR
;Beam A shifted by 1 pixel compared to Beam B
midi_fA=shift(midi_fA,2)
midi_fcA=shift(midi_fcA,2)

readf, 1,tmp

midi_fB=fltarr(range)
midi_fcB=fltarr(range)
x=0
y=0.0
z=0.0
FOR i=0, range-1 DO BEGIN
	readf, 1,x,w, y,z
	midi_fB[i]=y 
	midi_fcB[i]=z
ENDFOR
midi_fB=shift(midi_fB,1)
midi_fcB=shift(midi_fcB,1)

goto, ende

IF beam_comb then begin
IF beam_comb2 THEN BEGIN
	readf, 1,tmp
	midi_fphotA=fltarr(range)
	midi_fcphotA=fltarr(range)
	x=0
	y=0.0
	z=0.0
	FOR i=0, range-1 DO BEGIN
		readf, 1,x,w, y,z
		midi_fphotA[i]=y 
		midi_fcphotA[i]=z
	ENDFOR

	readf, 1,tmp
	midi_fphotB=fltarr(range)
	midi_fcphotB=fltarr(range)
	x=0
	y=0.0
	z=0.0
	FOR i=0, range-1 DO BEGIN
		readf, 1,x,w, y,z
		midi_fphotpB[i]=y 
		midi_fcphotB[i]=z
	ENDFOR
	
ENDIF ELSE BEGIN
	readf, 1,tmp
	midi_fphot=fltarr(range)
	midi_fcphot=fltarr(range)
	x=0
	y=0.0
	z=0.0
	FOR i=0, range-1 DO BEGIN
		readf, 1,x,w, y,z
		midi_fphot[i]=y 
		midi_fcphot[i]=z
	ENDFOR
ENDELSE
ENDIF  ;IF SCI_PHOT
ende:

outarr=fltarr(range,nbeam+1)
outarr(*,0) = midi_x
IF keyword_set(noweighting) THEN  outarr(*,1) = midi_fA ELSE outarr(*,1) = midi_fcA
IF keyword_set(noweighting) THEN  outarr(*,2) = midi_fB ELSE outarr(*,2) = midi_fcB
	
;IF beam_comb then begin
;	IF beam_comb2 THEN BEGIN
;	IF keyword_set(noweighting) THEN  outarr(*,3) = midi_fphotA ELSE outarr(*,3) = midi_fcphotA
;	IF keyword_set(noweighting) THEN  outarr(*,4) = midi_fphotB ELSE outarr(*,4) = midi_fcphotB
;	ENDIF ELSE BEGIN
;	IF keyword_set(noweighting) THEN  outarr(*,3) = midi_fphot ELSE outarr(*,3) = midi_fcphot
;	ENDELSE
;ENDIF  ;IF SCI_PHOT
	
close, 1


end
