function [coeffsMap] = spaciaoGenCentroidCoeffsMap(subapMap, subapSize, usedSubapSize, coeffs)

coeffsMap = zeros(size(subapMap)*subapSize);
numUsedSubaps = size(find(subapMap ~= 0 ));
guard = (subapSize - usedSubapSize)/2;
for i=1:numUsedSubaps
    [row,col] = find(subapMap == i);
    startRow = (row - 1)*subapSize + guard + 1;
    endRow = (row - 1)*subapSize+guard + usedSubapSize;
    startCol = (col - 1)*subapSize + guard + 1;
    endCol = (col-1)*subapSize + guard + usedSubapSize;
    
    coeffsMap(startRow:endRow, startCol:endCol) = reshape(coeffs(i,:),usedSubapSize,usedSubapSize)';
end
 
end



