clear
close all

NFigures = 2;
ManageFigureHandles

Derot = 0;

Devices = {'IMSensitivity_Angle','IMSensitivity_X','IMSensitivity_Y'};
Prefixes = {'cimdatSYNTHETIC_ANGSENS_IM_','cimdatSYNTHETIC_XSENS_IM_','cimdatSYNTHETIC_YSENS_IM_'};


N = numel(Devices);
figure(FigureHandles(1));
Path = '/Users/hbonnet/VLTI/GRAVITY/Data/CIAO/DATABASE/Heidelberg/IMs/';
for k = 1:N
    [H,I] = readfits(sprintf('%s/%s/%s%3.3d.fits',Path,Devices{k},Prefixes{k},Derot));
    subplot(1,3,k);
    %H = reshape(H,136,60);
    imagesc(H');
end

figure(FigureHandles(2));
Path = '/Users/hbonnet/VLTI/GRAVITY/Data/CIAO/2015-07-01/Matrices/';
L = dir([Path,'/*.fits']);
N = numel(L);
for k = 1:N
    H = readfits([Path,'/',L(k).name]);
    subplot(1,N,k);
    imagesc(H');
end
