clear
close all


L = dir;
L = L([L.isdir]);
Good = true(numel(L),1);
for k = 1:numel(L)
    Good(k) = L(k).name(1) ~= '.';
end
L = L(Good);

Prefixes = {...
    'HO','cimdatSYNTHETIC_HO_IM_';
    'TT','cimdatSYNTHETIC_TT_IM_';
    'IMSensitivity_X','cimdatSYNTHETIC_XSENS_IM_';
    'IMSensitivity_Y','cimdatSYNTHETIC_YSENS_IM_';
    'IMSensitivity_Angle','cimdatSYNTHETIC_ANGSENS_IM_'};
for k = 1:numel(L)
    Dir = L(k).name;
    K = dir(sprintf('%s/*.fits',Dir));
    [In,Which] = ismember(Dir,Prefixes(:,1));
    if ~In
        error('Cannot find this: %s',Dir);
    end
    Prefix = Prefixes{Which,2};

    for u = 1:numel(K)
        Name = K(u).name;
        UsAndDots = find(Name=='_' | Name == '.');
        Number = Name(UsAndDots(end-1)+1:UsAndDots(end)-1);
        NewName = sprintf('%s/%s%s.fits',Dir,Prefix,Number);
        OldName = sprintf('%s/%s',Dir,Name);

        movefile(OldName,NewName);
    end
end

