function res = PV(data)

% res = PV(data);
% 
% This function computes the Peak-to-Valley of the input 'data' variable,
% that can be a matrix of any size. It simply computes the difference
% between the largest and the smallest values in the input variable. NaNs
% are excluded
% 
% A typical entry could be:
% WF_PV = PV(WF);
% 
% Custom sub-routines required:
% - nanmax.m (Statistics Toolbox)
% - nanmin.m (Statistics Toolbox)
% 
% v1.0 J.Kolb 03/05/12
% - first release of fully commented file together with version 2.0 of the
%   PSIM code.

res = nanmax(data(:)) - nanmin(data(:));

% end of function