function [CM, S] = invIM(IM,mode_filt,dispID)

% [CM, S] = invIM(IM,mode_filt,dispID);
% 
% This function computes the pseudo-inverse of the Interaction Matrix 'IM'
% via TSVD (Truncated Singular Value Decomposition), i.e. SVD followed by
% filtering of 'mode_filt' modes.
% If 'dispID' is set to 1, the resulting Control Matrix (CM) and eigen
% values plot are displayed.
%
% A typical entry could be:
% [CM, S] = invIM(IM,20,1);
% 
% Custom sub-routines required:
% 1) First level
% - ficac.m
% 
% v1.0 J.Kolb 16/12/10
% v2.0 J.Kolb 04/05/12
% - improved comments

% Transposes the IM if orientation is wrong
if size(IM,2) > size(IM,1)
    flag = 1;
    IM = IM';
else
    flag = 0;
end

% Makes SVD
[U,S,V] = svd(IM,0);

% Modes filtering
Smax = S(length(S)-mode_filt,length(S)-mode_filt);
S(S < Smax) = Inf;

% Matrix inversion
T = 1./S;
CM = V*T*(U');

% Transposition of the CM to be consistent with input IM
if flag == 1;
    CM = CM';
end

% Display
if dispID == 1
    figure ; stem(1./diag(S)) ; grid on
    ficac(CM)
end

% end of function