function TT = pureTT(nbpix,D,TTangle)

% TT = pureTT(nbpix,D,TTangle);
% 
% The goal of this function is to produce a pure Tilt 'TT' wavefront (in
% microns) in the telescope pupil of diameter 'D', over 'nbpix' pixels and
% with the angle 'TTangle' in arcsec on the sky.
% The main application is the debugging of the SHWFS model('SHWFS_PSIM.m'
% and sub-routines)
% 
% A typical entry could be:
% TT = pureTT(960,8,0.83);
% 
% Custom sub-routines required:
% - none
% 
% v1.0 J.Kolb 16/12/10
% v2.0 J.Kolb 24/04/12
% - added help

[TT,~] = meshgrid(-(nbpix-1)/2:(nbpix-1)/2,-(nbpix-1)/2:(nbpix-1)/2);
TT = TT./nbpix;
d = TTangle/3600/180*pi*D*1e6;
TT = TT*d; % in microns

% end of function