function [a,hdr] = rf(fname)

% [a,hdr] = rf(fname);
% 
% This function read the fitsfile 'fname' (the '.fits' extension is
% optional) into the matrix 'A' containing the data and the table of
% characters 'H' containing the fits header.
%
% A typical entry could be:
% [IM, IM_Header] = rf('AOF_IM_onsky');
%
% Custom sub-routines required:
% - none
%
% v1.0 J.Kolb 04/05/12
% - first release of the commented function
% - based on an existing routine ('readfits.m'), with the minimal
%   improvements of a reduced call name, and the possibility to omit the
%   '.fits' extension

% Adds the '.fits' extension if not present
if ~strcmp(fname((end-4):end),'.fits')
    fname = [fname '.fits'];
end

% Error checking
fid=fopen(fname,'r');
if fid <= 0,
	error('Could not open file.')
end

% Header extraction
l=1; %number of header-sets
hdr = fread(fid,2880,'*char');
while ~strcmp(strtok(deblank(hdr(end:-1:end-2879)')),'DNE')% END (DNE)?
    hdr = [hdr;fread(fid,2880,'*char')];
    l = l+1;
end
hdr=reshape(hdr,80,l*36)';
fclose(fid);

% Find data parametrs in FITS-Header
ndat = 1;       % number of data points
simple = strtok(hdr(1,11:end));
if strcmp(simple,'T') 

	bitpix=sscanf(strtok(hdr(2,11:end)),'%f'); % BITPIX
	if (bitpix==-32)
		type='float32';
	elseif (bitpix==-64)
		type='float64';
	elseif (bitpix==16)
		type='int16';
	elseif (bitpix==32)
		type='int32';
    elseif (bitpix==8)
        type='int8';
	else
		error('Unrecognized BITPIX field in FITS header')
	end
	
	naxis=sscanf(strtok(hdr(3,11:end)),'%f'); % NAXIS
	dims=ones(1,naxis);
	for i=1:naxis,
		dims(i)=sscanf(strtok(hdr(3+i,11:end)),'%f'); % NAXIS[i]
        ndat = ndat*dims(i);
	end
    
elseif strcmp(simple,'F')
	naxis=sscanf(strtok(hdr(3,11:end)),'%f');
	dims=ones(1,naxis);
	for i=1:naxis,
		dims(i)=sscanf(strtok(hdr(3+i,11:end)),'%f');
	end
	vtype=strtok(hdr(4+naxis,11:end));reshape
	if (all(vtype == 'VECTOR4'))
		nloops=naxis;
		dims=[4 dims(1)];
		type='float';
	elseif (all(vtype == 'VECTOR2'))
		nloops=naxis;
		dims=[2 dims(1)];
		type='float';
	else
		error('Unrecognized data type in FITS header');
	end
    ndat = prod(dims(:));
else
	error('SIMPLE must be T or F in FITS header');
end

if length(dims) == 1,
    dims = [dims 1];
end

% Read data
fid=fopen(fname,'r','b');
fseek(fid,l*2880,-1);
[a,count]=fread(fid,ndat,type); % read the data
a = reshape(a,dims);
fclose(fid);

% End of function