function txy(t, x, y)

% txy(t, x, y)
% 
% This function is simply a shortcut to the 3 functions 'title', 'xlabel'
% and 'ylabel'. It allows displaying the title 't' (text between quotes)
% and the labels on the x and y axis ('x' and 'y' inputs) on the current
% figure.
% Also it displays the text of the title, axis labels and the figure itself
% (axis, legend...) larger than the default Matlab values, so that the
% figure looks better if saved or exported to a Word document for example.
% 
% A typical entry could be:
% txy('WFS residual slopes variance vs. loop gain', 'Gain','Residual slopes rms (pixel)')
%
% Custom sub-routines required:
% - none
%
% v1.0 J.Kolb 18/05/12
% - first release of fully commented file together with version 2.0 of the
%   PSIM code.

title(t,'Fontsize',20)
xlabel(x,'Fontsize',14)
ylabel(y,'Fontsize',14)
set(gca,'FontSize',14)

% end of function