function [nf,mf] = FindNM(mode)

% [nf,mf] = FindNM(mode);
% 
% The goal of this function is to compute the index of radial ('nf') and
% azimuthal ('mf') orders of the Zernike polynomial of generic order
% 'mode'. 'mode' can also be an array of numbers for which to compute the
% indexes.
% 
% A typical entry could be:
% [nf,mf] = FindNM(12);
% 
% Custom sub-routines required:
% - none
% 
% v1.0 J.Kolb 16/12/10
% - function created by R.Conan before 2002
% v2.0 J.Kolb 25/04/12
% - added help and comments

% Loop on the input mode numbers
for counti=1:size(mode,1)
   for countj=1:size(mode,2)
      
      % radial order
      n = 0;
      % azimuthal order
      m = 0;
      
      count = 0;
      
      while length(n)<mode(counti,countj)
         
         count = count + 1;
         tmp = 0:count;
         tmp = tmp(rem(count-tmp,2)==0);
         
         if all(tmp)
            n = [n ones(1,2.*length(tmp)).*count];
            tmp1 = tmp(ones(2,1),:);
            m = [m reshape(tmp1,1,size(tmp1,1).*size(tmp1,2))];
         else
            n = [n ones(1,(2.*length(tmp))-1).*count];
            tmp1 = tmp(ones(2,1),2:length(tmp));
            m = [m 0 reshape(tmp1,1,size(tmp1,1).*size(tmp1,2))];
         end
         
      end
      
      nf(counti,countj) = n(mode(counti,countj));
      mf(counti,countj) = m(mode(counti,countj));
      
   end
end

% end of function