% This is the standard input parameters file of the VLT Active Optics
% configuration (geometric model) for the function 'SHWFS_PSIM.m' 
% 
% v2.0 J.Kolb 03/05/12
% - first release of fully commented file together with version 2.0 of the
% PSIM code.

SH_model = 1;               % SH model used: 1=geometric, 2=diffractive

% Centroiding method
% 1) Geometric SH model
% - 'Z'    = "Z-tilt" method = projection of WF on zernike Tip and Tilt
% - 'G'    = "G-tilt" method = Angle of Arrival computation (difference of WF at pupil edges)
% 1) Diffractive SH model:
% - 'Bar'  = barycenter (in pixels from the corner)
% - 'CoG'  = Center of Gravity (in pixels from the center)
% - 'wCoG' = Weighted Center of Gravity (requires weighting map)
% - 'Corr' = Correlation (requires correlation map)
% - 'MF'   = Matched filter (requires filter map)
Cen_meth = 'G';
param = 0;

D = 8;                      % Telescope diameter in meters
SHsize = 24;                % Number of sub-apertures across the diameter
nbpixCCD = 22;               % Number of pixels per sub-aperture
pix_scale = 0.3;           % Detector pixel scale in arcsec/pixel
noise = 0;                  % 0 if perfect detector, 1 if noise added
wl = 0.589;                 % Wavelength (um)
source_size = 0*pix_scale;  % Source size (FWHM) in " ( = 0 if point source)
pixsize = 24;               % Detector pixel size in um
outmax = 1;                 % External diameter of the pupil mask (>0, between outmin and 1)
outmin = 1.12/8;            % Internal diameter of the pupil mask (between 0 and outmin, <1)
subap_min_illu = 0.5;       % Min illumination required for validity of the sub-apertures (between 0 and 1)
Cmin = 1;                   % Min binning of the WFS image to produce the detector image

% Detector parameters, used only when the noise is set to 1 in diffractive
% model. Noise set to 1 in geomatric model will only account to photon
% noise.
Nphot = 120;            % Number of incident photons per sub-aperture and per frame
Exptime = 1e-3;         % Exposure time [seconds], only for computation of dark current
QE = 1;                 % Quantum efficiency from 0 to 1 [no unit]
PSF = 0;                % Point Spread Function of the sensor (=0 if all charges collected in one pixel) [pixels]
Dark = 0;               % Dark current signal [electrons per pixel per second]
IMsat = 10^6;           % Saturation level [electrons]
CF = 1;                 % Conversion Factor [microV/electron]
Bias = 0;               % The overall Bias Voltage, converted into [electrons]
                        %   Bias [e] = 10^6 * Bias[V] / CF [microV/e]
XS = 1.4;               % Excess Noise [no unit] (1.4 for EMCCD)
NL = 0;                 % Non-Linearity [no unit] (Coefficients of a polynomial)
RON = 0.5;              % Read-Out Noise [electrons rms per pixel and per frame]
Digit = 1;              % Gain of the ADC [electron/ADU]

% End of file