function Zern = ZPolynomeQuick(mode,n,m,r,theta)

% Zern = ZPolynomeQuick(mode,n,m,r,theta);
% 
% The goal of this function is to compute the shape of a Zernike polynomial
% 'Zern'. The inputs are:
% - 'mode'      the order of the Zernike Polynomial
% - 'n'         the corresponding radial order (can be computed with the
%               function 'FindNM.m'
% - 'm'         the corresponding azimuthal order
% - 'r'         polar coordinates map of radius in the pupil (can be
%               generated from 'meshgrid' and 'cart2pol')
% - 'theta'     polar coordinates map of azimuth in the pupil
% 
% A typical entry could be:
% Z(:,:,12) = ZPolynomeQuick(12,4,2,RHO,THETA);
% 
% Custom sub-routines required:
% - none
% 
% v1.0 J.Kolb 16/12/10
% - function created by R.Conan before 2002
% v2.0 J.Kolb 25/04/12
% - added help and comments

R = 0;
for s=0:(n-m)/2
   R = R + (-1).^s.*prod(1:(n-s)).*r.^(n-2.*s)./(prod(1:s).*prod(1:((n+m)/2-s)).*prod(1:((n-m)/2-s)));
end

if m==0
   Zern = sqrt(n+1).*R;
elseif rem(mode,2)
   Zern = sqrt(n+1).*R.*sqrt(2).*sin(m.*theta);
else
   Zern = sqrt(n+1).*R.*sqrt(2).*cos(m.*theta);
end   

% end of function