function wbID = wb(cpt, maxcpt, wbID, decim)

% wbID = wb(cpt, maxcpt, wbID, decim);
% 
% Addition to the 'waitbar' function of an estimation of the remaining
% time. This is done by using the tic/toc functions.
% This function should be used in a 'for' loop, as first argument in it,
% and the input parameters are:
% - 'cpt' the current loop counter
% - 'maxcpt' the maximum loop counter of the 'for' loop.
% - 'wbID' is required to identify the waitbar display window. It should be
%   set to zero before the beginning of the loop, and then kept as
%   identical in/out variable.
% - 'decim' is optional. It is an integer that sets how often the waitbar
%   is updated: it will be updated once every 'decim' iteration of the
%   'for' loop.
% 
% A typical entry could be:
% wbID = 0;
% for cpt = 1:200
%     wbID = wb(cpt,200,wbID, 10);
%     [arguments]
% end
%
% Custom sub-routines required:
% - none
%
% v1.0 J.Kolb 02/05/12
% - first release of the commented function
% v2.0 J.Kolb 04/12/12
% - added possibility to decimate waitbar update frequency
% - improved HELP

% Initialization of decimation
if nargin < 4
    decim = 1;
end

% Initialization of the waitbar at the first cycle
if wbID == 0
    T0 = Inf;
    % Window opening at a default position
    wbID = waitbar(0, ['Time remaining: ', num2str(floor(T0/60)), ' min, ', num2str(T0 - floor(T0/60)*60), ' sec'],...
        'Position', [100 100 300 50]);
    % Start stopwatch
    tic
end

% Update of the remaining time estimation
switch cpt
    case maxcpt
        % Close the display window when the max cycle is reached
        close(wbID)
    otherwise
        if round(cpt/decim) == (cpt/decim)
            % Compute remaining time from the elapsed time and the ratio
            % between elapsed and remaining cycles.
            T0 = round(toc/(cpt-1)*(maxcpt-cpt+1));
            % Update the waitbar
            waitbar(cpt/maxcpt,wbID,['Time remaining: ', num2str(floor(T0/60)), ' min, ', num2str(T0 - floor(T0/60)*60), ' sec'])
        end
end

% end of function