% Exercises for the PSIM code training, J. Kolb, 10/12/12

% set path!

% open
open makeIM_PSIM

% help
help makeIM_PSIM

% doc
doc makeIM_PSIM

% which
which makeIM_PSIM

% ficac
data = randn(512, 512);
ficac(data)


%%%%%%%%%%%%%%%%%% MakeIM_PSIM %%%%%%%%%%%%%%%%%%%%%

% [IM, pupmask, wl, C, xyvalid_ref, xyfullill, xyf_of_v] =...
%     makeIM_PSIM(SHWFS_PSIM_input, nbpixWF, modes_ID, maxorder, amplitudes, Coeffs, Tomo, nb_neighb_SA)

% MAD IM

open SHWFS_input_MAD_geom

load DM_MAD_IF_SH02_512/Mode_1.mat
ficac(DM)
load DM_MAD_IF_SH02_512/Mode_60.mat
ficac(DM)

[IMg, pupmask, wl, C, xyvalid_ref, xyfullill, xyf_of_v] =...
    makeIM_PSIM('SHWFS_input_MAD_geom', 512, 'MAD_IF_SH02', 1:60, 1/10, [0 0 0 0 0 0 0], [0 0 0 0 0 0]);
ficac(IMg)

[IMd, pupmask, wl, C, xyvalid_ref, xyfullill, xyf_of_v] =...
    makeIM_PSIM('SHWFS_input_MAD_diff', 512, 'MAD_IF_SH02', 1:60, 1/10, [0 0 0 0 0 0 0], [0 0 0 0 0 0]);
ficac(IMd)
ficac(IMg-IMd)

% IM with Zernikes (Z2S)

[Z2S, pupmask, wl, C, xyvalid_ref, xyfullill, xyf_of_v] =...
    makeIM_PSIM('SHWFS_input_MAD_geom', 512, 'Z', 1:60, 1/10, [0 0 0 0 0 0 0], [0 0 0 0 0 0]);
ficac(Z2S)

% mis-registrations

[IMg, pupmask, wl, C, xyvalid_ref, xyfullill, xyf_of_v] =...
    makeIM_PSIM('SHWFS_input_MAD_geom', 256, 'MAD_IF_SH02', 1:60, 1/10, [0 0 0 0 0 0 0], [0 0 0 0 0 0]);
ficac(IMg)

[IMg10x, pupmask, wl, C, xyvalid_ref, xyfullill, xyf_of_v] =...
    makeIM_PSIM('SHWFS_input_MAD_geom', 256, 'MAD_IF_SH02', 1:60, 1/10, [10 0 0 0 0], [0 0 0 0 0 0]);
ficac(IMg-IMg10x)
ficac(pupmask)

[IMg10y, pupmask, wl, C, xyvalid_ref, xyfullill, xyf_of_v] =...
    makeIM_PSIM('SHWFS_input_MAD_geom', 256, 'MAD_IF_SH02', 1:60, 1/10, [0 10 0 0 0], [0 0 0 0 0 0]);
ficac(IMg-IMg10y)

[IMg1r, pupmask, wl, C, xyvalid_ref, xyfullill, xyf_of_v] =...
    makeIM_PSIM('SHWFS_input_MAD_geom', 256, 'MAD_IF_SH02', 1:60, 1/10, [0 0 1 0 0], [0 0 0 0 0 0]);
ficac(IMg-IMg1r)

% Tomography

[IMt, pupmask, wl, C, xyvalid_ref, xyfullill, xyf_of_v] =...
    makeIM_PSIM('SHWFS_input_MAD_geom', 256, 'MAD_IF_SH02', 1:60, 1/10, [0 0 0 0 0 0 0], [120 0 0 0 0 0]);
ficac(IMt)
ficac(pupmask)

[IMt, pupmask, wl, C, xyvalid_ref, xyfullill, xyf_of_v] =...
    makeIM_PSIM('SHWFS_input_MAD_geom', 256, 'MAD_IF_SH02', 1:60, 1/10, [0 0 0 0 0 0 0], [120 0 0 8.5 0 0]);
ficac(IMt)
ficac(pupmask)

% insert 'ficac(DM) ; ficac(metapupmask)' in 'MakeIM_PSIM', line 399
open makeIM_PSIM

lay_alt = [0 6 13];
lay_IF = struct('IF',{'MAD_IF_SH02','MAD_IF_SH02','MAD_IF_SH02'});
lay_amp = [1/10 1/10 1/10];

lay=1; Tomo = [120 0 0 lay_alt(lay) 0 0];
[IMt, pupmask, wl, C, xyvalid_ref, xyfullill, xyf_of_v] =...
    makeIM_PSIM('SHWFS_input_MAD_geom', 256, lay_IF(lay).IF, 1:1, lay_amp(lay), [0 0 0 0 0 0 0], Tomo);

lay=2; Tomo = [120 0 0 lay_alt(lay) 0 0];
[IMt, pupmask, wl, C, xyvalid_ref, xyfullill, xyf_of_v] =...
    makeIM_PSIM('SHWFS_input_MAD_geom', 256, lay_IF(lay).IF, 1:1, lay_amp(lay), [0 0 0 0 0 0 0], Tomo);

lay=3; Tomo = [120 0 0 lay_alt(lay) 0 0];
[IMt, pupmask, wl, C, xyvalid_ref, xyfullill, xyf_of_v] =...
    makeIM_PSIM('SHWFS_input_MAD_geom', 256, lay_IF(lay).IF, 1:1, lay_amp(lay), [0 0 0 0 0 0 0], Tomo);

% in the FoV
lay=3; Tomo = [120 30 0 lay_alt(lay) 0 0];
[IMt, pupmask, wl, C, xyvalid_ref, xyfullill, xyf_of_v] =...
    makeIM_PSIM('SHWFS_input_MAD_geom', 256, lay_IF(lay).IF, 1:1, lay_amp(lay), [0 0 0 0 0 0 0], Tomo);

% using 'Miska' method for vDM:
lay=1; Tomo = [120 0 0 lay_alt(lay) 0 0];
[IM_test, pupmask, wl, C, xyvalid_ref, xyfullill, xyf_of_v] =...
    makeIM_PSIM('SHWFS_input_MAD_geom', 256, lay_IF(lay).IF, 1:1, lay_amp(lay),...
    [0 0 0 100*(Tomo(4)*1000*Tomo(1)/8/3600/180*pi)*ones(1,2)], Tomo, Inf);

lay=2; Tomo = [120 0 0 lay_alt(lay) 0 0];
[IM_test, pupmask, wl, C, xyvalid_ref, xyfullill, xyf_of_v] =...
    makeIM_PSIM('SHWFS_input_MAD_geom', 256, lay_IF(lay).IF, 1:1, lay_amp(lay),...
    [0 0 0 100*(Tomo(4)*1000*Tomo(1)/8/3600/180*pi)*ones(1,2)], Tomo, Inf);

lay=3; Tomo = [120 0 0 lay_alt(lay) 0 0];
[IM_test, pupmask, wl, C, xyvalid_ref, xyfullill, xyf_of_v] =...
    makeIM_PSIM('SHWFS_input_MAD_geom', 256, lay_IF(lay).IF, 1:1, lay_amp(lay),...
    [0 0 0 100*(Tomo(4)*1000*Tomo(1)/8/3600/180*pi)*ones(1,2)], Tomo, Inf);

% !!! REMOVE 'ficac(DM) ; ficac(metapupmask)' in 'MakeIM_PSIM', line 399 !!!

% AOF IM
[IM_AOF, pupmask, wl, C, xyvalid_ref, xyfullill, xyf_of_v] =...
    makeIM_PSIM('SHWFS_input_AOF_geom', 240, 'Act_AOF', 1:100, 1/10, [0 0 0 0 0 7 7], [0 0 0 0 0 0], Inf);
toc
ficac(IM_AOF)

% using nb_neighb_SA
[IM_AOF, pupmask, wl, C, xyvalid_ref, xyfullill, xyf_of_v] =...
    makeIM_PSIM('SHWFS_input_AOF_geom', 240, 'Act_AOF', 1:1170, 1/10, [0 0 0 0 0 7 7], [0 0 0 0 0 0], Inf);
toc
ficac(IM_AOF)


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% other routines
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% wb
cpt2 = 0; maxcpt = 10000;
wbID = 0;
for cpt = 1:maxcpt
    wbID = wb(cpt,maxcpt,wbID);
    cpt2 = cpt2+1;
end

% wb, with decimation
cpt2 = 0; maxcpt = 10000;
wbID = 0;
for cpt = 1:maxcpt
    wbID = wb(cpt,maxcpt,wbID,100);
    cpt2 = cpt2+1;
end

% ficac
data = randn(512, 512);
ficac(data)

% txy
txy('Map of random values','X axis','Y axis')

% PV
tmp = PV(data); disp(tmp)

% ca
ca

% kill
kill

% createZ_PSIM, pupil mask
[pupmask, in, out] = createZ_PSIM(256, 1, 0.12, 1);
ficac(pupmask)

pupmask(out) = NaN;
ficac(pupmask)

% bin_PSIM
[pupmask, in, out] = createZ_PSIM(256, 1, 0.12, 1);
SH = bin_PSIM(pupmask,32);
ficac(SH)

% fpg
fpg(SH(:))

fpg(sort(SH(:),'descend'))

SH(SH>0.5) = 1;  SH(SH ~= 1) = 0;  ficac(SH)

% createZ_PSIM, 20 Zernikes
[Z, in, out] = createZ_PSIM(256, 1:20, 0.12, 1);
ficac(Z(:,:,8))

% proj
WF = 0.5 * Z(:,:,3) + 0.7 * Z(:,:,8) + 1 * Z(:,:,10) + 0.25 * Z(:,:,15);
ficac(WF)

Coeff = zeros(1,20);
for cpt = 1:20
    Coeff(cpt) = proj(WF,Z(:,:,cpt));
end
fpg(Coeff)

% createPS_PSIM, 1 screen
% [PS, D] = createPS_PSIM(PSsize, enl_fact, L0, Scale, r0, PSdisp, D);
PS = createPS_PSIM(256, 2, 22, 8/256, 0.1, 1);

% createPS_PSIM, for closed loop simulations
[PS, D] = createPS_PSIM([256 1024], 2, 22, 8/256, 0.1, 1); axis equal ; axis off ; colorbar off

% createPS_PSIM, multiple layers for closed loop simulations
PS(:,:,2) = createPS_PSIM([256 1024], 2, 22, 8/256, 0.1, 0, D);
PS(:,:,3) = createPS_PSIM([256 1024], 2, 22, 8/256, 0.1, 0, D);
disp(size(PS))

% createPS_PSIM, warning!!!!
PS = createPS_PSIM(2048, 2, 22, 8/256, 0.1, 1);

% makepsf_PSIM, single image
% [psf, wl, C, N, zeropad] = makepsf_PSIM(WFmask, pupmask, wl, d, pix_scale, nbpixCCD, Srce, Cmin, Tag_bin);
[PS, D] = createPS_PSIM(256, 2, 22, 8/256, 0.1, 1);
[pupmask, in, out] = createZ_PSIM(256, 1, 0.12, 1);

[psf, wl, C, N, zeropad] = makepsf_PSIM(PS/2/pi*0.5, pupmask, 2.2, 8, 0, 200, 0, 1);
ficac(psf) ; txy('PSF in linear scale','','');
ficac(log(psf - min(psf(:))+10000)) ; txy('PSF in log scale','','');

% makepsf_PSIM, long exposure
allpsf = zeros(200,200,100);
wbID = 0;
for cpt = 1:100
    wbID = wb(cpt,100,wbID,10);
    PS = createPS_PSIM(256, 2, 22, 8/256, 0.1, 0, D);
    [allpsf(:,:,cpt), wl, C, N, zeropad] = makepsf_PSIM(PS/2/pi*0.5, pupmask, 2.2, 8, 0, 200, 0, 1);
end
psf = mean(allpsf,3);
ficac(psf)

% crop_PSIM
psf2 = crop(psf,[75 150],[100 100]);
ficac(psf2) ; axis equal ; axis off

psf3 = crop(psf,100);
ficac(psf3) ; axis equal ; axis off

%%%%%%%%%%%% MGfit %%%%%%%%%%%%%%%%%%%
% fit_meth = 1: Circular Gaussian (5 parameters)
% fit_meth = 2: Elliptic Gaussian (7 parameters)
% fit_meth = 3: Circular Moffat (6 parameters)
% fit_meth = 4: Elliptic Moffat (8 parameters)
fit_meth = 4;
[p_res, fval, psf4, FWHM] = MGfit(psf3, fit_meth);

% MGfit, analysis
ficac([psf3 psf4 3*(psf3-psf4)]) ; axis equal ; axis off
disp(p_res(1)) ; disp(p_res(2)) ; disp(p_res(3:5)) ; disp(fval)

difflim = 2.2/8/2 * 1e-6 * 3600 * 180 / pi;
disp(['Measured FWHM = ', num2str(FWHM* difflim), ' arcsec']);

% S_F_L0
S = 0.9759*0.5*1e-6/0.1/pi*180*3600;
FWHMth = S_F_L0(S,0,22,2.2,1);
disp(['Theoretical FWHM = ', num2str(FWHMth), ' arcsec'])

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% centroid_PSIM
psf = psf*1e-7; ficac(psf)
[barxy1, psf2] = centroid_PSIM(psf, 'CoG', 0); disp(barxy1) ; ficac(psf2)
[barxy2, psf2] = centroid_PSIM(psf, 'CoG', 1); disp(barxy2) ; ficac(psf2)

psf5 = crop_PSIM(psf,[100 100],[100 75]); ficac(psf5)
[barxy3, psf2] = centroid_PSIM(psf5, 'CoG', 0); disp(barxy3) ;
[barxy4, psf2] = centroid_PSIM(psf5, 'CoG', 1); disp(barxy4) ;
disp(barxy1-barxy3) ; disp(barxy2-barxy4)

[barxy5, psf2] = centroid_PSIM(psf, 'Corr', 10); disp(barxy5)
[barxy6, psf2] = centroid_PSIM(psf5, 'Corr', 10); disp(barxy6)
disp(barxy5-barxy6)

%%%%%%%%%%%%%%% ImSensor_PSIM %%%%%%%%%%%%%%%%%%%%
% IMout = ImSensor_PSIM(IMin, QE, PSF, Dark, Bias, CF, IMsat, XS, NL, ...
%     RON, Exptime, Digit, Sensor_maps, binfact, IMdisp, IMout_type, noise_quick)

% with Bias of 100 electrons and RON = 10e
IMout = ImSensor_PSIM(psf5*100, 1, 0, 0, 100, 1, 10^6, 1, 0, ...
    10, 1e-3, 1, 0, 1, 1, 'ADU');

% with saturation @ 1000 ADUs
IMout = ImSensor_PSIM(psf5*1000, 1, 0, 0, 100, 1, 10^3, 1, 0, ...
    10, 1e-3, 1, 0, 1, 1, 'ADU');

% with binning x 10
IMout = ImSensor_PSIM(psf5*100, 1, 0, 0, 100, 1, 10^6, 1, 0, ...
    10, 1e-3, 1, 0, 10, 1, 'ADU');

% with detector psf = 3 pixels
IMout2 = ImSensor_PSIM(IMout, 1, 3, 0, 100, 1, 10^6, 1, 0, ...
    0, 1e-3, 1, 0, 1, 1, 'ADU');

% Generate maps of defects
IMxy = size(psf5);

PRNU = 1; %[%]
PRNUmap = (1 + PRNU / 100 * randn(IMxy));
ficac(PRNUmap)

NbColBias = 2; %[%]
ColBias = NbColBias / 100 * randn(1,IMxy(1));
ColBiasMap = ones(IMxy(2),1) * ColBias;
ficac(ColBiasMap)

NbDeadpx = 0.2; %[%]
xDeadpx = ceil(100*rand(1,round(NbDeadpx/100*prod(IMxy))));
yDeadpx = ceil(100*rand(1,round(NbDeadpx/100*prod(IMxy))));
DeadpxMap = ones(IMxy);
for cpt = 1:length(xDeadpx)
    DeadpxMap(xDeadpx(cpt),yDeadpx(cpt)) = 0;
end
ficac(DeadpxMap)

save 'MyDetector_1' PRNUmap ColBiasMap DeadpxMap

% now with defects
IMout = ImSensor_PSIM(psf5*10, 1, 0, 0, 100, 1, 10^6, 1, 0, ...
    1, 1e-3, 1, 'MyDetector_1', 1, 1, 'ADU');

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% Slopes_PSIM
PS = createPS_PSIM(256, 2, 22, 8/256, 0.2, 0);
CCD = zeros(64,64);
wbID = 0;
for cptx = 1:8
    for cpty = 1:8
        [CCD((1:8)+8*(cptx-1),(1:8)+8*(cpty-1)), wl, C, N, zeropad] =...
            makepsf_PSIM(PS((1:32)+32*(cptx-1),(1:32)+32*(cpty-1))/2/pi*0.5, ones(32,32), 0.5, 1, 0.2, 8, 0, 1);
    end
end
ficac(CCD)

% [xyslopes, CCDall2, CCDint] = Slopes_PSIM(CCDall, xyvalid, SHsize,...
%   nbpixCCD, Cen_meth, param, WFdisp)
[x, y] = meshgrid(1:8,1:8);
[xyslopes, CCDall2, CCDint] = Slopes_PSIM(CCD, [reshape(x,[64,1]) reshape(y,[64,1])], 8, 8, 'CoG', max(CCD(:)/10), 1);

% dp2phi2
% WF = dp2phi2(slopex, slopey, pupille, precis, nbiter, cste, tilt)
pix_scale = 0.2;
WF = dp2phi2(xyslopes(:,:,1)*pix_scale/180/3600*pi*1000, xyslopes(:,:,2)*pix_scale/180/3600*pi*1000, ones(8,8), 2.5, 5, 1, 0);
ficac(WF*1e6) ; ficac(PS/2/pi*0.5)


%%%%%%%%%%% SHWFS_PSIM %%%%%%%%%%%%%%

open SHWFS_params/SHWFS_input_template

PS = createPS_PSIM(512, 2, 22, 8/512, 0.2, 0);

[CCDall, xyslopes, wl_eff, C, xyvalid, xyfullill, xyf_of_v, Tag_params, CCDall2] =...
    SHWFS_PSIM(PS/2/pi*0.5, 'SHWFS_input_MAD_geom', [0 0 0 0 0], 1);

[CCDall, xyslopes, wl_eff, C, xyvalid, xyfullill, xyf_of_v, Tag_params, CCDall2] =...
    SHWFS_PSIM(PS/2/pi*0.5, 'SHWFS_input_MAD_geom', [100 0 0 0 0], 1);

[CCDall, xyslopes, wl_eff, C, xyvalid, xyfullill, xyf_of_v, Tag_params, CCDall2] =...
    SHWFS_PSIM(PS/2/pi*0.5, 'SHWFS_input_MAD_diff', [0 0 0 0 0], 1);

% pureTT

TT = pureTT(512,8,0.32);

[CCDall, xyslopes, wl_eff, C, xyvalid, xyfullill, xyf_of_v, Tag_params, CCDall2] =...
    SHWFS_PSIM(0*TT, 'SHWFS_input_MAD_geom', [0 0 0 0 0], 1);

[CCDall, xyslopes, wl_eff, C, xyvalid, xyfullill, xyf_of_v, Tag_params, CCDall2] =...
    SHWFS_PSIM(1*TT, 'SHWFS_input_MAD_geom', [0 0 0 0 0], 1);

[CCDall, xyslopes, wl_eff, C, xyvalid, xyfullill, xyf_of_v, Tag_params, CCDall2] =...
    SHWFS_PSIM(0*TT, 'SHWFS_input_MAD_diff', [0 0 0 0 0], 1);

[CCDall, xyslopes, wl_eff, C, xyvalid, xyfullill, xyf_of_v, Tag_params, CCDall2] =...
    SHWFS_PSIM(1*TT, 'SHWFS_input_MAD_diff', [0 0 0 0 0], 1);

wbID=0;
for cpt = 1:41
    wbID = wb(cpt,41,wbID);
    [CCDall, xyslopes, wl_eff, C, xyvalid, xyfullill, xyf_of_v, Tag_params, CCDall2] =...
        SHWFS_PSIM((cpt-1)/10*TT, 'SHWFS_input_MAD_geom', [0 0 0 0 0], 0);
    TTresp(cpt) = xyslopes(3,3,1);
end
figure ; plot(0:0.1:4,TTresp,'.-') ; grid on

% use of Tag_params

Tag_params = 0; wbID=0;
for cpt = 1:41
    wbID = wb(cpt,41,wbID);
    [CCDall, xyslopes, wl_eff, C, xyvalid, xyfullill, xyf_of_v, Tag_params, CCDall2] =...
        SHWFS_PSIM((cpt-1)/10*TT, 'SHWFS_input_MAD_geom', [0 0 0 0 0], 0, Tag_params);
    TTresp(cpt) = xyslopes(3,3,1);
end
figure ; plot(0:0.1:4,TTresp,'.-') ; grid on

Tag_params = 0; wbID=0;
for cpt = 1:41
    wbID = wb(cpt,41,wbID);
    [CCDall, xyslopes, wl_eff, C, xyvalid, xyfullill, xyf_of_v, Tag_params, CCDall2] =...
        SHWFS_PSIM((cpt-1)/10*TT, 'SHWFS_input_MAD_diff', [0 0 0 0 0], 0, Tag_params);
    TTresp(cpt) = xyslopes(3,3,1);
end
figure ; plot(0:0.1:4,TTresp,'.-') ; grid on

% change source size in 'SHWFS_input_MAD_diff' to 2 x pixel scale
open SHWFS_input_MAD_diff

Tag_params = 0; wbID=0;
for cpt = 1:41
    wbID = wb(cpt,41,wbID);
    [CCDall, xyslopes, wl_eff, C, xyvalid, xyfullill, xyf_of_v, Tag_params, CCDall2] =...
        SHWFS_PSIM((cpt-1)/10*TT, 'SHWFS_input_MAD_diff', [0 0 0 0 0], 0, Tag_params);
    TTresp(cpt) = xyslopes(3,3,1);
end
figure ; plot(0:0.1:4,TTresp,'.-') ; grid on

% pixel scale measurement

Tag_params = 0; wbID=0;
for cpt = 1:41
    wbID = wb(cpt,41,wbID);
    [CCDall, xyslopes, wl_eff, C, xyvalid, xyfullill, xyf_of_v, Tag_params, CCDall2] =...
        SHWFS_PSIM((cpt-1)/10*TT, 'SHWFS_input_MAD_diff', [0 0 0 0 0], 0, Tag_params);
    TTresp2(:,:,cpt) = CCDall(17:25,17:25);
end
figure ; plot((0:0.1:4)*0.32,squeeze(sum(TTresp2)),'.-') ; grid on

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% more makeIM_PSIM

% invIM
% [CM, S] = invIM(IM,mode_filt,dispID);
[Z2S, pupmask, wl, C, xyvalid_ref, xyfullill, xyf_of_v] =...
    makeIM_PSIM('SHWFS_input_MAD_geom', 512, 'Z', 1:60, 1/10, [0 0 0 0 0 0 0], [0 0 0 0 0 0]);
ficac(Z2S)

S2Z = invIM(Z2S,1,1);

% projection on Zernikes
PS = createPS_PSIM(512, 2, 22, 8/512, 0.2, 0);
[CCDall, xyslopes, wl_eff, C, xyvalid, xyfullill, xyf_of_v, Tag_params, CCDall2] =...
    SHWFS_PSIM(PS/2/pi*0.5, 'SHWFS_input_MAD_geom', [0 0 0 0 0], 1);
tmp = xyslopes(:,:,1) ; S = tmp(xyvalid(:,3)) ; tmp = xyslopes(:,:,2) ; S = [S;tmp(xyvalid(:,3))] ;
fpg(S)

SZ = S'*S2Z ; fpg(SZ)

Z = createZ_PSIM(64,1:60,0,1);
WF = zeros(64,64);
for cpt = 1:60
    WF = WF + SZ(cpt)*Z(:,:,cpt);
end
ficac(WF)

% MAD IM

[IMg, pupmask, wl, C, xyvalid_ref, xyfullill, xyf_of_v] =...
    makeIM_PSIM('SHWFS_input_MAD_geom', 512, 'MAD_IF_SH02', 1:60, 1/10, [0 0 0 0 0 0 0], [0 0 0 0 0 0]);
ficac(IMg)
CM = invIM(IMg,20,1);

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% Closed_loop_PSIM with MAD
% [meas, cmd, SR, psf2, WF_res, DM_shape] = Closed_Loop_PSIM(filename, IMfile, CMfile, PSfile, Turb, wl_im,...
%     SHWFS_PSIM_input, fqcy, delay, gain, Niter, Ctrl_meth, modes_ID, amplitudes, Coeffs, cmd_ref, disp_ID, nb_neighb_SA)

[IM, pupmask, wl, C, xyvalid_ref, xyfullill, xyf_of_v] =...
    makeIM_PSIM('SHWFS_input_MAD_geom', 64, 'MAD_IF_SH02', 1:60, 1/10, [0 0 0 0 0 0 0], [0 0 0 0 0 0]);
write_fits('MAD_IM_test.fits',IM);
CM = invIM(IM,20,1);
write_fits('MAD_CM_test_20.fits',CM);

[PS, D] = createPS_PSIM([64 1024], 2, 22, 8/64, 1, 0);
PS(:,:,2) = createPS_PSIM([64 1024], 2, 22, 8/64, 1, 0, D);
PS(:,:,3) = createPS_PSIM([64 1024], 2, 22, 8/64, 1, 0, D);
write_fits('MAD_PS_test.fits',PS);

[meas, cmd, SR, psf2, WF_res, DM_shape] = Closed_Loop_PSIM('MAD_test_1', 'MAD_IM_test', 'MAD_CM_test_20', 'MAD_PS_test',...
    [5;0.15;0], 2.2,'SHWFS_input_MAD_geom', 383, 3, 0.2, 10:30, 'geom', 'MAD_IF_SH02', 1/10, [0 0 0 0 0], 0, 1, 0);

% multiple layers
[meas, cmd, SR, psf2, WF_res, DM_shape] = Closed_Loop_PSIM('MAD_test_1', 'MAD_IM_test', 'MAD_CM_test_20', 'MAD_PS_test',...
    [5 10 30;0.1 0.20 0.30;0 180 180], 2.2,'SHWFS_input_MAD_geom', 383, 3, 0.2, 10:30, 'geom', 'MAD_IF_SH02', 1/10,...
    [0 0 0 0 0], 0, 1, 0);

% full WF propagation
[meas, cmd, SR, psf2, WF_res, DM_shape] = Closed_Loop_PSIM('MAD_test_1', 'MAD_IM_test', 'MAD_CM_test_20', 'MAD_PS_test',...
    [5;0.15;0], 2.2,'SHWFS_input_MAD_geom', 383, 3, 0.2, 10:30, 'MVM', 'MAD_IF_SH02', 1/10, [0 0 0 0 0], 0, 1, 0);

% without display
[meas, cmd, SR, psf2, WF_res, DM_shape] = Closed_Loop_PSIM('MAD_test_1', 'MAD_IM_test', 'MAD_CM_test_20', 'MAD_PS_test',...
    [5;0.15;0], 2.2,'SHWFS_input_MAD_geom', 383, 3, 0.2, 10:300, 'MVM', 'MAD_IF_SH02', 1/10, [0 0 0 0 0], 0, 0, 0);
fpg(SR)
ficac(psf2)
ficac(log(psf2 - min(psf2(:))+10000))
ficac(cmd)
ficac(meas)

% AOF Closed Loop

[PS, D] = createPS_PSIM([240 1024], 2, 22, 8/240, 1, 0);
write_fits('AOF_PS_test.fits',PS);

K = diag(newVKaiaj4(1:300,1:300,8,1/22,1))';
[IM, pupmask, wl, C, xyvalid_ref, xyfullill, xyf_of_v] =...
    makeIM_PSIM('SHWFS_input_AOF_geom', 240, 'Z', 1:300,...
    K/100, [0 0 0 0 0 0 0], [0 0 0 0 0 0]);
write_fits('AOF_IM_test.fits',IM);
CM = invIM(IM,50,1);
write_fits('AOF_CM_test_50.fits',CM);

[meas, cmd, SR, psf2, WF_res, DM_shape] = Closed_Loop_PSIM('AOF_test_1', 'AOF_IM_test', 'AOF_CM_test_50', 'AOF_PS_test',...
    [5;0.1;0], 2.2,'SHWFS_input_AOF_geom', 1000, 2, 0.2, 10:20, 'geom', 'Z', K/100, [0 0 0 0 0 7 7], 0, 1, 0);

[meas, cmd, SR, psf2, WF_res, DM_shape] = Closed_Loop_PSIM('AOF_test_1', 'AOF_IM_test', 'AOF_CM_test_50', 'AOF_PS_test',...
    [5;0.1;0], 2.2,'SHWFS_input_AOF_geom', 1000, 2, 0.3, 10:20, 'MVM', 'Z', K/100, [0 0 0 0 0 7 7], 0, 1, 0);

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%


