!+++++++++++++++
! copy the astrometric descriptors from one file (table) to another
! (image), to improve their portability... 
!---------------
defi/par p1 ? C "input?"
defi/par p2 ? C "output?"
defi/loc intab/c/1/72 XOX
defi/loc outima/c/1/72 OXO
defi/loc i/i/1/1 0

astro/checkfile {p1} .tbl softcheck
if outputi .eq. 0 then
  astro/checkfile {p1} .bdf check
endif
intab = outputc

astro/checkfile {p2} .bdf softcheck
if outputi .eq. 0 then
  astro/checkfile {p2} .tbl check
endif
outima = outputc

!
!- pos1 descriptors:
!
i = m$existd(intab,"EPO_PLA")
if i .gt. 0 then
   writ/out "copying astrometric calibr"
   copy/dd {intab} EPO_PLA {outima} EPO_PLA 
   writ/dhe {outima}  EPO_PLA "POS1: Plate epoch "
   copy/dd {intab} EPO_CAT {outima} EPO_CAT
   writ/dhe {outima}  EPO_CAT "POS1: Ref epoch "
   copy/dd {intab} FLAGS {outima} FLAGS
   writ/dhe {outima}  FLAGS "POS1: Schmidt plate? LS blink? "
   copy/dd {intab} SIG {outima} SIG
   writ/dhe {outima}  SIG "POS1: meas. tol. "
   copy/dd {intab} TERMS {outima} TERMS
   writ/dhe {outima}  TERMS "POS1: transfo.terms "
   copy/dd {intab} BX {outima} BX
   writ/dhe {outima}  BX "POS1: X transfo matrix "
   copy/dd {intab} BY {outima} BY
   writ/dhe {outima}  BY "POS1: Y transfo matrix "
   copy/dd {intab} CX {outima} CX
   writ/dhe {outima}  CX "POS1: X cst term "
   copy/dd {intab} CY {outima} CY
   writ/dhe {outima}  CY "POS1: Y cst term "
   copy/dd {intab} NX {outima} NX
   writ/dhe {outima}  NX "POS1: # of terms for X transfo"
   copy/dd {intab} NY {outima} NY
   writ/dhe {outima}  NY "POS1: # of terms for Y transfo "
   copy/dd {intab} AL_DE0 {outima} AL_DE0
   writ/dhe {outima}  AL_DE0 "POS1: RA,DEC of center "
endif

!
!- Centering
!
i = m$existd(intab,"START_S")
if i .gt. 0 then
   writ/out "copying  START_S"
   copy/dd {intab} START_S {outima} START_S
   writ/dhe {outima} START_S "Value of START for star registering"
endif
i = m$existd(intab,"AD_COM")
if i .gt. 0 then
   writ/out "copying  AD_COM"
   copy/dd {intab} AD_COM {outima} AD_COM
   writ/dhe {outima} AD_COM "Computed comet position (RA,Dec)"
endif
i = m$existd(intab,"AD_REF")
if i .gt. 0 then
   writ/out "copying  AD_REF"
   copy/dd {intab} AD_REF {outima} AD_REF
   writ/dhe {outima} AD_REF "Reference position (RA,Dec)"
endif
i = m$existd(intab,"P1_COMMENT")
if i .gt. 0 then
   writ/out "copying  P1_COMMENT"
   copy/dd {intab} P1_COMMENT {outima} P1_COMMENT
endif
i = m$existd(intab,"P1_STAR")
if i .gt. 0 then
   copy/dd {intab} P1_STAR {outima} P1_STAR
   writ/out "copying  P1_STAR"
   writ/dhe {outima} P1_STAR "position of ref in frame"
endif
i = m$existd(intab,"P1_COMET")
if i .gt. 0 then 
   writ/out "copying  P1_COMET"
   copy/dd {intab} P1_COMET {outima} P1_COMET
   writ/dhe {outima} P1_COMET "position of comet in frame"
endif
i = m$existd(intab,"START_OR")
if i .gt. 0 then
   writ/out "copying  START_OR"
   copy/dd {intab} START_OR {outima} START_OR
   writ/dhe {outima} START_OR "original START"
endif
i = m$existd(intab,"STEP_OR")
if i .gt. 0 then
   writ/out "copying  STEP_OR"
   copy/dd {intab} STEP_OR {outima} STEP_OR
   writ/dhe {outima} STEP_OR "original STEP"
endif

!
!- TIME
!

i = m$existd(intab,"JD")
if i .gt. 0 then
   writ/out "copying  JD"
   copy/dd {intab} JD {outima} JD
   writ/dhe {outima} JD "Julian Day Start of Expo"
else
   i = m$existd(intab,"o_time")
   if i .gt. 0 then
      writ/out "copying  O_TIME(5)->UT"
      writ/des {outima} UT/d/1/1 {{intab},o_time(5)}
      writ/dhe {outima} UT "(5)=UTstart"
   endif
endif

