! @@ photom image
!
! perform quick and dirty photometric calibration of an image
! using the USNO-A1 stars used to calibrate that image astrometrically
!
!USAGE
! 1- calibrate the image with astro/auto
! 2- @@ photom
!----
defi/loc inima/c/1/72 {p1}
defi/loc intab/c/1/72 oxoxo
defi/loc zploc/d/1/1 0.

defi/loc zp/d/1/1 0
defi/loc lin/d/1/1 0
defi/loc zps/r/1/1 0
defi/loc lins/r/1/1 0
defi/loc w/r/1/2 0.,0.
defi/loc iselnew/i/1/1 0
defi/loc iselold/i/1/1 0
defi/loc icount/i/1/1 0
defi/loc ijunk/i/1/1 0

defi/loc i/i/1/1 0
astr/checkfile {inima} .bdf check naked
intab = outputc//"_usno.tbl"

astr/checkfile {intab} .tbl softcheck extn
if outputi .eq. 0 then
	ijunk = m$index(intab,"_usno")-2
	intab = "{intab(1:{ijunk})}_usno.tbl"
	astr/checkfile {intab} .tbl check extn
endif

!- define the boxes and measure inst. magnitudes

comp/tab {intab} :xstart = :xcen -10.
comp/tab {intab} :ystart = :ycen -10.
comp/tab {intab} :xend   = :xcen +10.
comp/tab {intab} :yend   = :ycen +10.

sele/tab {intab} :std.eq.1 .and. :icent.ge.5000. .and.:icent.le.40000.
comp/tab {intab} :photstd = sel

sele/tab {intab} :photstd .eq. 1
iselold = {{intab},tblcontr(10)}

magn/cir {inima},{intab} {intab} @12,@3,@3



!- compute the ZPoint

!- start the iteration

again:

comp/tab {intab} :zpoint = :mag_r - :magnitude
sele/tab {intab} :photstd.eq.1
stat/tab {intab} :zpoint

zp = outputr(3)
zps = outputr(4)

set/for f6.3,f6.3
wri/out "zp= {zp} +/- {zps}  "

writ/out "Iteration: {icount}"
comp/tab {intab} :magdelt = :mag_r -{zp} -:magnitude

plot/axe 12,20 -2,2
set/grap color=2
sele/tab {intab} :std .eq. 1
over/tab {intab} :mag_r :magdelt
set/grap color=1
sele/tab {intab} :photstd.eq.1
over/tab {intab} :mag_r :magdelt

w(1) = zps*2. 
w(2) = zps* (-2.)

sele/tab {intab}  :photstd.eq.1 .and. :magdelt.le.{w(1)} .and. :magdelt.ge.{w(2)}
comp/tab {intab} :photstd = sel
sele/tab {intab} :photstd .eq. 1
iselnew = {{intab},tblcontr(10)}

if iselnew .lt. iselold .and. icount .le. 5 then
	iselold = iselnew
	icount = icount +1
	goto again
endif

zploc = {zp} -2.5* m$log10( {{inima},o_time(7)} )

writ/out "Zero point: {zp} - red. to 1sec: {zploc}"


writ/des {intab} zeropt/r/1/1 {zp}
writ/des {intab} zerloc/r/1/1 {zploc}
writ/des {inima} zeropt/r/1/1 {zp}
writ/des {inima} zerloc/r/1/1 {zploc}
