!+++++++++++++++
!.file          residual.prg
!.purpose       POS1 astrometric package
!               plots the xy residual of the standard stars, and ask
!               for the ones to be deleted.
!.VersionC #Version: Sat Sep 17 19:16:43 1994
!.Author        OR Hainaut
!---------------
defi/par p1 ppm ? "Standard file "
defi/par p2 N ? "Plot?"
defi/par p3 nil ? "residual scale? pix/arcsec"
defi/par p4 nil ? "just display?"
defi/loc i/i/1/1 0
defi/loc iw/i/1/1 0
defi/loc w/r/1/2 0.,0.
defi/loc w1/r/1/1 0.

defi/loc conv/r/1/1 0.

astro/checkfile {p1} .tbl check
defi/loc intab/c/1/72 {outputc}


!--plot the std stars
sele/tab {intab} :std .eq. 1  | $cat > /dev/null
if p2 .eq. "G" .or. p2 .eq. "g" then
  set/grap color=1 stype=2 frame=square
  plot/tab {intab} :r_a :dec
  set/grap color=2 stype=1

  stat/tab {intab} :xerr
  outputr(1) = -outputr(1)
  if outputr(1) .ge. outputr(2) then
     w1 = outputr(1)
  else
     w1 = outputr(2)
  endif

  stat/tab {intab} :yerr
  outputr(1) = -outputr(1)
  if outputr(1) .ge. w1   w1 = outputr(1)
  if outputr(2) .ge. w1   w1 = outputr(2)

  stat/tab {intab} :r_a
  w = m$abs(outputr(2)-outputr(1))

  !--draw the residuals
  !  I'm sure that a MIDAS guru could make this 10 times nicer and 100x faster
  do i = 1 5
    comp/tab {intab} wx = :r_a + :xerr*{w}/100./{w1}*{i}
    comp/tab {intab} wy = :dec + :yerr*{w}/250./{w1}*{i}
    sel/tab {intab} :std .eq. 1
    over/tab {intab} :wx :wy
  enddo
  set/grap color=1 stype=2

  !--label the stars
  ! same remark...
  stat/tab {intab} :r_a
  w1 = (outputr(2)-outputr(1))/50.
  iw = {{intab},TBLCONTR(4)}
  set/form i1
  do i = 1 {iw}
    if {{intab},:std,@{i}} .eq. 1 then
      w(1) = {{intab},:R_a,@{i}}-w1
      w(2) = {{intab},:dec,@{i}}-w1
      label/grap {i} {w(1)},{w(2)}
    endif
  enddo
  set/form
endif


!-- DISPLAY


if p2 .eq. "D" .or. p2 .eq. "d" then

  if p3 .eq. "nil" then
    stat/tab {intab} :xerr
    conv = {outputr(2)}
    stat/tab {intab} :yerr
    if outputr(2) .ge. conv then
      conv = outputr(2)
    endif
    conv = {{idimemc},npix(1)}/10./conv
    writ/out "Scale factor: {conv} pix/arcsec"
  else
    conv = {p3}
  endif

!  assi/gra d,0
!  plot/axe
  cle/ch ov 

  comp/tab {intab} :xstart = :xcen
  comp/tab {intab} :ystart = :ycen
  comp/tab {intab} :xend = :xcen + :xerr*{conv}
  comp/tab {intab} :yend = :ycen + :yerr*{conv}
  crea/col {intab} :iw ? ? i*4  | $cat > /dev/null
  comp/tab {intab} :iw = seq


  sele/tab {intab} :std .eq. 1  | $cat > /dev/null
  load/tab {intab} :xcen :ycen :iw ? 4 4
  sele/tab {intab} :std .ne. 1  | $cat > /dev/null
  load/tab {intab} :xcen :ycen :iw ? 3 3

  sele/tab {intab} :std .eq. 1  | $cat > /dev/null
  copy/tab {intab} wjunk
  dra/line wjunk ? ? 3


endif
!
!


if p4 .eq. "DONTASK" return

!-- Delete/undelete stars

delete:
inqu/key i "Star to be deleted/restored? (0 to exit)"
if i .le. 0 return
if i .gt. {{intab},tblcontr(4)} then
  write/out "*error* {i}: no such star (hint: you have to enter the"
  write/out "        sequencial number of the star, not its identifier"
  goto delete
  endif

if {{intab},:std,@{i}} .eq. 2 then
  writ/tab {intab} :std @{i} 1
else
  writ/tab {intab} :std @{i} 2
endif

goto delete
