
!
!    @@ pos1b  mes option outputtab flag
!or  @@ pos1b  mes option coordinates
!   
!  mes: table containing the measurements; must have the 
!       descriptors generated by pos1a. The table data is used only
!       for opt. 1 and 2.
!  option:
!       (1) Calculate (A,D) for plate center and several (X,Y)-values'/ 
!                input from table
!       (2) Calculate (A,D) for several (X,Y)-values only'/ 
!                input from table
!       (3) Calculate (A,D) for one (X,Y)-value'/ 
!                input from parameter line
!       (4) Calculate (X,Y) for one (A,D)-position'/
!           and stores XY in outputr 1&2
!                input from parameter line
!       (5) Calculate (X,Y) for several (A,D)s in disc file'/
!                input from an ascii file in old pos1 format
!
!  if option=1 or 2, outtab = output table
!                    flag: Y for trailed objects
!  if option=3, input=x,y
!               output stored in 
!                   rah, ram, ras, dsig, dd, dm, ds
!                   i1   i2   d1   c(2:2) i3 i3  d2
!               with i4 meaning outputi(4)
!                    d2         outputd(2)
!                    c(2:2)     outputc(2:2)!
!  if option = 4: coordinates = coordinate string eg 12,02,49,-45,01,23
!
!

defi/par p1 cernis ? "Measurement file "
if p1 .eq. "??" then
 write/out "@@ pos1b mes option output trail"
 write/out "(1) Calculate (A,D) for plate center and several (X,Y)-values"
 write/out "(2) Calculate (A,D) for several (X,Y)-values only"
 write/out "(3) Calculate (A,D) for one (X,Y)-value"
 write/out "(4) Calculate (X,Y) for one (A,D)-position"
 write/out "(5) Calculate (X,Y) for several (A,D)s in disc file"
 return
 endif
defi/par p2 2 n "Option?"
defi/par p3 pos1 ? "Output table?"
defi/par p4 N ? "Flag"

defi/loc IN_MES/c/1/72 {p1}
defi/loc OPT/i/1/1 {p2}


if opt .eq. 3 then
   defi/loc in_coor/d/1/2 {p3}
else ; if opt .eq. 4 then
  defi/loc in_coor/d/1/6 {p3}
else
  defi/loc out_mes/c/1/16 {p3}
endif ; endif

defi/loc flag/c/1/1 {p4}


!- finds the poch
defi/loc iex/i/1/1 0
writ/key midEp/d/1/1 -999.d0

set/form f20.14,f20.14
iex = m$existd(in_mes,"o_time")
if iex .gt. 0 then
  midEp = {{in_mes},o_time(4)} + 0.5* {{in_mes},o_time(7)}/86400.
endif

!- is there a magnitude thatI should write in the output?
iex = m$existk("pos1mag")
if iex .eq. 0 then
   writ/key pos1mag/r/1/1 99.
endif

iex = m$index(in_mes,"_xy")
if iex .gt. 0 then
   defi/loc wc/c/1/72 oxo
   iex = iex-1
   wc = "{in_mes(:{iex})}.bdf"
   iex = m$exist(wc)
   if iex .gt. 0 then
     iex = m$existd(wc,"o_time")
     if iex .gt. 0 then
       ! correction for midexp
       midEp = {{wc},o_time(4)} + 0.5* {{wc},o_time(7)}/86400.
     endif
   endif
endif

! correction mjd->jd
midEp = midEp + 2400000.5d0


!wri/out "mid exp: {midep}" 


run MID_WORK:pos1b.exe

if opt .eq. 3 then
   set/for f6.3,f6.3 i2
!!   writ/out {outputi(1)},{outputi(2)},{outputd(1)}, {outputc(1:2)}{outputi(3)},{outputi(4)},{outputd(2)}  " <-- " {in_coor(1)},{in_coor(2)}
!!   writ/out " <-- " {in_coor(1)},{in_coor(2)}
endif


