/*++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
.IDENTIFICATION http-get.c
.LANGUAGE       C
.AUTHOR         M. Albrecht [ESO Archive]
.ENVIRONMENT    Unix,WWW
.KEYWORDS       HTTP

.VERSION  1.0   24-Oct-1995 Creation.

.COMMENTS       Plain C example of an HTTP client GET method.
----------------------------------------------------------------------*/

#include	<stdio.h>
#include	<string.h>
#include	<sys/types.h>
#include	<sys/socket.h>
#include	<netinet/in.h>
#include	<arpa/inet.h>
#include	<netdb.h>

int debug = 0;

main(argc, argv)
int	argc;
char	*argv[];
{
	int			sockfd, port;
	struct sockaddr_in	serv_addr;
	char			*file, host[4096], get[4096];
	struct hostent 		*addr;

	if ( argc != 2 ) {
		fprintf(stderr, "Usage: %s <URL>\n", argv[0]);
		exit(1);
	}

	if ( !parse_url(argv[1], host, &port, get) ) {
		fprintf(stderr, 
			"Can't parse URL or protocol not supported.\n");
		exit(1);
	}

	if( !(addr = gethostbyname(host)) ){
	     perror("Can't resolve host address");
	     exit(1);
	}

	/*
	 * Fill in the structure "serv_addr" with the address of the
	 * server that we want to connect with.
	 */

	memset((char *) &serv_addr, '\0', sizeof(serv_addr));
	memcpy(&serv_addr.sin_addr,
	       addr->h_addr_list[0], addr->h_length);
	serv_addr.sin_family = AF_INET;
	serv_addr.sin_port   = htons(port);
     
	/*
	 * Open a TCP socket (an Internet stream socket).
	 */
	
	if ( (sockfd = socket(AF_INET, SOCK_STREAM, 0)) < 0) {
	     perror("Can't open local stream socket");
	     exit(1);
	}

	/*
	 * Connect to the server.
	 */

	if (connect(sockfd, (struct sockaddr *) &serv_addr,
		    sizeof(serv_addr)) < 0) {
		perror("Can't connect to server");
		exit(1);
	}

	/*
	 * set the default document to doc root 
	 */
	file = (*get)? get : "/";
	http_get(file, sockfd);		/* do it all */

	close(sockfd);
	exit(0);
}

/*
 * Send a GET method request to httpd on already opened socket;
 * then read and skip http header (ends with a blank line) and
 * then read the file from the socket and write it to stdout.
 */

#define	MAXLINE	512
#define	BUFSIZE	4096

http_get(file, sockfd)
register char	*file;
register int	sockfd;
{
	int	n, flength = 0;
	char	sendline[MAXLINE], recvline[MAXLINE + 1], buffer[BUFSIZE];
	char	type[BUFSIZE];

	/* send the GET method */
	sprintf(sendline, "GET %s HTTP/1.0\nUser-Agent: http-get\n\n", file);
	n = strlen(sendline);
	if (writen(sockfd, sendline, n) != n) {
	     perror("writen error on socket");
	     exit(1);
        }

	flength = 0;
	/* parse the http header: ends with a blank line */
	while ( (n = readline(sockfd, recvline, MAXLINE)) > 1 ) {
	     fwrite(recvline, n, 1, stdout);
	     /* get the length of the document */
	     if(strstr(recvline, "Content-length:")) 
	       flength = atoi(&recvline[15]);
	     /* and the mime type */
	     else if(strstr(recvline, "Content-type:")) {
	       strncpy(type, strtok(recvline+14, "\n"), sizeof(type)-1);
	       printf("Url: %s\n", file);
	       break;
	     }
        }
	fflush(stdout);

	/* now read the file from socket and write it to stdout */
	while ( (n = read(sockfd, buffer, BUFSIZE)) > 0 ) {
	    fwrite(buffer, n, 1, stdout);
	    flength -= n;
	}
	if(flength > 0)
	    fprintf(stderr, 
		    "Incomplete GET: %d bytes missing.\n", flength);

}
/*
 * Read a line from a descriptor.  Read the line one byte at a time,
 * looking for the newline.  We store the newline in the buffer,
 * then follow it with a null (the same as fgets(3)).
 * We return the number of characters up to, but not including,
 * the null (the same as strlen(3)).
 */

int
readline(fd, ptr, maxlen)
register int	fd;
register char	*ptr;
register int	maxlen;
{
	int	n, rc;
	char	c;

	for (n = 1; n < maxlen; n++) {
		if ( (rc = read(fd, &c, 1)) == 1) {
			*ptr++ = c;
			if (c == '\n')
				break;
		} else if (rc == 0) {
			if (n == 1)
				return(0);	/* EOF, no data read */
			else
				break;		/* EOF, some data was read */
		} else
			return(-1);	/* error */
	}

	*ptr = 0;
	return(n);
}
/*
 * Write "n" bytes to a descriptor.
 * Use in place of write() when fd is a stream socket.
 * This is needed because of socket latency.
 */

int
writen(fd, ptr, nbytes)
register int	fd;
register char	*ptr;
register int	nbytes;
{
     int	nleft, nwritten;
     
     nleft = nbytes;
     while (nleft > 0) {
	  nwritten = write(fd, ptr, nleft);
	  if (nwritten <= 0)
	    return(nwritten);		/* error */
	  
	  nleft -= nwritten;
	  ptr   += nwritten;
     }
     return(nbytes - nleft);
}

/* 
 * Parse a given URL into host, optional port, get_string
 * Only protocol supported is http (no ftp, file, etc).
 * Default port is 80
 * Return 1 upon error (unparseable)
 */
int parse_url(url, host, port, get)
char *url, *host, *get;
int *port;
{
    *get = *host = '\0';
    *port = 80;

    if (sscanf(url, "http://%31[^:/]:%d%1000s", host, port, get) != 3 &&
	sscanf(url, "http://%31[^/]%10000s", host, get) < 1) {
	return(0);
    }
    
    return(1);
}
