      SUBROUTINE MEAN(XTEMP,YTEMP,IX,XMEAN,YMEAN,NKICK,RESA,SIG) 

C
C MEAN computes mean values of (X,Y) measurements of the same object.
C If there are more than 2 measurements, the R.M.S. values of X, Y
C and R (=SQRT(X**2+Y**2)) are also returned in RESA(3).
C if R.M.S. (R) is larger than SIG, then the (X,Y) with the
c largest residual is removed. This process is continued until
C R.M.S. (R) < SIG, or if there are only 2 measurements left.
C
C A reasonable value is SIG = 5.0 microns
C
      IMPLICIT REAL*8 (A-H,O-Z), INTEGER*4 (I-N)
      DIMENSION XTEMP(20),YTEMP(20),RESA(3)

      NKICK = 0 
   10 RESX = 0 !<-- comes back here from the end
      RESY = 0
      RESD = 0
      XMEAN = 0 
      YMEAN = 0 

      do I = 1,IX
         XMEAN = XMEAN + XTEMP(I)
   20    YMEAN = YMEAN + YTEMP(I)
      enddo

      XMEAN = XMEAN/IX
      YMEAN = YMEAN/IX

      IF(IX.LE.2) GO TO  60 

      do I=1,IX
         RESX = RESX+(XMEAN-XTEMP(I))**2 
         RESY = RESY+(YMEAN-YTEMP(I))**2 
   30    RESD = RESD+((XMEAN-XTEMP(I))**2+(YMEAN-YTEMP(I))**2) 
      enddo

      RESX = SQRT(RESX/(IX**2-IX))
      RESY = SQRT(RESY/(IX**2-IX))
      RESD = SQRT(RESD/(IX**2-IX))

      IF(RESD.LT.SIG) GO TO  60 

      DIFF = 0

C
C NOW FIND THE WORST (X,Y) AND REMOVE IT
C
      do I=1,IX
         DIF = SQRT((XMEAN-XTEMP(I))**2+(YMEAN-YTEMP(I))**2) 
         IF(DIF.LT.DIFF) GO TO 40
         IKICK = I 
         DIFF = DIF
 40   enddo

C
C CLOSE THE RANKS
C
      do  I = IKICK, IX
         XTEMP(I) = XTEMP(I+1) 
   50    YTEMP(I) = YTEMP(I+1) 
      enddo

      IX = IX-1 
      NKICK = NKICK + 1 
      GO TO 10


C The End
   60 RESA(1) = RESX
      RESA(2) = RESY
      RESA(3) = RESD
      RETURN
      END 





