! POS1 astrometric package
!
! @@ get_usno RA DEC field out_table [server_type]
!
! PURPOSE
!   get the USNO-A1 astrometric standard stars for a given field
!
! USE
!   RA DEC, center of the field in deg
!   field, size of the field, in arcmin
!   out_table, output midas table.
!   server_type: G for Garching-like, T for Telescope-like
!
! VERSION
! ohainaut 2000-dec-12  fixed cleaning for 1st star
! ohainaut 2000-feb-2  cleaned and updated for new servers
! ohainaut 1998-xxx-x  birth and youth.
!-----------------------------------------------------------------------------

defi/par p1 ? ? "field center RA deg"
defi/par p2 ? ? "field center Dec deg"
defi/par p3 ? ? "field size"
defi/par p4 ? ? "output table"
defi/par p5 G C "server type G/T"

wri/out {p1} {p2}


defi/loc usserv/c/1/72 "http://archive.eso.org/skycat/servers/usnoa_res"
!defi/loc usserv/c/1/72 "http://wg5ops:8760/servers/usnoa-server"

defi/loc http_cli/c/1/72 "$MID_WORK/http-get"



defi/loc urlque/c/1/256 oxoxo
defi/loc raque/r/1/1 {p1}
defi/loc decque/r/1/1 {p2}
defi/loc decquec/c/1/72 {p2}


set/for f9.5
if {decque} .ge. 0 then
       decquec = "+"//"{decque}"
else
       decquec = "{decque}"
endif

defi/loc w/d/1/2 0.,0.


if "{P5}" .eq. "T" then
   urlque = "?{raque}{decquec}&radius=0,{p3}&format=2"
else
   raque = raque/15.   
   urlque = "?ra={raque}&dec={decquec}&radmax={p3}&format=2"
endif

writ/out "calling USNO-A server on {usserv(8:18)}..."

writ/out  {http_cli} "{usserv}{urlque}"

$ rm -f w_usno.html w_usno.dat w_usno.fmt
$ touch w_usno.fmt
$ {http_cli} "{usserv}{urlque}" >w_usno.html
writ/out "cleaning the results"
!!$ $MID_WORK/get_usno_clean 

$$ /bin/rm -f w_usno.dat w_usno.fmt
$$ grep U w_usno.html | grep _ | grep -v Server  |awk 'BEGIN{FS="</b>"}{print $1$2}'| grep -v b> w_usno.dat


$ touch w_usno.fmt

if P5 .eq. "T" then
 $ echo "defi/fie 15 24 D  f9.5  :r_a" >> w_usno.fmt
 $ echo "defi/fie 26 34 D  f9.5 :dec" >> w_usno.fmt
 $ echo "defi/fie 36 39 r  f4.1 :mag_r" >> w_usno.fmt
 $ echo "defi/fie 41 44 r  f4.1 :mag" >> w_usno.fmt
else
 $ touch w_usno.fmt
 $ echo "defi/fie 21 29 D  f9.5  :r_a" >> w_usno.fmt
 $ echo "defi/fie 31 39 D  f9.5 :dec" >> w_usno.fmt
 $ echo "defi/fie 41 44 r  f4.1 :mag_r" >> w_usno.fmt
 $ echo "defi/fie 46 49 r  f4.1 :mag" >> w_usno.fmt
endif

cre/tab {p4} 4 999 w_usno.dat  w_usno.fmt
name/col {p4} :r_a    ? ? R12.7   
name/col {p4} :dec ? ? s12.6     
name/col {p4} :mag_r ? ? f4.1
name/col {p4} :mag ? ? f4.1    
crea/col {p4} :w "junk"  I5 I
comp/tab {p4} :w = seq
comp/tab {p4} :ppm = tochar(:w)
comp/tab {p4} :ident = :ppm
dele/col {p4} :w
comp/tab {p4} :pma = 0.
comp/tab {p4} :pmd = 0.


!read/tab {p4}
