C     revJD.f
C     converts a JD into a calendar date
C     from J.Meeus
c
C     input: JD (R*8)
C     output: Year (I), Month (I), Day (r*8)
C

      subroutine revJD(JD,year,month,day)

      implicit none

      real*8 JD, f , E
      integer Z, A,B,C,D, alpha
      integer Year, Month
      real*8 Day

      z = int(JD+.5d0)
      f = JD+ .5d0 - z

      if ( Z .lt. 2 299 161) then
         A = Z

      else
      
         alpha =
     $        int((z - 1 867 216.25d0)/ 36 524.25d0)

         A = Z + 1 + alpha - int(alpha/4.d0)

      endif

      B = A+ 1524
      C = INT( (B - 122.1)/365.25)
      D = INT(365.25* C)
      E = INT( (B-D)/30.6001 )
      
      Day = B -D -INT( 30.6001*E)+F
      
      if (E .gt. 13.5) then
         Month = int(E-13.)
      else
         Month = int(E-1.)
      endif

      if (Month .gt. 2.5) then
         Year = C-4716
      else
         Year = C-4715
      endif

c      write(6,*) JD,year,month,day
   
      return
      end
