!	 astro_final.prg
!	 @@ castro_final obj.cat
!	 INCAT : images containing object to be astrometrised
!	 PURPOSE : calculate x,y -> alpha delta fo ra catalog
!	 CASE OF FRAMES NOT ALIGNED FOR PHOTOMETRY
!	 or NO PHOTOMETRY TABLE
!	 .version Wed Jul 11 15:48:55 2001 included in Pos1 packg
!	 .creation 2001-01-23 by Lara
!	 .history
!                2001-01-23 by Lara
!-----------------------------------------------------------------



DEFI/PAR p1 ? C " input catalog >"
DEFI/PAR p2 ? C " Name of .bdf file used for astrom. calibr. >"
DEFI/PAR p3 ? ? " Rough INTEGER coordinates of objects: x,y > " 

DEFI/LOC param2/c/1/20 {p2}
DEFI/LOC xyframe/I/1/2 {p3}

DEFI/LOC catal/i/1/1 0
DEFI/LOC image/c/1/25 " "
DEFI/LOC imname/c/1/25 " "
DEFI/LOC cgaussTab/c/1/25 " "
DEFI/LOC astrotab/c/1/25 " "
DEFI/LOC len/i/1/1 0
DEFI/LOC endname/i/1/1 0
DEFI/LOC xobj/r/1/1 1.
DEFI/LOC yobj/r/1/1 1.

defi/loc OPT/i/1/1 3 !! option for pos1b
defi/loc out_mes/c/1/16 junk !! needed (?) by pos1b
defi/loc flag/c/1/1 N  !! flag for pos1b
defi/loc pos1mag/r/1/1 99. !! magnitude for pos1b
defi/loc midEp/d/1/1 -99. !! mid-exposure for pos1b
defi/loc in_coor/d/1/2 -9999,-9999


$ rm -f castro_final.out
$ touch castro_final.out 

set/for f15.9,f15.9 !!! needed to pass info to pos1




! det name of astro table from bdf input filename
	endname = m$index(param2,".bdf") - 1
	if endname .lt. 0 then 
		astrotab = "{param2}_xy.tbl" 
	else 
	     imname = param2(1:{endname})
             astrotab = "{imname}_xy.tbl"
        endif

	defi/loc IN_MES/c/1/72 {astrotab} !! pass the name of the ref table to Pos1b.exe


cat_loop:

	 STORE/FRAME image {p1} 1 fini
	
	 writ/out "-----------------------------"
	 writ/out " Frame {image}"
	 writ/out "-----------------------------"
	 
	 cl/ch ov
!!	 kload {image} -1,15 sc=1 ce={xyframe(1)},{xyframe(2)} | $ cat - > /dev/null
	 load {image} cu=f,i sc=1 ce={xyframe(1)},{xyframe(2)} | $ cat - > /dev/null
	 cen/gauss ? cgaussTab	

	 xobj = {cgaussTab,:xcen,@1}
	 yobj = {cgaussTab,:ycen,@1}
	 in_coor(1) = xobj
	 in_coor(2) = yobj

	 ! mid-exp julian day
	 midEp = {{image},o_time(7)}/2.d0/86400.d0 +  {{image},o_time(4)} + 2400000.5d0
	$ rm -f w_pos1b.out
	run MID_WORK:pos1b.exe | $ grep ESO0000 > w_pos1b.out
	$ cat w_pos1b.out
	$ cat w_pos1b.out >> castro_final.out


GOTO cat_loop
fini:

writ/out "=============================================================================="
writ/out "=summary of {p1} using {p2} as ref:"
$ cat castro_final.out
!!!! $ sort castro_final.out
writ/out "===============================================castro/final done=============="


