c----------------------------------------------------------------------
      SUBROUTINE ADXY(A0,D0,XEST,YEST,NITER,INEX,COSD0,SIND0,ALFA0,
     *NX,NY,KK,IXY,IDX,IDY,BX,BY,CX,CY,SCHMIDT)
c
c     Pos1 astrometric package
c     ADXY converts (RA,Dec) into plate XY
C     inversion of the plate transformation is done in an iterative way
C     #Version: Wed Feb  1 16:49:27 1995
c----------------------------------------------------------------------
      IMPLICIT REAL*8 (A-H,O-Z), INTEGER*4 (I-N)

      DIMENSION A0(3),D0(3),D0A(3),AR(10101,4),BX(9),BY(9),
     * XEST(2,2),YEST(2,2),X(10),KK(9),IDX(9),IDY(9)
      CHARACTER*1 SCHMIDT

      PI = 4.0D0*DATAN(1.0D0)
      DOPI18 = PI/1.8D2
      DO0 = 0.0D0
      DO1 = 1.0D0
      DO60 = 6.0D1
      DO3600 = 3.6D3
      NITER = 0 
      INEX = 0

*     Conversion RA
      ALFAS = (A0(1)+A0(2)/DO60+A0(3)/DO3600)*1.5D1*DOPI18
      IF (ALFA0.lt.pi/2D0.and.alfas.gt.1.5d0*PI) ALFAS = ALFAS-2D0*PI 
      IF (ALFA0.gt.1.5d0*PI.and.alfas.lt.pi/2D0) ALFAS = ALFAS+2D0*PI 

*     Conversion Dec
      RH = DO1
      do 20 I = 1,3 
         if (D0(I).lt.DO0) RH = -DO1 
   20    D0A(I) = dabs(D0(I))
      DELTS = RH*(D0A(1)+D0A(2)/DO60+D0A(3)/DO3600)*DOPI18


      COSRH = COSD0*dcos(DELTS)*dcos(ALFAS-ALFA0) + SIND0*dsin(DELTS) 
      SINRH = dsqrt(DO1-COSRH**2) 
      SINPH = dcos(DELTS)*dsin(ALFAS-ALFA0)/SINRH 
      COSPH = (dsin(DELTS)-SIND0*COSRH)/(COSD0*SINRH)

      IF (SCHMIDT.EQ.'Y') THEN 
          RH = DATAN(SINRH/COSRH)
      else
          RH = SINRH/COSRH
      endif 

      AKSI = RH*SINPH/DOPI18
      ANU = RH*COSPH/DOPI18 

      XEST(1,1) = ((AKSI-CX)*BY(2)-(ANU-CY)*BX(2))/ 
     *     (BX(1)*BY(2)-BX(2)*BY(1)) 
      YEST(1,1) = ((AKSI-CX)*BY(1)-(ANU-CY)*BX(1))/ 
     *     (BX(2)*BY(1)-BX(1)*BY(2)) 

*     *start iteration
 30   XEST(2,1) = XEST(1,1)*1.0D3 
      YEST(2,1) = YEST(1,1)*1.0D3 

*     *diverge?
      if (dabs(XEST(2,1)).gt.2.0d5.or.dabs(YEST(2,1)).GT.2.0D5) 
     >     then
 9050    FORMAT(/,1X,'*error*ADXY9050: computed (X,Y):',2(F12.2),/
     >        1X,'position diverging outside plate area. sorry')
         INEX = 1
         return
      endif
      write(6,*) xest(2,1),yest(2,1)
      if (niter.ge.100)then
         write(6,9051)
 9051    format(' *error*ADXY9051: not converging after 100 iter.')
         inex = 1
         return
      endif
          
   60 NITER = NITER + 1 

   70 AR(1,1) = XEST(1,1) 
      AR(1,2) = YEST(1,1)
      AR(1,3) = DO0 
      AR(1,4) = DO0 
C      I16 = 1 

c     *x
      N = NX+1
      IXY = 1 
c      CALL RAR(I16,0,N,KK,IXY,IDX,IDY,X,AR) 
      CALL RAR(1,0,N,KK,IXY,IDX,IDY,X,AR) 
      L = NX
      V = DO0 
      do 80 I17 = 1,L 
 80      V = V + BX(I17)*X(I17)
      AKSI1 = V + CX

c     *y
      N = NY + 1
      IXY = 2 
c      CALL RAR(I16,0,N,KK,IXY,IDX,IDY,X,AR) 
      CALL RAR(1,0,N,KK,IXY,IDX,IDY,X,AR) 
      L = NY
      V = DO0 
      DO 90 I17 = 1,L 
   90   V = V + BY(I17)*X(I17)
      ANU1 = V + CY

*     how far from the requested position?
      DKSI = AKSI1 - AKSI 
      DNU = ANU1 - ANU
      DDIST = DSQRT(DKSI**2 + DNU**2) 
      DCRIT = 1.0D-6
c      DCRIT = 1.0D6 ! always return...
      IF (DDIST.LE.DCRIT ) return

*     too far... let's improve
*     -- d(ksi)/dx
      N = NX + 1
      IXY = 1 
      CALL RAR(1,1,N,KK,IXY,IDX,IDY,X,AR) 
      L = NX
      V = DO0 
      DO 110 I17 = 1,L
  110   V = V + BX(I17)*X(I17)
      DKDX = V

*     -- d(ksi)/dY
      N = NX + 1
      IXY = 1 
      CALL RAR(1,2,N,KK,IXY,IDX,IDY,X,AR) 
      L = NX
      V = DO0 
      DO 120 I17 = 1,L
  120   V = V + BX(I17)*X(I17)
      DKDY = V

*     -- d(nu)/dX
      N = NY + 1
      IXY = 2 
      CALL RAR(1,1,N,KK,IXY,IDX,IDY,X,AR) 
      L = NY
      V = DO0 
      DO 130 I17 = 1,L
  130 V = V + BY(I17)*X(I17)
      DNDX = V

*     -- d(nu)/dY
      N = NY + 1
      IXY = 2 
      CALL RAR(1,2,N,KK,IXY,IDX,IDY,X,AR) 
      L = NY
      V = DO0 
      DO 140 I17 = 1,L
  140   V = V + BY(I17)*X(I17)
      DNDY = V


      XEST(1,2) = (DKSI*DNDY-DNU*DKDY)/(DKDX*DNDY-DNDX*DKDY)
      XEST(1,1) = XEST(1,1) - XEST(1,2) 

      YEST(1,2) = (DKSI*DNDX-DNU*DKDX)/(DNDX*DKDY-DKDX*DNDY)
      YEST(1,1) = YEST(1,1) - YEST(1,2)

      GO TO 30

      END 




