!+++++++++++++++
!               POS1 Astrometric package
!		dss.prg
!		@@ dss in_image [out_tab] [method]
!		
!		dss.prg will read some xy image coordinates from an
!		image extracted from the Digital Sky Survey and convert
!		them in RA, Dec using the included astrometric calibr.
!		(cf DSS booklet)
!
! 		in_image: the dss image
!		out_tab: output table; POS1 compatible format
!			 default name = {in_image}_t
!		method: GAUSS or CURSOR
!
!.version 	Sat Apr  1 18:38:42 1995
!---------------
writ/out "obsolete..."
writ/out "   use now @@ dss_x2r image table Gauss/Curs Mes?"
writ/out "                      to convert XY to RA Dec"
writ/out "   or      @@ dss_r2x image table"
writ/out "                      to convert RA Dec to XY"
writ/out "   with    image= a dss image"
writ/out "           table= a midas table"
return

defi/par p1 ? ? "image?"
if p1 .eq. "??" then
   writ/out "@@ dss in_image [out_tab] [GAUSS/CURSOR] [Measured]"
   writ/out "       dssimage meas.tabl cen/gau or ge/cu alread.mes?"
   return
endif


defi/par p2 DEFAULT ? "output table"
defi/par p3 GAUSS ? "center/GAUSS or CURSOR"
defi/par p4 N ? "already measured?"

wri/key pi/d/1/1 3.14159265359

defi/loc in_ima/c/1/40 {p1}
defi/loc ij/i/1/1 0
defi/loc ik/i/1/1 0

!- test image filename
ij = m$len(in_ima)
ik = ij-3
if in_ima({ik}:{ij}) .ne. ".bdf" then
   dele/key in_ima
   defi/loc in_ima/c/1/40 {p1(1:{ij})}.bdf
else
   ij = ik-1
endif

!- output table filename
defi/loc out_tab/c/1/40 {p2}
if out_tab .eq. "DEFAULT" out_tab = "{p1(1:{ij})}_t.tbl"
writ/out "Input DSS image: {in_ima} output table: {out_tab}"

!goto start

!- test that the image is a DSS images
ij = M$EXISTD(in_ima,"CNPIX1")
if ij .eq. 0 then
   writ/out "*error* cannot find the some of the DSS descriptors"
   writ/out "        was this image obtained with getimage or dss???"
   return
endif

!- test that the image has been properly converted; reload properly if needed
if {{in_ima},CNPIX1} .ne. {{in_ima},start(1)} .or. {{in_ima},CNPIX2} .ne. {{in_ima},start(2)} then
   wri/des {in_ima} start {{in_ima},CNPIX1},{{in_ima},CNPIX2}
   wri/des {in_ima} step 1.,1.
   load {in_ima}
endif


!
!-- get the points to be converted
!
if p4 .ne. "Y" then
   if p3 .eq. "GAUSS" then 
      cent/gau ? {out_tab} p6=w
      comp/tab {out_tab} :mag = -2.5*log10(:icent)
   else
      get/curs {out_tab} p5=w
      comp/tab {out_tab} :xcen = :x_coord
      comp/tab {out_tab} :ycen = :y_coord
      comp/tab {out_tab} :mag = -2.5*log10(:value)
   endif
endif

start:
!
!-- Conversion XY -> RA Dec
!
!- init
ij = m$existc(out_tab,:x)
if {ij} .eq. -2 then
   write "Table {out_tab} dos not exist- How did you do that???"
   return
endif
if {ij} .ge. 0 del/col {out_tab} :x
crea/col {out_tab} :x ? ? R*8

ij = m$existc(out_tab,:y)
if  {ij} .ge. 0 del/col {out_tab} :y
crea/col {out_tab} :y ? ? R*8

ij = m$existc(out_tab,:x2)
if  {ij} .ge. 0 del/col {out_tab} :x2
crea/col {out_tab} :x2 ? ? R*8

ij = m$existc(out_tab,:y2)
if  {ij} .ge. 0 del/col {out_tab} :y2
crea/col {out_tab} :y2 ? ? R*8

ij = m$existc(out_tab,:x2py2)
if  {ij} .ge. 0 del/col {out_tab} :x2py2
crea/col {out_tab} :x2py2 ? ? R*8

ij = m$existc(out_tab,:aksi)
if  {ij} .ge. 0 del/col {out_tab} :aksi
crea/col {out_tab} :aksi ? ? R*8

ij = m$existc(out_tab,:aeta)
if  {ij} .ge. 0 del/col {out_tab} :aeta
crea/col {out_tab} :aeta ? ? R*8

ij = m$existc(out_tab,:r_a)
if  {ij} .ge. 0 del/col {out_tab} :r_a
crea/col {out_tab} :r_a "RA"  R12.7 R*8

ij = m$existc(out_tab,:dec)
if  {ij} .ge. 0 del/col {out_tab} :dec
crea/col {out_tab} :dec "Decl" S12.6 R*8

comp/tab {out_tab} :ppm = :ident
comp/tab {out_tab} :pma = 0.
comp/tab {out_tab} :pmd = 0.


!---
    writ/out "- pixel coord in milimeters"
!---
!- different convention MIDAS/DSS:
comp/tab {out_tab} :x = :xcen+.5
comp/tab {out_tab} :y = :ycen+.5

!- astrometric solution:
comp/tab {out_tab} :x = ( {{in_ima},ppo3} - :x * {{in_ima},xpixelsz} )/1000.
comp/tab {out_tab} :y = ( :y * {{in_ima},ypixelsz} - {{in_ima},ppo6} )/1000.

comp/tab {out_tab} :x2 = :x*:x
comp/tab {out_tab} :y2 = :y*:y
comp/tab {out_tab} :x2py2 = :x2+:y2
writ/out "{{in_ima},ppo3}, {{in_ima},xpixelsz} "
writ/out "{{in_ima},ppo6}, {{in_ima},ypixelsz} "

!---
    writ/out "- standard coord (Ksi) in arcsec"
!---
comp/tab {out_tab} :aksi = {{in_ima},amdx1}*:x +{{in_ima},amdx2}*:y +{{in_ima},amdx3}
comp/tab {out_tab} :aksi = :aksi +{{in_ima},amdx4}*:x2 +{{in_ima},amdx5}*:x*:y
comp/tab {out_tab} :aksi = :aksi +{{in_ima},amdx6}*:y2 +{{in_ima},amdx7}*:x2py2
comp/tab {out_tab} :aksi = :aksi +{{in_ima},amdx8}*:x2*:x +{{in_ima},amdx9}*:x2*:y
comp/tab {out_tab} :aksi = :aksi +{{in_ima},amdx10}*:x*:y2 + {{in_ima},amdx11}*:y2*:y
comp/tab {out_tab} :aksi = :aksi +{{in_ima},amdx12}*:x*:x2py2 
comp/tab {out_tab} :aksi = :aksi +{{in_ima},amdx13}*:x*:x2py2*:x2py2

!---
    writ/out "- standard coord (Eta) in arcsec"
!---
comp/tab {out_tab} :aeta = {{in_ima},amdy1}*:y +{{in_ima},amdy2}*:x +{{in_ima},amdy3}
comp/tab {out_tab} :aeta = :aeta +{{in_ima},amdy4}*:y2 +{{in_ima},amdy5}*:x*:y
comp/tab {out_tab} :aeta = :aeta +{{in_ima},amdy6}*:x2 +{{in_ima},amdy7}*:x2py2
comp/tab {out_tab} :aeta = :aeta +{{in_ima},amdy8}*:y2*:y +{{in_ima},amdy9}*:y2*:x
comp/tab {out_tab} :aeta = :aeta +{{in_ima},amdy10}*:x2*:y + {{in_ima},amdy11}*:x2*:x
comp/tab {out_tab} :aeta = :aeta +{{in_ima},amdy12}*:y*:x2py2 
comp/tab {out_tab} :aeta = :aeta +{{in_ima},amdy13}*:y*:x2py2*:x2py2

!---
   writ/out "- standard coord in  rad"
!---
comp/tab {out_tab} :ksi = :aksi/3600./180.*{pi}
comp/tab {out_tab} :eta = :aeta/3600./180.*{pi}

!---
   writ/out "- RA and Dec"
!---
defi/loc r_a0d/d/1/1 0.
defi/loc dec0d/d/1/1 0.
defi/loc r_a0/d/1/1 0.
defi/loc dec0/d/1/1 0.

defi/loc isig/i/1/1 0

isig = {{in_ima},pltdecsn}1

r_a0d = ({{in_ima},pltrah}+{{in_ima},pltram}/60.+{{in_ima},pltras}/3600.)*15.
dec0d = isig*({{in_ima},pltdecd}+{{in_ima},pltdecm}/60.+{{in_ima},pltdecs}/3600.)
writ/out {r_a0d},{dec0d}
r_a0 = r_a0d/180.*{pi}
dec0 = dec0d/180.*{pi}

writ/out "plate center (desc): {{in_ima},pltrah} {{in_ima},pltram} {{in_ima},pltras}"
writ/out "{isig}*{{in_ima},pltdecd} {{in_ima},pltdecm} {{in_ima},pltdecs}"
writ/out "Plate center (deg): {r_a0d}, {dec0d}"


comp/tab {out_tab} :wr_a = :ksi/cos({dec0d})/(1.-:eta*tan({dec0d}))
comp/tab {out_tab} :wr_a = atan(:wr_a)
comp/tab {out_tab} :r_a = :wr_a + {r_a0d}

comp/tab {out_tab} :wdec1 = (:eta+tan({dec0d}))*cos(:r_a-{r_a0d})
comp/tab {out_tab} :wdec2 = (1.-:eta*tan({dec0d}))
comp/tab {out_tab} :dec = atan(:wdec1/:wdec2)

read/tab {out_tab} :ppm :r_a :dec
