! POS1 package
! pos1_auto
!      @@ pos1_auto image pixScale posAng,orientation
!
! user interface to  pos1a and pos1edit 
! 
! dependencies
!  check_file.prg
!  get_usno.prg   http-get  (http-get.c)
!  pos1a.prg      pos1a.exe (pos1a.f)
!  pos1a.prg      pos1a.exe (pos1a.f)
!---
defi/par p1 ? ? "image?"
if "{p1}" .eq. "??" then 
  writ/out  "ASTROMET/AUTO image pixScale posAng,orientation"
  write/out "   image: input image (expects .bdf)"
  write/out "   pixScale, in arcsec, first guess"
  write/out "   posAng, of top of CCD, East of North"
  write/out "   orientation: +1 if E left of N, -1 if E right of N"
  write/out " "
  write/out "   Procedure: follow the instructions on screen..."
  HALT
endif
defi/par p2 A ? "Auto/Manual?"
defi/par p3 1 ? "graphic interface (1) or not (0)?"
defi/loc pixsc/r/1/1 0.24 !WFI
defi/loc posang/r/1/1 0.  !WFI
defi/loc orient/i/1/1 1   !WFI

defi/loc loadtab/i/1/1 {p3}



writ/out "                 _  "
writ/out " _ __   ___  ___/ |"
writ/out "| '_ \ / _ \/ __| |"
writ/out "| |_) | (_) \__ \ |"
writ/out "| .__/ \___/|___/_|"
writ/out "|_|                "
writ/out "		   _  "


defi/loc center/r/1/2 0.,0.

defi/loc main_det/r/1/1 0.
defi/loc ax/d/1/1 0.
defi/loc bx/d/1/1 0.
defi/loc cx/d/1/1 0.
defi/loc ay/d/1/1 0.
defi/loc by/d/1/1 0.
defi/loc cy/d/1/1 0.
writ/key scale/d/1/2 0. all
defi/loc ccd/c/1/1 x
defi/loc sx/r/1/3 0.,0.,0.
defi/loc sy/r/1/3 0.,0.,0.
defi/loc gx/r/1/3 0.,0.,0.
defi/loc gy/r/1/3 0.,0.,0.

defi/loc i/i/1/1 0
defi/loc w/r/1/1 0.
defi/loc rms/r/1/3 0.,0.,0.

defi/loc intab/c/1/72 oxoxo




!
!-- INPUT IMAGE
!
astr/checkfile {p1} .bdf check naked
defi/loc inima/c/1/72 {outputc}

i = m$len(inima) -1
intab = "{inima(1:{i})}"
i = i+1
ccd = "{inima({i}:{i})}"


if {{inima},o_pos(1)} .le. 0.0000001 then
   copy/dd {intab}h o_pos {inima}
endif


if loadtab .eq. 1 then
  if "{inima}" .ne. "{idimemc}" then
    writ/out "*info* loading image {inima}"
    load {inima} sc=fu cu=f,ihap ce=ce
  else
    writ/out "*info* image {inima} already loaded"
  endif
endif

set/for f9.5,f9.5
wri/key wra/d/1/1 {{inima},o_pos(1)}
wri/key wdec/d/1/1 {{inima},o_pos(2)}

defi/loc ra/i/1/3 0,0,0
defi/loc dec/i/1/3 0,0,0
defi/loc dsig/c/1/1 +

if wdec .lt. 0. then
  dsig = "-"
  wdec = -wdec
endif

wra = wra/15.d0
ra(1) = m$nint(wra-0.5)
ra(2) = m$nint(60.*(wra-ra(1))-.5)
ra(3) = m$nint(3600.*(wra-ra(1)-ra(2)/60.))
wra = wra*15.d0

dec(1) = m$nint(wdec-0.5)
dec(2) = m$nint(60.*(wdec-dec(1))-.5)
dec(3) = m$nint(3600.*(wdec-dec(1)-dec(2)/60.))
if dsig .eq. "-" wdec = -wdec


set/for i2
writ/out "*info* Center = {ra(1)}:{ra(2)}:{ra(3)}{dsig}{dec(1)}:{dec(2)}:{dec(3)}"


!
!-- GET THE STARS 
!

defi/loc rad/i/1/1 0.

!wfi!rad = {{inima},npix(1)}*pixsc/60.*2.   !  *.7
rad = {{inima},npix(1)}*pixsc/60.*3.


!--- do we have the table specific to this CCD?
astrom/checkfile {inima}_usno .tbl softcheck naked
if outputi .eq. 1 then
   !- yes
   intab  = "{inima}_usno"
   writ/out "*info* std-star file {intab} found on disk"

else
   !- no, the specific table for this image is not there.
   ! do we have a generic one for the field?

   astrom/checkfile {intab}_usno .tbl softcheck naked
   if outputi .eq. 1 then
      !- yes, generic table is here
      ! let's copy it into a specific one.
      $ cp {intab}_usno.tbl {inima}_usno.tbl
      intab = "{inima}_usno"

   else 

   !! do we have a generic table for the directory 
   !! (as it  could be the case for MOVIE)

       astrom/checkfile field_usno .tbl softcheck naked
    
       if outputi .eq. 0 then
          ! the generic table is not here 
          writ/out "*info* std-star file not found on disk - let`s create it"
          astrom/usno  {wra} {wdec} {rad} field_usno

       endif

       $ cp field_usno.tbl  {intab}_usno.tbl
       $ cp field_usno.tbl  {inima}_usno.tbl
      

      intab = "{inima}_usno"

   endif


endif




writ/key determi/r/1/1 0.


!-- crude estimate of the astrometric solution


if  ccd .eq. "a" then
  center(1) = 4100.  !! WFI: preset
  center(2) = 3950.
endif  
if  ccd .eq. "b" then
  center(1) = 3930.  !! WFI: preset
  center(2) = 3955.
endif  
if  ccd .eq. "c" then
  center(1) = 3850.  !! WFI: preset
  center(2) = 3960.
endif  
if  ccd .eq. "d" then
  center(1) = 3850.  !! WFI: preset
  center(2) = 3955.
endif  
if  ccd .eq. "e" then
  center(1) = 3930.  !! WFI: preset
  center(2) = 3955.
endif  
if  ccd .eq. "f" then
  center(1) = 4000.  !! WFI: preset
  center(2) = 3945.
endif  
if  ccd .eq. "g" then
  center(1) = 4085.  !! WFI: preset
  center(2) = 3955.
endif  
if  ccd .eq. "h" then
  center(1) = 4085.  !! WFI: preset
  center(2) = 3955.
endif  

comp/tab {intab} :xcen = -({orient})*cos({posang})*(:r_a-{wra}) 
comp/tab {intab} :xcen = :xcen - sin({posang})*(:dec-({wdec}))
comp/tab {intab} :xcen = :xcen*3600.*cos({wdec})
comp/tab {intab} :xcens = :xcen
comp/tab {intab} :xcen = {center(1)}+:xcens/{pixsc}

comp/tab {intab} :ycen = -({orient})*sin({posang})*(:r_a - {wra}) 
comp/tab {intab} :ycen = :ycen+ cos({posang})*(:dec-({wdec}))
comp/tab {intab} :ycen = :ycen*3600.
comp/tab {intab} :ycens = :ycen
comp/tab {intab} :ycen = {center(2)}+:ycens/{pixsc}

if p2 .eq. "A" goto skip  !!! Automatic

if loadtab .eq. 1 astro/loadtab {intab}


!
!-- IDENTIFY 3 STARS AND GET A BETTER ASTROMETRIC SOLUTION
!

writ/out 
writ/out "*ACTION*--> For 3 stars, click the circle then the image"
writ/out

$ rm -f wjunk_center.tbl
get/cur wjunk_center p4=6,1
if m$exist("wjunk_center.tbl") .eq. 0 then
   writ/out "ERROR you were supposed to select 6 points in total"
   return/exit
endif
if {wjunk_center.tbl,tblcontr(10)} .ne. 6 then
   writ/out "ERROR you were supposed to select 6 points in total"
   return/exit
else
  wri/out "thanks-"
endif

!center(1) = center(1) + {wjunk_center,:x_coord,@2}-{wjunk_center,:x_coord,@1}
!center(2) = center(2) + {wjunk_center,:y_coord,@2}-{wjunk_center,:y_coord,@1}

sx(1) = {wjunk_center,:x_coord,@1}
sx(2) = {wjunk_center,:x_coord,@3}
sx(3) = {wjunk_center,:x_coord,@5}
sy(1) = {wjunk_center,:y_coord,@1}
sy(2) = {wjunk_center,:y_coord,@3}
sy(3) = {wjunk_center,:y_coord,@5}

gx(1) = {wjunk_center,:x_coord,@2}
gx(2) = {wjunk_center,:x_coord,@4}
gx(3) = {wjunk_center,:x_coord,@6}
gy(1) = {wjunk_center,:y_coord,@2}
gy(2) = {wjunk_center,:y_coord,@4}
gy(3) = {wjunk_center,:y_coord,@6}

astro/dtm {sx(1)},{sx(2)},{sx(3)}  {sy(1)},{sy(2)},{sy(3)} 1.,1.,1.

main_det = determi

!- SOLVE X

astro/dtm {gx(1)},{gx(2)},{gx(3)}  {sy(1)},{sy(2)},{sy(3)} 1.,1.,1.
ax = determi/main_det

astro/dtm {sx(1)},{sx(2)},{sx(3)}  {gx(1)},{gx(2)},{gx(3)} 1.,1.,1.
bx = determi/main_det

astro/dtm {sx(1)},{sx(2)},{sx(3)}  {sy(1)},{sy(2)},{sy(3)} {gx(1)},{gx(2)},{gx(3)}
cx = determi/main_det


!- SOLVE Y

astro/dtm {gy(1)},{gy(2)},{gy(3)}  {sy(1)},{sy(2)},{sy(3)} 1.,1.,1.
ay = determi/main_det

astro/dtm {sx(1)},{sx(2)},{sx(3)}  {gy(1)},{gy(2)},{gy(3)} 1.,1.,1.
by = determi/main_det

astro/dtm {sx(1)},{sx(2)},{sx(3)}  {sy(1)},{sy(2)},{sy(3)} {gy(1)},{gy(2)},{gy(3)}
cy = determi/main_det

comp/tab {intab} :xold = :xcen
comp/tab {intab} :yold = :ycen

comp/tab {intab} :xcen = {ax}*:xold + {bx}*:yold + {cx}
comp/tab {intab} :ycen = {ay}*:xold + {by}*:yold + {cy}

pixsc = pixsc * m$sqrt(ax*by - bx*ay) 
writ/out "*RESULT* computed pixel scale: {pixsc} arcsec"


skip:

if loadtab .eq. 1 astro/loadtab {intab}

w = 3./pixsc
w = 20./pixsc
comp/tab {intab} :xstart = :xcen -{w}
comp/tab {intab} :xend = :xcen +{w}
comp/tab {intab} :ystart = :ycen -{w}
comp/tab {intab} :yend = :ycen +{w}


sele/tab {intab} :xstart .ge. {{inima},start(1)} | $cat > /dev/null

sele/tab {intab} sel.eq.1 .and. :ystart .ge. {{inima},start(2)} | $cat > /dev/null

w = {{inima},start(1)}+ {{inima},npix(1)}*{{inima},step(1)}
sele/tab {intab} sel.eq.1 .and. :xend .le. {w} | $cat > /dev/null

w = {{inima},start(2)}+ {{inima},npix(2)}*{{inima},step(2)}
sele/tab {intab} sel.eq.1 .and. :yend .le. {w} | $cat > /dev/null

copy/tab {intab} {inima}_xy

cent/mom {inima},{intab} {intab}  ! check if there are some stars there
sele/tab {intab} :status .ne. 1.  ! keeps the good ones (1=failed)
comp/tab {intab} :std = 1 + (1- sel ) ! mark the std (1) and bad (2)

cent/mom {inima},{inima}_xy {inima}_xy
if loadtab .eq. 1 load/tab {inima}_xy :xcen :ycen ? 6 10 3




defi/loc SIG/d/1/1 5
defi/loc STDSEL/C/1/1 U ! only "undeleted" stars (some deleted by cen/mom)
defi/loc tx/c/1/9 "111110000"
defi/loc ty/c/1/9 "111110000"
defi/loc yon/c/1/1 Y
defi/loc out_mes/c/1/16 " "
defi/loc flag/c/1/1 " "

again:

writ/out "*info* calling POS1A..."


astrom/transfo {intab} {inima}_xy MEAN 0,0 NN {SIG} {TX},{TY} {STDSEL} 

wri/out OUT

comp/tab {intab} :err = sqrt(:xerr**2 + :yerr**2)
sele/tab {intab} :std .eq. 1 | $cat > /dev/null
stat/tab {intab} :xerr   | $cat > /dev/null
rms(1) = outputr(4) *1.75
stat/tab {intab} :yerr  | $cat > /dev/null
rms(2) = outputr(4) *1.75
rms(3) = m$sqrt(rms(1)**2 + rms(2)**2)

if loadtab .eq. 1 then
   astro/edit {intab} D  200 DONTASK
else
   astro/edit {intab} N  200 DONTASK
endif

!old!sele/tab {intab} :std.eq.1.and. (abs(:xerr).ge.{rms(1)}.or. abs(:yerr).ge.{rms(2)} .or.:err.ge.{rms(3)}) | $cat > /dev/null

rms(3) = rms(3)*1.1
sele/tab {intab} :std.eq.1.and. :err.ge.{rms(3)} | $cat > /dev/null

! automatic sigma-clipping

if {{intab}.tbl,tblcontr(10)} .gt. 0 then
  !!! THESE LINE SHOULD BE JUST AFTER THE sele/tab
  read/tab {intab} :ppm :xerr :yerr
  comp/tab {intab} :std = 2.* sel + :std*(1-sel)
  stdsel = "U"
  goto again
endif 

! manual editing?

!! NOT INTERACTIVE FOR WFI
yon = "y"
!!inqu/key yon "ACCURACY OK? "
if yon .ne. "y" .and. yon .ne. "Y" then

  stdsel = "U"
  astro/edit {intab} N
  writ/out By typing (1) or (0),
  writ/out decide whether to use(1) or not to use(0)
  writ/out "        X Y XY X**2 Y**2 X**3 Y**3 XY**2 YX**2"
  inqu/key tx "IN X ([ret]={tx})?  > " 
  inqu/key ty "IN Y ([ret]={ty})?  > " 
  goto again
endif

writ/out 
writ/out " " 
writ/out "*info* image:                     {inima}"
writ/out "       all standard star table:   {intab}"
writ/out "       xy table:                  {inima}_xy"
writ/out 
writ/out "*info* updating {inima} astrometric descriptors"
writ/out "       use pos1b for astrometric computations"




!
!- pos1 descriptors:
!
here:
   writ/out "copying astrometric calibr"
   copy/dd {inima}_xy.tbl EPO_PLA {inima} EPO_PLA 
   writ/dhe {inima}  EPO_PLA "POS1: Plate epoch "
   copy/dd {inima}_xy.tbl EPO_CAT {inima} EPO_CAT
   writ/dhe {inima}  EPO_CAT "POS1: Ref epoch "
   copy/dd {inima}_xy.tbl FLAGS {inima} FLAGS
   writ/dhe {inima}  FLAGS "POS1: Schmidt plate? LS blink? "
   copy/dd {inima}_xy.tbl SIG {inima} SIG
   writ/dhe {inima}  SIG "POS1: meas. tol. "
   copy/dd {inima}_xy.tbl TERMS {inima} TERMS
   writ/dhe {inima}  TERMS "POS1: transfo.terms "
   copy/dd {inima}_xy.tbl BX {inima} BX
   writ/dhe {inima}  BX "POS1: X transfo matrix "
   copy/dd {inima}_xy.tbl BY {inima} BY
   writ/dhe {inima}  BY "POS1: Y transfo matrix "
   copy/dd {inima}_xy.tbl CX {inima} CX
   writ/dhe {inima}  CX "POS1: X cst term "
   copy/dd {inima}_xy.tbl CY {inima} CY
   writ/dhe {inima}  CY "POS1: Y cst term "
   copy/dd {inima}_xy.tbl NX {inima} NX
   writ/dhe {inima}  NX "POS1: # of terms for X transfo"
   copy/dd {inima}_xy.tbl NY {inima} NY
   writ/dhe {inima}  NY "POS1: # of terms for Y transfo "
   copy/dd {inima}_xy.tbl AL_DE0 {inima} AL_DE0
   writ/dhe {inima}  AL_DE0 "POS1: RA,DEC of center "


writ/out
writ/out "-------------------------------------------------------------pos1_auto exited."

!! Call the Photometric calibration

@@ pos1_photom {inima}
