
!
!    @@ pos1b  mes option outputtab flag
!or  @@ pos1b  mes option coordinates
!   
!  mes: table containing the measurements; must have the 
!       descriptors generated by pos1a. The table data is used only
!       for opt. 1 and 2.
!  option:
!       (1) Calculate (A,D) for plate center and several (X,Y)-values'/ 
!                input from table
!       (2) Calculate (A,D) for several (X,Y)-values only'/ 
!                input from table
!       (3) Calculate (A,D) for one (X,Y)-value'/ 
!                input from parameter line
!       (4) Calculate (X,Y) for one (A,D)-position'/
!           and stores XY in outputr 1&2
!                input from parameter line
!       (5) Calculate (X,Y) for several (A,D)s in disc file'/
!                input from an ascii file in old pos1 format
!
!  if option=1 or 2, outtab = output table
!                    flag: Y for trailed objects
!  if option=3, input=x,y
!               output stored in 
!                   rah, ram, ras, dsig, dd, dm, ds
!                   i1   i2   d1   c(2:2) i3 i3  d2
!               with i4 meaning outputi(4)
!                    d2         outputd(2)
!                    c(2:2)     outputc(2:2)!
!  if option = 4: coordinates = coordinate string eg 12,02,49,-45,01,23
!
!.version 2003-02-05T23:46:22 Wed ohainaut added ref image.

defi/par p1 cernis ? "Measurement file "
if p1 .eq. "??" then
 write/out "@@ pos1b mes option [option2] [ref image]"
 write/out "mes: data file containing the astrometric descriptors"
 write/out "option:
!obsolete! write/out " (1) Calculate (A,D) for plate center and several (X,Y)-values"
!obsolete! write/out " (2) Calculate (A,D) for several (X,Y)-values only"
 write/out " (3) Calculate (A,D) for one (X,Y)-value"
 write/out "   option2 can be  x,y value or"
 write/out "   CURSOR for a GET/CURSOR, or"
 write/out "   GAUSS for a  CENT/GAUSS"
 write/out " (4) Calculate (X,Y) for one (A,D)-position"
 write/out "    option2 is hh,mm,ss,dd,mm,ss
 write/out " (5) Calculate (X,Y) for several (A,D)s in disc file"
 write/out "ref_image: from where to get the epoch. "
 write/out "  if DISPLAY, takes whatever is displayed"
 write/out "  if not given, tries from mes input file."
 write/out "If keyword POS1MAG is set, its value will be passed to the"
 write/out "output for option3 (useful for minor planets)"

 return
 endif
defi/par p2 2 n "Option?"
defi/par p3 pos1 ? "Output table?"
defi/par p4 NIL ? "Ref image"

@@ pos1_checkfile {p1} .tbl check extn
defi/loc IN_MES/c/1/72 {outputc}  ! passed to pos1b.exe	


defi/loc OPT/i/1/1 {p2}		! passed to pos1b.exe	


defi/loc iex/i/1/1 0

! deal with the options

if opt .eq. 3 then              ! XY input

   if p3 .eq. "GAUSS" .or. p3 .eq. "IQE" then  ! center/gaus interactive input
      writ/out "--> measure the object with box."
      writ/out "only LAST object clicked will be astrometised"
      cent/{p3} CURSOR 
      defi/loc in_coor/d/1/2 0.,0.
      in_coor(1) = outputr(5)
      in_coor(2) = outputr(6)
   else ; if p3 .eq. "CURSOR" then ! get/cursor interactive input
      writ/out "--> click object"
      get/curs p4=1,1
      defi/loc in_coor/d/1/2 0.,0.
      in_coor(1) = outputr(12)
      in_coor(2) = outputr(13)
   else ! default: give the XY in command line
      defi/loc in_coor/d/1/2 {p3}
   endif; endif

else ; if opt .eq. 4 then       ! RA input

  defi/loc in_coor/d/1/6 {p3}

else

  defi/loc out_mes/c/1/16 {p3}

endif ; endif



!- is there a magnitude thatI should write in the output?
iex = m$existk("pos1mag")
if iex .eq. 0 then
   writ/key pos1mag/r/1/1 99.  ! passed to pos1b.exe	
endif


! reference image for epoch


writ/key midEp/d/1/1 -99999.d0   !! passed to pos1b.exe

defi/loc inima/c/1/72 {p4}
if inima .eq. "DISPLAY" then 
   inima = idimemc
endif

if inima .eq. "NIL" then       ! no reference image given. 
			       ! let's try to find it.
   inima = in_mes

   iex = m$index(inima,"_xy")  ! can we get the original image name?

   if iex .gt. 0 then
     defi/loc wc/c/1/72 oxo
     iex = iex-1
     wc = "{inima(:{iex})}.bdf"
     iex = m$exist(wc)		! does the orig image exist

     if iex .gt. 0 then
        iex = m$existd(wc,"o_time") ! does it have a time stamp?

        if iex .gt. 0 then	    ! YES    
            ! correction for midexp
            midEp = {{wc},o_time(4)} + 0.5* {{wc},o_time(7)}/86400.
        endif
     endif
   endif

else				! we do have a ref. image	
   iex = m$existd(inima,"o_time") ! does it have a time stamp?
   if iex .gt. 0 then	    ! YES    
       midEp = {{inima},o_time(4)} + 0.5* {{inima},o_time(7)}/86400.
   endif
endif

if midEp .le. 0 then
  inima = "Time not found"
endif


set/form f20.14,f20.14

iex = m$existd(inima,"o_time")
if iex .gt. 0 then
  midEp = {{inima},o_time(4)} + 0.5* {{inima},o_time(7)}/86400.
endif


! correction mjd->jd
midEp = midEp + 2400000.5d0



run MID_WORK:pos1b.exe

!!!if opt .eq. 3 then
!!!   set/for f6.3,f6.3 i2
!!!!!   writ/out {outputi(1)},{outputi(2)},{outputd(1)}, {outputc(1:2)}{outputi(3)},{outputi(4)},{outputd(2)}  " <-- " {in_coor(1)},{in_coor(2)}
!!!!!   writ/out " <-- " {in_coor(1)},{in_coor(2)}
!!!endif


wri/out "Time reference from: {inima}"

