crossref intab color standard method identif extinct select clr
defi/par p1 ?? c "measurement table"
if p1 .eq. "???" then
wr/o "			        		T M A G   Photometric Package "
wr/o "    AMAG/SOLVE / @@ amag "
wr/o " "
wr/o " .syntax								     "
wr/o "	  AMAG/SOLVE measurements color DUMMY method [Ident?]		     "
wr/o "                       [zero,extn,col] [Add_selec] [colr]		     "
wr/o " .purpose        T-MAG photometric package			     "
wr/o "			 compute a photmetric transformation		     "
wr/o " .input		 meas.tbl is created by AMAG/MES then		     "
wr/o "                        AMAG/MERG (and TMAG/EXPT) 		     "
wr/o "	      columns:	:MAGNITUDE 					     "
wr/o "			:airm	(manually from the frame)		     "
wr/o "			:filter (manually)				     "
wr/o " .output:	:stdmag 						     "
wr/o "			:dmag  						     "
wr/o "			:extn  						     "
wr/o " .parameters							     "
wr/o "			 meas:	tab. with the measurements		     "
wr/o "			 color:	U, B, V, R, I, W(=wide VR) or FILE:	     "
wr/o "				color to be processed. Other will be	     "
wr/o "				ignored for the reduction 		     "
wr/o "				(which is done color by color) 		     "
wr/o "			 dummy:	not used anymore - for backw. compatibility  "
wr/o "				(Landolt.tbl)				     "
wr/o "			 meth:       Zero Pt    Extinction    Colour term    "
wr/o "				A:   computed  Assumed=std/P6 assumed:def/p6 "
wr/o "				R:   computed     computed    assumed:def/p6 "
wr/o "				K:   computed  Assumed:std/p6    computed    "
wr/o "				C:   computed     computed       computed    "
wr/o "				Z:  Assumed/P6   Assumed/P6     Assumed/P6   "
wr/o "			 Id_found:	Are the star already identified? Y/N "
wr/o "			 zero,ext,col:	ZP, extincion and colortern to be use"
wr/o "			      (if nil, use default) 			     "
wr/o "			 Add_select:	-Add sel. to KEEP, like		     "
wr/o "					     seq.ge.10.and.seq.le.20	   "
wr/o "					-use "new" when changing color idx "
wr/o "                                      this will compute the new idx "
wr/o "                                      and RESET all the selections  "
wr/o "		 	 colr:  color to be used for the color reduction,     "
wr/o "                         def R-I					     "
wr/o " 									     "
wr/o " .usage								     "
wr/o "		measure the std stars with				     "
wr/o "			AMAG/MES in_cat scale angle orient                   "
wr/o "		merge the measurements tables with			     "
wr/o "			AMAG/MERGE.prg input.cat output.tbl tab_prefix       "
wr/o "		if needed, correct for the exposure time with		     "
wr/o "			TMAG/EXPTIME output.tbl 			     "
wr/o "		compute the solution with AMAG				     "
wr/o " 			(see below)					     "
wr/o "		check the results with 					     "
wr/o "			TMAG/PLOT table color mode(A)		             "
wr/o "		edit the results with					     "
wr/o "			TMAG/EDIT					     "
wr/o "	                then rerun  AMAG for new solution		     "
wr/o "          once you have a solution,				     "
wr/o "          measure the object with					     "
wr/o "                  AMAG/MESOBJ					     "
wr/o " 									     "
wr/o " .examples							     "
wr/o " 		AMAG myMes R ? 	A N nil,0.09,0.02 new			     "
wr/o " 			get a first guess: computes only the ZPt	     "
wr/o " 		TMAG/EDIT myMes D					     "
wr/o " 			kill some points				     "
wr/o " 		AMAG myMes R ? A Y nil,0.09,0.02			     "
wr/o " 			check the first guess				     "
wr/o " 		AMAG myMes R ? C Y					     "
wr/o " 			gets the full solution				     "
wr/o " 		TMAG/PLOT myMes R A					     "
wr/o " 			plots all the results				     "
wr/o "----------------------------------------------------------------------------"
! .version Wed Jan 10 03:27:08 2001 start uniformizing
! .history"
!	Thu Aug 31 06:54:07 2000 ORH first amag			     "
!	Wed Jul  2 02:21:36 1997			     "
!.author	ORH@IfA/UHawaii						     "
return
endif
defi/par p2 FILE C "color?"
defi/par p3 nil c "standard table"
defi/par p4 R c "Solution method? Assumed extin./Regre.lin./Colour?"
defi/par p5 N c "Stars already identified?"
defi/par p6 nil,nil,nil C "zero,extinction,colour? def: nil"
defi/par p7 none c "additional selection?"
defi/par p8 R-I C "color to be used for the color reduction"
!
!-- some variables
!
defi/loc mes_len/i/1/1 0
defi/loc std_len/i/1/1 0
defi/loc w_l1/i/1/1 0
defi/loc w_l2/i/1/1 0
defi/loc w_c/c/1/12 " "
defi/loc w_c1/c/1/12 " "
defi/loc w_c2/c/1/12 " "
defi/loc w/r/1/2 0.,0.

defi/loc i/i/1/1 0
defi/loc j/i/1/1 0
defi/loc glo_filt/c/1/1 "-"
defi/loc fra_filt/c/1/1 "-"

!
!
!---check files and parameters------------------------------
!
defi/loc intab/c/1/72 {p1}
@@ tmag_checkfile {intab} .tbl check
intab = outputc

defi/loc stdtab/c/1/72 oxoxo
!!@@ check_file {stdtab} .tbl check
!!stdtab = outputc
stdtab = intab


writ/key method/c/1/1 {p4}
method = M$UPPER(method)

writ/key st_idt/c/1/1 {p5}
st_idt = M$UPPER("{st_idt}")

!
!--- default parameters for zero,extn,color
!
writ/key wexcl/c/1/24 {p6}
i = m$index(wexcl,",")
if i .eq. 0 then
   writ/out "***ERROR*** this: >{wexcl}< is supposed to be something like"
   writ/out "           extin,color e.g. 0.125,-.19 or 0.2,nil "
   return
endif


i = i-1
j = i+2
defi/loc zero_tmp/c/1/12 {wexcl(1:{i})}
wexcl = wexcl({j}:)//"                 "

i = m$index(wexcl,",")
i = i-1
j = i+2
defi/loc extn_tmp/c/1/12 {wexcl(1:{i})}
defi/loc colr_tmp/c/1/12 {wexcl({j}:)}

!
!-- color index for color term
!

defi/loc clridx/c/1/3 {p8}
if "{clridx(2:2)}" .ne. "-" then
   writ/out "***ERROR*** this: >{clridx}< is supposed to be something like"
   writ/out "            filter-filter, e.g.  R-I "
   return
else
   writ/out "index = *{clridx}*"
endif

!
!- additional selection
!

writ/key wselect/c/1/72 {p7} 


copy/tab {stdtab} w_std !- you never know what can happen...

mes_len = {{intab},TBLCONTR(4)}
std_len = {w_std.tbl,TBLCONTR(4)}

!
!--- DEFAULT VALUES OF EXTN AND COLR TERMS
!
wri/key extn_U/r/1/1 0.200
wri/key extn_V/r/1/1 0.125
wri/key extn_B/r/1/1 0.214
wri/key extn_R/r/1/1 0.091
wri/key extn_I/r/1/1 0.051
wri/key extn_W/r/1/1 0.108 !broad VR

wri/key clr_U/r/1/1 0.
wri/key clr_V/r/1/1 0.
wri/key clr_B/r/1/1 0.
wri/key clr_R/r/1/1 -.117
wri/key clr_I/r/1/1 0.
wri/key clr_W/r/1/1 0.

!
!- WHICH FILTER? --------------------------------------------------
!
if p2 .eq. "FILE" then
   i = m$index(p1,"U") 
   if i .ne. 0  writ/key glo_filt U

   i = m$index(p1,"B") 
   if i .ne. 0  writ/key glo_filt B

   i = m$index(p1,"VR") + m$index(p1,"W")
   if i .ne. 0  writ/key glo_filt W ! this is the broad VR filter

   i = m$index(p1,"V") 
   if i .ne. 0  writ/key glo_filt V

   i = m$index(p1,"R")
   if i .ne. 0  writ/key glo_filt R

   i = m$index(p1,"I")
   if i .ne. 0 writ/key glo_filt I

   method = "C"
   writ/out "*info* method set to C"

else !-- I assume that I process all the colors are together, everything will
     !   be reduced at the same time...
   writ/key glo_filt {p2}
   glo_filt = M$UPPER(glo_filt)
   !-- change default extinction:
   if extn_tmp .ne. "nil"  extn_{glo_filt} = {extn_tmp}
   if colr_tmp .ne. "nil"  clr_{glo_filt} = {colr_tmp}
endif

if glo_filt .eq. "-" then
   write/out "*ERROR* Filter not set properly"
   return
endif

writ/out "*info* filter >{glo_filt}<"

!
!- INIT TABLE IF STARS NOT YET IDENTITIED --------------------
!

if St_Idt .ne. "Y" then
   !-- MEAS.TAB.
   j = m$existc(intab,":select")
   if j .gt. 0 then
      writ/out " "
      writ/out "***WARNING*** I have been here before -  "
      writ/out "              do you want to reset the table? "
      w_c = "proceed"
      inqui/key w_c  "              proceed, or Ctrl-C"
      w_c = M$UPPER(w_c)
      if w_c .eq. "NO" goto select:
   
      dele/col {intab} :select
   endif

   writ/out "*info* creating/updating the following working columns:"
   writ/out "  Table: {p1}"
   writ/out "  Columns: :DMAG, :STDMAG, :STDCOL, :STDMAG,"
   writ/out "           :EXTN, :ZERO, :SELECT"

   j = m$existc(intab,":dmag")
   if j .lt. 0 then
      crea/col {intab} :dmag ? F8.3 R*4
   else
      comp/tab {intab} :dmag = -9999.
   endif

   j = m$existc(intab,":stdmag")
   if j .lt. 0 then
      crea/col {intab} :stdmag ? F8.3 R*4
   else
      comp/tab {intab} :stdmag = -9999.
   endif

   j = m$existc(intab,":stdcol")
   if j .lt. 0 then
      crea/col {intab} :stdcol ? F8.3 R*4
   else
      comp/tab {intab} :stdcol = -9999.
   endif

   j = m$existc(intab,":stdmag")
   if j .lt. 0 then
      comp/tab {intab} :stdmag = -1.
   else
      comp/tab {intab} :stdmag = -9999.
   endif

   j = m$existc(intab,":extn")
   if j .lt. 0 then
      crea/col {intab} :extn ? F8.3 R*4
   else
      comp/tab {intab} :extn = -9999.
   endif

   j = m$existc(intab,":zero")
   if j .lt. 0 then
      crea/col {intab} :zero ? F8.3 R*4
   else
      comp/tab {intab} :zero = -9999.
   endif

   j = m$existc(intab,":zero")
   if j .lt. 0 then
      comp/tab {intab} :zero = -1.
   else
      comp/tab {intab} :zero = -9999.
   endif

   !--- STD TABLE
   sele/tab {stdtab} all
   writ/out "*info*Number of standard stars in ref. table:"
   sele/tab {stdtab} :ident .ne. ""


   writ/out "*info* I will identify the stars from {p1} in {p3}"
   writ/out "   meas std  ident      fitr"

   !
   !--- IDENTIFICATION LOOP ---------------------------------------------------
   !

   do i = 1 {mes_len}  			!-- loop on measurements
      fra_filt = "{{intab},:FILTER,@{i}}"	!-filter of the frame

!!      w_c = "{{intab},:ident,@{i}}"
!!      w_l1 = M$LEN(w_c)
!!      w_c1 = w_c(1:{w_l1})


      !-  IDENTIFY THE STAR----------------
!!      sel/tab {intab} all
!!      do j = 1 {std_len} 			!- loop the standards
!!	 w_c = "{w_std.tbl,:ident,@{j}}"
!!	 w_l2 = M$LEN(w_c)
!!	 w_c2 = w_c(1:{w_l2})
!!	 if "{w_c1}" .eq. "{w_c2}" then
	    !-- STAR IDENTIFIED
found_it:
!!           writ/out ">{{intab},:ident,@{i}}< >{w_std.tbl,:ident,@{j}}<"
!!           writ/out ">{w_c1}< {w_l1}   >{w_c2}< {w_l2}   "
!!	    write/out "--- {i} {j} {w_std.tbl,:ident,@{j}} {fra_filt}*"

!!	    {intab},:stdmag,@{i} = {w_std.tbl,:{fra_filt},@{j}}
	    {intab},:stdmag,@{i} = {{intab},:{fra_filt},@{i}}

!!	    {intab},:stdcol,@{i} = {w_std.tbl,:{clridx(1:1)},@{j}}-{w_std.tbl,:{clridx(3:3)},@{j}}
	    {intab},:stdcol,@{i} = {{intab},:{clridx(1:1)},@{i}}-{{intab},:{clridx(3:3)},@{i}}

!!	    goto end_in			!-- jumps out
!!	 endif
!!      enddo
!!      writ/out "   ??? Star >{w_c1}< not found in standard table {p3}"
!!      {intab},:stdmag,@{i} = -100.
!!end_in:				!-- jumps here when the * is identified
   enddo				!-- end of identification loop
endif                                   !-- end of star not yet identified? 

!
!-- Blah blah
!
if method .eq. "A"  writ/out "*info* Extinction   set to: {extn_{glo_filt}}"
if method .eq. "A" .or. method .eq. "R"  writ/out "*info* Colour corr. set to: {clr_{glo_filt}}"

!
!-- SELECTION --------------------------------------------------
!
select:


j = m$existc(intab,":select")

!- reset in case of change of filter
if wselect .eq. "new" then 
   if j .gt. 0 dele/col {intab} :select
   wselect = "none"
   !-- reset stdstatus: -9999: bad id, 0=previously rejected, 1:0K
   !   keep -9999, reset 0 and 1 to 1
   sele/tab {intab} :stdstatus .lt. 0. 
   comp/tab {intab} :stdstatus = 1 - 1000*sel
   sele/tab {intab} all
   j = 0
endif

if j .gt. 0 then
   !-- THE :SELECT COL. EXISTS
   if wselect .eq. "none" then 
      !- NO ADDITIONAL SELECTION: take new edition into account 
      sele/tab {intab}  :stdstatus .gt. 0 .and. :select .eq. 1
   else
      !- ADDITIONAL SELECTION:
!     ! mop sele/tab {intab} :select.eq.1 .and.{wselect} 
      sele/tab {intab} :stdstatus.gt.0. .and. {wselect}  
      sele/tab {intab} sel .and. :select .eq. 1
   endif   
   comp/tab {intab} :select = sel
else
   !-- :SELECT DOES NOT EXIST
   crea/col {intab} :select ? ? I4
   if wselect .eq. "none" then 
      sele/tab {intab} :filter.eq."{glo_filt}" .and. :stdstatus.gt.0. 
   else !- ADDITIONAL SELECTION:
      sele/tab {intab} :filter.eq."{glo_filt}" .and. :stdstatus.gt.0. .and. {wselect} 
   endif
   comp/tab {intab} :select = sel
endif


sele/tab {intab} :select.eq.1 

!
!--- TEST: ENOUGH POINTS??? ----------------------------------------
!
j = {{intab},tblcontr(10)}

if method .eq. "R" .and. j .le. 2 then
   writ/out "*SORRY* Only >{j}< remaining data point."
   writ/out "        cannot estimate the extinction with that..."
   writ/out "        Try option   method=A, possibly with   extin=something"
   return/exit
endif
if method .eq. "K" .and. j .eq. 3 then
   writ/out "*SORRY* Only >{j}< remaining data point."
   writ/out "        cannot estimate the  colour terms with that..."
   writ/out "        Try option   method=R"
   return/exit
endif
if method .eq. "C" .and. j .le. 2 then      
   writ/out "*SORRY* Only >{j}< remaining data point."
   writ/out "        cannot estimate the extinc. and colour terms with that..."
   writ/out "        Try option   method=A, possibly with   extin=something"
   return/exit
endif


!
!- PHOTOMETRIC REDUCTION------------------------------------------------
!

!- ASSUME EVERYTHING, DON'T COMPUTE ANYTHING

if method .eq. "Z" then
   comp/tab {intab} :dmag = :stdmag - (:magnitude + {zero_tmp}-{extn_{glo_filt}}*:airm + {clr_{glo_filt}}*:stdcol)

   sele/tab {intab} :select .gt. 0.  

   writ/key zero/r/1/2 {zero_tmp},0.
   writ/key extn/r/1/2 {extn_{glo_filt}},0.
   writ/key colr/r/1/2 {clr_{glo_filt}},0.

   defi/loc flag_z/c/1/8 pre-set
   defi/loc flag_e/c/1/8 pre-set
   defi/loc flag_c/c/1/8 pre-set
endif



!- JUST THE ZERO PT

if method .eq. "A" then
   comp/tab {intab} :dmag = :stdmag - :magnitude
   comp/tab {intab} :zero = :dmag + {extn_{glo_filt}}*:airm -{clr_{glo_filt}}*:stdcol

   sele/tab {intab} :select .gt. 0.  
   stat/tab {intab} :zero

   writ/key zero/r/1/2 {outputr(3)},{outputr(4)}
   writ/key extn/r/1/2 {extn_{glo_filt}},0.
   writ/key colr/r/1/2 {clr_{glo_filt}},0.

   defi/loc flag_z/c/1/8 computed
   defi/loc flag_e/c/1/8 pre-set
   defi/loc flag_c/c/1/8 pre-set
endif

!- ZERO POINT AND EXTINCTION

if method .eq. "R" then
   comp/tab {intab} :dmag = :stdmag - (:magnitude +{clr_{glo_filt}} *:stdcol)
   sele/tab {intab} :select .gt. 0.  
   regr/lin {intab} :dmag :airm
   writ/key zero/r/1/2 {outputd(1)},{outputr(3)}
   writ/key extn/r/1/2 {outputd(2)},{outputr(4)}
   extn(1) = -1.*extn(1)
   writ/key colr/r/1/2 {clr_{glo_filt}},0.

   defi/loc flag_z/c/1/8 computed
   defi/loc flag_e/c/1/8 computed
   defi/loc flag_c/c/1/8 pre-set
endif

!- ZERO POINT AND COLOR

if method .eq. "K" then
   comp/tab {intab} :dmag = :stdmag - (:magnitude - {extn_{glo_filt}}*:airm)
   sele/tab {intab} :select .gt. 0.  
   regr/lin {intab} :dmag :stdcol
   writ/key zero/r/1/2 {outputd(1)},{outputr(3)}
   writ/key colr/r/1/2 {outputd(2)},{outputr(4)}
   writ/key extn/r/1/2 {extn_{glo_filt}},0.

   defi/loc flag_z/c/1/8 computed
   defi/loc flag_e/c/1/8 pre-set
   defi/loc flag_c/c/1/8 computed
endif

!- ZERO POINT AND EXTINCTION AND COLOR

if method .eq. "C" then
   comp/tab {intab} :dmag = :stdmag - :magnitude
   sele/tab {intab} :select .gt. 0.  
   regr/lin {intab} :dmag :airm,:stdcol
   writ/key zero/r/1/2 {outputd(1)},{outputr(3)}
   writ/key extn/r/1/2 {outputd(2)},{outputr(4)}
   writ/key colr/r/1/2 {outputd(3)},{outputr(5)}
   extn(1) = -1.*extn(1)
   defi/loc flag_z/c/1/8 computed
   defi/loc flag_e/c/1/8 computed
   defi/loc flag_c/c/1/8 computed
endif

!- DM_TEST = MEASURED-COMPUTED
comp/tab {intab} :dm_test =  :magnitude+ ({zero(1)}) -({extn(1)}*:airm)
comp/tab {intab} :dm_test =  :dm_test + ({colr(1)}*:stdcol)- :stdmag
!comp/tab {intab} :rms = :dm_test**2
sele/tab {intab} :select .eq. 1 


@@ tmag_plot int={intab} col={p2} plo=f x=:airm y=:dm_test 

!writ/out "--------------------------------------------------"
!writ/out "RMS:
!sele/tab {intab} :select .gt. 0. 
!stat/tab {intab} :rms
!writ/out "--------------------------------------------------"
set/form f6.3
writ/out "|Filter = {glo_filt}    MAG = mag_instrum. + zero - extn*airmass + colr*({clridx})"
writ/out "|  zero = {zero(1)} +/- {zero(2)}    ({flag_z})"
writ/out "|  extn = {extn(1)} +/- {extn(2)}    ({flag_e})"
writ/out "|  colr = {colr(1)} +/- {colr(2)}    ({flag_c})"


if {zero(2)} .ge. .2 then
   writ/out "*warning* large RMS. Are you sure you normalized the"
   writ/out "          images before measuring them? If not, normalize"
   writ/out "          the table with tmag/exptime "
endif
writ/des {intab} ph_zero{p2}/r/1/2 {zero(1)},{zero(2)}
writ/dhe {intab} ph_zero{p2} "{p2}-band photometric zeropt and error"
writ/des {intab} ph_extn{p2}/r/1/2 {extn(1)},{extn(2)}
writ/dhe {intab} ph_extn{p2} "{p2}-band photometric extn and error"
writ/des {intab} ph_colr{p2}/r/1/2 {colr(1)},{colr(2)}
writ/dhe {intab} ph_colr{p2} "{p2}-band colr correction and error"
writ/des {intab} ph_flag{p2}/c/1/30 "Z-{flag_z}/E-{flag_e}/C-{flag_c}"
writ/dhe {intab} ph_flag{p2} "{p2}-band photometry flags"
sele/tab {intab} :select .eq. 1 
writ/des {intab} ph_std{p2}/i/1/1 {{intab},tblcontr(10)}
writ/dhe {intab} ph_std{p2} "Nr of std used for {p2} reduction"
writ/des {intab} ph_idx{p2}/c/1/3 {clridx}
writ/dhe {intab} ph_idx{p2} "Color idx used for {p2} reduction"
set/form

writ/out "-----------------------------------------------------------------tmag/phot end"

return
