
!------------------------------------------------------------------------------
! AMAG
! amag_comp table
!
! deals with a table that was obtained with amag_objmes
! then amag_merge to merge them into one big table (with
! as many filters as desired, but only *1* object
! and tmag_exptime for exp time normalization
!


defi/par p1 ? ? "input table"
if p1 .eq. "???" then
wr/o "			        		T M A G   Photometric Package "
wr/o " AMAG/COMP   or  @@ amag_comp"
wr/o ""
wr/o " .syntax								      "
wr/o "    AMAG/COMP in_table						      "
wr/o "									      "
wr/o " .purpose  given a photometric solution (hardcoded in this prg),	      "
wr/o "           amag_comp transforms a set of instrumental magnitudes	      "
wr/o "           measured in different filters into the stadard		      "
wr/o "		 magnitudes. The color correction is applied iterativelly     "
wr/o "		 till the result converges. In case some filters are	      "
wr/o "		 missing, the program assumes the object has an 	      "
wr/o "		 average TNO color.					      "
wr/o " .input	 in_table is a table that has been created by amag_objmes     "
wr/o " .output   adds :stdmag and :stdmag_sigma in the original table	      "
wr/o " .note	 the program assumes that the instrumental magnitudes	      "
wr/o "		 have already been time-normalized (eg TMAG/EXPTIME)	      "
wr/o "-----------------------------------------------------------------------------"
! .version Tue Mar 13 11:10:03 2001 fixed midep output
! .history
!  Fri Mar  9 14:58:34 2001 default tno colors
!  Fri Mar  9 14:07:09 2001 fixed index cond.
!  Tue Jan  9 23:12:14 2001 orh/ads creation
!  Tue Jan  9 23:11:40 2001 orh/ads
!-----------------------------------------------------------------------------
return
endif


! WFI nov2000
!DEFI/LOC zero/R/1/5 -99.,-99.99,24.329,24.498,23.256   ! U B V R I
!DEFI/LOC zeroS/R/1/5 -99.,-99.9,0.029,0.027,0.045      ! U B V R I
!
!DEFI/LOC extn/R/1/5 -99.,-99.,0.180,0.097,0.126 !U B V R I
!DEFI/LOC extnS/R/1/5 -99.,-99.9,0.014,0.009,0.015      ! U B V R I
!
!DEFI/LOC color/R/1/5 -99.,-99.99,-.104,-0.094,0.206    ! U B V R I
!DEFI/LOC colors/R/1/5 -99.,-99.9,0.021,0.021,0.029     ! U B V R I

!defi/loc cindexU/c/1/3 U-B
!defi/loc cindexB/c/1/3 B-V
!defi/loc cindexV/c/1/3 V-R
!defi/loc cindexR/c/1/3 R-I
!defi/loc cindexI/c/1/3 R-I

!NTT+SuSi2  jan 2001
!DEFI/LOC zero/R/1/5 -99.,25.642,25.853,25.814,24.693   ! U B V R I
!DEFI/LOC zeroS/R/1/5 -99.,0.029,0.025,0.024,0.025      ! U B V R I
!
!DEFI/LOC extn/R/1/5 -99.,0.327,0.214,0.276,0.141 !U B V R I
!DEFI/LOC extnS/R/1/5 -99.,0.025,0.016,0.017,0.017      ! U B V R I
!
!DEFI/LOC color/R/1/5 -99.,-0.067,0.029,-0.010,-0.022   ! U B V R I
!DEFI/LOC colors/R/1/5 -99.,-0.114,0.000,0.000,0.000    ! U B V R I
!
!
!defi/loc cindexU/c/1/3 U-B
!defi/loc cindexB/c/1/3 B-V
!defi/loc cindexV/c/1/3 V-R
!defi/loc cindexR/c/1/3 V-R
!defi/loc cindexI/c/1/3 R-I




! FORS2
DEFI/LOC zero/R/1/5 -99.,26.967,27.31,27.482,26.533     ! U B V R I
DEFI/LOC zeroS/R/1/5 -99.,0.013,0.009,0.021,0.014       ! U B V R I

DEFI/LOC extn/R/1/5 -99.,0.24,0.112,0.091,0.061 !U B V R I
DEFI/LOC extnS/R/1/5 -99.,0.007,0.005,0.007,0.006       ! U B V R I

DEFI/LOC color/R/1/5 -99.,-0.067,0.029,-0.010,-0.022    ! U B V R I
DEFI/LOC colors/R/1/5 -99.,0.006,0.004,0.011,0.006      ! U B V R I

defi/loc cindexU/c/1/3 U-B
defi/loc cindexB/c/1/3 B-V
defi/loc cindexV/c/1/3 B-V
defi/loc cindexR/c/1/3 V-R
defi/loc cindexI/c/1/3 V-I


DEFI/LOC diap_pix/R/1/1 0.
DEFI/LOC seeing_a/R/1/1 0.
DEFI/LOC seeing_b/R/1/1 0.
DEFI/LOC inima/C/1/72 {p1}
defi/loc intab/c/1/72 xxx


defi/loc cloopU/i/1/1 1
defi/loc cloopB/i/1/1 2
defi/loc cloopV/i/1/1 3
defi/loc cloopR/i/1/1 4
defi/loc cloopI/i/1/1 5
defi/loc ccc/c/1/5 UBVRI

!----------------------------------------------------------------------
defi/loc wF/c/1/1 X



@@ check_file {p1} .tbl check naked
intab = outputc

defi/loc avU/R/1/1 -999
defi/loc avB/R/1/1 -999
defi/loc avV/R/1/1 -999
defi/loc avR/R/1/1 -999
defi/loc avI/R/1/1 -999

defi/loc avoldU/R/1/1 0
defi/loc avoldB/R/1/1 0
defi/loc avoldV/R/1/1 0
defi/loc avoldR/R/1/1 0
defi/loc avoldI/R/1/1 0

defi/loc navU/i/1/1 0
defi/loc navB/i/1/1 0
defi/loc navV/i/1/1 0
defi/loc navR/i/1/1 0
defi/loc navI/i/1/1 0

! average TNO colors from ORH/ADS dec 28th
defi/loc tnoUB/r/1/1 0.98
defi/loc tnoBV/r/1/1 0.93
defi/loc tnoVR/r/1/1 0.60
defi/loc tnoRI/r/1/1 0.57

defi/loc tnoU/r/1/1 0.
defi/loc tnoB/r/1/1 0.
defi/loc tnoV/r/1/1 0.
defi/loc tnoR/r/1/1 0.
defi/loc tnoI/r/1/1 0.

! we define the mag of tnos to be use in case a color is not available
tnoU = 0.
tnoB = tnoU - tnoUB
tnoV = tnoB - tnoBV
tnoR = tnoV - tnoVR
tnoI = tnoR - tnoRI



defi/loc i/i/1/1 0
defi/loc j/i/1/1 0
defi/loc k/i/1/1 0
defi/loc tbllen/i/1/1 0
defi/loc summ/r/1/1 0

sele/tab {intab} all

tbllen = {{intab}.tbl,tblcontr(10)}


comp/tab {intab} :stdmag = -999.
comp/tab {intab} :stdmag_sigma = -999.

iterate:

set/form f10.10


!-- compute the photometric solution

do i = 1 {tbllen}
   wF = "{{intab},:filter,@{i}}"

   {intab},:stdmag,@{i} = {{intab},:magnitude,@{i}} + -
      {zero({cloop{wF}})} -
    - {extn({cloop{wF}})} *  {{intab},:airm,@{i}}


  {intab},:stdmag_sigma,@{i} = {{intab},:mag_sigma,@{i}} + -
      {zeroS({cloop{wF}})} -
    - {extnS({cloop{wF}})} *  {{intab},:airm,@{i}}



   if {av{cindex{wF}(1:1)}} .gt. -99 .and. {av{cindex{wF}(3:3)}}) .gt. -99 then
      {intab},:stdmag,@{i} = {{intab},:stdmag,@{i}} + {color({cloop{wF}})} * -
                  ({av{cindex{wF}(1:1)}} - {av{cindex{wF}(3:3)}})
      {intab},:stdmag_sigma,@{i} =  {{intab},:stdmag_sigma,@{i}} -
               + {colorS({cloop{wF}})} * -
                 ({av{cindex{wF}(1:1)}} - {av{cindex{wF}(3:3)}})
   else ! color not available -> we use default tno colors
      {intab},:stdmag,@{i} = {{intab},:stdmag,@{i}} + {color({cloop{wF}})} * -
                  ({tno{cindex{wF}(1:1)}} - {tno{cindex{wF}(3:3)}})

      {intab},:stdmag_sigma,@{i} =  {{intab},:stdmag_sigma,@{i}} -
               + {colorS({cloop{wF}})} * -
                 ({tno{cindex{wF}(1:1)}} - {tno{cindex{wF}(3:3)}})

   endif






enddo


!-- summ the computed magnitudes ...
do i = 1 5
      av{ccc({i}:{i})} = 0.
      nav{ccc({i}:{i})} = 0
enddo

do i = 1 {tbllen}
  nav{{intab},:filter,@{i}} = nav{{intab},:filter,@{i}} +1
  av{{intab},:filter,@{i}} = av{{intab},:filter,@{i}} -
          + {{intab},:stdmag,@{i}}
enddo


!-- ... to get the average standard magnitudes

do i = 1 5
   if nav{ccc({i}:{i})} .gt. 0 then
      av{ccc({i}:{i})}  = av{ccc({i}:{i})} /nav{ccc({i}:{i})}
   else
      av{ccc({i}:{i})} = -99999.
   endif
enddo


!-- Did we change anything compared to previous iteration?

summ = 0
do i = 1 5
   summ = summ + m$abs(av{ccc({i}:{i})} -  avold{ccc({i}:{i})})
   avold{ccc({i}:{i})} = av{ccc({i}:{i})}
enddo


writ/out "SUMMMMMMMMMM {Summ} {avoldR} {avR}"

if summ .gt. 0.00001 goto iterate


name/col {intab} :stdmag f7.4
name/col {intab} :stdmag_sigma f7.4
name/col {intab} :exp_time f6.1
name/col {intab} :airm f5.3

ass/print file {intab}.out

comp/tab {intab} :midExpMJD = :epoch + :exp_time/2./86400.
name/col {intab} :midExpMJD f11.5

print/tab {intab} :frame :filter :midExpMJD :exp_time :airm :stdmag :stdmag_sigma

$ cat  {intab}.out






