!------------------------------------------------------------------------
! TMAG PHOTOMETRIC PACKAGE
! @@ amag_mes std_frames.cat pixScale angle orientation
!
! semi-automatically measure stars
! modified for WFI
!----------------------------------------------------------------------
defi/par p1 ? ? "image?
if "{p1}" .eq. "???" then
wr/o "			          		T M A G   Photometric Package "
wr/o " AMAG/MES  or  @@ amag_mes                                              "
wr/o "                                                                        "
wr/o ".syntax                                                                 "
wr/o "		AMAG/MES image pixScale posAng orientation                    "
wr/o ".purpose                                                                "
wr/o "          measures the standard stars on one image.                     "
wr/o "                                                                        "
wr/o ".parameters                                                            "
wr/o "   	image: input image (expects .bdf)                            "
wr/o "          pixScale, in arcsec                                          "
wr/o "          posAng, of top of CCD, East of North, or AUTO
wr/o "          orientation: +1 if E left of N, -1 if E right of N"
wr/o ".usage                                                                 "
wr/o "          The image will be loaded."
wr/o "          Click on one cross, and on the corresponding star "
wr/o "          The prg will then compute the offset between the object and"
wr/o "          the catalogue, and measure all the stars in the catalogue"
wr/o "                                                                        "
wr/o ".notes                                                                  "
wr/o "          - the coordinates are expected to be found in O_POS           "
wr/o "          - is posAng = AUTO, the angle is read in ESO.ADA.POSANG       "
wr/o "          - the program knows only about Landolt's std in UBVRI         "
wr/o "          - the program looks for the filter in FILTER or in            "
wr/o "              ESO.INS.FILT1.NAME                                        "
wr/o "          - the prg tries to get the airmass from                       "
wr/o "             ESO.TEL.AIRM.START and ...END (averages them)             "
wr/o "             or O_AIRM                                                  "
wr/o "          - the epoch is optained from o_time(4), and the exposure time "
wr/o "            from o_time(7)                                              "
wr/o "                                                                        "
wr/o "-----------------------------------------------------------------------------"
!.autor 	o hainaut
!
! .version Wed Jan 10 03:09:36 2001 orh first recorded version
! .history 
! 2000 orh creation
return
endif
defi/par p2 .24 N "pixel scale?"
defi/par p3 0. c "posang value/AUTO"
defi/par p4 1. N "orient 1: E =left of N, -1: E right of N"


defi/loc center/r/1/2 0.,0.
defi/loc i/i/1/1 0

defi/loc main_det/r/1/1 0.
defi/loc ax/d/1/1 0.
defi/loc bx/d/1/1 0.
defi/loc cx/d/1/1 0.
defi/loc ay/d/1/1 0.
defi/loc by/d/1/1 0.
defi/loc cy/d/1/1 0.
writ/key scale/d/1/2 0. all

defi/loc sx/r/1/3 0.,0.,0.
defi/loc sy/r/1/3 0.,0.,0.
defi/loc gx/r/1/3 0.,0.,0.
defi/loc gy/r/1/3 0.,0.,0.

defi/loc w/r/1/1 0.
defi/loc rms/r/1/3 0.,0.,0.


defi/loc orient/i/1/1 {p4}

!
!-- INPUT IMAGE
!
@@ tmag_checkfile {p1} .bdf check naked
defi/loc inima/c/1/72 {outputc}
defi/loc inimsh/c/1/72 {outputc}

if "{inima}" .ne. "{idimemc}" then
  writ/out "*info* loading image {inima}"
  ! load {inima} sc=fu cu=f,ihap
  load {inima} sc=fu cu=.001,0.1
  ! kload {inima} -1,10 sc=fu
else
  writ/out "*info* image {inima} already loaded"
endif


!- reads the coord from header

wri/key wra/d/1/1 {{inima},o_pos(1)}
wri/key wdec/d/1/1 {{inima},o_pos(2)}

if wra .le. 0.0000001 then ! we don't  have the coordinates...
   i = m$len(inima)-1
   inimsh = "{inima(:{i})}.bdf"
   wra = {{inimsh},o_pos(1)}
   wdec = {{inimsh},o_pos(2)}
endif
writ/out "coord: {wra} {wdec}"


if "{P3}" .eq. "AUTO" then
   defi/loc posang/r/1/1 {{inima},ESO.ADA.POSANG}
else
   defi/loc posang/r/1/1 {p3}
endif
writ/out "Position Angle: {posang}"

!
!-- GET THE STARS 
!

set/for f8.6
defi/loc pixsc/r/1/1 {p2}

defi/loc rad/i/1/1 0.
rad = {{inima},npix(1)}*pixsc/60.*2.   !  *.7

defi/loc intab/c/1/72 LandLoc.tbl

sele/tab MID_WORK:Landolt.tbl all
copy/tab MID_WORK:Landolt.tbl {intab}



writ/key determi/r/1/1 0.


!-- crude estimate of the astrometric solution

i = m$index(idimemc,"wfi")
if i .eq. 0 then
 center(1) = {{idimemc},NPIX(1)}/2.*{{idimemc},STEP(1)} + {{idimemc},START(1)}
 center(2) = {{idimemc},NPIX(2)}/2.*{{idimemc},STEP(2)} + {{idimemc},START(2)}
else
 center(1) = 3600. ! 4050.
 center(2) = 3870. ! 3900.
endif


defi/loc iflag/i/1/1 1

recenter:

writ/out {center(1)} {center(2)}

comp/tab {intab} :xcen = -({orient})*cos({posang})*(:r_a-{wra}) 
comp/tab {intab} :xcen = :xcen - sin({posang})*(:dec-({wdec}))
comp/tab {intab} :xcen = :xcen*3600.*cos({wdec})
comp/tab {intab} :xcens = :xcen
comp/tab {intab} :xcen = {center(1)}+:xcens/{pixsc}

comp/tab {intab} :ycen = -({orient})*sin({posang})*(:r_a - {wra}) 
comp/tab {intab} :ycen = :ycen+ cos({posang})*(:dec-({wdec}))
comp/tab {intab} :ycen = :ycen*3600.
comp/tab {intab} :ycens = :ycen
comp/tab {intab} :ycen = {center(2)}+:ycens/{pixsc}

writ/out "*info* Loading the stars on display"

cle/ch ov

sel/tab  {intab} all  ! | $cat > /dev/null
load/tab {intab} :xcen :ycen ? 6 10 3

comp/tab {intab} :dist = sqrt(:xcen**2 + :ycen**2)

!##########3

if iflag .eq. 1 then
  
  writ/out 
  writ/out "*ACTION*--> For 1 star, click the cross, then the image"
  writ/out
  
  $ rm -f wjunk_center.tbl
  get/cur wjunk_center p4=2,1
  if m$exist("wjunk_center.tbl") .eq. 0 then
     writ/out "ERROR you were supposed to select 2 points in total"
     return
  endif
  if {wjunk_center.tbl,tblcontr(10)} .ne. 2 then
     writ/out "ERROR you were supposed to select 2 points in total"
     return/exit
  else
    wri/out "thanks-"
  endif
  
  
  center(1) = center(1)- {wjunk_center,:x_coord,@1} +{wjunk_center,:x_coord,@2}
  center(2) = center(2)- {wjunk_center,:y_coord,@1} +{wjunk_center,:y_coord,@2}
  
  iflag = 0
  goto recenter
endif


w = 10./pixsc
!!w = 30./pixsc
!!w = 99
comp/tab {intab} :xstart = :xcen -{w}
comp/tab {intab} :xend = :xcen +{w}
comp/tab {intab} :ystart = :ycen -{w}
comp/tab {intab} :yend = :ycen +{w}
dra/rec {intab} F

sele/tab {intab} :xstart .ge. {{inima},start(1)}  ! | $cat > /dev/null
sele/tab {intab} sel.eq.1 .and. :ystart .ge. {{inima},start(2)} ! | $cat > /dev/null
w = {{inima},start(1)}+ {{inima},npix(1)}*{{inima},step(1)}
sele/tab {intab} sel.eq.1 .and. :xend .le. {w} ! | $cat > /dev/null
w = {{inima},start(2)}+ {{inima},npix(2)}*{{inima},step(2)}
sele/tab {intab} sel.eq.1 .and. :yend .le. {w} ! | $cat > /dev/null


copy/tab {intab} w.tbl
copy/tab w.tbl {intab}


!? cent/mom {inima},{intab} {intab}  ! check if there are some stars there
!? sele/tab {intab} :status .ne. 1.  ! keeps the good ones (1=failed)
!? comp/tab {intab} :std = 1 + (1- sel ) ! mark the std (1) and bad (2)

comp/tab {intab} :standard = :ident
cent/mom {inima},{intab} {intab}

!return
load/tab {intab} :xcen :ycen ? 6 10 4


w = 5./pixsc
comp/tab {intab} :xstart = :xcen -{w}
comp/tab {intab} :xend = :xcen +{w}
comp/tab {intab} :ystart = :ycen -{w}
comp/tab {intab} :yend = :ycen +{w}


defi/loc diapspec/c/1/72  "{w},@15,@10" !"@30,@5,@5"

magn/cir {inima},{intab} {intab} {diapspec} ? 1,2. 2,1,1,1
name/col {intab} :magnitude f8.3


draw/cir {intab} F

w = w+30
comp/tab {intab} :xstart = :xcen -{w}
comp/tab {intab} :xend = :xcen +{w}
comp/tab {intab} :ystart = :ycen -{w}
comp/tab {intab} :yend = :ycen +{w}
draw/cir {intab} F

w = w+100
comp/tab {intab} :xstart = :xcen -{w}
comp/tab {intab} :xend = :xcen +{w}
comp/tab {intab} :ystart = :ycen -{w}
comp/tab {intab} :yend = :ycen +{w}
draw/cir {intab} F


!-------- airmass

i = m$existd(inima,"ESO.TEL.AIRM.START")
if i .eq. 1 then
  comp/tab {intab} :AIRM = ({{inima},ESO.TEL.AIRM.START}+{{inima},ESO.TEL.AIRM.END})/2.
else
  i = m$existd(inima,"o_airm")
  if i .eq. 1 then
    comp/tab {intab} :AIRM = {{inima},o_airm}
  else 
    comp/tab {intab} :AIRM = .9999999
  endif
endif

!---------- filter
crea/col {intab} :filter C*1
i = m$existd(inima,"FILTER")
if i .eq. 1 then
   comp/tab {intab} :filter = "{{inima},FILTER(1:1)}"
endif
i = m$existd(inima,"ESO.INS.FILT1.NAME")
if i .eq. 1 then
   comp/tab {intab} :filter = "{{inima},ESO.INS.FILT1.NAME(1:1)}"
endif
i = m$existd(inima,"ESO.INS.FILT2.NAME")
if i .eq. 1 then
   comp/tab {intab} :filter = "{{inima},ESO.INS.FILT1.NAME(1:1)}"
endif

!-------- exptime

comp/tab {intab} :exp_time = {{inima},o_time(7)}

!-------- epoch

comp/tab  {intab} :epoch = {{inima},O_TIME(4)}

!-------
comp/tab  {intab} :frame = "{inima}"
comp/tab  {intab} :fr_id = "{{inima},IDENT}"

!------
comp/tab {intab} :stdstatus = 1-1000*:status

$ mv {intab} t_{inima}.tbl
read/tab  t_{inima} :standard :MAGNITUDE :filter


return !!!!!!!!!!!!!!1


