!-----------------------------------------------------------------------------
! AMAG
! amag_objmes image diap_diam [pixScale]
! 
!  image: input image
!  diap_diam: diameter of the diaphragm
!	  must start with @ or s or a
!	  @: in pix, s: in seeing, a: in arcsec (using p3)
!  pixScale: size of the pixel. If not give, assumed =1.
!
! measures an object in a frame (DESIGNED FOR *1* OBJECT)
! stores the results in a table tm_<image>
! with info for being processed by amag_comp
!
! 
!
! can be called by an exec/cat
!
! first, measure the seeing: measure a bunch of stars
! then measure the object with the circles
!
! .version Tue Jan  9 23:12:14 2001 orh/ads creation
! .history 
!  Tue Jan  9 23:11:40 2001 orh/ads 
!-----------------------------------------------------------------------------
DEFI/PAR p1 ? I " image >"
DEFI/PAR p2 ? ? " Diaphragm diameter (@=pix: @12, s=seeing: s3) > "
DEFI/PAR p3 1. N " Pixel size > "

DEFI/LOC WC/c/1/72 {p2}
DEFI/LOC mode/c/1/1 {wc(1:1)}
DEFI/LOC pixsize/r/1/1 {p3}

if mode .ne. "@" then
if mode .ne. "a" then
if mode .ne. "s" then
	writ/out "*error* wrong diameter, must start with @ or s"
	return/exit
endif ; endif ; endif

DEFI/LOC diap/R/1/1 {wc(2:)}
DEFI/LOC diap_pix/R/1/1 0.
DEFI/LOC seeing_a/R/1/1 0.
DEFI/LOC seeing_b/R/1/1 0.
DEFI/LOC inima/C/1/72 {p1}
DEFI/LOC intab/C/1/72 "XXX"


DEFI/LOC i/I/1/1 0

@@ check_file {p1} .bdf check naked ! = no ".bdf"
inima = outputc
intab = "tm_{inima}"

$ rm -f {intab}.tbl


if "{idimemc}" .ne. "{inima}" then
	load {inima}
endif
clea/cha over

! get the seeing


WRITE/OUT "Select a few stars for seeing measurement then exit"
CEN/IQE ? wseeing 
STAT/TAB wseeing :AX_MAJ 
seeing_a = outputr(3)*pixsize
STAT/TAB wseeing :AX_MIN 
seeing_b = outputr(3)*pixsize

! measure obj

if mode .eq. "s" then
    diap_pix = diap * seeing_a/pixsize
else ; if mode .eq. "a" then
    diap_pix = diap/pixsize
else
    diap_pix = diap
endif; endif

!-- measure the magnitude

MAG/CIRCL ? {intab} @{diap_pix},@10,@10

!-- measure the center (for further astrometry)
!   (cen/gau uses the XSTART, YSTART, XEND, YEND for the center box)

CENT/GAU {inima},{intab} {intab}



crea/col {intab} :filter C*1
cre/col {intab} :epoch r*8 f15.8
name/col {intab} :xcen f8.2
name/col {intab} :ycen f8.2


!-------- airmass

i = m$existd(inima,"ESO.TEL.AIRM.START")
if i .eq. 1 then
  comp/tab {intab} :AIRM = ({{inima},ESO.TEL.AIRM.START}+{{inima},ESO.TEL.AIRM.END})/2.
else
  i = m$existd(inima,"o_airm")
  if i .eq. 1 then
    comp/tab {intab} :AIRM = {{inima},o_airm}
  else 
    comp/tab {intab} :AIRM = .9999999
  endif
endif

!---------- filter

i = m$existd(inima,"ESO.INS.FILT1.NAME")
if i .eq. 1 then
   comp/tab {intab} :filter = "{{inima},ESO.INS.FILT1.NAME(1:1)}"
endif
i = m$existd(inima,"ESO.INS.FILT2.NAME")
if i .eq. 1 then
   comp/tab {intab} :filter = "{{inima},ESO.INS.FILT2.NAME(1:1)}"
endif
i = m$existd(inima,"FILTER")
if i .eq. 1 then
   comp/tab {intab} :filter = "{{inima},FILTER(1:1)}"
endif

!-------- exptime

comp/tab {intab} :exp_time = {{inima},o_time(7)}

!-------- epoch
set/for   f15.8
COMP/TAB  {intab} :epoch = {{inima},O_TIME(4)}
set/for
!-------
COMP/TAB  {intab} :frame = "{inima}"

i = m$existd(inima,"IDENT")
if i .eq. 1 then
  COMP/TAB  {intab} :fr_id = "{{inima},IDENT}"
else
  COMP/TAB  {intab} :fr_id = "{inima}"
endif

i = m$existd(inima,"ESO.OBS.NAME}")
if i .eq. 1 then
  COMP/TAB  {intab} :name = "{{inima},ESO.OBS.NAME}"
else
  COMP/TAB  {intab} :name = "{inima}"
endif

comp/tab {intab} :seeing_a = {seeing_A}
comp/tab {intab} :seeing_b = {seeing_b}

set/form f5.2
defi/loc out/C/1/80 "{{intab},:name,@1} {inima} {{inima},O_TIME(4)} {{inima},o_time(7)} {{intab},:filter,@1}"
set/form f5.3
out = "{out} {{intab},:airm,@1} {{intab},:MAGNITUDE,@1}"
out = "{out} {{intab},:MAG_SIGMA,@1} {{intab},:SKY,@1}"
write/out "{out}"

set/form




